/*
 * Decompiled with CFR 0.152.
 */
package com.hxgy.im.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.hxgy.im.config.ProjProperties;
import com.hxgy.im.enums.BusiPushStatusEnum;
import com.hxgy.im.enums.BusiPushTypeEnum;
import com.hxgy.im.enums.ErrorEnum;
import com.hxgy.im.enums.MediaProcessTypeEnum;
import com.hxgy.im.pojo.dto.EditMediaCompleteDto;
import com.hxgy.im.pojo.dto.IMTencentEditMedia;
import com.hxgy.im.pojo.entity.IMBusiPushConfigEntity;
import com.hxgy.im.pojo.entity.IMMixtedFlowEntity;
import com.hxgy.im.pojo.entity.ImAccountEntity;
import com.hxgy.im.pojo.entity.ImApplicationEntity;
import com.hxgy.im.pojo.entity.ImMediaProcessEntity;
import com.hxgy.im.pojo.entity.ImMemberEntity;
import com.hxgy.im.pojo.vo.TencentMedia.IMEditMediaFileInfo;
import com.hxgy.im.pojo.vo.TencentMedia.IMEditMediaReqVo;
import com.hxgy.im.pojo.vo.TencentMedia.IMEditMediaRespVo;
import com.hxgy.im.pojo.vo.TencentMedia.IMEditMediaStreamInfo;
import com.hxgy.im.repository.IMMixtedFlowRepository;
import com.hxgy.im.repository.ImAccountRepository;
import com.hxgy.im.repository.ImApplicationRepository;
import com.hxgy.im.repository.ImBusiPushConfigRepository;
import com.hxgy.im.repository.ImMemberRepository;
import com.hxgy.im.repository.mapper.ImMediaProcessMapper;
import com.hxgy.im.service.IMBusiPushService;
import com.hxgy.im.service.MediaProcessService;
import com.hxgy.im.util.RestTemplateUtils;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.common.profile.ClientProfile;
import com.tencentcloudapi.common.profile.HttpProfile;
import com.tencentcloudapi.vod.v20180717.VodClient;
import com.tencentcloudapi.vod.v20180717.models.EditMediaFileInfo;
import com.tencentcloudapi.vod.v20180717.models.EditMediaOutputConfig;
import com.tencentcloudapi.vod.v20180717.models.EditMediaRequest;
import com.tencentcloudapi.vod.v20180717.models.EditMediaResponse;
import com.tencentcloudapi.vod.v20180717.models.EditMediaStreamInfo;
import com.tencentcloudapi.vod.v20180717.models.MediaProcessTaskInput;
import com.tencentcloudapi.vod.v20180717.models.MediaProcessTaskResult;
import com.tencentcloudapi.vod.v20180717.models.MediaProcessTaskTranscodeResult;
import com.tencentcloudapi.vod.v20180717.models.ProcedureTask;
import com.tencentcloudapi.vod.v20180717.models.ProcessMediaRequest;
import com.tencentcloudapi.vod.v20180717.models.ProcessMediaResponse;
import com.tencentcloudapi.vod.v20180717.models.TranscodeTaskInput;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MediaProcessServiceImpl
implements MediaProcessService {
    private static final Logger log = LoggerFactory.getLogger(MediaProcessServiceImpl.class);
    @Autowired
    private ImBusiPushConfigRepository pushConfigRepository;
    @Autowired
    private ImMemberRepository imMemberRepository;
    @Autowired
    private ImAccountRepository imAccountRepository;
    @Autowired
    private IMMixtedFlowRepository mixtedFlowRepository;
    @Autowired
    private ImApplicationRepository imApplicationRepository;
    @Autowired
    private ImMediaProcessMapper imMediaProcessMapper;
    @Autowired
    private IMBusiPushService imBusiPushService;
    @Autowired
    private MediaProcessService mediaProcessService;
    @Autowired
    private ProjProperties projProperties;
    @Resource(name="toTestAsyncPool")
    private ThreadPoolTaskExecutor toTestAsyncPool;
    @Value(value="${byh.domain}")
    private String byhDomain;
    private static final String STREAM = "Stream";

    public BaseResponse<Object> EditMedia(IMEditMediaReqVo reqVo) {
        ArrayList<Object> list;
        log.info("\u526a\u8f91\u89c6\u9891 editMediaVo:{}", (Object)reqVo);
        if (reqVo == null || StringUtils.isEmpty((CharSequence)reqVo.getInputType())) {
            return BaseResponse.error((String)"\u975e\u6cd5\u53c2\u6570");
        }
        IMTencentEditMedia imTencentEditMedia = new IMTencentEditMedia();
        imTencentEditMedia.setInputType(reqVo.getInputType());
        imTencentEditMedia.setSessionContext(reqVo.getBusiCode() + "_" + reqVo.getTreatmentId());
        imTencentEditMedia.setMediaName(StringUtils.isEmpty((CharSequence)reqVo.getMediaName()) ? null : reqVo.getMediaName());
        if ("File".equalsIgnoreCase(reqVo.getInputType())) {
            list = new ArrayList<Object>();
            list.add(reqVo.getImEditMediaFileInfo());
            imTencentEditMedia.setImEditMediaFileInfo(list);
        } else if (STREAM.equalsIgnoreCase(reqVo.getInputType())) {
            list = new ArrayList();
            list.add(reqVo.getImEditMediaStreamInfo());
            imTencentEditMedia.setImEditMediaStreamInfo(list);
        } else {
            return BaseResponse.error((String)"\u5165\u53c2InputType\u8f93\u5165\u6709\u8bef");
        }
        EditMediaResponse response = this.tencentEditMedia(imTencentEditMedia);
        if (response == null || StringUtils.isEmpty((CharSequence)response.getRequestId())) {
            log.info("\u8bf7\u6c42\u817e\u8baf\u89c6\u9891\u7f16\u8f91\u63a5\u53e3 \u54cd\u5e94\u5f02\u5e38");
            return BaseResponse.error((String)"\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        log.info("\u8bf7\u6c42\u817e\u8baf\u89c6\u9891\u7f16\u8f91\u63a5\u53e3  \u54cd\u5e94:{}", (Object)(response.getRequestId() + "<=RequestId==TaskId=>" + response.getTaskId()));
        return BaseResponse.success((Object)response);
    }

    @Transactional
    public BaseResponse<Object> callbackProcessVideo(JSONObject jsonObject) {
        String eventType = jsonObject.getString("EventType");
        log.info("\u817e\u8baf\u4e91\u70b9\u64ad-\u89c6\u9891\u5904\u7406\u4e8b\u4ef6\u7c7b\u578b: {}", (Object)eventType);
        if ("ProcedureStateChanged".equalsIgnoreCase(eventType)) {
            this.procedureStateChanged(jsonObject);
            return BaseResponse.success();
        }
        if ("EditMediaComplete".equalsIgnoreCase(eventType)) {
            return this.editMediaComplete(jsonObject);
        }
        return BaseResponse.success();
    }

    private BaseResponse<Object> editMediaComplete(JSONObject jsonObject) {
        String sessionContext;
        String stateChanged = JSONObject.toJSONString((Object)jsonObject.getJSONObject("EditMediaComplete"));
        EditMediaCompleteDto editMediaCompleteDto = (EditMediaCompleteDto)JSONObject.parseObject((String)stateChanged, EditMediaCompleteDto.class);
        if (0 == editMediaCompleteDto.getErrCode() && "FINISH".equalsIgnoreCase(editMediaCompleteDto.getStatus()) && StringUtils.isNotEmpty((CharSequence)(sessionContext = editMediaCompleteDto.getSessionContext())) && sessionContext.contains("_")) {
            String[] s = sessionContext.split("_");
            String busiCode = s[0];
            String treatmentId = s[1];
            IMEditMediaRespVo vo = new IMEditMediaRespVo(busiCode, treatmentId, editMediaCompleteDto.getOutput().getFileId(), editMediaCompleteDto.getOutput().getFileType(), editMediaCompleteDto.getOutput().getFileUrl());
            this.imBusiPushService.editMediaCompletePushToBusiness(vo, BusiPushTypeEnum.MEDIA_EDIT);
            return BaseResponse.success((Object)vo);
        }
        log.info("\u56de\u8c03==\u300b\u89c6\u9891\u7f16\u8f91 \u672a\u5b8c\u6210 editMediaCompleteDto:{}", (Object)editMediaCompleteDto);
        return BaseResponse.error((IError)ErrorEnum.SYSTEM_ERROR, (String)"\u89c6\u9891\u7f16\u8f91\u672a\u5b8c\u6210");
    }

    public BaseResponse<Object> mediaTranscode(String fileId, ImMediaProcessEntity mediaProcessEntity) {
        if (null == mediaProcessEntity) {
            mediaProcessEntity = new ImMediaProcessEntity();
        }
        mediaProcessEntity.setFileId(fileId);
        mediaProcessEntity.setType(MediaProcessTypeEnum.TRANSCODE.getValue());
        this.mediaProcessService.save(mediaProcessEntity);
        this.processMediaReq(fileId);
        return BaseResponse.success();
    }

    public BaseResponse<Object> save(ImMediaProcessEntity mediaProcessEntity) {
        if (null == mediaProcessEntity) {
            log.info("----save--ImMediaProcess\u5165\u53c2\u4e3anull");
            return BaseResponse.error((IError)ErrorEnum.INVALID_PARAMETER);
        }
        if (null == mediaProcessEntity.getId()) {
            log.info("\u65b0\u589eImMediaProcessEntity:{}", (Object)JSON.toJSONString((Object)mediaProcessEntity));
            this.imMediaProcessMapper.insert(mediaProcessEntity);
        } else {
            log.info("\u66f4\u65b0mMediaProcessEntity:{}", (Object)JSON.toJSONString((Object)mediaProcessEntity));
            this.imMediaProcessMapper.update(mediaProcessEntity);
        }
        return BaseResponse.success();
    }

    private EditMediaResponse tencentEditMedia(IMTencentEditMedia imTencentEditMedia) {
        EditMediaResponse response;
        ImApplicationEntity apiSecret = new ImApplicationEntity();
        if (imTencentEditMedia.getImEditMediaFileInfo() != null && imTencentEditMedia.getImEditMediaFileInfo().size() > 0) {
            apiSecret = this.getApiSecretByfileId(((IMEditMediaFileInfo)imTencentEditMedia.getImEditMediaFileInfo().get(0)).getFileId());
        }
        try {
            Credential cred = new Credential(apiSecret.getSecretId(), apiSecret.getSecretKey());
            HttpProfile httpProfile = new HttpProfile();
            httpProfile.setEndpoint(this.projProperties.getTxSdkHttpProfile());
            ClientProfile clientProfile = new ClientProfile();
            clientProfile.setHttpProfile(httpProfile);
            VodClient client = new VodClient(cred, "", clientProfile);
            EditMediaRequest request = new EditMediaRequest();
            if ("File".equalsIgnoreCase(imTencentEditMedia.getInputType())) {
                List fileInfoList = imTencentEditMedia.getImEditMediaFileInfo();
                EditMediaFileInfo[] infos = new EditMediaFileInfo[fileInfoList.size()];
                for (int i = 0; i < fileInfoList.size(); ++i) {
                    IMEditMediaFileInfo fileInfo = (IMEditMediaFileInfo)fileInfoList.get(i);
                    EditMediaFileInfo editMediaFileInfo = new EditMediaFileInfo();
                    BeanUtils.copyProperties((Object)fileInfo, (Object)editMediaFileInfo);
                    infos[i] = editMediaFileInfo;
                }
                request.setFileInfos(infos);
                request.setInputType("File");
            } else if (STREAM.equalsIgnoreCase(imTencentEditMedia.getInputType())) {
                List streamInfoList = imTencentEditMedia.getImEditMediaStreamInfo();
                EditMediaStreamInfo[] streamInfos = new EditMediaStreamInfo[streamInfoList.size()];
                for (int i = 0; i < streamInfoList.size(); ++i) {
                    IMEditMediaStreamInfo streamInfo1 = (IMEditMediaStreamInfo)streamInfoList.get(i);
                    EditMediaStreamInfo editMediaFileInfo = new EditMediaStreamInfo();
                    BeanUtils.copyProperties((Object)streamInfo1, (Object)editMediaFileInfo);
                    streamInfos[i] = editMediaFileInfo;
                }
                request.setStreamInfos(streamInfos);
                request.setInputType(STREAM);
            } else {
                return null;
            }
            request.setSessionContext(imTencentEditMedia.getSessionContext());
            request.setDefinition(Long.valueOf(20L));
            EditMediaOutputConfig config = new EditMediaOutputConfig();
            config.setClassId(Long.valueOf(0L));
            config.setMediaName(imTencentEditMedia.getMediaName());
            config.setType("mp4");
            request.setOutputConfig(config);
            log.info("\u8bf7\u6c42\u817e\u8baf\u89c6\u9891\u7f16\u8f91\u63a5\u53e3  \u8f6c\u7801\u62fc\u63a5\u540e\u7684\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)JSONObject.toJSONString((Object)request));
            response = client.EditMedia(request);
        }
        catch (TencentCloudSDKException e) {
            log.info("\u8bf7\u6c42\u817e\u8baf\u89c6\u9891\u7f16\u8f91\u63a5\u53e3  \u5f02\u5e38:{}", (Object)(e.getMessage() + "  Cause:" + e.getCause()));
            return null;
        }
        return response;
    }

    private ProcessMediaResponse processMediaReq(String fileId) {
        log.info("-----\u89c6\u9891\u56de\u8c03\u540e  \u53d1\u8d77\u8f6c\u7801\u8bf7\u6c42-----\u4e91\u70b9\u64ad\u8f6c\u7801\u7684\u6587\u4ef6id\u662f:{}", (Object)fileId);
        ProcessMediaResponse resp = null;
        ImApplicationEntity secret = this.getApiSecretByfileId(fileId);
        try {
            Credential cred = new Credential(secret.getSecretId(), secret.getSecretKey());
            HttpProfile httpProfile = new HttpProfile();
            httpProfile.setEndpoint(this.projProperties.getTxSdkHttpProfile());
            ClientProfile clientProfile = new ClientProfile();
            clientProfile.setHttpProfile(httpProfile);
            VodClient client = new VodClient(cred, "", clientProfile);
            ProcessMediaRequest processMediaRequest = new ProcessMediaRequest();
            processMediaRequest.setFileId(fileId);
            MediaProcessTaskInput mediaProcessTaskInput = new MediaProcessTaskInput();
            TranscodeTaskInput[] transcodeTaskInputs = new TranscodeTaskInput[1];
            TranscodeTaskInput transcodeTaskInput = new TranscodeTaskInput();
            transcodeTaskInput.setDefinition(Long.valueOf(20L));
            transcodeTaskInputs[0] = transcodeTaskInput;
            mediaProcessTaskInput.setTranscodeTaskSet(transcodeTaskInputs);
            processMediaRequest.setMediaProcessTask(mediaProcessTaskInput);
            String params = JSONObject.toJSONString((Object)processMediaRequest);
            log.info("\u4e91\u70b9\u64ad\u8f6c\u7801\u62fc\u63a5\u540e\u7684\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)params);
            resp = client.ProcessMedia(processMediaRequest);
            log.info("\u89c6\u9891\u8f6c\u7801\u817e\u8baf\u8fd4\u56de\u7684\u4fe1\u606f\u662f:{}", (Object)JSON.toJSONString((Object)resp));
        }
        catch (TencentCloudSDKException e) {
            log.error(e.getRequestId(), (Throwable)e);
        }
        return resp;
    }

    private void procedureStateChanged(JSONObject jsonObject) {
        log.info("\u8fdb\u5165\u4e91\u70b9\u64ad\u56de\u8c03,\u56de\u8c03\u4fe1\u606f\u662f:{}", (Object)jsonObject.toJSONString());
        String eventType = jsonObject.getString("EventType");
        String procedureTaskStr = JSONObject.toJSONString((Object)jsonObject.getJSONObject("ProcedureStateChangeEvent"));
        ProcedureTask procedureTask = (ProcedureTask)JSONObject.parseObject((String)procedureTaskStr, ProcedureTask.class);
        if ("ProcedureStateChanged".equalsIgnoreCase(eventType) && "FINISH".equalsIgnoreCase(procedureTask.getStatus()) && procedureTask.getMediaProcessResultSet() != null) {
            log.info("======>\u786e\u8ba4\u662f\u89c6\u9891\u8f6c\u7801\u56de\u8c03");
            String fileId = procedureTask.getFileId();
            List list = this.mixtedFlowRepository.selectByFileId(fileId);
            if (null == list || list.size() == 0) {
                this.toTestAsyncPool.execute(() -> this.procedureStateChangedtotest(jsonObject));
                return;
            }
            MediaProcessTaskResult[] mediaProcessTaskResults = procedureTask.getMediaProcessResultSet();
            ImMediaProcessEntity mediaProcessEntity = new ImMediaProcessEntity();
            BusiPushTypeEnum busiPushType = null;
            for (MediaProcessTaskResult mediaProcessTaskResult : mediaProcessTaskResults) {
                if (!MediaProcessTypeEnum.TRANSCODE.getDesc().equalsIgnoreCase(mediaProcessTaskResult.getType())) continue;
                busiPushType = BusiPushTypeEnum.MEDIA_TRANSCODE;
                MediaProcessTaskTranscodeResult mediaProcessTaskTranscodeResult = mediaProcessTaskResult.getTranscodeTask();
                if (!"SUCCESS".equalsIgnoreCase(mediaProcessTaskTranscodeResult.getStatus())) continue;
                String videoUrl = mediaProcessTaskTranscodeResult.getOutput().getUrl();
                Long size = mediaProcessTaskTranscodeResult.getOutput().getSize();
                Long duration = mediaProcessTaskTranscodeResult.getOutput().getDuration().longValue();
                ImMediaProcessEntity entity = this.imMediaProcessMapper.selectByFileIdAndType(fileId, MediaProcessTypeEnum.TRANSCODE.getValue());
                if (null == entity) break;
                BeanUtils.copyProperties((Object)entity, (Object)mediaProcessEntity);
                mediaProcessEntity.setVideoUrl(videoUrl);
                mediaProcessEntity.setSize(size);
                mediaProcessEntity.setDuration(duration);
                this.imMediaProcessMapper.update(mediaProcessEntity);
                break;
            }
            this.imBusiPushService.mediaProcessPushToBusiness(mediaProcessEntity, busiPushType);
        }
    }

    private ImApplicationEntity getApiSecretByfileId(String fileId) {
        ImApplicationEntity applicationEntity = new ImApplicationEntity();
        try {
            ImAccountEntity imAccountEntity;
            String appcode;
            ImApplicationEntity app;
            Optional accountEntityOptional;
            String sessionId;
            List memberEntities;
            List list = this.mixtedFlowRepository.selectByFileId(fileId);
            if (list != null && list.size() > 0 && (memberEntities = this.imMemberRepository.findBySessionId(sessionId = ((IMMixtedFlowEntity)list.get(0)).getSessionId())) != null && memberEntities.size() > 0 && (accountEntityOptional = this.imAccountRepository.findById((Object)((ImMemberEntity)memberEntities.get(0)).getAccountId())).isPresent() && (app = this.imApplicationRepository.findByAppCode(appcode = (imAccountEntity = (ImAccountEntity)accountEntityOptional.get()).getSdkAccount().split("\\*")[1])) != null && StringUtils.isNotEmpty((CharSequence)app.getSecretId()) && StringUtils.isNotEmpty((CharSequence)app.getSecretKey())) {
                String secretId = app.getSecretId();
                String secretKey = app.getSecretKey();
                if (StringUtils.isNotEmpty((CharSequence)secretId) && StringUtils.isNotEmpty((CharSequence)secretKey)) {
                    applicationEntity.setSecretId(secretId);
                    applicationEntity.setSecretKey(secretKey);
                }
            }
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u817e\u8bafapi\u63a5\u53e3\u8bbf\u95ee\u79d8\u94a5 e:" + e);
            applicationEntity = (ImApplicationEntity)this.imApplicationRepository.findAll().get(0);
        }
        if (StringUtils.isEmpty((CharSequence)applicationEntity.getSecretId()) || StringUtils.isEmpty((CharSequence)applicationEntity.getSecretKey())) {
            log.info("\u83b7\u53d6\u817e\u8bafapi\u63a5\u53e3\u8bbf\u95ee\u79d8\u94a5 \u83b7\u53d6\u5931\u8d25\uff0c\u53d6\u9ed8\u8ba4\u914d\u7f6e");
            ImApplicationEntity entity = (ImApplicationEntity)this.imApplicationRepository.findAll().get(0);
            applicationEntity.setSecretId(entity.getSecretId());
            applicationEntity.setSecretKey(entity.getSecretKey());
        }
        log.info("---SecretId:{},SecretKey:{}", (Object)applicationEntity.getSecretId(), (Object)applicationEntity.getSecretKey());
        return applicationEntity;
    }

    private void procedureStateChangedtotest(JSONObject object) {
        IMBusiPushConfigEntity configEntity = this.pushConfigRepository.findByPushTypeAndBusiCode("transcodeToTest", "im_test");
        if (configEntity != null && BusiPushStatusEnum.ON.getValue().equals(configEntity.getStatus())) {
            String url = configEntity.getDomain() + "/cloud" + configEntity.getUri();
            log.info("\u4efb\u52a1\u6d41\u5904\u7406\u56de\u8c03\u8f6c\u53d1\u81f3\u6d4b\u8bd5\u73af\u5883IM,\u8bf7\u6c42params:{}", (Object)object.toJSONString());
            String result = RestTemplateUtils.post((String)url, (JSONObject)object, (MediaType)MediaType.APPLICATION_JSON_UTF8);
            log.info("\u4efb\u52a1\u6d41\u5904\u7406\u56de\u8c03\u8f6c\u53d1\u81f3\u6d4b\u8bd5\u73af\u5883IM \u54cd\u5e94={}", (Object)result);
        }
    }
}

