/*
 * Decompiled with CFR 0.152.
 */
package com.hxgy.im.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final String FIND_ERROR = "\u51fa\u73b0\u5f02\u5e38:";
    private static ObjectMapper mapper = new ObjectMapper();
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> convertCollection(String json, Class<? extends Collection<?>> collection, Class<T> clazz) {
        try {
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            CollectionType javaType = mapper.getTypeFactory().constructCollectionType(collection, clazz);
            List list = (List)mapper.readValue(json, (JavaType)javaType);
            return list;
        }
        catch (Exception e) {
            log.error(FIND_ERROR + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> T convertObject(String json, Class<T> clazz) {
        Object object;
        try {
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            object = mapper.readValue(json, clazz);
        }
        catch (Exception e) {
            log.error(FIND_ERROR + e.getMessage(), (Throwable)e);
            return null;
        }
        return (T)object;
    }

    public static String convertObject(Object object) {
        try {
            String string = mapper.writeValueAsString(object);
            return string;
        }
        catch (Exception e) {
            log.error(FIND_ERROR + e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

