/*
 * Decompiled with CFR 0.152.
 */
package com.hxgy.im.controller;

import com.alibaba.fastjson.JSON;
import com.hxgy.im.pojo.vo.IMMixtedFlowCallbackReqVO;
import com.hxgy.im.pojo.vo.TestIMMixtedFlowCallbackReqVO;
import com.hxgy.im.pojo.vo.TestIMTencentCallBackReqVO;
import com.hxgy.im.service.IMBusiPushService;
import com.hxgy.im.service.IMCommonService;
import com.hxgy.im.service.IMMsgService;
import com.hxgy.im.service.TestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/test"})
public class TestController {
    private static final Logger log = LoggerFactory.getLogger(TestController.class);
    @Autowired
    private IMBusiPushService busiPushService;
    @Autowired
    private IMCommonService imCommonService;
    @Autowired
    private TestService testService;
    @Autowired
    private IMMsgService msgService;

    @PostMapping(value={"/circularPush"})
    public Boolean circularPush(String fromAccount, String toAccount, String businessCode, String treatmentId, Long msgTime) {
        this.busiPushService.sessionRecorder(fromAccount, toAccount, businessCode, treatmentId, msgTime);
        return true;
    }

    @PostMapping(value={"/pushOfflineMsg"})
    public Boolean pushOfflineMsg(String toAccount, String businessCode, String treatmentId) {
        this.busiPushService.pushOfflineMsg(toAccount, businessCode, treatmentId);
        return true;
    }

    @PostMapping(value={"/msg"})
    public Boolean msg(String fromAccount, String toAccount, String businessCode, String treatmentId, Long msgTime) {
        this.busiPushService.pushOfflineMsg(toAccount, businessCode, treatmentId);
        this.busiPushService.sessionRecorder(fromAccount, toAccount, businessCode, treatmentId, msgTime);
        return true;
    }

    @PostMapping(value={"/save/c2c/callback"})
    public void saveTencentC2CMsgCallbackToTest(@RequestBody TestIMTencentCallBackReqVO reqVO) {
        log.info("-------------\u5355\u804a\u6d88\u606f\u56de\u8c03---------" + JSON.toJSONString((Object)reqVO));
        this.testService.saveTencentC2CMsg(reqVO);
    }

    @PostMapping(value={"/save/media/callback"})
    public void saveTencentMediaCallbackToTest(@RequestBody TestIMMixtedFlowCallbackReqVO reqVO) {
        log.info("-------------\u5a92\u4f53\u6587\u4ef6\u56de\u8c03---------" + JSON.toJSONString((Object)reqVO));
        IMMixtedFlowCallbackReqVO callbackReqVO = new IMMixtedFlowCallbackReqVO();
        BeanUtils.copyProperties((Object)reqVO, (Object)callbackReqVO);
        this.imCommonService.endMixedFlow2Business(callbackReqVO);
    }

    @PostMapping(value={"/save/group/callback"})
    public void saveTencentGroupMsgCallbackToTest(@RequestBody TestIMTencentCallBackReqVO reqVO) {
        log.info("-------------\u7fa4\u804a\u6d88\u606f\u56de\u8c03---------" + JSON.toJSONString((Object)reqVO));
        this.testService.saveTencentGroupMsg(reqVO);
    }
}

