/*
 * Decompiled with CFR 0.152.
 */
package com.hxgy.im.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
public class RabbitMqConfig {
    private static final Logger log = LoggerFactory.getLogger(RabbitMqConfig.class);
    private String EXCHANGE = "ehos-im-topic";
    private String QUEUENAME = "ehos-im";
    private static final String LISTEN_KEY = "im.msg.#";
    @Value(value="${spring.rabbitmq.host}")
    private String host;
    @Value(value="${spring.rabbitmq.port}")
    private int port;
    @Value(value="${spring.rabbitmq.username}")
    private String username;
    @Value(value="${spring.rabbitmq.password}")
    private String password;
    private static final String LISTEN_KEY_YCJX = "video.ycjx";
    private static final String QUEUE_NAME_YCJX = "ehos-im-ycjx";
    private static final String LISTEN_KEY_YCHY = "video.ychy";
    private static final String QUEUE_NAME_YCHY = "ehos-im-ychy";

    @Bean(name={"connectionFactory"})
    public ConnectionFactory connectionFactory() {
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory();
        connectionFactory.setAddresses(this.host + ":" + this.port);
        connectionFactory.setUsername(this.username);
        connectionFactory.setPassword(this.password);
        connectionFactory.setVirtualHost("/");
        connectionFactory.setPublisherConfirms(true);
        log.info("MQ\u521d\u59cb\u5316\u8fde\u63a5\u6210\u529f!");
        return connectionFactory;
    }

    @Bean
    @Scope(value="prototype")
    public RabbitTemplate rabbitTemplate() {
        log.info("MQ\u521d\u59cb\u5316\u58f0\u660erabbitTemplate\u6210\u529f!");
        return new RabbitTemplate(this.connectionFactory());
    }

    @Bean
    TopicExchange exchange() {
        log.info("MQ\u521d\u59cb\u5316\u58f0\u660eexchange\u6210\u529f!");
        return new TopicExchange(this.EXCHANGE, true, false);
    }

    @Bean(name={"queue"})
    public Queue queue() {
        log.info("MQ\u521d\u59cb\u5316\u58f0\u660equeue\u6210\u529f!");
        return new Queue(this.QUEUENAME, true);
    }

    @Bean
    public Binding binding() {
        log.info("MQ\u521d\u59cb\u5316\u58f0\u660ebinding\u961f\u5217\u6210\u529f!");
        return BindingBuilder.bind((Queue)this.queue()).to(this.exchange()).with(LISTEN_KEY);
    }

    @Bean(name={"ycjxQueue"})
    public Queue ycjxQueue() {
        log.info("MQ\u521d\u59cb\u5316\u58f0\u660eycjxQueue...\u6210\u529f!");
        return new Queue(QUEUE_NAME_YCJX);
    }

    @Bean
    public Binding ycjxbinding() {
        log.info("MQ\u521d\u59cb\u5316\u58f0\u660eycjxbinding\u961f\u5217\u6210\u529f!");
        return BindingBuilder.bind((Queue)this.ycjxQueue()).to(this.exchange()).with(LISTEN_KEY_YCJX);
    }

    @Bean(name={"ychyQueue"})
    public Queue ychyQueue() {
        log.info("MQ\u521d\u59cb\u5316\u58f0\u660eychyQueue...\u6210\u529f!");
        return new Queue(QUEUE_NAME_YCHY);
    }

    @Bean
    public Binding ychybinding() {
        log.info("MQ\u521d\u59cb\u5316\u58f0\u660eychybinding\u961f\u5217\u6210\u529f!");
        return BindingBuilder.bind((Queue)this.ychyQueue()).to(this.exchange()).with(LISTEN_KEY_YCHY);
    }
}

