/*
 * Decompiled with CFR 0.152.
 */
package com.hxgy.im.config;

import com.xxl.job.core.executor.XxlJobExecutor;
import com.xxl.job.core.executor.impl.XxlJobSpringExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(basePackages={"com.hxgy.im.task"})
public class XxlJobConfig {
    private Logger logger = LoggerFactory.getLogger(XxlJobConfig.class);
    @Value(value="${xxl.job.admin.addresses}")
    private String adminAddresses;
    @Value(value="${xxl.job.executor.appname}")
    private String appName;
    @Value(value="${xxl.job.executor.ip}")
    private String ip;
    @Value(value="${xxl.job.executor.port}")
    private int port;
    @Value(value="${xxl.job.accessToken}")
    private String accessToken;
    @Value(value="${xxl.job.executor.logpath}")
    private String logPath;
    @Value(value="${xxl.job.executor.logretentiondays}")
    private int logRetentionDays;

    @Bean(initMethod="start", destroyMethod="destroy")
    public XxlJobExecutor xxlJobExecutor() {
        XxlJobSpringExecutor xxlJobExecutor = new XxlJobSpringExecutor();
        xxlJobExecutor.setAdminAddresses(this.adminAddresses);
        xxlJobExecutor.setAppName(this.appName);
        xxlJobExecutor.setIp(this.ip);
        xxlJobExecutor.setPort(this.port);
        xxlJobExecutor.setAccessToken(this.accessToken);
        xxlJobExecutor.setLogPath(this.logPath);
        xxlJobExecutor.setLogRetentionDays(this.logRetentionDays);
        this.logger.info(">>>>>>>>>>> xxl-job config inited. <<<<<<<<<<<");
        return xxlJobExecutor;
    }
}

