/*
 * Decompiled with CFR 0.152.
 */
package com.hxgy.im.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EmojiConvertUtil {
    private EmojiConvertUtil() {
    }

    public static String emojiConvert(String emojiStr) throws UnsupportedEncodingException {
        String patternStr = "[\ud83c\udc00-\ud83c\udfff]|[\ud83d\udc00-\ud83d\udfff]|[\u2600-\u27ff]";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(emojiStr);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            try {
                matcher.appendReplacement(sb, "[[" + URLEncoder.encode(matcher.group(0), "UTF-8") + "]]");
            }
            catch (UnsupportedEncodingException e) {
                return emojiStr.replaceAll("[^\\u0000-\\uFFFF]", "(\u8868\u60c5)");
            }
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String emojiRecovery(String str) throws UnsupportedEncodingException {
        if (str == null) {
            return "";
        }
        String patternString = "\\[\\[(.*?)\\]\\]";
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, URLDecoder.decode(matcher.group(1), "UTF-8"));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

