/*
 * Decompiled with CFR 0.152.
 */
package com.hxgy.im.util;

import com.hxgy.im.util.JsonUtils;
import java.nio.charset.Charset;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.zip.Deflater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebRTCSigApi {
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);
    private static final String FIND_ERROR = "\u51fa\u73b0\u5f02\u5e38:";
    private static final String UTF_8 = "UTF-8";
    private int mSdkAppid = 0;
    private PrivateKey mPrivateKey = null;
    private PublicKey mPublicKey = null;

    public void setSdkAppid(int sdkappid) {
        this.mSdkAppid = sdkappid;
    }

    public void setPrivateKey(String privateKey) {
        String privateKeyPEM = privateKey.replace("-----BEGIN PRIVATE KEY-----\r\n", "").replace("-----END PRIVATE KEY-----\r\n", "").replace("\r\n", "");
        byte[] encodedKey = Base64.getDecoder().decode(privateKeyPEM.getBytes());
        try {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encodedKey);
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            this.mPrivateKey = keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            log.error(FIND_ERROR + e.getMessage(), (Throwable)e);
        }
    }

    public void setPublicKey(String publicKey) {
        String publicKeyPEM = publicKey.replace("-----BEGIN PUBLIC KEY-----\r\n", "").replace("-----END PUBLIC KEY-----\r\n", "").replace("\r\n", "");
        byte[] encodedKey = Base64.getDecoder().decode(publicKeyPEM.getBytes());
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encodedKey);
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            this.mPublicKey = keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            log.error(FIND_ERROR + e.getMessage(), (Throwable)e);
        }
    }

    public byte[] sign(byte[] data) {
        try {
            Signature signer = Signature.getInstance("SHA256withECDSA");
            signer.initSign(this.mPrivateKey);
            signer.update(data);
            return signer.sign();
        }
        catch (Exception e) {
            log.error(FIND_ERROR + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean verify(byte[] data, byte[] sig) {
        try {
            Signature signer = Signature.getInstance("SHA256withECDSA");
            signer.initVerify(this.mPublicKey);
            signer.update(data);
            return signer.verify(sig);
        }
        catch (Exception e) {
            log.error(FIND_ERROR + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private byte[] base64UrlEncode(byte[] data) {
        byte[] encode = Base64.getEncoder().encode(data);
        for (int i = 0; i < encode.length; ++i) {
            if (encode[i] == 43) {
                encode[i] = 42;
                continue;
            }
            if (encode[i] == 47) {
                encode[i] = 45;
                continue;
            }
            if (encode[i] != 61) continue;
            encode[i] = 95;
        }
        return encode;
    }

    private byte[] base64UrlDecode(byte[] data) {
        byte[] encode = Arrays.copyOf(data, data.length);
        for (int i = 0; i < encode.length; ++i) {
            if (encode[i] == 42) {
                encode[i] = 43;
                continue;
            }
            if (encode[i] == 45) {
                encode[i] = 47;
                continue;
            }
            if (encode[i] != 95) continue;
            encode[i] = 61;
        }
        return encode;
    }

    public String genUserSig(String userid, int expire) {
        String time = String.valueOf(System.currentTimeMillis() / 1000L);
        String serialString = "TLS.appid_at_3rd:0\nTLS.account_type:0\nTLS.identifier:" + userid + "\nTLS.sdk_appid:" + this.mSdkAppid + "\nTLS.time:" + time + "\nTLS.expire_after:" + expire + "\n";
        byte[] signBytes = this.sign(serialString.getBytes(Charset.forName(UTF_8)));
        String sig = Base64.getEncoder().encodeToString(signBytes);
        String jsonString = "{\"TLS.account_type\":\"0\",\"TLS.identifier\":\"" + userid + "\",\"TLS.appid_at_3rd\":\"" + 0 + "\",\"TLS.sdk_appid\":\"" + this.mSdkAppid + "\",\"TLS.expire_after\":\"" + expire + "\",\"TLS.sig\":\"" + sig + "\",\"TLS.time\":\"" + time + "\",\"TLS.version\": \"201512300000\"}";
        Deflater compresser = new Deflater();
        compresser.setInput(jsonString.getBytes(Charset.forName(UTF_8)));
        compresser.finish();
        byte[] compressBytes = new byte[512];
        int compressBytesLength = compresser.deflate(compressBytes);
        compresser.end();
        String userSig = new String(this.base64UrlEncode(Arrays.copyOfRange(compressBytes, 0, compressBytesLength)));
        return userSig;
    }

    public String genPrivMapEncrypt(String userid, int roomid, int expire) {
        String time = String.valueOf(System.currentTimeMillis() / 1000L);
        int accountLength = userid.length();
        int offset = 0;
        byte[] bytes = new byte[3 + accountLength + 4 + 4 + 4 + 4 + 4];
        bytes[offset++] = 0;
        bytes[offset++] = (byte)((accountLength & 0xFF00) >> 8);
        bytes[offset++] = (byte)(accountLength & 0xFF);
        while (offset < 3 + accountLength) {
            bytes[offset] = (byte)userid.charAt(offset - 3);
            ++offset;
        }
        bytes[offset++] = (byte)((this.mSdkAppid & 0xFF000000) >> 24);
        bytes[offset++] = (byte)((this.mSdkAppid & 0xFF0000) >> 16);
        bytes[offset++] = (byte)((this.mSdkAppid & 0xFF00) >> 8);
        bytes[offset++] = (byte)(this.mSdkAppid & 0xFF);
        long nRoomId = roomid;
        bytes[offset++] = (byte)((nRoomId & 0xFFFFFFFFFF000000L) >> 24);
        bytes[offset++] = (byte)((nRoomId & 0xFF0000L) >> 16);
        bytes[offset++] = (byte)((nRoomId & 0xFF00L) >> 8);
        bytes[offset++] = (byte)(nRoomId & 0xFFL);
        long expiredTime = Long.valueOf(time) + (long)expire;
        bytes[offset++] = (byte)((expiredTime & 0xFFFFFFFFFF000000L) >> 24);
        bytes[offset++] = (byte)((expiredTime & 0xFF0000L) >> 16);
        bytes[offset++] = (byte)((expiredTime & 0xFF00L) >> 8);
        bytes[offset++] = (byte)(expiredTime & 0xFFL);
        bytes[offset++] = 0;
        bytes[offset++] = 0;
        bytes[offset++] = 0;
        bytes[offset++] = -1;
        bytes[offset++] = 0;
        bytes[offset++] = 0;
        bytes[offset++] = 0;
        bytes[offset++] = 0;
        String userbuf = Base64.getEncoder().encodeToString(bytes);
        String serialString = "TLS.appid_at_3rd:0\nTLS.account_type:0\nTLS.identifier:" + userid + "\nTLS.sdk_appid:" + this.mSdkAppid + "\nTLS.time:" + time + "\nTLS.expire_after:" + expire + "\nTLS.userbuf:" + userbuf + "\n";
        byte[] signBytes = this.sign(serialString.getBytes(Charset.forName(UTF_8)));
        String sig = Base64.getEncoder().encodeToString(signBytes);
        String jsonString = "{\"TLS.appid_at_3rd\":\"0\",\"TLS.account_type\":\"0\",\"TLS.identifier\":\"" + userid + "\",\"TLS.sdk_appid\":\"" + this.mSdkAppid + "\",\"TLS.expire_after\":\"" + expire + "\",\"TLS.sig\":\"" + sig + "\",\"TLS.time\":\"" + time + "\",\"TLS.userbuf\":\"" + userbuf + "\",\"TLS.version\": \"201512300000\"}";
        Deflater compresser = new Deflater();
        compresser.setInput(jsonString.getBytes(Charset.forName(UTF_8)));
        compresser.finish();
        byte[] compressBytes = new byte[512];
        int compressBytesLength = compresser.deflate(compressBytes);
        compresser.end();
        String privMapEncrypt = new String(this.base64UrlEncode(Arrays.copyOfRange(compressBytes, 0, compressBytesLength)));
        return privMapEncrypt;
    }
}

