/*
 * Decompiled with CFR 0.152.
 */
package com.hxgy.im.util.oss;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.ObjectMetadata;
import com.hxgy.im.util.UUIDUtil;
import com.hxgy.im.util.oss.OssClientFactory;
import com.hxgy.im.util.oss.OssConfig;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class OssManageUtil {
    private static final Logger log = LoggerFactory.getLogger(OssManageUtil.class);
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    private SimpleDateFormat code_time = new SimpleDateFormat("yyyy/MM/dd");
    public static final String JPG_IMAGE = "jpg";
    public static final String PNG_IMAGE = "png";
    public static final String GIF_IMAGE = "gif";
    public static final String JPEG_IMAGE = "jpeg";
    private static List<String> images = null;
    private static List<String> videos = null;

    public static Map<String, Object> uploadFile(String fileDir, MultipartFile multipartFile) {
        OSSClient ossClient = OssClientFactory.createOSSClient();
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        try {
            InputStream inputStream = multipartFile.getInputStream();
            boolean fileDirExit = ossClient.doesObjectExist(OssConfig.BUCKET_NAME, fileDir);
            if (!fileDirExit) {
                ObjectMetadata objectMetadata = new ObjectMetadata();
                byte[] buffer = new byte[]{};
                try (ByteArrayInputStream in = new ByteArrayInputStream(buffer);){
                    objectMetadata.setContentLength(0L);
                    ossClient.putObject(OssConfig.BUCKET_NAME, fileDir, (InputStream)in, objectMetadata);
                }
                catch (Exception e) {
                    log.error("\u51fa\u73b0\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
                }
            }
            String prefix = multipartFile.getOriginalFilename().substring(multipartFile.getOriginalFilename().lastIndexOf(".") + 1);
            String fileUuid = UUIDUtil.getUUID();
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentType("image/jpeg");
            meta.setCacheControl("max-age=8640000");
            meta.setContentLength(multipartFile.getSize());
            long currentTime = System.currentTimeMillis();
            ossClient.putObject(OssConfig.BUCKET_NAME, fileDir + "/" + currentTime + "_" + fileUuid + "." + prefix, inputStream, meta);
            String returl = OssConfig.ACCESS_URL + "/" + fileDir + "/" + currentTime + "_" + fileUuid + "." + prefix;
            map.put("urlpath", returl);
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
        return map;
    }

    static {
        images = new ArrayList();
        images.add(JPG_IMAGE);
        images.add(PNG_IMAGE);
        images.add(GIF_IMAGE);
        images.add("JPG");
        images.add("PNG");
        images.add("GIF");
        videos = new ArrayList();
        videos.add("mp4");
        videos.add("mov");
        videos.add("avi");
        videos.add("wmv");
    }
}

