/*
 * Decompiled with CFR 0.152.
 */
package com.hxgy.im.config;

import com.hxgy.im.enums.BusiPushTypeEnum;
import com.hxgy.im.enums.CallBackBusinessEnum;
import com.hxgy.im.pojo.entity.IMMixtedFlowEntity;
import com.hxgy.im.pojo.entity.ImMediaProcessEntity;
import com.hxgy.im.repository.mapper.ImMediaProcessMapper;
import com.hxgy.im.repository.mapper.ImMixtedFlowMapper;
import com.hxgy.im.service.IMBusiPushService;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DelayedAudioProcessReceiver {
    private static final Logger log = LoggerFactory.getLogger(DelayedAudioProcessReceiver.class);
    @Autowired
    private ImMixtedFlowMapper imMixtedFlowMapper;
    @Autowired
    private ImMediaProcessMapper imMediaProcessMapper;
    @Autowired
    private IMBusiPushService imBusiPushService;

    @RabbitListener(queues={"audio.delayed.order.test"})
    @RabbitHandler
    public void process(String fileId) {
        try {
            log.info("=========================fileId: " + fileId);
            IMMixtedFlowEntity audioEntity = this.imMixtedFlowMapper.findOneByFileId(fileId);
            log.info("----uploadAudioMsg--audioEntity:{}", (Object)audioEntity);
            ImMediaProcessEntity imMediaProcessEntity = this.imMediaProcessMapper.selectByFileId(fileId);
            log.info("----uploadAudioMsg--imMediaProcessEntity:{}", (Object)imMediaProcessEntity);
            String sessionId = audioEntity.getSessionId();
            Long startTime = imMediaProcessEntity.getStartTime();
            Long endTime = imMediaProcessEntity.getEndTime();
            log.info("----uploadAudioMsg--sessionId:{},-----startTime:{},-----endTime:{}", new Object[]{sessionId, startTime, endTime});
            IMMixtedFlowEntity imMixtedFlowEntity = this.imMixtedFlowMapper.selectByOneSession(sessionId, startTime, endTime);
            log.info("----uploadAudioMsg--imMixtedFlowEntity:{}", (Object)imMixtedFlowEntity);
            if (imMixtedFlowEntity == null) {
                this.imBusiPushService.audioProcessPushToBusinessNew(imMediaProcessEntity, BusiPushTypeEnum.MEDIA_TRANSCODE, true);
                this.updateImMixtedFlowInfo(fileId, CallBackBusinessEnum.STATUS_PUSH.getValue());
            } else {
                this.updateImMixtedFlowInfo(fileId, CallBackBusinessEnum.STATUS_NO_PUSH.getValue());
            }
            log.info("----uploadAudioMsg--\u65b9\u6cd5\u5b8c\u6210");
        }
        catch (Exception e) {
            log.info("---------mq\u6d88\u8d39\u5f02\u5e38---------", (Throwable)e);
        }
    }

    public void updateImMixtedFlowInfo(String fileId, String callBackBusiness) {
        IMMixtedFlowEntity imMixtedFlow = this.imMixtedFlowMapper.findOneByFileId(fileId);
        log.info("----uploadAudioMsg--imMixtedFlow:{}", (Object)imMixtedFlow);
        imMixtedFlow.setCallBackBusiness(callBackBusiness);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        imMixtedFlow.setUpdateDateTime(format.format(new Date()));
        this.imMixtedFlowMapper.update(imMixtedFlow);
    }
}

