/*
 * Decompiled with CFR 0.152.
 */
package com.hxgy.im.logback;

import com.alibaba.fastjson.JSONObject;
import com.hxgy.im.logback.fs.FeiShuMessage;
import com.hxgy.im.logback.wx.Message;
import com.hxgy.im.util.HttpClientUtils;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageManager {
    private static final Logger log = LogManager.getLogger(MessageManager.class);

    public static boolean sendMessage(Message message, String webHookAddress) {
        OkHttpClient client = new OkHttpClient();
        client.setConnectTimeout(10L, TimeUnit.SECONDS);
        client.setReadTimeout(20L, TimeUnit.SECONDS);
        MediaType contentType = MediaType.parse((String)"application/json; charset=utf-8");
        RequestBody body = RequestBody.create((MediaType)contentType, (String)JSONObject.toJSONString((Object)message));
        Request request = new Request.Builder().url(webHookAddress).post(body).addHeader("cache-control", "no-cache").build();
        try {
            log.info("===\u5f00\u59cb\u8c03\u7528\u4f01\u4e1a\u5fae\u4fe1\u53d1\u9001\u6d88\u606f!");
            Response response = client.newCall(request).execute();
            byte[] datas = response.body().bytes();
            String respMsg = new String(datas);
            JSONObject resultJSON = JSONObject.parseObject((String)respMsg);
            if (resultJSON.getIntValue("errcode") == 0) {
                log.info("\u6d88\u606f\u53d1\u9001\u6210\u529f!");
                return true;
            }
            log.info("\u6d88\u606f\u53d1\u9001\u5931\u8d25, \u9519\u8bef\u4fe1\u606f\u5982\u4e0b: {}", (Object)resultJSON.getString("errmsg"));
            return false;
        }
        catch (IOException e) {
            log.info("\u6d88\u606f\u53d1\u9001\u5931\u8d25, \u5f02\u5e38\u4fe1\u606f\u5982\u4e0b: {}", (Object)e.getMessage());
            return false;
        }
    }

    public static boolean sendFeiShuMessage(FeiShuMessage message, String webHookAddress) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("msg_type", "text");
        params.put("content", message.getContent().toJSONString());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        try {
            log.info("===\u5f00\u59cb\u8c03\u7528\u98de\u4e66\u53d1\u9001\u6d88\u606f!");
            String respMsg = HttpClientUtils.simplePostInvokeHeaders((String)webHookAddress, params, headers);
            System.out.println(respMsg);
            JSONObject resultJSON = JSONObject.parseObject((String)respMsg);
            if (resultJSON.getInteger("StatusCode") == 0) {
                log.info("\u6d88\u606f\u53d1\u9001\u6210\u529f!");
                return true;
            }
            log.info("\u6d88\u606f\u53d1\u9001\u5931\u8d25, \u9519\u8bef\u4fe1\u606f\u5982\u4e0b: {}", (Object)resultJSON.getString("msg"));
            return false;
        }
        catch (Exception e) {
            log.info("\u6d88\u606f\u53d1\u9001\u5931\u8d25, \u5f02\u5e38\u4fe1\u606f\u5982\u4e0b: {}", (Object)e.getMessage());
            return false;
        }
    }
}

