/*
 * Decompiled with CFR 0.152.
 */
package com.hxgy.im.repository.dao.impl;

import com.hxgy.im.pojo.bo.IMQueryMsgParamsBO;
import com.hxgy.im.pojo.bo.IMSingleMsgResultBO;
import com.hxgy.im.pojo.bo.QueryImNoReadMsgParamsBO;
import com.hxgy.im.pojo.vo.IMGroupListVO;
import com.hxgy.im.pojo.vo.IMGroupMemberReqVO;
import com.hxgy.im.pojo.vo.IMGroupMemberVO;
import com.hxgy.im.repository.dao.IMJskfMsgDao;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class IMJskfMsgDaoImpl
implements IMJskfMsgDao {
    Logger logger = LoggerFactory.getLogger(IMJskfMsgDaoImpl.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private static final String LIMIT = " limit ";

    public List<IMSingleMsgResultBO> querySingleMsg(IMQueryMsgParamsBO paramsBO) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(" select DISTINCT  bean.id,bean.api_msg_id as apiMsgId,bean.time_stamp as timeStamp,bean.session_id as sessionId,");
        sqlBuilder.append(" bean.client_msg_id as clientMsgId, bean.msg_time as msgTime, bean.duration as duration ,bean.message as msgContent, ");
        sqlBuilder.append(" bean.msg_type as msgType ,bean.status , sender.sdk_account as sendSdkAccount,receiver.sdk_account as receSdkAccount,");
        sqlBuilder.append(" sess.treatment_id as appointmentId,sender.from_nick as sendFromNick,sess.business_code as businessCode ");
        sqlBuilder.append(" from im_message_jskf  bean ");
        sqlBuilder.append(" left join im_account sender on sender.id = bean.sender_id ");
        sqlBuilder.append(" left join im_account receiver on receiver.id = bean.receiver_id ");
        sqlBuilder.append(" left join im_session_jskf sess on sess.id = bean.session_id ");
        sqlBuilder.append(" left join im_single_msg_relation_jskf msgrelation on msgrelation.single_msg_id = bean.id ");
        sqlBuilder.append(" where bean.session_id in (");
        sqlBuilder.append(paramsBO.getSessionIds());
        sqlBuilder.append(" ) ");
        sqlBuilder.append(" and bean.status = 0 ");
        if (StringUtils.isNotBlank((CharSequence)paramsBO.getAccountId())) {
            sqlBuilder.append(" and (msgrelation.receiver_id is null or msgrelation.receiver_id = '");
            sqlBuilder.append(paramsBO.getAccountId());
            sqlBuilder.append("') ");
        }
        if (StringUtils.isNotBlank((CharSequence)paramsBO.getStartDate())) {
            sqlBuilder.append(" and bean.msg_time >= '");
            sqlBuilder.append(paramsBO.getStartDate());
            sqlBuilder.append("'");
        }
        if (StringUtils.isNotBlank((CharSequence)paramsBO.getEndDate())) {
            sqlBuilder.append(" and bean.msg_time <= '");
            sqlBuilder.append(paramsBO.getEndDate());
            sqlBuilder.append("'");
        }
        sqlBuilder.append("  GROUP BY bean.id ");
        if (StringUtils.isNotBlank((CharSequence)paramsBO.getSortOrder())) {
            sqlBuilder.append(" order by bean.msg_time " + paramsBO.getSortOrder());
        } else {
            sqlBuilder.append(" order by bean.msg_time DESC");
        }
        Integer page = paramsBO.getPage();
        Integer pageSize = paramsBO.getPageSize();
        Integer pa = page * pageSize;
        sqlBuilder.append(LIMIT + pa + "," + pageSize);
        this.logger.info("\u67e5\u8be2\u5355\u804a\u5386\u53f2\u6d88\u606f selectSql= {} ", (Object)sqlBuilder.toString());
        return this.jdbcTemplate.query(sqlBuilder.toString(), new Object[0], (RowMapper)new BeanPropertyRowMapper(IMSingleMsgResultBO.class));
    }

    public List<IMSingleMsgResultBO> queryGroupMsg(IMQueryMsgParamsBO paramsBO) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(" select DISTINCT msg.id,msg.client_msg_id,msg.time_stamp,msg.session_id, ");
        sqlBuilder.append(" msg.api_msg_id,msg.msg_time,msg.duration,msg.group_id,msg.msg_content,msg.msg_type, ");
        sqlBuilder.append(" sender.sdk_account as sendSdkAccount,sender.from_nick as sendFromNick, ");
        sqlBuilder.append(" receive.sdk_account as receSdkAccount,sess.treatment_id as appointmentId,sess.business_code as businessCode  ");
        sqlBuilder.append("  from im_group_msg msg ");
        sqlBuilder.append("  left join im_group_msg_relation msgPo on msgPo.group_msg_id = msg.id  ");
        sqlBuilder.append("  left join im_account sender on sender.id = msg.sender_id");
        sqlBuilder.append("  left join im_account receive on msgPo.receiver_id = receive.id");
        sqlBuilder.append("  left join im_session_jskf sess on msg.session_id = sess.id ");
        sqlBuilder.append(" where msg.session_id in (");
        sqlBuilder.append(paramsBO.getSessionIds());
        sqlBuilder.append(") ");
        if (StringUtils.isNotBlank((CharSequence)paramsBO.getAccountId())) {
            sqlBuilder.append(" and ( msgPo.receiver_id is null  or msgPo.receiver_id = '");
            sqlBuilder.append(paramsBO.getAccountId());
            sqlBuilder.append("')");
        }
        if (StringUtils.isNotBlank((CharSequence)paramsBO.getStartDate())) {
            sqlBuilder.append(" and msg.msg_time >= '");
            sqlBuilder.append(paramsBO.getStartDate());
            sqlBuilder.append("'");
        }
        if (StringUtils.isNotBlank((CharSequence)paramsBO.getEndDate())) {
            sqlBuilder.append(" and msg.msg_time <= '");
            sqlBuilder.append(paramsBO.getEndDate());
            sqlBuilder.append("'");
        }
        sqlBuilder.append(" GROUP BY msg.id ");
        if (StringUtils.isNotBlank((CharSequence)paramsBO.getSortOrder())) {
            sqlBuilder.append(" order by msg.msg_time " + paramsBO.getSortOrder());
        } else {
            sqlBuilder.append(" order by msg.msg_time DESC");
        }
        Integer page = paramsBO.getPage();
        Integer pageSize = paramsBO.getPageSize();
        Integer pa = page * pageSize;
        sqlBuilder.append(LIMIT + pa + "," + pageSize);
        this.logger.info("\u67e5\u8be2\u7fa4\u804a\u5386\u53f2\u6d88\u606f sql= {} ", (Object)sqlBuilder.toString());
        return this.jdbcTemplate.query(sqlBuilder.toString(), new Object[0], (RowMapper)new BeanPropertyRowMapper(IMSingleMsgResultBO.class));
    }

    public List<IMSingleMsgResultBO> queryImNoReadMsg(QueryImNoReadMsgParamsBO paramsBO) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(" select DISTINCT msg.id,msg.client_msg_id,msg.time_stamp,msg.session_id, ");
        sqlBuilder.append(" msg.api_msg_id,msg.msg_time,msg.duration,msg.group_id,msg.msg_content,msg.msg_type,");
        sqlBuilder.append(" sender.sdk_account as sendSdkAccount,sender.from_nick as sendFromNick,");
        sqlBuilder.append(" receive.sdk_account as receSdkAccount,sess.treatment_id as appointmentId ");
        sqlBuilder.append(" from im_group_msg msg ");
        sqlBuilder.append(" left join im_group_msg_relation msgPo on msgPo.group_msg_id = msg.id");
        sqlBuilder.append(" left join im_account sender on sender.id = msg.sender_id ");
        sqlBuilder.append(" left join im_account receive on msgPo.receiver_id = receive.id ");
        sqlBuilder.append(" left join im_session_jskf sess on msg.session_id = sess.id");
        sqlBuilder.append("  where  msg.session_id in (");
        sqlBuilder.append("  SELECT sx.id FROM im_session_jskf sx");
        sqlBuilder.append("  WHERE sx.id in (");
        sqlBuilder.append("   SELECT DISTINCT mx.session_id FROM im_member_jskf mx");
        sqlBuilder.append(" WHERE mx.account_id = (");
        sqlBuilder.append(" SELECT bean.id  FROM im_account bean");
        sqlBuilder.append(" WHERE 1=1 AND bean.sdk_account = '");
        sqlBuilder.append(paramsBO.getSdkAccount());
        sqlBuilder.append("'");
        sqlBuilder.append(" AND bean.app_id = (");
        sqlBuilder.append(" SELECT app.id FROM im_application app ");
        sqlBuilder.append(" WHERE app.app_code = '");
        sqlBuilder.append(paramsBO.getAppCode());
        sqlBuilder.append("'");
        sqlBuilder.append(")");
        sqlBuilder.append(")");
        sqlBuilder.append(" GROUP BY mx.session_id");
        sqlBuilder.append(")");
        sqlBuilder.append(")");
        if (StringUtils.isNotEmpty((CharSequence)paramsBO.getStartDate())) {
            sqlBuilder.append(" and msg.msg_time > '");
            sqlBuilder.append(paramsBO.getStartDate());
            sqlBuilder.append("'");
        }
        sqlBuilder.append(" AND (msgPo.receiver_id = (");
        sqlBuilder.append(" SELECT bean.id  FROM im_account bean");
        sqlBuilder.append(" WHERE 1=1 AND bean.sdk_account = '");
        sqlBuilder.append(paramsBO.getSdkAccount());
        sqlBuilder.append("'");
        sqlBuilder.append(" AND bean.app_id = (");
        sqlBuilder.append(" SELECT app.id FROM im_application app ");
        sqlBuilder.append(" WHERE app.app_code = '");
        sqlBuilder.append(paramsBO.getAppCode());
        sqlBuilder.append("'");
        sqlBuilder.append(")");
        sqlBuilder.append(")");
        sqlBuilder.append(" OR msgPo.receiver_id IS NULL)");
        sqlBuilder.append(" ORDER BY msg.msg_time DESC ");
        if (StringUtils.isEmpty((CharSequence)paramsBO.getStartDate())) {
            sqlBuilder.append(" limit 1");
        }
        return this.jdbcTemplate.query(sqlBuilder.toString(), new Object[0], (RowMapper)new BeanPropertyRowMapper(IMSingleMsgResultBO.class));
    }

    public List<IMGroupMemberVO> groupMember(IMGroupMemberReqVO reqVO) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("  select DISTINCT ia.user_id as userId , \nia.sdk_account as sdkAccount, \nia.from_nick as fromNick, \nia.head_url as headUrl, ise.create_user  as createUser,ise.treatment_id  as  treatmentId, ise.room_num as roomNum ");
        sqlBuilder.append(" from im_session_jskf ise,im_member_jskf im,im_account ia ");
        sqlBuilder.append(" where ise.id=im.session_id and im.account_id=ia.id and IFNULL(ise.group_die,'') <> '2' ");
        if (StringUtils.isNotBlank((CharSequence)reqVO.getGroupId())) {
            sqlBuilder.append(" and ise.group_id= '");
            sqlBuilder.append(reqVO.getGroupId());
            sqlBuilder.append("'");
        }
        if (null != reqVO.getRoomNum()) {
            sqlBuilder.append(" and ise.room_num= '");
            sqlBuilder.append(reqVO.getRoomNum());
            sqlBuilder.append("'");
        }
        sqlBuilder.append(" order by ia.create_date_time DESC");
        Integer page = reqVO.getPage() - 1;
        Integer pageSize = reqVO.getPageSize();
        Integer pa = page * pageSize;
        sqlBuilder.append(LIMIT + pa + "," + pageSize);
        this.logger.info("\u67e5\u8be2\u7fa4\u7ec4\u6210\u5458 sql= {} ", (Object)sqlBuilder.toString());
        return this.jdbcTemplate.query(sqlBuilder.toString(), new Object[0], (RowMapper)new BeanPropertyRowMapper(IMGroupMemberVO.class));
    }

    public List<IMGroupListVO> groupList(String userId) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(" select DISTINCT ise.group_id groupId, ise.group_name groupName,   ise.group_logo groupLogo,ise.room_num roomNum   from im_session_jskf ise,im_member_jskf im,im_account ia   where ise.id=im.session_id and im.account_id=ia.id   and ise.type=2 and business_code='ptlt' and IFNULL(ise.group_die,'') <> '2' ");
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            sqlBuilder.append(" and ia.user_id='");
            sqlBuilder.append(userId);
            sqlBuilder.append("'");
        }
        this.logger.info("\u7fa4\u7ec4\u5217\u8868 sql= {} ", (Object)sqlBuilder.toString());
        return this.jdbcTemplate.query(sqlBuilder.toString(), new Object[0], (RowMapper)new BeanPropertyRowMapper(IMGroupListVO.class));
    }
}

