/*
 * Decompiled with CFR 0.152.
 */
package com.hxgy.im.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.hxgy.im.enums.BusiCodeEnum;
import com.hxgy.im.enums.BusiPushStatusEnum;
import com.hxgy.im.enums.BusiPushTypeEnum;
import com.hxgy.im.pojo.bo.TencentCustomElemMsgVo;
import com.hxgy.im.pojo.bo.TencentSingleMsgExtBO;
import com.hxgy.im.pojo.entity.IMBusiPushConfigEntity;
import com.hxgy.im.pojo.entity.ImAccountEntity;
import com.hxgy.im.pojo.entity.ImApplicationEntity;
import com.hxgy.im.pojo.entity.ImGroupMsgEntity;
import com.hxgy.im.pojo.entity.ImMessageEntity;
import com.hxgy.im.pojo.entity.ImMessageJskfEntity;
import com.hxgy.im.pojo.entity.ImSessionEntity;
import com.hxgy.im.pojo.entity.ImSessionJskfEntity;
import com.hxgy.im.pojo.vo.TestIMTencentCallBackReqVO;
import com.hxgy.im.pojo.vo.TestTencentCustomElemMsgVo;
import com.hxgy.im.pojo.vo.TestTencentMsgBodyVO;
import com.hxgy.im.pojo.vo.TestTencentSingleMsgExtBO;
import com.hxgy.im.repository.ImAccountRepository;
import com.hxgy.im.repository.ImApplicationRepository;
import com.hxgy.im.repository.ImBusiPushConfigRepository;
import com.hxgy.im.repository.ImGroupMsgRepository;
import com.hxgy.im.repository.ImMessageJskfRepository;
import com.hxgy.im.repository.ImMessageRepository;
import com.hxgy.im.repository.ImSessionJskfRepository;
import com.hxgy.im.repository.ImSessionRepository;
import com.hxgy.im.service.IMBusiPushService;
import com.hxgy.im.util.DateUtils;
import com.hxgy.im.util.EmojiConvertUtil;
import com.hxgy.im.util.JsonUtils;
import com.hxgy.im.util.RestTemplateUtils;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class TestService {
    private static final Logger log = LoggerFactory.getLogger(TestService.class);
    @Autowired
    private ImSessionRepository sessionRepository;
    @Autowired
    private ImAccountRepository accountRepository;
    @Autowired
    private ImApplicationRepository appRepository;
    @Autowired
    private ImMessageRepository singleMsgRepository;
    @Autowired
    private IMBusiPushService imBusiPushService;
    @Autowired
    private ImGroupMsgRepository groupMsgRepository;
    @Autowired
    private ImBusiPushConfigRepository pushConfigRepository;
    @Resource(name="toTestAsyncPool")
    private ThreadPoolTaskExecutor toTestAsyncPool;
    @Autowired
    private ImSessionJskfRepository imSessionJskfRepository;
    @Autowired
    private ImMessageJskfRepository imMessageJskfRepository;

    public void saveTencentC2CMsg(TestIMTencentCallBackReqVO reqVO) {
        log.info("----\u6d4b\u8bd5\u73af\u5883---\u5355\u804a\u6d88\u606f\u56de\u8c03 \u4fdd\u5b58 \u8fdb\u5165service\u65b9\u6cd5!!!==>reqVO:{}", (Object)JSONObject.toJSONString((Object)reqVO));
        List msgBodyList = reqVO.getMsgBody();
        if (msgBodyList == null) {
            log.error("----\u6d4b\u8bd5\u73af\u5883---\u89e3\u6790\u5355\u804a\u6d88\u606f\u65f6msgBodyList\u662f\u7a7a\u7684\uff0c\u4e0d\u6267\u884c\u4efb\u4f55\u64cd\u4f5c!");
            return;
        }
        Map<String, TestTencentMsgBodyVO> msgTypeMap = msgBodyList.stream().collect(Collectors.toMap(TestTencentMsgBodyVO::getMsgType, a -> a, (k1, k2) -> k1));
        TestTencentMsgBodyVO cutomElmMsg = msgTypeMap.get("TIMCustomElem");
        if (cutomElmMsg == null) {
            log.error("---\u7ecf\u89e3\u6790\u81ea\u5b9a\u4e49\u6d88\u606f\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u6267\u884c\u4efb\u4f55\u64cd\u4f5c!");
            return;
        }
        Object cusMsgContent = cutomElmMsg.getMsgContent();
        TestTencentMsgBodyVO textElmMsg = msgTypeMap.get("TIMTextElem");
        TestTencentCustomElemMsgVo customVoData = (TestTencentCustomElemMsgVo)JSON.parseObject((String)JSON.toJSONString((Object)cusMsgContent), TestTencentCustomElemMsgVo.class);
        String diyData = customVoData.getData();
        if (StringUtils.isBlank((CharSequence)diyData)) {
            log.error("---\u5355\u804a\u6d88\u606f\u81ea\u5b9a\u4e49\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u6267\u884c\u4efb\u4f55\u64cd\u4f5c!");
            return;
        }
        TestTencentSingleMsgExtBO extBo = (TestTencentSingleMsgExtBO)JsonUtils.convertObject((String)diyData.replaceAll("\n", ""), TestTencentSingleMsgExtBO.class);
        Long userAction = extBo.getUserAction();
        if (userAction == null || userAction == 0L) {
            log.error("----\u6d4b\u8bd5\u73af\u5883---userAction\u662f\u7a7a\u62160\u7684\uff0c\u4e0d\u6267\u884c\u4efb\u4f55\u64cd\u4f5c!");
            return;
        }
        int intValue = userAction.intValue();
        if (2000 == intValue || 2050 == intValue) {
            Long msgTime;
            Long currentMaxMsgId;
            String busiCode = extBo.getBusinessCode();
            String treatmentId = extBo.getAppointmentId();
            ImSessionJskfEntity imSessionJskfEntity = this.imSessionJskfRepository.findByBusiCodeAndTreatmentId(busiCode, treatmentId);
            String sessionId = "";
            Boolean zkFlag = false;
            if (Objects.isNull(imSessionJskfEntity)) {
                ImSessionEntity session = this.sessionRepository.findByBusiCodeAndTreatmentId(busiCode, treatmentId);
                if (session == null) {
                    log.error("\u5355\u804a\u6d88\u606f\u63a5\u6536\u67e5\u8be2session\u65f6\u4e3a\u7a7a\uff0c\u4e0d\u6267\u884c\u4efb\u4f55\u64cd\u4f5c");
                    this.toTestAsyncPool.execute(() -> this.msgProToDev(reqVO, "c2cToTest", "im_test"));
                    return;
                }
                sessionId = session.getId();
            } else {
                sessionId = imSessionJskfEntity.getId();
                zkFlag = true;
            }
            String fromAccount = reqVO.getFromAccount();
            String toAccount = reqVO.getToAccount();
            String[] splitFacc = fromAccount.split("\\*");
            String[] splitTacc = toAccount.split("\\*");
            String fromAppCode = splitFacc[1];
            String toAppCode = splitTacc[1];
            ImApplicationEntity fromApp = this.appRepository.findByAppCode(fromAppCode);
            String fromAppId = fromApp.getId();
            ImApplicationEntity toApp = this.appRepository.findByAppCode(toAppCode);
            String toAppId = toApp.getId();
            ImAccountEntity fromAcc = this.accountRepository.findByAppIdAndSdkAccount(fromAppId, fromAccount);
            ImAccountEntity toAcc = this.accountRepository.findByAppIdAndSdkAccount(toAppId, toAccount);
            String extMsgType = extBo.getMsgType();
            ImMessageEntity msgEntity = new ImMessageEntity();
            if (zkFlag.booleanValue()) {
                currentMaxMsgId = this.imMessageJskfRepository.findByMsgIdMax();
                msgEntity.setMsgId(Long.valueOf(currentMaxMsgId + 1L));
            } else {
                currentMaxMsgId = this.singleMsgRepository.findByMsgIdMax();
                msgEntity.setMsgId(Long.valueOf(currentMaxMsgId + 1L));
            }
            Long msgSeq = reqVO.getMsgSeq();
            msgEntity.setApiMsgId(msgSeq == null ? null : String.valueOf(msgSeq));
            msgEntity.setClientMsgId(extBo.getMsgId());
            if ("TEXT".equalsIgnoreCase(extMsgType)) {
                msgEntity.setMsgType("TIMTextElem");
                if (textElmMsg != null) {
                    try {
                        Object textObj = textElmMsg.getMsgContent();
                        String textObjStr = JSON.toJSONString((Object)textObj);
                        JSONObject text = JSON.parseObject((String)textObjStr);
                        msgEntity.setMessage(EmojiConvertUtil.emojiConvert((String)text.getString("Text")));
                    }
                    catch (Exception e) {
                        log.error("emoji\u8868\u60c5\u8f6c\u6362\u5931\u8d25!{}", (Throwable)e);
                    }
                }
            } else if ("SOUND".equalsIgnoreCase(extMsgType)) {
                msgEntity.setDuration(extBo.getDuration());
                msgEntity.setMsgType("TIMSoundElem");
                msgEntity.setMessage(extBo.getAttacheUrl());
            } else if ("PICTURE".equalsIgnoreCase(extMsgType)) {
                msgEntity.setMsgType("TIMImageElem");
                msgEntity.setMessage(extBo.getAttacheUrl());
            } else {
                log.error("\u65e0\u6cd5\u89e3\u6790\u7684\u81ea\u5b9a\u4e49\u6d88\u606f\u771f\u5b9e\u7c7b\u578b:{}", (Object)extMsgType);
                return;
            }
            if ((msgTime = reqVO.getMsgTime()) != null) {
                msgEntity.setMsgTime(DateUtils.longToStrDate((String)"yyyy-MM-dd HH:mm:ss", (long)(msgTime * 1000L)));
                msgEntity.setTimeStamp(msgTime);
            } else {
                msgEntity.setMsgTime(DateUtils.getCurrentDateToString());
                msgEntity.setTimeStamp(DateUtils.getSecondTimestamp());
            }
            msgEntity.setOptPlatform(reqVO.getOptPlatform());
            msgEntity.setReceiverId(toAcc.getId());
            msgEntity.setSenderId(fromAcc.getId());
            msgEntity.setSessionId(sessionId);
            if (zkFlag.booleanValue()) {
                ImMessageJskfEntity singleJskfMsg = new ImMessageJskfEntity();
                BeanUtils.copyProperties((Object)msgEntity, (Object)singleJskfMsg);
                this.imMessageJskfRepository.saveAndFlush((Object)singleJskfMsg);
            } else {
                this.singleMsgRepository.saveAndFlush((Object)msgEntity);
            }
            if (BusiCodeEnum.JTYS.getBusiCodeEnumValue().equals(busiCode)) {
                this.imBusiPushService.pushUnreadMsg(busiCode, BusiPushTypeEnum.MSG_JTYS_UN_READ, msgEntity);
            }
            if (BusiCodeEnum.ZXZX.getBusiCodeEnumValue().equals(busiCode)) {
                this.imBusiPushService.pushOfflineMsg(toAccount, busiCode, treatmentId);
            } else {
                this.imBusiPushService.pushOfflineMsgV2(toAccount, busiCode, treatmentId);
            }
            this.imBusiPushService.sessionRecorder(fromAccount, toAccount, busiCode, treatmentId, msgTime);
        }
    }

    public void saveTencentGroupMsg(TestIMTencentCallBackReqVO reqVO) {
        log.info("=========----\u6d4b\u8bd5\u73af\u5883---im.msg.group.msg\u8fdb\u5165saveTencentGroupMsg=========");
        String fromAccount = reqVO.getFromAccount();
        Long apiMsgId = reqVO.getMsgSeq();
        Long sendMsgTime = reqVO.getMsgTime();
        String optPlatform = reqVO.getOptPlatform();
        List msgBodys = reqVO.getMsgBody();
        if (msgBodys == null || msgBodys.isEmpty()) {
            log.info("----\u6d4b\u8bd5\u73af\u5883---\u7fa4\u7ec4\u6d88\u606f  msgBodys >>>>> is null> {} , completed!", (Object)msgBodys);
            return;
        }
        Map<String, TestTencentMsgBodyVO> mapByType = msgBodys.stream().collect(Collectors.toMap(TestTencentMsgBodyVO::getMsgType, a -> a, (k1, k2) -> k1));
        TestTencentMsgBodyVO textBodyVO = mapByType.get("TIMTextElem");
        TestTencentMsgBodyVO customBodyVO = mapByType.get("TIMCustomElem");
        if (customBodyVO == null) {
            log.error("----\u6d4b\u8bd5\u73af\u5883---\u7fa4\u7ec4\u6d88\u606f  customElem >>>>> is null>{} , completed!", (Object)customBodyVO);
            return;
        }
        Object cusObj = customBodyVO.getMsgContent();
        TencentCustomElemMsgVo customElemVo = (TencentCustomElemMsgVo)JsonUtils.convertObject((String)JsonUtils.convertObject((Object)cusObj), TencentCustomElemMsgVo.class);
        String cusElemData = customElemVo.getData();
        TencentSingleMsgExtBO extVo = (TencentSingleMsgExtBO)JsonUtils.convertObject((String)cusElemData.replaceAll("\n", ""), TencentSingleMsgExtBO.class);
        if (extVo == null) {
            log.info("----\u6d4b\u8bd5\u73af\u5883---\u7fa4\u7ec4\u6d88\u606f extVo >>>>> is null>{} , completed!", (Object)extVo);
            return;
        }
        Long userAction = extVo.getUserAction();
        if (userAction == 2050L || userAction == 2000L) {
            ImGroupMsgEntity groupMsgPo;
            String clientMsgId = extVo.getMsgId();
            if (StringUtils.isNotBlank((CharSequence)clientMsgId) && (groupMsgPo = this.groupMsgRepository.findByClientMsgId(clientMsgId)) != null) {
                log.info("----\u6d4b\u8bd5\u73af\u5883---\u7fa4\u7ec4\u6d88\u606f  clientMsgId > {} >>>>> is already exist! , completed!", (Object)clientMsgId);
                return;
            }
            String uniqueId = extVo.getAppointmentId();
            String busiCode = extVo.getBusinessCode();
            ImSessionJskfEntity imSessionJskfEntity = this.imSessionJskfRepository.findByBusiCodeAndTreatmentId(busiCode, uniqueId);
            ImSessionEntity session = new ImSessionEntity();
            if (Objects.isNull(imSessionJskfEntity)) {
                session = this.sessionRepository.findByBusiCodeAndTreatmentId(busiCode, uniqueId);
                if (session == null) {
                    log.info("\u7fa4\u7ec4\u6d88\u606f  session > {}-{} >>>>> is not exist! , completed!", (Object)busiCode, (Object)uniqueId);
                    this.toTestAsyncPool.execute(() -> this.msgProToDev(reqVO, "groupTest", "im_test"));
                    return;
                }
            } else {
                BeanUtils.copyProperties((Object)imSessionJskfEntity, (Object)session);
            }
            String[] splitAcocunt = fromAccount.split("\\*");
            String fromAppCode = splitAcocunt[1];
            ImApplicationEntity fromApp = this.appRepository.findByAppCode(fromAppCode);
            ImAccountEntity fAccount = this.accountRepository.findByAppIdAndSdkAccount(fromApp.getId(), fromAccount);
            String msgType = extVo.getMsgType();
            ImGroupMsgEntity imGroupMsgEntity = new ImGroupMsgEntity();
            Long currentMaxMsgId = this.groupMsgRepository.findByMsgIdMax();
            imGroupMsgEntity.setMsgId(Long.valueOf(currentMaxMsgId + 1L));
            if ("SOUND".equalsIgnoreCase(msgType)) {
                imGroupMsgEntity.setMsgContent(extVo.getAttacheUrl());
                imGroupMsgEntity.setDuration(extVo.getDuration());
                imGroupMsgEntity.setMsgType("TIMSoundElem");
            } else if ("TEXT".equalsIgnoreCase(msgType)) {
                Object textObj = textBodyVO.getMsgContent();
                String textObjStr = JSON.toJSONString((Object)textObj);
                JSONObject text = JSON.parseObject((String)textObjStr);
                try {
                    imGroupMsgEntity.setMsgContent(EmojiConvertUtil.emojiConvert((String)text.getString("Text")));
                }
                catch (UnsupportedEncodingException e) {
                    log.error("----\u6d4b\u8bd5\u73af\u5883---\u7fa4\u7ec4\u6d88\u606f emoji\u8868\u60c5\u8f6c\u6362\u5931\u8d25!{}", (Throwable)e);
                }
                imGroupMsgEntity.setMsgType("TIMTextElem");
            } else if ("PICTURE".equalsIgnoreCase(msgType)) {
                imGroupMsgEntity.setMsgContent(extVo.getAttacheUrl());
                imGroupMsgEntity.setMsgType("TIMImageElem");
            } else {
                log.info("----\u6d4b\u8bd5\u73af\u5883---\u7fa4\u7ec4\u6d88\u606f \tmsgType > {} >>>>> is not Definition! completed!", (Object)msgType);
                return;
            }
            if (apiMsgId != null) {
                imGroupMsgEntity.setApiMsgId(String.valueOf(apiMsgId));
            }
            imGroupMsgEntity.setClientMsgId(clientMsgId);
            if (sendMsgTime != null) {
                imGroupMsgEntity.setTimeStamp(sendMsgTime);
                imGroupMsgEntity.setMsgTime(DateUtils.longToStrDate((String)"yyyy-MM-dd HH:mm:ss", (long)(sendMsgTime * 1000L)));
            } else {
                imGroupMsgEntity.setTimeStamp(DateUtils.getSecondTimestamp((Date)DateUtils.getCurrentDate()));
                imGroupMsgEntity.setMsgTime(DateUtils.getCurrentDateToString());
            }
            imGroupMsgEntity.setOptPlatform(optPlatform);
            imGroupMsgEntity.setGroupId(session.getGroupId());
            imGroupMsgEntity.setSenderId(fAccount.getId());
            imGroupMsgEntity.setSessionId(session.getId());
            this.groupMsgRepository.saveAndFlush((Object)imGroupMsgEntity);
            log.info(">>>>>>----\u6d4b\u8bd5\u73af\u5883---\u7fa4\u7ec4\u6d88\u606f\u4fdd\u5b58\u6210\u529f: " + imGroupMsgEntity.getId());
        } else {
            log.info("----\u6d4b\u8bd5\u73af\u5883---\u7fa4\u7ec4\u6d88\u606f userAction= {} >>>>> is not active message ! , completed!", (Object)userAction);
        }
    }

    private void msgProToDev(TestIMTencentCallBackReqVO reqVO, String pushType, String busiCode) {
        IMBusiPushConfigEntity configEntity = this.pushConfigRepository.findByPushTypeAndBusiCode(pushType, busiCode);
        if (configEntity != null && BusiPushStatusEnum.ON.getValue().equals(configEntity.getStatus())) {
            String url = configEntity.getDomain() + "/cloud" + configEntity.getUri();
            log.info("\u6d88\u606f\u8f6c\u81f3\u5f00\u53d1\u73af\u5883IM,\u8bf7\u6c42params:{}", (Object)JSON.toJSONString((Object)reqVO));
            JSONObject object = JSONObject.parseObject((String)JSON.toJSONString((Object)reqVO));
            String result = RestTemplateUtils.post((String)url, (JSONObject)object, (MediaType)MediaType.APPLICATION_JSON_UTF8);
            log.info("\u6d88\u606f\u8f6c\u53d1\u81f3\u5f00\u53d1\u73af\u5883IM\u670d\u52a1\u5668 \u54cd\u5e94={}", (Object)result);
        }
    }
}

