/*
 * Decompiled with CFR 0.152.
 */
package com.hxgy.im.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.hxgy.im.config.SnowIdConfig;
import com.hxgy.im.pojo.bo.IMSaveAccountBO;
import com.hxgy.im.pojo.entity.ImAccountEntity;
import com.hxgy.im.pojo.entity.ImApplicationEntity;
import com.hxgy.im.pojo.entity.ImSigEntity;
import com.hxgy.im.pojo.vo.AccountVO;
import com.hxgy.im.pojo.vo.SdkAccountVo;
import com.hxgy.im.repository.ImAccountRepository;
import com.hxgy.im.service.IMAccountService;
import com.hxgy.im.service.IMApplicationService;
import com.hxgy.im.service.IMSigService;
import com.hxgy.im.util.DateUtils;
import com.hxgy.im.util.SdkAccountUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class IMAccountServiceImpl
implements IMAccountService {
    @Autowired
    private RedissonClient redissonClient;
    private static final Logger log = LoggerFactory.getLogger(IMAccountServiceImpl.class);
    @Autowired
    private ImAccountRepository accountRepository;
    @Autowired
    private IMApplicationService applicationService;
    @Autowired
    private IMSigService sigService;
    @Autowired
    private SnowIdConfig snowIdConfig;
    private static final Object lock1 = new Object();
    private static final Object lock2 = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImAccountEntity saveOrQueryAccount(IMSaveAccountBO accountBO) {
        ImAccountEntity account;
        block16: {
            Object lock = null;
            account = null;
            try {
                String appId = accountBO.getAppId();
                String userId = accountBO.getUserId();
                String formNick = accountBO.getFormNick();
                String appCode = accountBO.getAppCode();
                String headLogo = accountBO.getHeadLogo();
                account = this.accountRepository.findByAppIdAndUserId(appId, userId);
                log.info("saveOrQueryAccount\u4fe1\u606f={}", (Object)account);
                if (account == null) {
                    account = new ImAccountEntity();
                    account.setAppId(appId);
                    account.setFromNick(formNick);
                    account.setHeadUrl(headLogo);
                    long nextId = this.snowIdConfig.nextId();
                    if (StringUtils.isNotBlank((CharSequence)appCode)) {
                        String sdkAccount = SdkAccountUtils.convertSdkAccount((String)String.valueOf(nextId), (String)appCode);
                        account.setSdkAccount(sdkAccount);
                    } else {
                        account.setSdkAccount(userId);
                    }
                    account.setLineStatus(Integer.valueOf(0));
                    account.setUserId(userId);
                    Object object = lock1;
                    synchronized (object) {
                        ImAccountEntity account2 = this.accountRepository.findByAppIdAndUserId(appId, userId);
                        if (account2 == null) {
                            this.accountRepository.saveAndFlush((Object)account);
                        }
                        break block16;
                    }
                }
                if (!StringUtils.isNotEmpty((CharSequence)formNick) || !StringUtils.isNotEmpty((CharSequence)headLogo)) break block16;
                account.setFromNick(formNick);
                account.setHeadUrl(headLogo);
                Object object = lock2;
                synchronized (object) {
                    ImAccountEntity account2 = this.accountRepository.findByAppIdAndUserId(appId, userId);
                    if (account2 != null) {
                        this.accountRepository.saveAndFlush((Object)account);
                    }
                }
            }
            catch (Exception e) {
                log.error("\u4fdd\u5b58\u8d26\u53f7\u51fa\u73b0\u5f02\u5e38:{}", (Throwable)e);
            }
            finally {
                log.info("\u67e5\u8be2\u6216\u65b0\u589e\u8d26\u53f7\u6267\u884c\u5b8c\u6bd5!");
            }
        }
        log.info("\u4fdd\u5b58\u8d26\u53f7\u5b8c\u6210:{}", account);
        return account;
    }

    public ImAccountEntity queryAccountByAppIdAndUserId(String appId, String userId) {
        ImAccountEntity imAccountEntity;
        if (StringUtils.isNotEmpty((CharSequence)appId) && StringUtils.isNotEmpty((CharSequence)userId) && (imAccountEntity = this.accountRepository.findByAppIdAndUserId(appId, userId)) != null) {
            return imAccountEntity;
        }
        return null;
    }

    private void unRedisLock(RLock lock) {
        if (lock != null) {
            if (!lock.isHeldByCurrentThread()) {
                log.warn("redis\u8d85\u65f6\u81ea\u52a8\u91ca\u653e\u9501!");
            } else {
                log.info("\u903b\u8f91\u6267\u884c\u5b8c\u6210\u4e3b\u52a8\u91ca\u653e\u9501\uff1a{}", (Object)lock.getName());
                lock.unlock();
            }
        } else {
            log.info("lock\u5bf9\u8c61\u4e3a\u7a7a!");
        }
    }

    public BaseResponse<Map<String, List<SdkAccountVo>>> querySdkAccountList(Map<String, List<String>> map) {
        log.info("\u6279\u91cf\u67e5\u8be2\u7528\u6237\u7684IM\u8d26\u53f7\u4fe1\u606f \u5165\u53c2:{}", (Object)JSONObject.toJSONString(map));
        HashMap sdkAccountMap = new HashMap(16);
        if (map.isEmpty()) {
            return BaseResponse.success(sdkAccountMap);
        }
        Set<String> appCodeSet = map.keySet();
        for (String appCode : appCodeSet) {
            ImApplicationEntity applicationEntity = this.applicationService.findAppByAppcode(appCode);
            if (applicationEntity == null) {
                sdkAccountMap.put(appCode, null);
                continue;
            }
            String appId = applicationEntity.getId();
            List<String> userIdList = map.get(appCode);
            ArrayList<SdkAccountVo> list = new ArrayList<SdkAccountVo>(userIdList.size());
            for (String userId : userIdList) {
                SdkAccountVo vo;
                ImAccountEntity imAccount = this.accountRepository.findByAppIdAndUserId(appId, userId);
                if (imAccount == null) {
                    SdkAccountVo vo2 = new SdkAccountVo(userId, "", "");
                    list.add(vo2);
                    continue;
                }
                ImSigEntity imSigEntity = this.sigService.findSigByAccountId(imAccount.getId());
                if (imSigEntity == null) {
                    vo = new SdkAccountVo(imAccount.getUserId(), imAccount.getSdkAccount(), "");
                    list.add(vo);
                    continue;
                }
                vo = new SdkAccountVo(imAccount.getUserId(), imAccount.getSdkAccount(), imSigEntity.getAccountSig());
                list.add(vo);
            }
            sdkAccountMap.put(appCode, list);
        }
        log.info("\u6279\u91cf\u67e5\u8be2\u7528\u6237\u7684IM\u8d26\u53f7\u4fe1\u606f \u6210\u529f \u54cd\u5e94:{}", (Object)JSONObject.toJSONString(sdkAccountMap));
        return BaseResponse.success(sdkAccountMap);
    }

    public BaseResponse<Object> clearTempAccountInfo(AccountVO reqVO) {
        ImApplicationEntity applicationEntity;
        log.info("\u6e05\u7406\u4e34\u65f6\u7528\u6237\u7684IM\u8d26\u53f7\u4fe1\u606f \u5165\u53c2:{}", (Object)reqVO);
        if (reqVO.getUserId().endsWith("_temp") && Objects.nonNull(applicationEntity = this.applicationService.findAppByAppcode(reqVO.getAppCode()))) {
            ImAccountEntity imAccountEntity = this.accountRepository.findByAppIdAndUserId(applicationEntity.getId(), reqVO.getUserId());
            log.info("\u67e5\u8be2\u4e34\u65f6\u7528\u6237\u7684IM\u8d26\u53f7\u4fe1\u606f{}", (Object)imAccountEntity);
            if (Objects.nonNull(imAccountEntity)) {
                String accountId = imAccountEntity.getId();
                ImSigEntity imSigEntity = this.sigService.findSigByAccountId(accountId);
                log.info("\u67e5\u8be2\u4e34\u65f6\u7528\u6237\u7684IM\u7b7e\u540d\u4fe1\u606f{}", (Object)imSigEntity);
                if (Objects.nonNull(imSigEntity)) {
                    this.sigService.deletTempSignInfo(imSigEntity.getId());
                }
                this.accountRepository.deleteById((Object)accountId);
            }
        }
        return BaseResponse.success();
    }

    public String clearAllTempAccountInfo() {
        List imAccountEntities = this.accountRepository.findAll((Specification & Serializable)(root, query, cb) -> {
            ArrayList<Predicate> filters = new ArrayList<Predicate>();
            filters.add(cb.like((Expression)root.get("userId"), "%_temp"));
            filters.add(cb.lessThanOrEqualTo(root.get("createDateTime").as(String.class), (Comparable)((Object)DateUtils.getBeforeCurrentDayString((int)14))));
            query.where(filters.toArray(new Predicate[filters.size()]));
            return null;
        });
        log.info("\u5b9a\u65f6\u67e5\u8be2\u4e34\u65f6\u7528\u6237\u7684IM\u8d26\u53f7\u4fe1\u606f{}", (Object)imAccountEntities);
        int size = imAccountEntities.size();
        List accountIds = imAccountEntities.stream().map(e -> e.getId()).distinct().collect(Collectors.toList());
        log.info("\u5b9a\u65f6\u67e5\u8be2\u4e34\u65f6\u7528\u6237\u7684IM\u8d26\u53f7\u7b7e\u540d\u4fe1\u606f\u7f16\u53f7{}", accountIds);
        List imSigEntities = this.sigService.findAllSignByAccountIds(accountIds);
        log.info("\u5b9a\u65f6\u67e5\u8be2\u4e34\u65f6\u7528\u6237\u7684IM\u8d26\u53f7\u7b7e\u540d\u4fe1\u606f{}", (Object)imSigEntities);
        this.sigService.deleteInBatch(imSigEntities);
        this.accountRepository.deleteInBatch((Iterable)imAccountEntities);
        log.info("\u5b9a\u65f6\u5220\u9664\u4e34\u65f6\u7528\u6237\u7684IM\u8d26\u53f7\u4fe1\u606f\u5b8c\u6210");
        return "\u5220\u9664\u4e34\u65f6\u8d26\u53f7\u6267\u884c\u5b8c\u6bd5:" + size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveAccount(ImAccountEntity accountEntity) {
        block13: {
            RLock lock = null;
            try {
                String key = "im_create_account:userId:" + accountEntity.getUserId() + ":appId:" + accountEntity.getAppId();
                lock = this.redissonClient.getLock(key);
                lock.lock(5L, TimeUnit.SECONDS);
                if (!lock.tryLock()) {
                    log.info("ImAccountEntity\u5df2\u5b58\u5728\uff0c\u8df3\u8fc7\u4fdd\u5b58\uff0caccountId={}", (Object)accountEntity.getId());
                } else {
                    this.accountRepository.saveAndFlush((Object)accountEntity);
                }
                log.info("\u67e5\u8be2\u6216\u65b0\u589e\u8d26\u53f7\u6267\u884c\u5b8c\u6bd5!");
            }
            catch (Exception e) {
                log.error("\u4fdd\u5b58\u8d26\u53f7\u51fa\u73b0\u5f02\u5e38:{}", (Throwable)e);
                break block13;
            }
            try {
                this.unRedisLock(lock);
            }
            catch (Exception e) {
                log.info("\u91ca\u653e\u9501\u5931\u8d25 {}", (Throwable)e);
            }
            break block13;
            finally {
                log.info("\u67e5\u8be2\u6216\u65b0\u589e\u8d26\u53f7\u6267\u884c\u5b8c\u6bd5!");
                try {
                    this.unRedisLock(lock);
                }
                catch (Exception e) {
                    log.info("\u91ca\u653e\u9501\u5931\u8d25 {}", (Throwable)e);
                }
            }
        }
        log.info("\u4fdd\u5b58\u8d26\u53f7\u5b8c\u6210:{}", (Object)accountEntity);
    }
}

