/*
 * Decompiled with CFR 0.152.
 */
package com.hxgy.im.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.hxgy.im.enums.BusiCodeEnum;
import com.hxgy.im.enums.BusiPushStatusEnum;
import com.hxgy.im.enums.BusiPushTypeEnum;
import com.hxgy.im.enums.ErrorEnum;
import com.hxgy.im.enums.IMMsgStatus;
import com.hxgy.im.enums.IMOptPlatformEnum;
import com.hxgy.im.enums.ImMsgEnum;
import com.hxgy.im.pojo.bo.IMQueryMsgParamsBO;
import com.hxgy.im.pojo.bo.IMSingleMsgResultBO;
import com.hxgy.im.pojo.bo.QueryImNoReadMsgParamsBO;
import com.hxgy.im.pojo.bo.TencentCustomElemMsgVo;
import com.hxgy.im.pojo.bo.TencentSingleMsgExtBO;
import com.hxgy.im.pojo.entity.IMBusiPushConfigEntity;
import com.hxgy.im.pojo.entity.ImAccountEntity;
import com.hxgy.im.pojo.entity.ImApplicationEntity;
import com.hxgy.im.pojo.entity.ImGroupMsgEntity;
import com.hxgy.im.pojo.entity.ImMessageEntity;
import com.hxgy.im.pojo.entity.ImMessageJskfEntity;
import com.hxgy.im.pojo.entity.ImSessionEntity;
import com.hxgy.im.pojo.entity.ImSessionJskfEntity;
import com.hxgy.im.pojo.vo.IMQueryMsgReqVO;
import com.hxgy.im.pojo.vo.IMQueryNoReadMsgReqVO;
import com.hxgy.im.pojo.vo.IMRecallMsgReqVO;
import com.hxgy.im.pojo.vo.IMSingleMsgResultVO;
import com.hxgy.im.pojo.vo.IMTencentCallBackReqVO;
import com.hxgy.im.pojo.vo.IMUpdateOnlineStatusReqVO;
import com.hxgy.im.pojo.vo.TencentChangeStateVO;
import com.hxgy.im.pojo.vo.TencentMsgBodyVO;
import com.hxgy.im.pojo.vo.tencentVo.AndroidInfo;
import com.hxgy.im.pojo.vo.tencentVo.ApnsInfo;
import com.hxgy.im.pojo.vo.tencentVo.IMC2cMsgBeforeSendCallbackRespVO;
import com.hxgy.im.pojo.vo.tencentVo.OfflinePushInfo;
import com.hxgy.im.repository.ImAccountRepository;
import com.hxgy.im.repository.ImApplicationRepository;
import com.hxgy.im.repository.ImBusiPushConfigRepository;
import com.hxgy.im.repository.ImGroupMsgRepository;
import com.hxgy.im.repository.ImMemberJskfRepository;
import com.hxgy.im.repository.ImMessageJskfRepository;
import com.hxgy.im.repository.ImMessageRepository;
import com.hxgy.im.repository.ImSessionJskfRepository;
import com.hxgy.im.repository.ImSessionRepository;
import com.hxgy.im.repository.ImSingleMsgRelationJskfRepository;
import com.hxgy.im.repository.dao.IMJskfMsgDao;
import com.hxgy.im.repository.dao.IMMsgDao;
import com.hxgy.im.service.IMBusiPushService;
import com.hxgy.im.service.IMMsgService;
import com.hxgy.im.service.IMPushMsgService;
import com.hxgy.im.service.IMSessionService;
import com.hxgy.im.util.DateUtils;
import com.hxgy.im.util.EmojiConvertUtil;
import com.hxgy.im.util.JsonUtils;
import com.hxgy.im.util.RestTemplateUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class IMMsgServiceImpl
implements IMMsgService {
    private static final Logger log = LoggerFactory.getLogger(IMMsgServiceImpl.class);
    @Autowired
    private ImAccountRepository accountRepository;
    @Autowired
    private ImApplicationRepository appRepository;
    @Autowired
    private ImMessageRepository singleMsgRepository;
    @Autowired
    private ImSessionRepository sessionRepository;
    @Autowired
    private ImGroupMsgRepository groupMsgRepository;
    @Autowired
    private IMMsgDao imMsgDao;
    @Autowired
    private IMSessionService sessionService;
    @Autowired
    private IMBusiPushService imBusiPushService;
    @Autowired
    private IMPushMsgService imPushMsgService;
    @Autowired
    private ImBusiPushConfigRepository pushConfigRepository;
    @Resource(name="toTestAsyncPool")
    private ThreadPoolTaskExecutor toTestAsyncPool;
    @Autowired
    private ImSessionJskfRepository imSessionJskfRepository;
    @Autowired
    private ImMessageJskfRepository imMessageJskfRepository;
    @Autowired
    private ImMemberJskfRepository imMemberJskfRepository;
    @Autowired
    private ImSingleMsgRelationJskfRepository imSingleMsgRelationJskfRepository;
    @Autowired
    private IMJskfMsgDao imJskfMsgDao;

    public IMC2cMsgBeforeSendCallbackRespVO tencentC2CMsgSendBefore(IMTencentCallBackReqVO reqVO) {
        log.info("--\u5355\u804a\u6d88\u606f\u53d1\u9001\u4e4b\u524d \u56de\u8c03---IMTencentCallBackReqVO:{}", (Object)JSON.toJSONString((Object)reqVO));
        return new IMC2cMsgBeforeSendCallbackRespVO("OK", "", Integer.valueOf(0));
    }

    private IMC2cMsgBeforeSendCallbackRespVO updateIMTencentCallBackReqVO(IMTencentCallBackReqVO reqVO) {
        List msgBody = reqVO.getMsgBody();
        ArrayList<TencentMsgBodyVO> msgBody1 = new ArrayList<TencentMsgBodyVO>(msgBody);
        TencentMsgBodyVO tencentMsgBodyV = new TencentMsgBodyVO();
        JSONObject msgObject = new JSONObject();
        msgObject.put("Text", (Object)"[\u56fe\u7247/\u6587\u5b572]");
        tencentMsgBodyV.setMsgContent((Object)msgObject);
        tencentMsgBodyV.setMsgType("TIMTextElem");
        msgBody1.add(tencentMsgBodyV);
        CopyOnWriteArrayList copyOnWriteArrayList = new CopyOnWriteArrayList();
        for (TencentMsgBodyVO tencentMsgBodyVO : msgBody) {
            String data;
            JSONObject datajson;
            Object msgContent;
            JSONObject jsonObject;
            if (!"TIMCustomElem".equals(tencentMsgBodyVO.getMsgType()) || (jsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)(msgContent = tencentMsgBodyVO.getMsgContent())))) == null || (datajson = JSONObject.parseObject((String)(data = jsonObject.getString("Data")))) == null || !"PICTURE".equals(datajson.getString("msgType")) && !"SOUND".equals(datajson.getString("msgType"))) continue;
            TencentMsgBodyVO tencentMsgBodyVO1 = new TencentMsgBodyVO();
            JSONObject msgObject2 = new JSONObject();
            msgObject2.put("Text", (Object)"[\u56fe\u7247/\u6587\u5b572]");
            tencentMsgBodyVO1.setMsgContent((Object)msgObject2);
            tencentMsgBodyVO1.setMsgType("TIMTextElem");
            msgBody1.add(tencentMsgBodyVO1);
        }
        OfflinePushInfo offlinePushInfo = new OfflinePushInfo();
        AndroidInfo androidInfo = new AndroidInfo();
        androidInfo.setSound("msgTritone.caf");
        androidInfo.setOPPOChannelID("test_OPPO_channel_id");
        ApnsInfo apnsInfo = new ApnsInfo();
        apnsInfo.setBadgeMode(Integer.valueOf(1));
        apnsInfo.setSound("msgTritone.caf");
        apnsInfo.setTitle("\u81ea\u5b9a\u4e49 apns title");
        apnsInfo.setSubTitle("\u81ea\u5b9a\u4e49 apns SubTitle");
        apnsInfo.setImage("https://\u793a\u4f8b\u56fe\u7247.jpg");
        offlinePushInfo.setPushFlag(Integer.valueOf(0));
        offlinePushInfo.setTitle("\u79bb\u7ebfTitle  offlinePushInfo Title");
        offlinePushInfo.setDesc("\u79bb\u7ebfDesc \u63a8\u9001\u5185\u5bb9");
        offlinePushInfo.setExt("\u79bb\u7ebfExt  \u900f\u4f20\u5185\u5bb9");
        offlinePushInfo.setAndroidInfo(androidInfo);
        offlinePushInfo.setApnsInfo(apnsInfo);
        IMC2cMsgBeforeSendCallbackRespVO callbackRespVO = new IMC2cMsgBeforeSendCallbackRespVO("OK", "", Integer.valueOf(0), msgBody, offlinePushInfo);
        log.info("\u533b\u751f[{}]\u79bb\u7ebf \u4fee\u6539\u6d88\u606f\u4f53\uff0c\u54cd\u5e94:{}", (Object)reqVO.getToAccount(), (Object)JSON.toJSONString((Object)callbackRespVO));
        return callbackRespVO;
    }

    public void saveTencentC2CMsg(IMTencentCallBackReqVO reqVO) {
        log.info("\u5355\u804a\u6d88\u606f\u56de\u8c03 \u4fdd\u5b58 \u8fdb\u5165service\u65b9\u6cd5!!!==>reqVO:{}", (Object)JSONObject.toJSONString((Object)reqVO));
        List msgBodyList = reqVO.getMsgBody();
        if (msgBodyList == null) {
            log.error("\u89e3\u6790\u5355\u804a\u6d88\u606f\u65f6msgBodyList\u662f\u7a7a\u7684\uff0c\u4e0d\u6267\u884c\u4efb\u4f55\u64cd\u4f5c!");
            return;
        }
        Map<String, TencentMsgBodyVO> msgTypeMap = msgBodyList.stream().collect(Collectors.toMap(TencentMsgBodyVO::getMsgType, a -> a, (k1, k2) -> k1));
        TencentMsgBodyVO cutomElmMsg = msgTypeMap.get("TIMCustomElem");
        if (cutomElmMsg == null) {
            log.error("\u7ecf\u89e3\u6790\u81ea\u5b9a\u4e49\u6d88\u606f\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u6267\u884c\u4efb\u4f55\u64cd\u4f5c!");
            return;
        }
        Object cusMsgContent = cutomElmMsg.getMsgContent();
        TencentMsgBodyVO textElmMsg = msgTypeMap.get("TIMTextElem");
        TencentCustomElemMsgVo customVoData = (TencentCustomElemMsgVo)JSON.parseObject((String)JSON.toJSONString((Object)cusMsgContent), TencentCustomElemMsgVo.class);
        String diyData = customVoData.getData();
        if (StringUtils.isBlank((CharSequence)diyData)) {
            log.error("\u5355\u804a\u6d88\u606f\u81ea\u5b9a\u4e49\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u6267\u884c\u4efb\u4f55\u64cd\u4f5c!");
            return;
        }
        TencentSingleMsgExtBO extBo = (TencentSingleMsgExtBO)JsonUtils.convertObject((String)diyData.replaceAll("\n", ""), TencentSingleMsgExtBO.class);
        Long userAction = extBo.getUserAction();
        if (userAction == null || userAction == 0L) {
            log.error("userAction\u662f\u7a7a\u62160\u7684\uff0c\u4e0d\u6267\u884c\u4efb\u4f55\u64cd\u4f5c!");
            return;
        }
        int intValue = userAction.intValue();
        if (2000 == intValue || 2050 == intValue) {
            Long msgTime;
            Long currentMaxMsgId;
            String busiCode = extBo.getBusinessCode();
            String treatmentId = extBo.getAppointmentId();
            ImSessionJskfEntity imSessionJskfEntity = this.imSessionJskfRepository.findByBusiCodeAndTreatmentId(busiCode, treatmentId);
            String sessionId = "";
            Boolean zkFlag = false;
            if (Objects.isNull(imSessionJskfEntity)) {
                ImSessionEntity session = this.sessionRepository.findByBusiCodeAndTreatmentId(busiCode, treatmentId);
                if (session == null) {
                    log.error("\u5355\u804a\u6d88\u606f\u63a5\u6536\u67e5\u8be2session\u65f6\u4e3a\u7a7a\uff0c\u4e0d\u6267\u884c\u4efb\u4f55\u64cd\u4f5c");
                    this.toTestAsyncPool.execute(() -> this.msgProToTest(reqVO, "c2cToTest", "im_test"));
                    return;
                }
                sessionId = session.getId();
            } else {
                sessionId = imSessionJskfEntity.getId();
                zkFlag = true;
            }
            String fromAccount = reqVO.getFromAccount();
            String toAccount = reqVO.getToAccount();
            String[] splitFacc = fromAccount.split("\\*");
            String[] splitTacc = toAccount.split("\\*");
            String fromAppCode = splitFacc[1];
            String toAppCode = splitTacc[1];
            ImApplicationEntity fromApp = this.appRepository.findByAppCode(fromAppCode);
            String fromAppId = fromApp.getId();
            ImApplicationEntity toApp = this.appRepository.findByAppCode(toAppCode);
            String toAppId = toApp.getId();
            ImAccountEntity fromAcc = this.accountRepository.findByAppIdAndSdkAccount(fromAppId, fromAccount);
            ImAccountEntity toAcc = this.accountRepository.findByAppIdAndSdkAccount(toAppId, toAccount);
            String extMsgType = extBo.getMsgType();
            ImMessageEntity msgEntity = new ImMessageEntity();
            if (zkFlag.booleanValue()) {
                currentMaxMsgId = this.imMessageJskfRepository.findByMsgIdMax();
                msgEntity.setMsgId(Long.valueOf(currentMaxMsgId + 1L));
            } else {
                currentMaxMsgId = this.singleMsgRepository.findByMsgIdMax();
                msgEntity.setMsgId(Long.valueOf(currentMaxMsgId + 1L));
            }
            Long msgSeq = reqVO.getMsgSeq();
            msgEntity.setApiMsgId(msgSeq == null ? null : String.valueOf(msgSeq));
            msgEntity.setClientMsgId(extBo.getMsgId());
            if ("TEXT".equalsIgnoreCase(extMsgType)) {
                msgEntity.setMsgType("TIMTextElem");
                if (textElmMsg != null) {
                    try {
                        Object textObj = textElmMsg.getMsgContent();
                        String textObjStr = JSON.toJSONString((Object)textObj);
                        JSONObject text = JSON.parseObject((String)textObjStr);
                        msgEntity.setMessage(EmojiConvertUtil.emojiConvert((String)text.getString("Text")));
                    }
                    catch (Exception e) {
                        log.error("emoji\u8868\u60c5\u8f6c\u6362\u5931\u8d25!{}", (Throwable)e);
                    }
                }
            } else if ("SOUND".equalsIgnoreCase(extMsgType)) {
                msgEntity.setDuration(extBo.getDuration());
                msgEntity.setMsgType("TIMSoundElem");
                msgEntity.setMessage(extBo.getAttacheUrl());
            } else if ("PICTURE".equalsIgnoreCase(extMsgType)) {
                msgEntity.setMsgType("TIMImageElem");
                msgEntity.setMessage(extBo.getAttacheUrl());
            } else {
                log.error("\u65e0\u6cd5\u89e3\u6790\u7684\u81ea\u5b9a\u4e49\u6d88\u606f\u771f\u5b9e\u7c7b\u578b:{}", (Object)extMsgType);
                return;
            }
            if ((msgTime = reqVO.getMsgTime()) != null) {
                msgEntity.setMsgTime(DateUtils.longToStrDate((String)"yyyy-MM-dd HH:mm:ss", (long)(msgTime * 1000L)));
                msgEntity.setTimeStamp(msgTime);
            } else {
                msgEntity.setMsgTime(DateUtils.getCurrentDateToString());
                msgEntity.setTimeStamp(DateUtils.getSecondTimestamp());
            }
            msgEntity.setOptPlatform(reqVO.getOptPlatform());
            msgEntity.setReceiverId(toAcc.getId());
            msgEntity.setSenderId(fromAcc.getId());
            msgEntity.setSessionId(sessionId);
            if (zkFlag.booleanValue()) {
                ImMessageJskfEntity singleJskfMsg = new ImMessageJskfEntity();
                BeanUtils.copyProperties((Object)msgEntity, (Object)singleJskfMsg);
                this.imMessageJskfRepository.saveAndFlush((Object)singleJskfMsg);
            } else {
                this.singleMsgRepository.saveAndFlush((Object)msgEntity);
                if (BusiCodeEnum.JTYS.getBusiCodeEnumValue().equals(busiCode)) {
                    this.imBusiPushService.pushUnreadMsg(busiCode, BusiPushTypeEnum.MSG_JTYS_UN_READ, msgEntity);
                }
                if (BusiCodeEnum.ZXZX.getBusiCodeEnumValue().equals(busiCode)) {
                    this.imBusiPushService.pushOfflineMsg(toAccount, busiCode, treatmentId);
                } else {
                    this.imBusiPushService.pushOfflineMsgV2(toAccount, busiCode, treatmentId);
                }
                this.imBusiPushService.sessionRecorder(fromAccount, toAccount, busiCode, treatmentId, msgTime);
            }
        }
    }

    public void updateAccountLineStatus(IMTencentCallBackReqVO reqVO) {
        TencentChangeStateVO info = reqVO.getInfo();
        if (info == null) {
            log.error("\u72b6\u6001\u66f4\u6539\u56de\u8c03\u540e\u6536\u5230\u7684INFO\u5185\u5bb9\u4e3a\u7a7a!");
            return;
        }
        String action = info.getAction();
        String sdkAccount = info.getToAccount();
        String reason = info.getReason();
        List accountList = this.accountRepository.findBySdkAccount(sdkAccount);
        if (accountList.isEmpty()) {
            log.error("\u72b6\u6001\u66f4\u6539\u56de\u8c03,\u6b64[{}]\u8d26\u53f7\u672a\u67e5\u8be2\u5230\u8bb0\u5f55!", (Object)sdkAccount);
            return;
        }
        accountList.stream().forEach(account -> {
            if ("Login".equals(action)) {
                account.setLineStatus(Integer.valueOf(1));
            } else if ("Logout".equals(action)) {
                account.setLineStatus(Integer.valueOf(0));
            } else {
                account.setLineStatus(Integer.valueOf(0));
            }
            account.setReseaon(reason);
            account.setUpdateDateTime(DateUtils.getCurrentDateToString());
        });
        this.accountRepository.saveAll((Iterable)accountList);
        if (IMOptPlatformEnum.WEB.name().equalsIgnoreCase(reqVO.getOptPlatform()) || info.getToAccount().endsWith("EHOS_DOCTOR")) {
            IMUpdateOnlineStatusReqVO updateOnlineStatusReqVO = new IMUpdateOnlineStatusReqVO();
            updateOnlineStatusReqVO.setSdkAccount(info.getToAccount());
            updateOnlineStatusReqVO.setOptPlatform(reqVO.getOptPlatform());
            updateOnlineStatusReqVO.setOnlineStatus(info.getAction());
            updateOnlineStatusReqVO.setReason(info.getReason());
            updateOnlineStatusReqVO.setSdkAppid(reqVO.getSdkAppId());
            log.info("\u5728\u7ebf\u72b6\u6001\u66f4\u6539\u56de\u8c03 == \u540c\u6b65\u72b6\u6001\u5230im_online_status\u8868,{}", (Object)JSON.toJSONString((Object)updateOnlineStatusReqVO));
            this.sessionService.updateOnlineStatus(updateOnlineStatusReqVO);
        }
    }

    public void saveTencentGroupMsg(IMTencentCallBackReqVO reqVO) {
        log.info("=========im.msg.group.msg\u8fdb\u5165saveTencentGroupMsg=========");
        String fromAccount = reqVO.getFromAccount();
        Long apiMsgId = reqVO.getMsgSeq();
        Long sendMsgTime = reqVO.getMsgTime();
        String optPlatform = reqVO.getOptPlatform();
        List msgBodys = reqVO.getMsgBody();
        if (msgBodys == null || msgBodys.isEmpty()) {
            log.info("\u7fa4\u7ec4\u6d88\u606f  msgBodys >>>>> is null> {} , completed!", (Object)msgBodys);
            return;
        }
        Map<String, TencentMsgBodyVO> mapByType = msgBodys.stream().collect(Collectors.toMap(TencentMsgBodyVO::getMsgType, a -> a, (k1, k2) -> k1));
        TencentMsgBodyVO textBodyVO = mapByType.get("TIMTextElem");
        TencentMsgBodyVO customBodyVO = mapByType.get("TIMCustomElem");
        if (customBodyVO == null) {
            log.error("\u7fa4\u7ec4\u6d88\u606f  customElem >>>>> is null>{} , completed!", (Object)customBodyVO);
            return;
        }
        Object cusObj = customBodyVO.getMsgContent();
        TencentCustomElemMsgVo customElemVo = (TencentCustomElemMsgVo)JsonUtils.convertObject((String)JsonUtils.convertObject((Object)cusObj), TencentCustomElemMsgVo.class);
        String cusElemData = customElemVo.getData();
        TencentSingleMsgExtBO extVo = (TencentSingleMsgExtBO)JsonUtils.convertObject((String)cusElemData.replaceAll("\n", ""), TencentSingleMsgExtBO.class);
        if (extVo == null) {
            log.info("\u7fa4\u7ec4\u6d88\u606f extVo >>>>> is null>{} , completed!", (Object)extVo);
            return;
        }
        Long userAction = extVo.getUserAction();
        if (userAction == 2050L || userAction == 2000L) {
            ImGroupMsgEntity groupMsgPo;
            String clientMsgId = extVo.getMsgId();
            if (StringUtils.isNotBlank((CharSequence)clientMsgId) && (groupMsgPo = this.groupMsgRepository.findByClientMsgId(clientMsgId)) != null) {
                log.info("\u7fa4\u7ec4\u6d88\u606f  clientMsgId > {} >>>>> is already exist! , completed!", (Object)clientMsgId);
                return;
            }
            String uniqueId = extVo.getAppointmentId();
            String busiCode = extVo.getBusinessCode();
            ImSessionJskfEntity imSessionJskfEntity = this.imSessionJskfRepository.findByBusiCodeAndTreatmentId(busiCode, uniqueId);
            ImSessionEntity session = new ImSessionEntity();
            if (Objects.isNull(imSessionJskfEntity)) {
                session = this.sessionRepository.findByBusiCodeAndTreatmentId(busiCode, uniqueId);
                if (session == null) {
                    log.info("\u7fa4\u7ec4\u6d88\u606f  session > {}-{} >>>>> is not exist! , completed!", (Object)busiCode, (Object)uniqueId);
                    this.toTestAsyncPool.execute(() -> this.msgProToTest(reqVO, "groupTest", "im_test"));
                    return;
                }
            } else {
                BeanUtils.copyProperties((Object)imSessionJskfEntity, (Object)session);
            }
            String[] splitAcocunt = fromAccount.split("\\*");
            String fromAppCode = splitAcocunt[1];
            ImApplicationEntity fromApp = this.appRepository.findByAppCode(fromAppCode);
            ImAccountEntity fAccount = this.accountRepository.findByAppIdAndSdkAccount(fromApp.getId(), fromAccount);
            String msgType = extVo.getMsgType();
            ImGroupMsgEntity imGroupMsgEntity = new ImGroupMsgEntity();
            Long currentMaxMsgId = this.groupMsgRepository.findByMsgIdMax();
            imGroupMsgEntity.setMsgId(Long.valueOf(currentMaxMsgId + 1L));
            if ("SOUND".equalsIgnoreCase(msgType)) {
                imGroupMsgEntity.setMsgContent(extVo.getAttacheUrl());
                imGroupMsgEntity.setDuration(extVo.getDuration());
                imGroupMsgEntity.setMsgType("TIMSoundElem");
            } else if ("TEXT".equalsIgnoreCase(msgType)) {
                Object textObj = textBodyVO.getMsgContent();
                String textObjStr = JSON.toJSONString((Object)textObj);
                JSONObject text = JSON.parseObject((String)textObjStr);
                try {
                    imGroupMsgEntity.setMsgContent(EmojiConvertUtil.emojiConvert((String)text.getString("Text")));
                }
                catch (UnsupportedEncodingException e) {
                    log.error("\u7fa4\u7ec4\u6d88\u606f emoji\u8868\u60c5\u8f6c\u6362\u5931\u8d25!{}", (Throwable)e);
                }
                imGroupMsgEntity.setMsgType("TIMTextElem");
            } else if ("PICTURE".equalsIgnoreCase(msgType)) {
                imGroupMsgEntity.setMsgContent(extVo.getAttacheUrl());
                imGroupMsgEntity.setMsgType("TIMImageElem");
            } else {
                log.info("\u7fa4\u7ec4\u6d88\u606f \tmsgType > {} >>>>> is not Definition! completed!", (Object)msgType);
                return;
            }
            if (apiMsgId != null) {
                imGroupMsgEntity.setApiMsgId(String.valueOf(apiMsgId));
            }
            imGroupMsgEntity.setClientMsgId(clientMsgId);
            if (sendMsgTime != null) {
                imGroupMsgEntity.setTimeStamp(sendMsgTime);
                imGroupMsgEntity.setMsgTime(DateUtils.longToStrDate((String)"yyyy-MM-dd HH:mm:ss", (long)(sendMsgTime * 1000L)));
            } else {
                imGroupMsgEntity.setTimeStamp(DateUtils.getSecondTimestamp((Date)DateUtils.getCurrentDate()));
                imGroupMsgEntity.setMsgTime(DateUtils.getCurrentDateToString());
            }
            imGroupMsgEntity.setOptPlatform(optPlatform);
            imGroupMsgEntity.setGroupId(session.getGroupId());
            imGroupMsgEntity.setSenderId(fAccount.getId());
            imGroupMsgEntity.setSessionId(session.getId());
            this.groupMsgRepository.saveAndFlush((Object)imGroupMsgEntity);
            log.info(">>>>>>\u7fa4\u7ec4\u6d88\u606f\u4fdd\u5b58\u6210\u529f: " + imGroupMsgEntity.getId());
        } else {
            log.info("\u7fa4\u7ec4\u6d88\u606f userAction= {} >>>>> is not active message ! , completed!", (Object)userAction);
        }
    }

    public BaseResponse<List<IMSingleMsgResultVO>> getImMsg(IMQueryMsgReqVO reqVO) {
        String appCode = reqVO.getAppCode();
        String userId = reqVO.getUserId();
        String accountId = null;
        if (StringUtils.isNotBlank((CharSequence)appCode)) {
            ImApplicationEntity app = this.appRepository.findByAppCode(appCode);
            String appId = app.getId();
            ImAccountEntity account = this.accountRepository.findByAppIdAndUserId(appId, userId);
            if (account == null) {
                return BaseResponse.error((String)"\u8d26\u53f7\u4e0d\u5b58\u5728!");
            }
            accountId = account.getId();
        }
        List appointmentId = reqVO.getAppointmentId();
        IMQueryMsgParamsBO paramsBO = new IMQueryMsgParamsBO();
        paramsBO.setAccountId(accountId);
        Long startDate = reqVO.getStartDate();
        Long endDate = reqVO.getEndDate();
        if (startDate != null && startDate > 0L) {
            paramsBO.setStartDate(DateUtils.longToStrDate((String)"yyyy-MM-dd HH:mm:ss", (long)(startDate * 1000L)));
        }
        if (endDate != null && endDate > 0L) {
            paramsBO.setEndDate(DateUtils.longToStrDate((String)"yyyy-MM-dd HH:mm:ss", (long)(endDate * 1000L)));
        }
        paramsBO.setPage(reqVO.getPage());
        paramsBO.setPageSize(reqVO.getPageSize());
        List<ImSessionEntity> imSessions = new ArrayList();
        Boolean zkFlag = false;
        List imSessionJskfs = this.imSessionJskfRepository.findBatchSession(appointmentId, reqVO.getBusinessCode());
        if (imSessionJskfs.isEmpty()) {
            imSessions = this.sessionRepository.findBatchSession(appointmentId, reqVO.getBusinessCode());
            if (imSessions.isEmpty()) {
                return BaseResponse.error((String)"\u4f1a\u8bdd\u4e0d\u5b58\u5728!");
            }
        } else {
            for (ImSessionJskfEntity imSessionJskfEntity : imSessionJskfs) {
                ImSessionEntity imSessionEntity = new ImSessionEntity();
                BeanUtils.copyProperties((Object)imSessionJskfEntity, (Object)imSessionEntity);
                imSessions.add(imSessionEntity);
            }
            zkFlag = true;
        }
        int sessSize = imSessions.size();
        StringBuilder sesIdsBuilder = new StringBuilder();
        for (int i = 1; i <= sessSize; ++i) {
            sesIdsBuilder.append("'").append(((ImSessionEntity)imSessions.get(i - 1)).getId()).append("'");
            if (sessSize == i) continue;
            sesIdsBuilder.append(",");
        }
        paramsBO.setSessionIds(sesIdsBuilder.toString());
        if (StringUtils.isBlank((CharSequence)reqVO.getSortOrder())) {
            paramsBO.setSortOrder("DESC");
        } else {
            paramsBO.setSortOrder(reqVO.getSortOrder());
        }
        String msgType = reqVO.getMsgType();
        List querySingleMsg = new ArrayList();
        if ("1".equals(msgType)) {
            querySingleMsg = zkFlag.booleanValue() ? this.imJskfMsgDao.querySingleMsg(paramsBO) : this.imMsgDao.querySingleMsg(paramsBO);
        } else if ("0".equals(msgType)) {
            querySingleMsg = zkFlag.booleanValue() ? this.imJskfMsgDao.queryGroupMsg(paramsBO) : this.imMsgDao.queryGroupMsg(paramsBO);
        } else {
            log.error("\u672a\u77e5\u7684\u6d88\u606f\u7c7b\u578b:{}", (Object)msgType);
        }
        return BaseResponse.success((Object)this.convertSigleMsg(querySingleMsg));
    }

    private List<IMSingleMsgResultVO> convertSigleMsg(List<IMSingleMsgResultBO> msgList) {
        ArrayList<IMSingleMsgResultVO> resultVOs = new ArrayList<IMSingleMsgResultVO>();
        msgList.stream().forEach(msg -> {
            IMSingleMsgResultVO resultVO = new IMSingleMsgResultVO();
            resultVO.setAppointmentId(msg.getAppointmentId());
            resultVO.setFromNick(msg.getSendFromNick());
            resultVO.setGroupId(msg.getGroupId());
            resultVO.setReceiver(msg.getReceSdkAccount());
            resultVO.setSender(msg.getSendSdkAccount());
            resultVO.setSendTime(msg.getMsgTime());
            resultVO.setThirdSdkAccount(msg.getSendSdkAccount());
            resultVO.setTimeStamp(Long.valueOf(Long.parseLong(msg.getTimeStamp())));
            resultVO.setBusinessCode(msg.getBusinessCode());
            String msgType = msg.getMsgType();
            String msgContent = msg.getMsgContent();
            if ("TIMTextElem".equals(msgType)) {
                resultVO.setMsgType("TEXT");
                try {
                    resultVO.setMsgContent(EmojiConvertUtil.emojiRecovery((String)msgContent));
                }
                catch (UnsupportedEncodingException e) {
                    log.error("\u83b7\u53d6\u5355\u804a\u6d88\u606f\u8f6c\u6362EMOJI\u65f6\u5f02\u5e38:{}", (Object)msgContent);
                }
            } else if ("TIMSoundElem".equals(msgType)) {
                resultVO.setMsgType("SOUND");
                resultVO.setFileUrl(msgContent);
                resultVO.setMsgContent(msgContent);
                resultVO.setDuration(Integer.valueOf(Integer.parseInt(msg.getDuration())));
            } else if ("TIMImageElem".equals(msgType)) {
                resultVO.setMsgType("PICTURE");
                resultVO.setFileUrl(msgContent);
                resultVO.setMsgContent(msgContent);
            } else {
                resultVO.setMsgType(msg.getMsgType());
                resultVO.setMsgContent(msgContent);
            }
            String apiMsgId = msg.getApiMsgId();
            String clientMsgId = msg.getClientMsgId();
            if (StringUtils.isNotEmpty((CharSequence)clientMsgId)) {
                resultVO.setMsgId(clientMsgId);
            } else if (StringUtils.isNotBlank((CharSequence)apiMsgId)) {
                JSONObject jsonObject = JSONObject.parseObject((String)msgContent);
                Object msgRandom = jsonObject.get((Object)"msgRandom");
                if (Objects.isNull(msgRandom)) {
                    resultVO.setMsgId(apiMsgId);
                } else {
                    resultVO.setMsgId(msgRandom.toString());
                }
            } else {
                resultVO.setMsgId(msg.getId());
            }
            resultVOs.add(resultVO);
        });
        return resultVOs;
    }

    public BaseResponse<List<IMSingleMsgResultVO>> queryImNoReadMsg(IMQueryNoReadMsgReqVO reqVO) {
        QueryImNoReadMsgParamsBO paramsBO = new QueryImNoReadMsgParamsBO();
        paramsBO.setAppCode(reqVO.getAppCode());
        paramsBO.setSdkAccount(reqVO.getAccount());
        Long msgTime = reqVO.getMsgTime();
        if (msgTime != null && (long)msgTime.intValue() != 0L) {
            String startDate = DateUtils.longToStrDate((String)"yyyy-MM-dd HH:mm:ss", (long)msgTime);
            paramsBO.setStartDate(startDate);
        }
        List msgList = new ArrayList();
        if (reqVO.getMsgType().equals(0)) {
            msgList = this.imMsgDao.queryImNoReadMsg(paramsBO);
        } else {
            List imSessions = this.sessionRepository.findBatchSession(reqVO.getAppointmentId(), reqVO.getBusinessCode());
            int sessSize = imSessions.size();
            StringBuilder sesIdsBuilder = new StringBuilder();
            for (int i = 1; i <= sessSize; ++i) {
                sesIdsBuilder.append("'").append(((ImSessionEntity)imSessions.get(i - 1)).getId()).append("'");
                if (sessSize == i) continue;
                sesIdsBuilder.append(",");
            }
            paramsBO.setSessionIds(sesIdsBuilder.toString());
            msgList = this.imMsgDao.querySingleImNoReadMsg(paramsBO);
        }
        return BaseResponse.success((Object)this.convertSigleMsg(msgList));
    }

    public BaseResponse<Object> recallImMsg(IMRecallMsgReqVO reqVO) {
        log.info("\u6d88\u606f\u64a4\u56de \u63a5\u53e3\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqVO));
        Short msgType = reqVO.getMsgType();
        String clientMsgId = reqVO.getClientMsgId();
        if (ImMsgEnum.TypeEnum.SINGLE.getValue() == msgType.shortValue()) {
            Optional optional = this.imMessageJskfRepository.findByClientMsgId(clientMsgId);
            if (!optional.isPresent()) {
                this.singleMsgRepository.updateSingleMessageStatus(clientMsgId, Integer.valueOf(IMMsgStatus.RECALL.getValue()));
            } else {
                this.imMessageJskfRepository.updateSingleMessageStatus(clientMsgId, Integer.valueOf(IMMsgStatus.RECALL.getValue()));
            }
        } else if (ImMsgEnum.TypeEnum.GROUP.getValue() == msgType.shortValue()) {
            this.groupMsgRepository.updateGroupMessageStatus(clientMsgId, IMMsgStatus.RECALL.getValue());
        } else {
            log.info("[\u6d88\u606f\u64a4\u56de] \u6d88\u606f\u7c7b\u578b\u6709\u8bef,msgType:{}", (Object)reqVO.getMsgType());
            return BaseResponse.error((IError)ErrorEnum.INVALID_PARAMETER, (String)"[\u6d88\u606f\u64a4\u56de]\u6d88\u606f\u7c7b\u578b\u6709\u8bef");
        }
        this.imPushMsgService.pushRecallMsg(reqVO.getSdkAccount(), reqVO.getBusiCode(), reqVO.getTreatmentId(), reqVO.getClientMsgId());
        return BaseResponse.success();
    }

    public String clearSingleRelationInfo() {
        this.toTestAsyncPool.execute(() -> {
            String lastWeekStr = DateUtils.getLastWeekToString();
            String startDateStr = lastWeekStr + " 00:00:00";
            String endDayStr = lastWeekStr + " 23:59:59";
            this.imSingleMsgRelationJskfRepository.deleteSeverDaysSingleMsgRelationData(startDateStr, endDayStr);
            this.imMessageJskfRepository.deleteSeverDaysMessageData(startDateStr, endDayStr);
            this.imMemberJskfRepository.deleteSeverDaysImMemberData(startDateStr, endDayStr);
            this.imSessionJskfRepository.deleteSeverDaysImSessionData(startDateStr, endDayStr);
        });
        log.info("\u5b9a\u65f6\u5220\u9664\u5355\u804a\u5173\u7cfb\u4fe1\u606f\u5b8c\u6210");
        return "\u5220\u9664\u5355\u804a\u5173\u7cfb\u4fe1\u606f\u5b8c\u6bd5!";
    }

    private void msgProToTest(IMTencentCallBackReqVO reqVO, String pushType, String busiCode) {
        IMBusiPushConfigEntity configEntity = this.pushConfigRepository.findByPushTypeAndBusiCode(pushType, busiCode);
        if (configEntity != null && BusiPushStatusEnum.ON.getValue().equals(configEntity.getStatus())) {
            String url = configEntity.getDomain() + "/cloud" + configEntity.getUri();
            log.info("\u6d88\u606f\u8f6c\u81f3\u6d4b\u8bd5\u73af\u5883IM,\u8bf7\u6c42params:{}", (Object)JSON.toJSONString((Object)reqVO));
            JSONObject object = JSONObject.parseObject((String)JSON.toJSONString((Object)reqVO));
            String result = RestTemplateUtils.post((String)url, (JSONObject)object, (MediaType)MediaType.APPLICATION_JSON_UTF8);
            log.info("\u6d88\u606f\u8f6c\u53d1\u81f3\u6d4b\u8bd5\u73af\u5883IM\u670d\u52a1\u5668 \u54cd\u5e94={}", (Object)result);
        }
    }
}

