/*
 * Decompiled with CFR 0.152.
 */
package com.hxgy.im.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.hxgy.im.pojo.bo.IMSaveAccountBO;
import com.hxgy.im.pojo.bo.IMSaveSigBO;
import com.hxgy.im.pojo.entity.ImAccountEntity;
import com.hxgy.im.pojo.entity.ImApplicationEntity;
import com.hxgy.im.pojo.entity.ImSigEntity;
import com.hxgy.im.repository.ImApplicationRepository;
import com.hxgy.im.service.BaseService;
import com.hxgy.im.service.IMAccountService;
import com.hxgy.im.service.IMPushAccountService;
import com.hxgy.im.service.IMSigService;
import com.hxgy.im.util.RestTemplateUtils;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;

@Service
public class IMPushAccountServiceImpl
extends BaseService
implements IMPushAccountService {
    @Autowired
    private ImApplicationRepository appRepository;
    @Autowired
    private IMAccountService accountService;
    @Autowired
    private IMSigService imSigService;
    private static final Logger log = LoggerFactory.getLogger(IMPushAccountServiceImpl.class);

    public void pushAccount(String appSdkId, List<String> accounts) {
        String ACCOUNT_PUSH_URL = this.txImUrl.concat("/v4/im_open_login_svc/multiaccount_import?");
        List allApp = this.appRepository.findByAppSdkId(appSdkId);
        Map<String, ImApplicationEntity> mapByType = allApp.stream().collect(Collectors.toMap(ImApplicationEntity::getAppSdkId, a -> a, (k1, k2) -> k1));
        mapByType.forEach((sdkId, appObj) -> {
            String postUrl = this.createTencentPostUrl(ACCOUNT_PUSH_URL, appObj);
            System.out.println(postUrl);
            JSONObject pushData = new JSONObject();
            pushData.put("Accounts", (Object)accounts);
            String result = RestTemplateUtils.post((String)postUrl, (JSONObject)pushData, (MediaType)MediaType.APPLICATION_JSON_UTF8);
            if (StringUtils.isBlank((CharSequence)result)) {
                log.error("\u4e0a\u4f20\u8d26\u53f7\uff0c\u817e\u8baf\u8fd4\u56de\uff1a{}", (Object)result);
                return;
            }
            log.info("\u4e0a\u4f20\u8d26\u53f7\uff0c\u817e\u8baf\u8fd4\u56de\uff1a{}", (Object)result);
        });
    }

    public void pushNewAccount(String appSdkId, List<String> accounts) {
        String ACCOUNT_PUSH_URL = this.txImUrl.concat("/v4/im_open_login_svc/multiaccount_import?");
        List allApp = this.appRepository.findByAppSdkId(appSdkId);
        Map<String, ImApplicationEntity> mapByType = allApp.stream().collect(Collectors.toMap(ImApplicationEntity::getAppSdkId, a -> a, (k1, k2) -> k1));
        mapByType.forEach((sdkId, appObj) -> {
            String postUrl = this.createNewTencentPostUrl(ACCOUNT_PUSH_URL, appObj);
            System.out.println(postUrl);
            JSONObject pushData = new JSONObject();
            pushData.put("Accounts", (Object)accounts);
            String result = RestTemplateUtils.post((String)postUrl, (JSONObject)pushData, (MediaType)MediaType.APPLICATION_JSON_UTF8);
            if (StringUtils.isBlank((CharSequence)result)) {
                log.error("\u4e0a\u4f20\u8d26\u53f7\uff0c\u817e\u8baf\u8fd4\u56de\uff1a{}", (Object)result);
                return;
            }
            log.info("\u4e0a\u4f20\u8d26\u53f7\uff0c\u817e\u8baf\u8fd4\u56de\uff1a{}", (Object)result);
        });
    }

    private String createTencentPostUrl(String urlPrefix, ImApplicationEntity app) {
        String appSdkId = app.getAppSdkId();
        String userId = app.getSysAdmin();
        String appId = app.getId();
        String appSdkKey = app.getAppSdkKey();
        IMSaveAccountBO accountBO = new IMSaveAccountBO(appId, "", userId, "\u7ba1\u7406\u5458");
        ImAccountEntity adminAccount = this.accountService.saveOrQueryAccount(accountBO);
        String accountId = adminAccount.getId();
        IMSaveSigBO sigBo = new IMSaveSigBO(appSdkId, appSdkKey, userId, accountId);
        ImSigEntity sig = this.imSigService.saveSig(sigBo);
        StringBuilder urlBuilder = new StringBuilder(urlPrefix);
        urlBuilder.append("usersig=");
        urlBuilder.append(sig.getAccountSig());
        urlBuilder.append("&");
        urlBuilder.append("identifier=");
        urlBuilder.append(userId);
        urlBuilder.append("&");
        urlBuilder.append("sdkappid=");
        urlBuilder.append(appSdkId);
        urlBuilder.append("&");
        urlBuilder.append("random=");
        urlBuilder.append(99999999);
        urlBuilder.append("&");
        urlBuilder.append("contenttype=");
        urlBuilder.append("json");
        return urlBuilder.toString();
    }

    private String createNewTencentPostUrl(String urlPrefix, ImApplicationEntity app) {
        String appSdkId = app.getAppSdkId();
        String userId = app.getSysAdmin();
        String appId = app.getId();
        ImAccountEntity adminAccount = this.accountService.queryAccountByAppIdAndUserId(appId, userId);
        String accountId = adminAccount.getId();
        ImSigEntity sig = this.imSigService.findSigByAccountId(accountId);
        StringBuilder urlBuilder = new StringBuilder(urlPrefix);
        urlBuilder.append("usersig=");
        urlBuilder.append(sig.getAccountSig());
        urlBuilder.append("&");
        urlBuilder.append("identifier=");
        urlBuilder.append(userId);
        urlBuilder.append("&");
        urlBuilder.append("sdkappid=");
        urlBuilder.append(appSdkId);
        urlBuilder.append("&");
        urlBuilder.append("random=");
        urlBuilder.append(99999999);
        urlBuilder.append("&");
        urlBuilder.append("contenttype=");
        urlBuilder.append("json");
        return urlBuilder.toString();
    }
}

