/*
 * Decompiled with CFR 0.152.
 */
package com.hxgy.im.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.hxgy.im.config.SnowIdConfig;
import com.hxgy.im.enums.ErrorEnum;
import com.hxgy.im.enums.IMOnlineStatusEnum;
import com.hxgy.im.enums.IMOptPlatformEnum;
import com.hxgy.im.enums.PushBusiMsgTypeEnum;
import com.hxgy.im.pojo.bo.IMSaveAccountBO;
import com.hxgy.im.pojo.bo.IMSaveSessionBO;
import com.hxgy.im.pojo.bo.IMSaveSigBO;
import com.hxgy.im.pojo.entity.ImAccountEntity;
import com.hxgy.im.pojo.entity.ImApplicationEntity;
import com.hxgy.im.pojo.entity.ImMemberEntity;
import com.hxgy.im.pojo.entity.ImMemberJskfEntity;
import com.hxgy.im.pojo.entity.ImOnlineStatusEntity;
import com.hxgy.im.pojo.entity.ImSessionEntity;
import com.hxgy.im.pojo.entity.ImSessionJskfEntity;
import com.hxgy.im.pojo.entity.ImSessionJskfHistoryEntity;
import com.hxgy.im.pojo.entity.ImSigEntity;
import com.hxgy.im.pojo.vo.IMAccountStatusDataVO;
import com.hxgy.im.pojo.vo.IMBatchGetSessionReqVO;
import com.hxgy.im.pojo.vo.IMBatchGetStatusReqVO;
import com.hxgy.im.pojo.vo.IMBatchGetStatusRspVO;
import com.hxgy.im.pojo.vo.IMGetSessionMemberVo;
import com.hxgy.im.pojo.vo.IMQueryTargetSdkAccountReqVO;
import com.hxgy.im.pojo.vo.IMQueryTargetSdkAccountRspVO;
import com.hxgy.im.pojo.vo.IMSaveSessionReqVO;
import com.hxgy.im.pojo.vo.IMSessionRspVO;
import com.hxgy.im.pojo.vo.IMUpdateOnlineStatusReqVO;
import com.hxgy.im.repository.ImAccountRepository;
import com.hxgy.im.repository.ImApplicationRepository;
import com.hxgy.im.repository.ImMemberJskfHistoryRepository;
import com.hxgy.im.repository.ImMemberJskfRepository;
import com.hxgy.im.repository.ImMemberRepository;
import com.hxgy.im.repository.ImSessionJskfHistoryRepository;
import com.hxgy.im.repository.ImSessionJskfRepository;
import com.hxgy.im.repository.ImSessionRepository;
import com.hxgy.im.repository.ImSigRepository;
import com.hxgy.im.repository.mapper.ImOnlineStatusMapper;
import com.hxgy.im.service.IMAccountService;
import com.hxgy.im.service.IMPushAccountService;
import com.hxgy.im.service.IMSessionService;
import com.hxgy.im.service.IMSigService;
import com.hxgy.im.util.DateUtils;
import com.hxgy.im.util.RedisUtil;
import com.hxgy.im.util.SdkAccountUtils;
import com.hxgy.im.util.TencentSigUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IMSessionServiceImpl
implements IMSessionService {
    private static final Logger log = LoggerFactory.getLogger(IMSessionServiceImpl.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private ImSessionRepository sessionRepository;
    @Autowired
    private ImApplicationRepository appRepository;
    @Autowired
    private ImAccountRepository accountRepository;
    @Autowired
    private IMAccountService accountService;
    @Autowired
    private IMSigService sigService;
    @Autowired
    private ImMemberRepository memberRepository;
    @Autowired
    private IMPushAccountService pushAccountService;
    @Autowired
    private ImOnlineStatusMapper onlineStatusMapper;
    @Autowired
    private ImSigRepository sigRepository;
    @Autowired
    private ImSessionJskfRepository imSessionJskfRepository;
    @Autowired
    private ImMemberJskfRepository imMemberJskfRepository;
    @Autowired
    private ImSessionJskfHistoryRepository imSessionJskfHistoryRepository;
    @Autowired
    private ImMemberJskfHistoryRepository imMemberJskfHistoryRepository;
    @Autowired
    private SnowIdConfig snowIdConfig;
    private static final Object lock1 = new Object();
    private static final Object lock2 = new Object();
    private static final Object lock3 = new Object();
    private static final Logger logger = LoggerFactory.getLogger(IMSessionServiceImpl.class);

    @Transactional(rollbackFor={Exception.class})
    public ImSessionEntity saveSingleIMSession(IMSaveSessionReqVO reqVO) {
        logger.info("\u4fdd\u5b58session\u8bf7\u6c42\u6570\u636e:{}", (Object)JSON.toJSONString((Object)reqVO, (boolean)true));
        String busiCode = reqVO.getBusiCode();
        String treatmentId = reqVO.getTreatmentId();
        IMSaveSessionBO bo = StringUtils.isNotEmpty((CharSequence)reqVO.getBusiNodeCode()) ? new IMSaveSessionBO(reqVO.getBusiNodeCode(), busiCode, treatmentId, reqVO.getCreateUser(), "1") : new IMSaveSessionBO(busiCode, treatmentId, reqVO.getCreateUser(), "1");
        ImSessionEntity session = this.findMaxRoomNumAndSave(bo);
        String sessionId = session.getId();
        List memberList = this.memberRepository.findBySessionId(sessionId);
        if (CollectionUtils.isNotEmpty((Collection)memberList) && !memberList.isEmpty()) {
            this.memberRepository.deleteAll((Iterable)memberList);
            memberList.clear();
        }
        List reqMemList = reqVO.getMemberList();
        ArrayList sdkAccounts = new ArrayList();
        reqMemList.stream().forEach(member -> {
            sdkAccounts.clear();
            String appCode = member.getAppCode();
            String userId = member.getUserId();
            ImApplicationEntity app = this.appRepository.findByAppCode(appCode);
            if (app == null) {
                logger.info("\u6839\u636e\u7f16\u7801[{}]\u67e5\u8be2\u5e94\u7528\u65f6\u4e3a\u7a7a!", (Object)appCode);
                return;
            }
            String appId = app.getId();
            IMSaveAccountBO accountBO = new IMSaveAccountBO(appId, appCode, userId, "");
            ImAccountEntity account = this.accountService.saveOrQueryAccount(accountBO);
            String accountId = account.getId();
            IMSaveSigBO sigBo = new IMSaveSigBO(app.getAppSdkId(), app.getAppSdkKey(), account.getSdkAccount(), accountId);
            System.out.println("###\u521b\u5efasession\u65f6\u67e5\u8be2sig");
            ImSigEntity sigEntity = this.sigService.saveSig(sigBo);
            log.info("\u521b\u5efasession\u65f6\u67e5\u8be2sig:{}", (Object)sigEntity);
            ImMemberEntity me = new ImMemberEntity();
            me.setAccountId(accountId);
            me.setDoctorId(member.getDoctorId());
            me.setPatIdCard(member.getPatIdCard());
            me.setSessionId(sessionId);
            me.setPatientId(member.getPatientId());
            me.setMixFlowType(member.getFlowType());
            memberList.add(me);
            sdkAccounts.add(account.getSdkAccount());
            this.pushAccountService.pushAccount(app.getAppSdkId(), sdkAccounts);
        });
        if (CollectionUtils.isNotEmpty((Collection)memberList) && !memberList.isEmpty()) {
            log.info("\u4fdd\u5b58\u6210\u5458\u4fe1\u606f\u5230member\u8868\uff0c\u6210\u5458\u6570\uff1a{}", (Object)memberList.size());
            this.memberRepository.saveAll((Iterable)memberList);
        }
        log.info("\u4fdd\u5b58session \u54cd\u5e94\u6570\u636e-session\u4f1a\u8bdd:{}", (Object)session);
        return session;
    }

    private void unRedisLock(RLock lock) {
        if (lock != null) {
            if (!lock.isHeldByCurrentThread()) {
                logger.warn("redis\u8d85\u65f6\u81ea\u52a8\u91ca\u653e\u9501!");
            } else {
                logger.info("\u903b\u8f91\u6267\u884c\u5b8c\u6210\u4e3b\u52a8\u91ca\u653e\u9501\uff1a{}", (Object)lock.getName());
                lock.unlock();
            }
        } else {
            logger.info("lock\u5bf9\u8c61\u4e3a\u7a7a!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImSessionEntity findMaxRoomNumAndSave(IMSaveSessionBO bo) {
        String busiCode = bo.getBusiCode();
        String treatmentId = bo.getTreatmentId();
        Object lock = null;
        String sessionType = bo.getSessionType();
        ImSessionEntity sessionEntity = null;
        sessionEntity = this.sessionRepository.findByBusiCodeAndTreatmentId(busiCode, treatmentId);
        if (sessionEntity == null) {
            ImSessionEntity sessionEntity2;
            Object object;
            Long incRoomNum = null;
            if (this.redisUtil.hasKey("im_create_max_session")) {
                Long maxRoomNum = Long.valueOf(this.redisUtil.get("im_create_max_session").toString());
                logger.info("redis\u7f13\u5b58\u4e2d\u83b7\u53d6\u5bf9\u8c61\u7684\u7684key\u7684\u503c: {} ", (Object)maxRoomNum);
                if (Objects.nonNull(maxRoomNum)) {
                    incRoomNum = this.redisUtil.incr("im_create_max_session", 1L);
                    logger.info("redis\u7f13\u5b58\u4e2d\u83b7\u53d6\u5bf9\u8c61\u7684\u7684incRoomNum\u7684\u503c: {} ", (Object)incRoomNum);
                } else {
                    Long currentMaxRoomNum = this.sessionRepository.findByRoomNumMax();
                    incRoomNum = currentMaxRoomNum + 1L;
                    this.redisUtil.set("im_create_max_session", (Object)incRoomNum);
                }
            } else {
                Long currentMaxRoomNum = this.sessionRepository.findByRoomNumMax();
                logger.info("\u6570\u636e\u5e93\u67e5\u8be2\u4e2d\u83b7\u53d6\u5bf9\u8c61\u7684\u7684incRoomNum\u7684\u503c: {} ", (Object)currentMaxRoomNum);
                incRoomNum = currentMaxRoomNum + 1L;
                this.redisUtil.set("im_create_max_session", (Object)incRoomNum);
            }
            sessionEntity = new ImSessionEntity();
            if ("1".equals(sessionType)) {
                sessionEntity.setBusiCode(busiCode);
                sessionEntity.setCreateUser(bo.getCreateUser());
                sessionEntity.setRoomNum(incRoomNum);
                sessionEntity.setTreatmentId(treatmentId);
                sessionEntity.setType("1");
                sessionEntity.setBusiNodeCode(bo.getBusiNodeCode());
                object = lock1;
                synchronized (object) {
                    sessionEntity2 = this.sessionRepository.findByBusiCodeAndTreatmentId(busiCode, treatmentId);
                    if (sessionEntity2 == null) {
                        this.sessionRepository.saveAndFlush((Object)sessionEntity);
                    }
                }
            }
            if ("2".equals(sessionType)) {
                sessionEntity.setBusiCode(busiCode);
                sessionEntity.setCreateUser(bo.getCreateUser());
                sessionEntity.setRoomNum(incRoomNum);
                sessionEntity.setTreatmentId(treatmentId);
                sessionEntity.setType("2");
                sessionEntity.setBusiNodeCode(bo.getBusiNodeCode());
                object = lock2;
                synchronized (object) {
                    sessionEntity2 = this.sessionRepository.findByBusiCodeAndTreatmentId(busiCode, treatmentId);
                    if (sessionEntity2 == null) {
                        this.sessionRepository.saveAndFlush((Object)sessionEntity);
                    }
                }
            }
        }
        return sessionEntity;
    }

    public BaseResponse<List<IMSessionRspVO>> batchGetSession(IMBatchGetSessionReqVO reqVO) {
        String busiCode = reqVO.getBusiCode();
        List treatmentId = reqVO.getTreatmentId();
        ArrayList rsp = new ArrayList();
        treatmentId.stream().forEach(treatId -> {
            IMSessionRspVO rspVO = new IMSessionRspVO();
            ImSessionJskfEntity imSessionJskfEntity = this.imSessionJskfRepository.findByBusiCodeAndTreatmentId(busiCode, treatId);
            if (Objects.isNull(imSessionJskfEntity)) {
                ImSessionEntity session = this.sessionRepository.findByBusiCodeAndTreatmentId(busiCode, treatId);
                if (session == null) {
                    return;
                }
                String sessionId = session.getId();
                rspVO.setBusiCode(busiCode);
                rspVO.setGroupId(session.getGroupId());
                rspVO.setRoomNum(session.getRoomNum());
                rspVO.setTreatmentId(session.getTreatmentId());
                List memberList = this.memberRepository.findBySessionId(sessionId);
                ArrayList rspMemList = new ArrayList();
                memberList.stream().forEach(member -> {
                    String accountId = member.getAccountId();
                    ImAccountEntity account = (ImAccountEntity)this.accountRepository.findById((Object)accountId).get();
                    String appId = account.getAppId();
                    ImApplicationEntity appEntity = (ImApplicationEntity)this.appRepository.findById((Object)appId).get();
                    IMGetSessionMemberVo accRsp = new IMGetSessionMemberVo();
                    accRsp.setAppCode(appEntity.getAppCode());
                    accRsp.setSdkAccount(account.getSdkAccount());
                    IMSaveSigBO sigBo = new IMSaveSigBO(appEntity.getAppSdkId(), appEntity.getAppSdkKey(), account.getSdkAccount(), accountId);
                    ImSigEntity sig = this.sigService.saveSig(sigBo);
                    accRsp.setSig(sig.getAccountSig());
                    accRsp.setUserId(account.getUserId());
                    accRsp.setFlowType(member.getMixFlowType());
                    rspMemList.add(accRsp);
                });
                rspVO.setMemberList(rspMemList);
            } else {
                String sessionId = imSessionJskfEntity.getId();
                rspVO.setBusiCode(busiCode);
                rspVO.setGroupId(imSessionJskfEntity.getGroupId());
                rspVO.setRoomNum(imSessionJskfEntity.getRoomNum());
                rspVO.setTreatmentId(imSessionJskfEntity.getTreatmentId());
                List memberList = this.imMemberJskfRepository.findBySessionId(sessionId);
                ArrayList rspMemList = new ArrayList();
                memberList.stream().forEach(member -> {
                    String accountId = member.getAccountId();
                    ImAccountEntity account = (ImAccountEntity)this.accountRepository.findById((Object)accountId).get();
                    String appId = account.getAppId();
                    ImApplicationEntity appEntity = (ImApplicationEntity)this.appRepository.findById((Object)appId).get();
                    IMGetSessionMemberVo accRsp = new IMGetSessionMemberVo();
                    accRsp.setAppCode(appEntity.getAppCode());
                    accRsp.setSdkAccount(account.getSdkAccount());
                    IMSaveSigBO sigBo = new IMSaveSigBO(appEntity.getAppSdkId(), appEntity.getAppSdkKey(), account.getSdkAccount(), accountId);
                    ImSigEntity sig = this.sigService.saveSig(sigBo);
                    accRsp.setSig(sig.getAccountSig());
                    accRsp.setUserId(account.getUserId());
                    accRsp.setFlowType(member.getMixFlowType());
                    rspMemList.add(accRsp);
                });
                rspVO.setMemberList(rspMemList);
            }
            rsp.add(rspVO);
        });
        return BaseResponse.success(rsp);
    }

    public BaseResponse<Object> batchGetStatus(IMBatchGetStatusReqVO reqVO) {
        List reqData = reqVO.getData();
        ArrayList rsp = new ArrayList();
        reqData.stream().forEach(data -> {
            List userIds = data.getUserId();
            String appCode = data.getAppCode();
            ImApplicationEntity app = this.appRepository.findByAppCode(appCode);
            String appId = app.getId();
            List accountList = this.accountRepository.queryOnLineStatus(appId, userIds);
            IMBatchGetStatusRspVO rspVO = new IMBatchGetStatusRspVO();
            rspVO.setAppCode(appCode);
            ArrayList rspDataList = new ArrayList();
            accountList.stream().forEach(account -> {
                IMAccountStatusDataVO rspData = new IMAccountStatusDataVO();
                rspData.setLineStatus(account.getLineStatus());
                rspData.setSdkAccount(account.getSdkAccount());
                rspData.setUserId(account.getUserId());
                rspDataList.add(rspData);
            });
            rspVO.setData(rspDataList);
            rsp.add(rspVO);
        });
        return BaseResponse.success(rsp);
    }

    public BaseResponse<IMQueryTargetSdkAccountRspVO> qeuryTagetSdkAccount(IMQueryTargetSdkAccountReqVO reqVO) {
        String appCode = reqVO.getAppCode();
        String busiCode = reqVO.getBusiCode();
        String treatmentId = reqVO.getTreatmentId();
        String userId = reqVO.getUserId();
        logger.info("\u67e5\u8be2\u5bf9\u65b9IM\u76f8\u5173\u4fe1\u606f:appCode:{} = {} = treatmentId:{} ==userId:{}", new Object[]{appCode, busiCode, treatmentId, userId});
        ImSessionJskfEntity imSessionJskfEntity = this.imSessionJskfRepository.findByBusiCodeAndTreatmentId(busiCode, treatmentId);
        IMQueryTargetSdkAccountRspVO rsp = new IMQueryTargetSdkAccountRspVO();
        if (Objects.isNull(imSessionJskfEntity)) {
            ImSessionEntity sessionEntity = this.sessionRepository.findByBusiCodeAndTreatmentId(busiCode, treatmentId);
            if (sessionEntity == null) {
                return BaseResponse.error((IError)ErrorEnum.SESSION_NO_EXIST, (String)"\u4f1a\u8bdd\u4e0d\u5b58\u5728!");
            }
            String sessId = sessionEntity.getId();
            List memerList = this.memberRepository.findBySessionId(sessId);
            memerList.stream().forEach(member -> {
                String accountId = member.getAccountId();
                ImAccountEntity account = (ImAccountEntity)this.accountRepository.findById((Object)accountId).get();
                if (StringUtils.isBlank((CharSequence)userId)) {
                    String appId = account.getAppId();
                    ImApplicationEntity app = (ImApplicationEntity)this.appRepository.findById((Object)appId).get();
                    if (app.getAppCode().equals(appCode)) {
                        rsp.setAppCode(app.getAppCode());
                        rsp.setSdkAccount(account.getSdkAccount());
                        rsp.setUserId(account.getUserId());
                        rsp.setRoomNum(sessionEntity.getRoomNum());
                    }
                } else {
                    String uId = account.getUserId();
                    if (uId.equals(userId)) {
                        rsp.setAppCode(appCode);
                        rsp.setSdkAccount(account.getSdkAccount());
                        rsp.setUserId(account.getUserId());
                        rsp.setRoomNum(sessionEntity.getRoomNum());
                    }
                }
            });
        } else {
            String sessId = imSessionJskfEntity.getId();
            List memerList = this.imMemberJskfRepository.findBySessionId(sessId);
            memerList.stream().forEach(member -> {
                String accountId = member.getAccountId();
                ImAccountEntity account = (ImAccountEntity)this.accountRepository.findById((Object)accountId).get();
                if (StringUtils.isBlank((CharSequence)userId)) {
                    String appId = account.getAppId();
                    ImApplicationEntity app = (ImApplicationEntity)this.appRepository.findById((Object)appId).get();
                    if (app.getAppCode().equals(appCode)) {
                        rsp.setAppCode(app.getAppCode());
                        rsp.setSdkAccount(account.getSdkAccount());
                        rsp.setUserId(account.getUserId());
                        rsp.setRoomNum(imSessionJskfEntity.getRoomNum());
                    }
                } else {
                    String uId = account.getUserId();
                    if (uId.equals(userId)) {
                        rsp.setAppCode(appCode);
                        rsp.setSdkAccount(account.getSdkAccount());
                        rsp.setUserId(account.getUserId());
                        rsp.setRoomNum(imSessionJskfEntity.getRoomNum());
                    }
                }
            });
        }
        return BaseResponse.success((Object)rsp);
    }

    public BaseResponse<Object> updateOnlineStatus(IMUpdateOnlineStatusReqVO reqVO) {
        String offlineMsg;
        log.info("\u7528\u6237\u5728\u7ebf\u72b6\u6001\u53d8\u66f4 IMUpdateOnlineStatusReqVO:{}", (Object)JSON.toJSONString((Object)reqVO));
        ImOnlineStatusEntity onlineStatusEntity = new ImOnlineStatusEntity();
        BeanUtils.copyProperties((Object)reqVO, (Object)onlineStatusEntity);
        if (this.onlineStatusMapper.updateIMOnlineStatus(onlineStatusEntity) == 0) {
            log.info("\u7528\u6237\u5728\u7ebf\u72b6\u6001\u65e0\u53d8\u5316");
        }
        String sdkAccount = reqVO.getSdkAccount();
        boolean wxOpt = IMOptPlatformEnum.WX_H5.name().equalsIgnoreCase(reqVO.getOptPlatform());
        boolean offline = IMOnlineStatusEnum.OFFLINE.name().equalsIgnoreCase(reqVO.getOnlineStatus());
        boolean online = IMOnlineStatusEnum.ONLINE.name().equalsIgnoreCase(reqVO.getOnlineStatus());
        String statusKey = sdkAccount + "_" + IMOnlineStatusEnum.OFFLINE.name();
        String pushMsgKey = PushBusiMsgTypeEnum.OFFLINE_MSG.name().concat(sdkAccount);
        boolean firstMsg = true;
        boolean hasKey = this.redisUtil.hasKey(pushMsgKey);
        if (hasKey && StringUtils.isNotEmpty((CharSequence)(offlineMsg = (String)this.redisUtil.get(pushMsgKey))) && offlineMsg.contains("NoFirst")) {
            firstMsg = false;
        }
        log.info("\u8fdb\u5165\u5224\u65ad==\u7f13\u5b58\u7528\u6237\u79bb/\u5728\u7ebf\u72b6\u6001==\u662f\u5426\u79bb\u7ebf:{},\u662f\u5426\u662f\u7b2c\u4e00\u6761\u63a8\u9001:{}", (Object)offline, (Object)firstMsg);
        if (wxOpt && offline) {
            log.info("\u5c0f\u7a0b\u5e8f\u4e3b\u52a8\u53d1\u8d77\u79bb\u7ebf==\u7f13\u5b58\u5c0f\u7a0b\u5e8f\u7528\u6237\u79bb\u7ebf\u72b6\u6001,sdkAccount:{}", (Object)sdkAccount);
            this.redisUtil.set(statusKey, (Object)IMOnlineStatusEnum.OFFLINE.name());
            if (firstMsg) {
                log.info("\u5c0f\u7a0b\u5e8f\u4e3b\u52a8\u53d1\u8d77\u79bb\u7ebf==\u300b\u672a\u63a8\u9001\u8fc7\u6d88\u606f");
                this.redisUtil.set(pushMsgKey, (Object)sdkAccount, 180L);
            } else {
                log.info("\u5c0f\u7a0b\u5e8f\u4e3b\u52a8\u53d1\u8d77\u79bb\u7ebf==\u300b\u5728\u4e09\u5206\u949f\u6d88\u606f\u5012\u8ba1\u65f6\u4e2d\uff0c\u4e0d\u4fee\u6539");
            }
        } else if (wxOpt && online) {
            log.info("wx-->\u5c0f\u7a0b\u5e8f\u4e0a\u7ebf\u4e86==\u7f13\u5b58\u72b6\u6001\u4fe1\u606f\u6e05\u7a7a");
            this.redisUtil.del(new String[]{statusKey});
            this.redisUtil.del(new String[]{pushMsgKey});
        }
        boolean disConn = IMOnlineStatusEnum.DISCONNECT.name().equalsIgnoreCase(reqVO.getOnlineStatus());
        boolean login = IMOnlineStatusEnum.LOGIN.name().equalsIgnoreCase(reqVO.getOnlineStatus());
        boolean logout = IMOnlineStatusEnum.LOGOUT.name().equalsIgnoreCase(reqVO.getOnlineStatus());
        if (IMOptPlatformEnum.WEB.name().equalsIgnoreCase(reqVO.getOptPlatform()) && sdkAccount.endsWith("EHOS_PATIENT")) {
            log.info("\u817e\u8baf\u72b6\u6001\u56de\u8c03--\u5c0f\u7a0b\u5e8f\u7528\u6237iM\u72b6\u6001\u66f4\u65b0,IMOnlineStatus:{}", (Object)JSON.toJSONString((Object)reqVO));
            if (disConn || logout) {
                log.info("\u817e\u8baf\u56de\u8c03\u53d1\u8d77===\u7f13\u5b58\u5c0f\u7a0b\u5e8f\u7528\u6237\u79bb\u7ebf\u72b6\u6001,sdkAccount:{}", (Object)sdkAccount);
                this.redisUtil.set(statusKey, (Object)IMOnlineStatusEnum.OFFLINE.name());
                if (firstMsg) {
                    log.info("tx\u53d1\u8d77\u79bb\u7ebf==\u300b\u672a\u63a8\u9001\u8fc7\u6d88\u606f");
                    this.redisUtil.set(pushMsgKey, (Object)sdkAccount, 180L);
                } else {
                    log.info("tx\u4e3b\u52a8\u53d1\u8d77\u79bb\u7ebf==\u300b\u5728\u4e09\u5206\u949f\u6d88\u606f\u5012\u8ba1\u65f6\u4e2d\uff0c\u4e0d\u4fee\u6539");
                }
            } else if (login) {
                log.info("tx-->\u5c0f\u7a0b\u5e8f\u4e0a\u7ebf\u4e86==\u7f13\u5b58\u72b6\u6001\u4fe1\u606f\u6e05\u7a7a");
                this.redisUtil.del(new String[]{statusKey});
                this.redisUtil.del(new String[]{pushMsgKey});
            } else {
                log.info("\u817e\u8baf\u72b6\u6001\u56de\u8c03--\u672a\u77e5\u7684\u72b6\u6001[{}]\u53d8\u66f4", (Object)reqVO.getOnlineStatus());
            }
        }
        if (sdkAccount.endsWith("EHOS_DOCTOR")) {
            if (disConn || logout) {
                log.info("\u817e\u8baf\u56de\u8c03\u53d1\u8d77===\u7f13\u5b58\u533b\u751f\u79bb\u7ebf\u72b6\u6001,sdkAccount:{}", (Object)sdkAccount);
                this.redisUtil.set(statusKey, (Object)IMOnlineStatusEnum.OFFLINE.name());
            } else if (login) {
                log.info("\u817e\u8baf\u56de\u8c03\u53d1\u8d77-->\u7f13\u5b58\u533b\u751f\u4e0a\u7ebf\u4e86==\u7f13\u5b58\u72b6\u6001\u4fe1\u606f\u6e05\u7a7a");
                this.redisUtil.del(new String[]{statusKey, IMOnlineStatusEnum.ONLINE.name()});
            } else {
                log.info("\u817e\u8baf\u72b6\u6001\u56de\u8c03--\u672a\u77e5\u7684\u72b6\u6001[{}]\u53d8\u66f4", (Object)reqVO.getOnlineStatus());
            }
        }
        return BaseResponse.success();
    }

    public ImSessionJskfEntity saveNewSingleIMSession(IMSaveSessionReqVO reqVO) {
        logger.info("\u4fdd\u5b58session\u8bf7\u6c42\u6570\u636e:{}", (Object)JSON.toJSONString((Object)reqVO, (boolean)true));
        String busiCode = reqVO.getBusiCode();
        String treatmentId = reqVO.getTreatmentId();
        IMSaveSessionBO bo = StringUtils.isNotEmpty((CharSequence)reqVO.getBusiNodeCode()) ? new IMSaveSessionBO(reqVO.getBusiNodeCode(), busiCode, treatmentId, reqVO.getCreateUser(), "1") : new IMSaveSessionBO(busiCode, treatmentId, reqVO.getCreateUser(), "1");
        ImSessionJskfEntity session = this.imSessionJskfRepository.findByBusiCodeAndTreatmentId(busiCode, treatmentId);
        logger.info("ImSessionEntity session {} ", (Object)session);
        if (session == null) {
            session = new ImSessionJskfEntity();
            if ("1".equals(bo.getSessionType())) {
                Long incRoomNum = null;
                if (this.redisUtil.hasKey("im_create_max_jskf_session")) {
                    Long maxRoomNum = Long.valueOf(this.redisUtil.get("im_create_max_jskf_session").toString());
                    logger.info("redis\u7f13\u5b58\u4e2d\u83b7\u53d6\u5bf9\u8c61\u7684\u7684key\u7684\u503c: {} ", (Object)maxRoomNum);
                    if (Objects.nonNull(maxRoomNum)) {
                        incRoomNum = this.redisUtil.incr("im_create_max_jskf_session", 1L);
                        logger.info("redis\u7f13\u5b58\u4e2d\u83b7\u53d6\u5bf9\u8c61\u7684\u7684incRoomNum\u7684\u503c: {} ", (Object)incRoomNum);
                    } else {
                        Long currentMaxRoomNum = this.imSessionJskfRepository.findByRoomNumMax();
                        incRoomNum = currentMaxRoomNum + 1L;
                        this.redisUtil.set("im_create_max_jskf_session", (Object)incRoomNum);
                    }
                } else {
                    Long currentMaxRoomNum = this.imSessionJskfRepository.findByRoomNumMax();
                    logger.info("\u6570\u636e\u5e93\u67e5\u8be2\u4e2d\u83b7\u53d6\u5bf9\u8c61\u7684\u7684incRoomNum\u7684\u503c: {} ", (Object)currentMaxRoomNum);
                    incRoomNum = currentMaxRoomNum + 1L;
                    this.redisUtil.set("im_create_max_jskf_session", (Object)incRoomNum);
                }
                session.setBusiCode(busiCode);
                session.setCreateUser(bo.getCreateUser());
                session.setRoomNum(incRoomNum);
                session.setTreatmentId(treatmentId);
                session.setType("1");
                session.setBusiNodeCode(bo.getBusiNodeCode());
                logger.info("SaveImSessionEntity sessionEntity {} ", (Object)session);
                this.saveJskfMaxRoomNumAndSave(session);
            }
        }
        String sessionId = session.getId();
        logger.info("SaveImSessionEntity sessionId {} ", (Object)sessionId);
        List memberList = this.imMemberJskfRepository.findBySessionId(sessionId);
        if (CollectionUtils.isNotEmpty((Collection)memberList) && !memberList.isEmpty()) {
            this.imMemberJskfRepository.deleteAll((Iterable)memberList);
            memberList.clear();
        }
        List reqMemList = reqVO.getMemberList();
        ArrayList sdkAccounts = new ArrayList();
        reqMemList.stream().forEach(member -> {
            String sdkAccount;
            sdkAccounts.clear();
            String appCode = member.getAppCode();
            String userId = member.getUserId();
            ImApplicationEntity app = this.appRepository.findByAppCode(appCode);
            if (app == null) {
                logger.info("\u6839\u636e\u7f16\u7801[{}]\u67e5\u8be2\u5e94\u7528\u65f6\u4e3a\u7a7a!", (Object)appCode);
                return;
            }
            String appId = app.getId();
            ImAccountEntity account = this.accountRepository.findByAppIdAndUserId(appId, userId);
            log.info("ImAccountEntity account =" + account);
            if (account == null) {
                account = new ImAccountEntity();
                account.setAppId(appId);
                long nextId = this.snowIdConfig.nextId();
                if (StringUtils.isNotBlank((CharSequence)appCode)) {
                    sdkAccount = SdkAccountUtils.convertSdkAccount((String)String.valueOf(nextId), (String)appCode);
                    account.setSdkAccount(sdkAccount);
                } else {
                    account.setSdkAccount(userId);
                }
                account.setLineStatus(Integer.valueOf(0));
                account.setUserId(userId);
                log.info("SaveImAccountEntity account =" + account);
                this.accountService.saveAccount(account);
            }
            String accountId = account.getId();
            log.info("SaveImAccountEntity account =" + accountId);
            IMSaveSigBO sigBo = new IMSaveSigBO(app.getAppSdkId(), app.getAppSdkKey(), account.getSdkAccount(), accountId);
            log.info("###\u521b\u5efasession\u65f6\u67e5\u8be2sig");
            sdkAccount = sigBo.getSdkAccount();
            String sdkAppId = sigBo.getSdkAppId();
            String sdkAppKey = sigBo.getSdkAppKey();
            ImSigEntity sigEntity = this.sigRepository.findByAccountId(accountId);
            log.info("ImSigEntity sigEntity =" + sigEntity);
            if (sigEntity == null) {
                sigEntity = new ImSigEntity();
                sigEntity.setAccountId(accountId);
                String result = null;
                try {
                    result = TencentSigUtils.genNewTLSSignatureEx((String)sdkAppId, (String)sdkAppKey, (String)sdkAccount);
                }
                catch (IOException e) {
                    log.error("sdkAccount={},sdkAppId={},sdkAppKey={},\u751f\u6210SIG\u5f02\u5e38:{}", new Object[]{sdkAccount, sdkAppKey, sdkAppId, e});
                    throw new RuntimeException("SIG\u751f\u6210\u5f02\u5e38");
                }
                sigEntity.setAccountSig(result == null ? null : result);
                String closeDate = DateUtils.dateToSimpleString((Date)DateUtils.getAfterCurrentDay((int)175));
                sigEntity.setCloseDate(closeDate);
                log.info("SaveImSigEntity sigEntity =" + sigEntity);
                this.sigService.saveSigInfo(sigEntity);
            }
            log.info("\u521b\u5efasession\u65f6\u67e5\u8be2sig:{}", (Object)sigEntity);
            ImMemberJskfEntity me = new ImMemberJskfEntity();
            me.setAccountId(accountId);
            me.setDoctorId(member.getDoctorId());
            me.setPatIdCard(member.getPatIdCard());
            me.setSessionId(sessionId);
            me.setPatientId(member.getPatientId());
            me.setMixFlowType(member.getFlowType());
            memberList.add(me);
            sdkAccounts.add(account.getSdkAccount());
            this.pushAccountService.pushNewAccount(app.getAppSdkId(), sdkAccounts);
        });
        if (CollectionUtils.isNotEmpty((Collection)memberList) && !memberList.isEmpty()) {
            log.info("\u4fdd\u5b58\u6210\u5458\u4fe1\u606f\u5230member\u8868\uff0c\u6210\u5458\u6570\uff1a{}", (Object)memberList.size());
            this.imMemberJskfRepository.saveAll((Iterable)memberList);
        }
        log.info("\u4fdd\u5b58session \u54cd\u5e94\u6570\u636e-session\u4f1a\u8bdd:{}", (Object)session);
        logger.info("SaveImSessionEntity sessionEntity {} ", (Object)session);
        if (Objects.isNull(session.getRoomNum())) {
            Optional sessionEntityOptional = this.imSessionJskfRepository.findById((Object)sessionId);
            if (sessionEntityOptional != null && sessionEntityOptional.isPresent()) {
                session = (ImSessionJskfEntity)sessionEntityOptional.get();
            }
            logger.info("SaveImSessionEntity session\u4fe1\u606f {} ", (Object)session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveMaxRoomNumAndSave(ImSessionEntity session) {
        RLock lock = null;
        try {
            String key = "im_create_max_session:treatmentId:" + session.getTreatmentId() + ":busiCode:" + session.getBusiCode();
            lock = this.redissonClient.getLock(key);
            lock.lock(10L, TimeUnit.SECONDS);
            logger.info("\u83b7\u53d6\u9501\u6210\u529f: {} ", (Object)lock.getName());
            this.sessionRepository.saveAndFlush((Object)session);
        }
        catch (Throwable throwable) {
            this.unRedisLock(lock);
            throw throwable;
        }
        this.unRedisLock(lock);
        log.info("\u4fdd\u5b58\u8d26\u53f7\u5b8c\u6210:{}", (Object)session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveJskfMaxRoomNumAndSave(ImSessionJskfEntity session) {
        RLock lock = null;
        try {
            String key = "im_create_max_jskf_session:treatmentId:" + session.getTreatmentId() + ":busiCode:" + session.getBusiCode();
            lock = this.redissonClient.getLock(key);
            lock.lock(10L, TimeUnit.SECONDS);
            logger.info("\u83b7\u53d6\u9501\u6210\u529f: {} ", (Object)lock.getName());
            this.imSessionJskfRepository.saveAndFlush((Object)session);
        }
        catch (Throwable throwable) {
            this.unRedisLock(lock);
            throw throwable;
        }
        this.unRedisLock(lock);
        log.info("\u4fdd\u5b58\u8d26\u53f7\u5b8c\u6210:{}", (Object)session);
    }

    public BaseResponse<IMQueryTargetSdkAccountRspVO> getHistoryTargetSdkAccount(IMQueryTargetSdkAccountReqVO reqVO) {
        String appCode = reqVO.getAppCode();
        String busiCode = reqVO.getBusiCode();
        String treatmentId = reqVO.getTreatmentId();
        String userId = reqVO.getUserId();
        logger.info("\u67e5\u8be2\u5bf9\u65b9IM\u76f8\u5173\u4fe1\u606f:appCode:{} = {} = treatmentId:{} ==userId:{}", new Object[]{appCode, busiCode, treatmentId, userId});
        ImSessionJskfHistoryEntity imSessionJskfHistoryEntity = this.imSessionJskfHistoryRepository.findByBusiCodeAndTreatmentId(busiCode, treatmentId);
        IMQueryTargetSdkAccountRspVO rsp = new IMQueryTargetSdkAccountRspVO();
        String sessId = imSessionJskfHistoryEntity.getId();
        List memerList = this.imMemberJskfHistoryRepository.findBySessionId(sessId);
        memerList.stream().forEach(member -> {
            String accountId = member.getAccountId();
            ImAccountEntity account = (ImAccountEntity)this.accountRepository.findById((Object)accountId).get();
            if (StringUtils.isBlank((CharSequence)userId)) {
                String appId = account.getAppId();
                ImApplicationEntity app = (ImApplicationEntity)this.appRepository.findById((Object)appId).get();
                if (app.getAppCode().equals(appCode)) {
                    rsp.setAppCode(app.getAppCode());
                    rsp.setSdkAccount(account.getSdkAccount());
                    rsp.setUserId(account.getUserId());
                    rsp.setRoomNum(imSessionJskfHistoryEntity.getRoomNum());
                }
            } else {
                String uId = account.getUserId();
                if (uId.equals(userId)) {
                    rsp.setAppCode(appCode);
                    rsp.setSdkAccount(account.getSdkAccount());
                    rsp.setUserId(account.getUserId());
                    rsp.setRoomNum(imSessionJskfHistoryEntity.getRoomNum());
                }
            }
        });
        return BaseResponse.success((Object)rsp);
    }
}

