/*
 * Decompiled with CFR 0.152.
 */
package com.hxgy.im.service.impl;

import com.hxgy.im.pojo.bo.IMSaveSigBO;
import com.hxgy.im.pojo.entity.ImAccountEntity;
import com.hxgy.im.pojo.entity.ImApplicationEntity;
import com.hxgy.im.pojo.entity.ImSigEntity;
import com.hxgy.im.repository.ImAccountRepository;
import com.hxgy.im.repository.ImApplicationRepository;
import com.hxgy.im.repository.ImSigRepository;
import com.hxgy.im.service.IMSigService;
import com.hxgy.im.util.DateUtils;
import com.hxgy.im.util.TencentSigUtils;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IMSigServiceImpl
implements IMSigService {
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private ImSigRepository sigRepository;
    @Autowired
    private ImAccountRepository accountRepository;
    @Autowired
    private ImApplicationRepository applicationRepository;
    private static final Logger log = LoggerFactory.getLogger(IMSigServiceImpl.class);
    private static final Object lock1 = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImSigEntity saveSig(IMSaveSigBO sigBo) {
        String accountId = sigBo.getAccountId();
        String sdkAccount = sigBo.getSdkAccount();
        String sdkAppId = sigBo.getSdkAppId();
        String sdkAppKey = sigBo.getSdkAppKey();
        ImSigEntity sig = this.sigRepository.findByAccountId(accountId);
        if (sig == null) {
            sig = new ImSigEntity();
            sig.setAccountId(accountId);
            String result = null;
            try {
                result = TencentSigUtils.genNewTLSSignatureEx((String)sdkAppId, (String)sdkAppKey, (String)sdkAccount);
            }
            catch (IOException e) {
                log.error("sdkAccount={},sdkAppId={},sdkAppKey={},\u751f\u6210SIG\u5f02\u5e38:{}", new Object[]{sdkAccount, sdkAppKey, sdkAppId, e});
                throw new RuntimeException("SIG\u751f\u6210\u5f02\u5e38");
            }
            sig.setAccountSig(result == null ? null : result);
            String closeDate = DateUtils.dateToSimpleString((Date)DateUtils.getAfterCurrentDay((int)175));
            sig.setCloseDate(closeDate);
            Object object = lock1;
            synchronized (object) {
                ImSigEntity byAccountId = this.sigRepository.findByAccountId(accountId);
                if (byAccountId != null) {
                    log.info("sig\u5df2\u5b58\u5728\uff0c\u8df3\u8fc7\u4fdd\u5b58\uff0caccountId={}", (Object)accountId);
                    return byAccountId;
                }
                log.info("###\u5f00\u59cb\u4fdd\u5b58\u751f\u6210\u7684sig:accountId = {} , sdkAccount = {} , sdkAppId = {}", new Object[]{accountId, sdkAccount, sdkAppId});
                this.sigRepository.saveAndFlush((Object)sig);
            }
        }
        return sig;
    }

    public String updateSigJob() {
        List passSigList;
        String closeDate = DateUtils.getCurrentDateSimpleToString();
        try {
            String nextDayToString = DateUtils.getNextDayToString((String)closeDate);
            passSigList = this.sigRepository.findByCloseDateBefore(nextDayToString);
            log.info("ceshiupdatesig\u66f4\u65b0sig,nextDayToString:{},size:{}", (Object)nextDayToString, (Object)passSigList.size());
        }
        catch (Exception e) {
            log.info("ceshiupdatesig\u66f4\u65b0sig error:{}", (Throwable)e);
            passSigList = this.sigRepository.findByCloseDate(closeDate);
            log.info("ceshiupdatesig\u66f4\u65b0sig,closeDate:{},size:{}", (Object)closeDate, (Object)passSigList.size());
        }
        if (passSigList == null || passSigList.isEmpty()) {
            return "\u6ca1\u6709\u9700\u8981\u66f4\u65b0\u7684SIG:".concat(closeDate);
        }
        int size = passSigList.size();
        log.info("\u5b9a\u65f6\u66f4\u65b0SIG,closeDate={}, size\uff1a{}", (Object)closeDate, (Object)size);
        HashMap mapApp = new HashMap(16);
        String newDate = DateUtils.dateToSimpleString((Date)DateUtils.getAfterCurrentDay((int)145));
        passSigList.stream().forEach(sigEntity -> {
            String accountId = sigEntity.getAccountId();
            Optional optional = this.accountRepository.findById((Object)accountId);
            if (!optional.isPresent()) {
                System.out.println("\u8d26\u53f7\u4e0d\u5b58\u5728" + accountId);
                log.info("\u5b9a\u65f6\u4efb\u52a1\u66f4\u65b0\u5373\u5c06\u8fc7\u671f\u7684sig \u5f02\u5e38  \u8d26\u53f7\u4e0d\u5b58\u5728,closeDate={}, accountId={}", (Object)closeDate, (Object)accountId);
            } else {
                ImAccountEntity account = (ImAccountEntity)this.accountRepository.findById((Object)accountId).get();
                String appId = account.getAppId();
                if (!mapApp.containsKey(appId)) {
                    ImApplicationEntity app = (ImApplicationEntity)this.applicationRepository.findById((Object)account.getAppId()).get();
                    mapApp.put(appId, app);
                }
                try {
                    String signatureResult = TencentSigUtils.genNewTLSSignatureEx((String)((ImApplicationEntity)mapApp.get(appId)).getAppSdkId(), (String)((ImApplicationEntity)mapApp.get(appId)).getAppSdkKey(), (String)account.getSdkAccount());
                    sigEntity.setAccountSig(signatureResult);
                }
                catch (IOException e) {
                    log.error("\u51fa\u73b0\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
                    return;
                }
                sigEntity.setCloseDate(newDate);
                sigEntity.setUpdateDateTime(DateUtils.getCurrentDateToString());
                sigEntity.setUpdateUser("update-task");
                this.sigRepository.saveAndFlush(sigEntity);
            }
        });
        return "\u6267\u884c\u5b8c\u6bd5:" + size;
    }

    public ImSigEntity findSigByAccountId(String accountId) {
        ImSigEntity sigEntity;
        if (StringUtils.isNotEmpty((CharSequence)accountId) && (sigEntity = this.sigRepository.findByAccountId(accountId)) != null) {
            return sigEntity;
        }
        return null;
    }

    public void deletTempSignInfo(String id) {
        this.sigRepository.deleteById((Object)id);
    }

    public void deleteInBatch(List<ImSigEntity> imSigEntities) {
        this.sigRepository.deleteInBatch(imSigEntities);
    }

    public List<ImSigEntity> findAllSignByAccountIds(List<String> accountIds) {
        return this.sigRepository.findAllSignByAccountIds(accountIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveSigInfo(ImSigEntity sigEntity) {
        block13: {
            RLock lock = null;
            try {
                String key = "im_create_sign:accountId:" + sigEntity.getAccountId();
                lock = this.redissonClient.getLock(key);
                lock.lock(5L, TimeUnit.SECONDS);
                if (!lock.tryLock()) {
                    log.info("sig\u5df2\u5b58\u5728\uff0c\u8df3\u8fc7\u4fdd\u5b58\uff0caccountId={}", (Object)sigEntity.getAccountId());
                } else {
                    this.sigRepository.saveAndFlush((Object)sigEntity);
                }
                log.info("\u67e5\u8be2\u6216\u65b0\u589e\u7b7e\u540d\u4fe1\u606f\u6267\u884c\u5b8c\u6bd5!");
            }
            catch (Exception e) {
                log.error("\u4fdd\u5b58\u7b7e\u540d\u51fa\u73b0\u5f02\u5e38:{}", (Throwable)e);
                break block13;
            }
            try {
                this.unRedisLock(lock);
            }
            catch (Exception e) {
                log.info("\u91ca\u653e\u9501\u5931\u8d25 {}", (Throwable)e);
            }
            break block13;
            finally {
                log.info("\u67e5\u8be2\u6216\u65b0\u589e\u7b7e\u540d\u4fe1\u606f\u6267\u884c\u5b8c\u6bd5!");
                try {
                    this.unRedisLock(lock);
                }
                catch (Exception e) {
                    log.info("\u91ca\u653e\u9501\u5931\u8d25 {}", (Throwable)e);
                }
            }
        }
        log.info("\u4fdd\u5b58\u7b7e\u540d\u4fe1\u606f\u5b8c\u6210:{}", (Object)sigEntity);
    }

    private void unRedisLock(RLock lock) {
        if (lock != null) {
            if (!lock.isHeldByCurrentThread()) {
                log.warn("redis\u8d85\u65f6\u81ea\u52a8\u91ca\u653e\u9501!");
            } else {
                log.info("\u903b\u8f91\u6267\u884c\u5b8c\u6210\u4e3b\u52a8\u91ca\u653e\u9501\uff1a{}", (Object)lock.getName());
                lock.unlock();
            }
        } else {
            log.info("lock\u5bf9\u8c61\u4e3a\u7a7a!");
        }
    }
}

