/*
 * Decompiled with CFR 0.152.
 */
package com.hxgy.im.service.impl;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RBucket;
import org.redisson.api.RCountDownLatch;
import org.redisson.api.RDeque;
import org.redisson.api.RList;
import org.redisson.api.RLock;
import org.redisson.api.RMap;
import org.redisson.api.RQueue;
import org.redisson.api.RReadWriteLock;
import org.redisson.api.RSet;
import org.redisson.api.RSortedSet;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="redissonService")
public class RedissonService {
    @Autowired
    private RedissonClient redissonClient;

    public void getRedissonClient() throws IOException {
        Config config = this.redissonClient.getConfig();
        System.out.println(config.toJSON().toString());
    }

    public <T> RBucket<T> getRBucket(String objectName) {
        RBucket bucket = this.redissonClient.getBucket(objectName);
        return bucket;
    }

    public <K, V> RMap<K, V> getRMap(String objectName) {
        RMap map = this.redissonClient.getMap(objectName);
        return map;
    }

    public <V> RSortedSet<V> getRSortedSet(String objectName) {
        RSortedSet sortedSet = this.redissonClient.getSortedSet(objectName);
        return sortedSet;
    }

    public <V> RSet<V> getRSet(String objectName) {
        RSet rSet = this.redissonClient.getSet(objectName);
        return rSet;
    }

    public <V> RList<V> getRList(String objectName) {
        RList rList = this.redissonClient.getList(objectName);
        return rList;
    }

    public <V> RQueue<V> getRQueue(String objectName) {
        RQueue rQueue = this.redissonClient.getQueue(objectName);
        return rQueue;
    }

    public <V> RDeque<V> getRDeque(String objectName) {
        RDeque rDeque = this.redissonClient.getDeque(objectName);
        return rDeque;
    }

    public RLock getRLock(String objectName) {
        RLock rLock = this.redissonClient.getLock(objectName);
        return rLock;
    }

    public Boolean tryLock(String key, long leaseTime, TimeUnit unit) {
        RLock rLock = this.redissonClient.getLock(key);
        boolean tryLock = false;
        try {
            tryLock = rLock.tryLock(0L, leaseTime, unit);
        }
        catch (InterruptedException e) {
            return false;
        }
        return tryLock;
    }

    public Boolean verifyTryLock(RLock rLock, long leaseTime, TimeUnit unit) {
        boolean tryLock = false;
        try {
            tryLock = rLock.tryLock(0L, leaseTime, unit);
        }
        catch (InterruptedException e) {
            return false;
        }
        return tryLock;
    }

    public RReadWriteLock getRWLock(String objectName) {
        RReadWriteLock rwlock = this.redissonClient.getReadWriteLock(objectName);
        return rwlock;
    }

    public RAtomicLong getRAtomicLong(String objectName) {
        RAtomicLong rAtomicLong = this.redissonClient.getAtomicLong(objectName);
        return rAtomicLong;
    }

    public RCountDownLatch getRCountDownLatch(String objectName) {
        RCountDownLatch rCountDownLatch = this.redissonClient.getCountDownLatch(objectName);
        return rCountDownLatch;
    }
}

