/*
 * Decompiled with CFR 0.152.
 */
package com.hxgy.im.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateUtils {
    public static final String FULL_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String SIMPLE_FORMAT = "yyyy-MM-dd";
    private static final String FORMAT = "yyyyMMddHHmmss";
    private static final String FORMAT_MINUTE = "yyyyMMddHHmm";
    private static final String SUB_HOURE_FORMAT = "yyyyMMddHH";
    private static final String TIME_FORMAT = "HH:mm:ss";
    private static final String FIND_ERROR = "\u51fa\u73b0\u5f02\u5e38:";
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);

    public static Date getDateBefore(Date d, int day) {
        Calendar now = Calendar.getInstance();
        now.setTime(d);
        now.set(5, now.get(5) - day);
        return now.getTime();
    }

    public static Date getDateAfter(Date d, int day) {
        Calendar now = Calendar.getInstance();
        now.setTime(d);
        now.set(5, now.get(5) + day);
        return now.getTime();
    }

    public static String getCurrentTimeToString() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
        return df.format(calendar.getTime());
    }

    public static Date getAddMonth(Date date, int month) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.add(2, month);
        return now.getTime();
    }

    public static Date getSubtractMonth(Date date, int month) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.add(2, -month);
        return now.getTime();
    }

    public static Date getAddYear(Date date, int year) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.add(1, year);
        return now.getTime();
    }

    public static Date getSubtractYear(Date date, int year) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.add(1, -year);
        return now.getTime();
    }

    private static Calendar initCurrentDate() {
        Date date = new Date(System.currentTimeMillis());
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c;
    }

    public static int getCurrentYear() {
        Calendar c = DateUtils.initCurrentDate();
        return c.get(1);
    }

    public static int getCurrentMonth() {
        return DateUtils.initCurrentDate().get(2) + 1;
    }

    public static int getCurrentDay() {
        return DateUtils.initCurrentDate().get(5);
    }

    public static int getCurrentHour() {
        return DateUtils.initCurrentDate().get(11);
    }

    public static int getCurrentMinute() {
        return DateUtils.initCurrentDate().get(12);
    }

    public static int getCurrentSecond() {
        return DateUtils.initCurrentDate().get(13);
    }

    public static String getCurrentDate(String format) {
        SimpleDateFormat parse = new SimpleDateFormat(format);
        return parse.format(new Date());
    }

    public static Date parseDate(String str, String parsePatterns) throws ParseException {
        if (str == null || parsePatterns == null) {
            throw new IllegalArgumentException("Date and Patterns must not be null");
        }
        SimpleDateFormat parser = null;
        ParsePosition pos = new ParsePosition(0);
        parser = new SimpleDateFormat(parsePatterns);
        pos.setIndex(0);
        Date date = parser.parse(str, pos);
        if (date != null && pos.getIndex() == str.length()) {
            return date;
        }
        throw new ParseException("Unable to parse the date: " + str, -1);
    }

    public static String dateToString(Date date, String par) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(par);
        return sdf.format(date);
    }

    public static long strToDateLong(String date) throws Exception {
        long l = 0L;
        try {
            Calendar ca = Calendar.getInstance();
            ca.setTime(java.sql.Date.valueOf(date));
            l = ca.getTimeInMillis();
        }
        catch (Exception e) {
            throw new Exception("\u65e5\u671f\u5b57\u7b26\u4e32\u8f6c\u6362\u4e3a\u957f\u6574\u578b\u9519\u8bef");
        }
        return l;
    }

    public static String longToStrDate(String format, long time) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(new Date(time));
    }

    public static Date strToDate(String str, String parsePatterns) throws ParseException {
        return DateUtils.parseDate((String)str, (String)parsePatterns);
    }

    public static Date getAfterCurrentDay(int days) {
        Date result = null;
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.add(7, days);
            result = calendar.getTime();
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static String getBeforeCurrentDayString(int days) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date result = null;
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.add(7, -days);
            result = calendar.getTime();
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
        return df.format(result);
    }

    public static String getCurrentDateTimeString() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        return df.format(calendar.getTime());
    }

    public static String getCurrentDateTimeToMinuteString() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmm");
        return df.format(calendar.getTime());
    }

    public static String getCurrentDateToString() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df.format(calendar.getTime());
    }

    public static String getCurrentDateSimpleToString() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(calendar.getTime());
    }

    public static Date getCurrentDate() {
        Calendar calendar = Calendar.getInstance();
        return calendar.getTime();
    }

    public static Timestamp getCurrentDateTimestamp() {
        Calendar calendar = Calendar.getInstance();
        return new Timestamp(calendar.getTime().getTime());
    }

    public static String getNextWeekToString() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(7, 6);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(calendar.getTime());
    }

    public static String getNextDayToString(String day) {
        String result = "";
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            calendar.setTime(df.parse(day));
            calendar.add(7, 1);
            result = df.format(calendar.getTime());
        }
        catch (ParseException e) {
            log.error("\u51fa\u73b0\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static String getLastWeekToString() {
        String result = "";
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            calendar.add(4, -1);
            result = df.format(calendar.getTime());
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static String getYestarDayToString(String day) {
        String result = "";
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            calendar.setTime(df.parse(day));
            calendar.add(7, -1);
            result = df.format(calendar.getTime());
        }
        catch (ParseException e) {
            log.error("\u51fa\u73b0\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static Date stringToSimpleDate(String str) {
        if (str == null || "".equals(str)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return df.parse(str);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date stringToFullDate(String str) {
        if (str == null || "".equals(str)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return df.parse(str);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String dateToSimpleString(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(date);
    }

    public static String dateToFullString(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df.format(date);
    }

    public static String getWeekChinese(String date) {
        String[] weekDays = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            cal.setTime(df.parse(date));
        }
        catch (ParseException e) {
            log.error("\u51fa\u73b0\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }

    public static boolean judgeDate(String startStr, String endStr) {
        Date startDate = DateUtils.stringToSimpleDate((String)startStr);
        Date endDate = DateUtils.stringToSimpleDate((String)endStr);
        return Objects.nonNull(startDate) && Objects.nonNull(endDate) && startDate.before(endDate);
    }

    public static boolean judgeDateEqual(String startStr, String endStr) {
        Date startDate = DateUtils.stringToSimpleDate((String)startStr);
        Date endDate = DateUtils.stringToSimpleDate((String)endStr);
        return Objects.nonNull(endDate) && Objects.nonNull(startDate) && (startDate.before(endDate) || startDate.compareTo(endDate) == 0);
    }

    public static String getNumAfterDate(String str, int day) {
        Date startDate = DateUtils.stringToSimpleDate((String)str);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        calendar.add(7, day);
        return DateUtils.dateToSimpleString((Date)calendar.getTime());
    }

    public static String unixTimeToString(String unixTime) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(Long.parseLong(unixTime));
        return DateUtils.dateToSimpleString((Date)c.getTime());
    }

    public static String stringToUnixTime(String date) {
        Calendar c = Calendar.getInstance();
        Date date2 = DateUtils.stringToSimpleDate((String)date);
        c.setTime(date2);
        return c.getTimeInMillis() + "";
    }

    public static Timestamp stringToTimestamp(String tsStr) {
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        try {
            ts = Timestamp.valueOf(tsStr);
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
        return ts;
    }

    public static String getStrByTimestamp(Timestamp cc_time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(cc_time);
    }

    public static Time strToTime(String strDate) {
        if ("".equals(strDate) || strDate == null) {
            return null;
        }
        String str = strDate;
        SimpleDateFormat format = new SimpleDateFormat("hh:mm:ss");
        Date d = null;
        try {
            d = format.parse(str);
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
        if (Objects.nonNull(d)) {
            Time time = new Time(d.getTime());
            return Time.valueOf(str);
        }
        return null;
    }

    public static Time getTime() {
        Date d = new Date();
        Time time = new Time(d.getTime());
        return time;
    }

    public static int getBetweenDayNumber(String startStr, String endStr) {
        Date dateA = DateUtils.stringToSimpleDate((String)startStr);
        Date dateB = DateUtils.stringToSimpleDate((String)endStr);
        long dayNumber = 0L;
        long DAY = 86400000L;
        try {
            if (Objects.nonNull(dateA) && Objects.nonNull(dateB)) {
                dayNumber = (dateB.getTime() - dateA.getTime()) / DAY;
            }
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
        return (int)dayNumber;
    }

    public static int daysBetween(Date date1, Date date2) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        long time1 = cal.getTimeInMillis();
        cal.setTime(date2);
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(between_days));
    }

    public static Date dateAddDays(Date date, int addDays) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, addDays);
        return calendar.getTime();
    }

    public static Date dateAddHours(Date date, int addHours) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(11, addHours);
        return calendar.getTime();
    }

    public static Date dateAddMinutes(Date date, int addMinutes) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(12, addMinutes);
        return calendar.getTime();
    }

    public static String getLastDayBySimpleDay(String date) {
        String lastDay = null;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtils.stringToSimpleDate((String)date));
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        lastDay = DateUtils.dateToSimpleString((Date)calendar.getTime());
        return lastDay;
    }

    public static String getFirstDayBySimpleDay(String date) {
        String lastDay = null;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtils.stringToSimpleDate((String)date));
        calendar.set(5, 1);
        lastDay = DateUtils.dateToSimpleString((Date)calendar.getTime());
        return lastDay;
    }

    public static boolean judgeFullDate(String startStr, String endStr) {
        Date startDate = DateUtils.stringToFullDate((String)startStr);
        Date endDate = DateUtils.stringToFullDate((String)endStr);
        return Objects.nonNull(startDate) && Objects.nonNull(endDate) && startDate.before(endDate);
    }

    public static int getDaysOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.getActualMaximum(5);
    }

    public static String beforeOneHourToNowDate(int houre) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, calendar.get(11) - houre);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHH");
        return df.format(calendar.getTime());
    }

    public static Long getSecondTimestamp(Date date) {
        if (null == date) {
            return 0L;
        }
        String timestamp = String.valueOf(date.getTime());
        int length = timestamp.length();
        if (length > 3) {
            return Long.valueOf(timestamp.substring(0, length - 3));
        }
        return 0L;
    }

    public static Long getSecondTimestamp() {
        return LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8"));
    }

    public static Long getMilliTimestamp() {
        return LocalDateTime.now().toInstant(ZoneOffset.of("+8")).toEpochMilli();
    }

    public static boolean compareDate(String date1, String startDate, String endDate) {
        boolean flag = false;
        if (DateUtils.compare_date((String)date1, (String)startDate) != -1 && DateUtils.compare_date((String)date1, (String)endDate) != 1) {
            flag = true;
        }
        return flag;
    }

    public static int compare_date(String DATE1, String DATE2) {
        try {
            Date dt1 = DateUtils.parseDate((String)DATE1, (String)"yyyy-MM-dd");
            Date dt2 = DateUtils.parseDate((String)DATE2, (String)"yyyy-MM-dd");
            if (dt1.getTime() > dt2.getTime()) {
                System.out.println(DATE1 + " \u5728  " + DATE2 + "\u524d");
                return 1;
            }
            if (dt1.getTime() < dt2.getTime()) {
                System.out.println(DATE1 + " \u5728  " + DATE2 + "\u540e");
                return -1;
            }
            return 0;
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public static void main(String[] args) {
        String str = DateUtils.getBeforeCurrentDayString((int)5);
        System.out.println(str);
    }
}

