/*
 * Decompiled with CFR 0.152.
 */
package com.hxgy.im.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public class RabbitMqUtils {
    private static final Logger log = LoggerFactory.getLogger(RabbitMqUtils.class);
    public static final int ONE_THOUSAND = 1000;
    public static final String X_DELAY = "x-delay";

    public static void senderDelayedPrescriptionOrder(RabbitTemplate rabbitTemplate, String mainId, Integer orderExpireTime) {
        rabbitTemplate.convertAndSend("audio.delayed_exchange", "audio.delayed_order_routing_key", (Object)mainId, message -> {
            message.getMessageProperties().setHeader(X_DELAY, (Object)(orderExpireTime * 1000));
            log.info("send prescription order message to rabbitmq: " + mainId);
            return message;
        });
    }

    public static void sendMessageDelayedOrder(RabbitTemplate rabbitTemplate, String msgDate, Long orderExpireTime) {
        rabbitTemplate.convertAndSend("audio.delayed_exchange", "send.message.delayed_order_routing_key", (Object)msgDate, message -> {
            message.getMessageProperties().setHeader(X_DELAY, (Object)orderExpireTime);
            log.info("send message to rabbitmq: " + msgDate);
            return message;
        });
    }
}

