/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.doctor.basedata.api.bo.doc_service.ZXWZServiceBo;
import com.doctor.basedata.api.utils.ValidPropertyUtil;
import com.doctor.basedata.api.utils.ValidateResult;
import com.doctoruser.doctor.enums.ServiceCodeEnum;
import com.doctoruser.doctor.handler.DocServiceHandler;
import com.doctoruser.doctor.mapper.DocDoctorWorkplacesInfoMapper;
import com.doctoruser.doctor.pojo.dto.DoctorIdsAndOrganIdDTO;
import com.doctoruser.doctor.pojo.dto.OutPatientServiceSyncParamDTO;
import com.doctoruser.doctor.pojo.vo.DocServiceSetParam;
import com.doctoruser.doctor.pojo.vo.InquiryServiceConfigReq;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.HttpClientUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="zxmz")
public class ZXMZServiceHandler
implements DocServiceHandler {
    private static final Logger log = LoggerFactory.getLogger(ZXMZServiceHandler.class);
    @Value(value="${domainName}")
    private String NodeDomainName;
    @Value(value="${oldOnlineInquiryNodeCode}")
    private String oldOnlineInquiryNodeCode;
    @Autowired
    private DocDoctorWorkplacesInfoMapper docDoctorWorkplacesInfoMapper;

    public void executeSynchronise(DocServiceSetParam serviceSetParam, List<Long> doctorIds) {
        String[] split = this.oldOnlineInquiryNodeCode.split(",");
        HashSet<String> nodeAppCode = new HashSet<String>(Arrays.asList(split));
        if (nodeAppCode.contains(serviceSetParam.getAppCode())) {
            this.synchroniseOldOnlineInquiry(serviceSetParam, doctorIds);
        } else {
            this.synchroniseNewOnlineInquiry(serviceSetParam, doctorIds);
        }
    }

    public void synchroniseInsert(DocServiceSetParam serviceSetParam, List<Long> doctorIds) {
        serviceSetParam.setOperationType(Integer.valueOf(1));
        this.executeSynchronise(serviceSetParam, doctorIds);
    }

    public void synchroniseUpdate(DocServiceSetParam serviceSetParam, List<Long> doctorIds) {
        serviceSetParam.setOperationType(Integer.valueOf(2));
        this.executeSynchronise(serviceSetParam, doctorIds);
    }

    private void synchroniseNewOnlineInquiry(DocServiceSetParam serviceSetParam, List<Long> doctorIds) {
        DoctorIdsAndOrganIdDTO doctorIdsAndOrganId = new DoctorIdsAndOrganIdDTO();
        doctorIdsAndOrganId.setDoctorIds(doctorIds);
        doctorIdsAndOrganId.setOrganId(serviceSetParam.getOrganId());
        doctorIdsAndOrganId.setIsDefault(Integer.valueOf(1));
        doctorIdsAndOrganId.setStatus(Integer.valueOf(1));
        List doctorInfoList = this.docDoctorWorkplacesInfoMapper.getDoctorIdAndDeptIdByDoctorIdsAndOrganId(doctorIdsAndOrganId);
        ZXWZServiceBo zxwzServiceBo = (ZXWZServiceBo)JSON.parseObject((String)serviceSetParam.getServiceInfo(), ZXWZServiceBo.class);
        OutPatientServiceSyncParamDTO outPatientServiceSyncParamDTO = new OutPatientServiceSyncParamDTO();
        outPatientServiceSyncParamDTO.setDoctorInfo(doctorInfoList);
        outPatientServiceSyncParamDTO.setAppCode(serviceSetParam.getAppCode());
        outPatientServiceSyncParamDTO.setDailyLimit(zxwzServiceBo.getNumLimit());
        outPatientServiceSyncParamDTO.setHospitalId(String.valueOf(serviceSetParam.getOrganId()));
        Integer isSchedule = this.computeScheduleStatus(zxwzServiceBo.getIsSchedule(), zxwzServiceBo.getAnyTimeOrder());
        outPatientServiceSyncParamDTO.setIsSchedule(isSchedule);
        outPatientServiceSyncParamDTO.setNumLimit(zxwzServiceBo.getReplyLimit());
        outPatientServiceSyncParamDTO.setOrderTime(zxwzServiceBo.getWaitTimeLimit());
        outPatientServiceSyncParamDTO.setOrderTimeUnit(Integer.valueOf(zxwzServiceBo.getWaitTimeUnit()));
        outPatientServiceSyncParamDTO.setPrice(zxwzServiceBo.getServicePrice());
        outPatientServiceSyncParamDTO.setServiceCode(serviceSetParam.getServiceCode());
        outPatientServiceSyncParamDTO.setServTime(zxwzServiceBo.getEffectiveTime());
        outPatientServiceSyncParamDTO.setStatus(serviceSetParam.getStatus());
        outPatientServiceSyncParamDTO.setTimeUnit(Integer.valueOf(zxwzServiceBo.getServiceTimeUnit()));
        outPatientServiceSyncParamDTO.setOperationType(serviceSetParam.getOperationType());
        log.info("\u8c03\u7528\u5728\u7ebf\u95ee\u8bca\u670d\u52a1\u8bbe\u7f6e\u670d\u52a1\u914d\u7f6e\u5165\u53c2:[{}]", (Object)JSON.toJSONString((Object)outPatientServiceSyncParamDTO));
        BaseResponse baseResponse = HttpClientUtil.doJsonPost((Object)outPatientServiceSyncParamDTO, (String)(this.NodeDomainName + serviceSetParam.getAppCode() + "/netinquiry/serviceconfig/saveConfigInfoListNew"));
        log.info("\u8c03\u7528\u5728\u7ebf\u95ee\u8bca\u670d\u52a1\u8bbe\u7f6e\u670d\u52a1\u914d\u7f6e\u8fd4\u56de:[{}]", (Object)JSON.toJSONString((Object)baseResponse));
        if (!baseResponse.isSuccess()) {
            throw new RuntimeException("\u540c\u6b65\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    public String parseAndCheckServiceConfig(String serviceConfig) {
        ZXWZServiceBo zxwzServiceBo = (ZXWZServiceBo)JSON.parseObject((String)serviceConfig, ZXWZServiceBo.class);
        if (Objects.isNull(zxwzServiceBo)) {
            return ServiceCodeEnum.ZXMZ.getServiceConfig();
        }
        int anyTimeOrder = Objects.isNull(zxwzServiceBo.getAnyTimeOrder()) ? 1 : zxwzServiceBo.getAnyTimeOrder();
        zxwzServiceBo.setAnyTimeOrder(Integer.valueOf(anyTimeOrder));
        return JSON.toJSONString((Object)zxwzServiceBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
    }

    public ValidateResult parseAndCheckServiceConfigRetValiadte(String serviceConfig) {
        ZXWZServiceBo zxwzServiceBo = (ZXWZServiceBo)JSON.parseObject((String)serviceConfig, ZXWZServiceBo.class);
        if (Objects.isNull(zxwzServiceBo)) {
            return new ValidateResult("\u670d\u52a1\u914d\u7f6e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", false);
        }
        int anyTimeOrder = Objects.isNull(zxwzServiceBo.getAnyTimeOrder()) ? 1 : zxwzServiceBo.getAnyTimeOrder();
        zxwzServiceBo.setAnyTimeOrder(Integer.valueOf(anyTimeOrder));
        return ValidPropertyUtil.validate((Object)zxwzServiceBo);
    }

    private void synchroniseOldOnlineInquiry(DocServiceSetParam serviceSetParam, List<Long> doctorIds) {
        ZXWZServiceBo serviceInfo = (ZXWZServiceBo)JSON.parseObject((String)serviceSetParam.getServiceInfo(), ZXWZServiceBo.class);
        for (Long doctorId : doctorIds) {
            InquiryServiceConfigReq inquiryServiceConfig = new InquiryServiceConfigReq();
            inquiryServiceConfig.setDoctorId(String.valueOf(doctorId));
            inquiryServiceConfig.setNumLimit(serviceInfo.getReplyLimit());
            inquiryServiceConfig.setPrice(serviceInfo.getServicePrice());
            inquiryServiceConfig.setDailyLimit(serviceInfo.getNumLimit());
            inquiryServiceConfig.setAppCode(serviceSetParam.getAppCode());
            inquiryServiceConfig.setServTime(serviceInfo.getEffectiveTime());
            inquiryServiceConfig.setServCode(serviceSetParam.getServiceCode());
            BaseResponse baseResponse = HttpClientUtil.doJsonPost((Object)inquiryServiceConfig, (String)(this.NodeDomainName + serviceSetParam.getAppCode() + "/netinquiry/advisory/saveServiceInfo"));
            if (!Objects.isNull(baseResponse) && baseResponse.isSuccess()) continue;
            throw new RuntimeException("\u8c03\u7528\u5728\u7ebf\u95ee\u8bca\u8bbe\u7f6e\u670d\u52a1\u62a5\u9519:" + baseResponse.getMsg());
        }
    }
}

