/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.controller;

import com.alibaba.fastjson.JSONObject;
import com.doctor.basedata.api.ConfigurationApi;
import com.doctor.basedata.api.vo.ConfigurationReqVo;
import com.doctoruser.doctor.mapper.ConfigurationMapper;
import com.doctoruser.doctor.pojo.entity.ConfigEntity;
import com.doctoruser.doctor.service.ConfigurationService;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONTokener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="/common/configuration")
@Api(tags={"\u7edf\u4e00\u914d\u7f6e\u7ba1\u7406"})
public class ConfigurationController
implements ConfigurationApi {
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private ConfigurationMapper configurationMapper;

    @PostMapping(value={"/save"})
    @ApiOperation(value="/\u4fdd\u5b58\u914d\u7f6e")
    public void save() throws JSONException {
        List configEntitys = this.configurationMapper.findone();
        for (ConfigEntity configEntity : configEntitys) {
            String jsonStr = configEntity.getContent();
            Object json = new JSONTokener(jsonStr).nextValue();
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("id", configEntity.getId());
            map.put("createTime", configEntity.getCreateTime());
            map.put("updateTime", configEntity.getUpdateTime());
            map.put("status", configEntity.getStatus());
            map.put("levelCode", configEntity.getLevelCode());
            map.put("busiCode", configEntity.getBusiCode());
            map.put("clientCode", configEntity.getClientCode());
            if (json instanceof org.json.JSONObject) {
                if (StringUtils.isNotBlank((CharSequence)configEntity.getContent())) {
                    LinkedHashMap linkedHashMap = (LinkedHashMap)JSONObject.parseObject((String)configEntity.getContent(), LinkedHashMap.class);
                    map.put("content", linkedHashMap);
                }
                this.configurationService.insert(map);
                continue;
            }
            if (!(json instanceof JSONArray)) continue;
            if (StringUtils.isNotBlank((CharSequence)configEntity.getContent())) {
                List contentList = JSONObject.parseArray((String)configEntity.getContent(), LinkedHashMap.class);
                map.put("content", contentList);
            }
            this.configurationService.insert(map);
        }
    }

    @PostMapping(value={"/get_configuration"})
    @ApiOperation(value="\u67e5\u8be2\u7edf\u4e00\u914d\u7f6e\u5185\u5bb9")
    public BaseResponse<Map<String, Object>> getConfiguration(@RequestBody ConfigurationReqVo configurationReqVo) {
        HashMap<String, String> mapParam = new HashMap<String, String>();
        mapParam.put("busiCode", configurationReqVo.getBusiCode());
        if (StringUtils.isNotBlank((CharSequence)configurationReqVo.getLevelCode())) {
            mapParam.put("levelCode", configurationReqVo.getLevelCode());
        }
        if (StringUtils.isNotBlank((CharSequence)configurationReqVo.getClientCode())) {
            mapParam.put("clientCode", configurationReqVo.getClientCode());
        }
        configurationReqVo.getScreenParam().forEach((key, value) -> mapParam.put("content." + key, (String)value));
        return this.configurationService.findByCondition(mapParam);
    }
}

