/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.controller;

import com.alibaba.fastjson.JSON;
import com.doctor.basedata.api.DocBalanceOperateApi;
import com.doctor.basedata.api.dto.DoctorBalanceDTO;
import com.doctor.basedata.api.vo.ConsultationRemunerationReqVO;
import com.doctor.basedata.api.vo.UpdateBalanceReq;
import com.doctoruser.doctor.enums.EHErrorEnum;
import com.doctoruser.doctor.service.DocBalanceOperateService;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DocBalanceOperateController
implements DocBalanceOperateApi {
    private static final Logger log = LoggerFactory.getLogger(DocBalanceOperateController.class);
    @Autowired
    private DocBalanceOperateService docBalanceOperateService;

    public BaseResponse updateDoctorBalance(@RequestBody UpdateBalanceReq updateReq) {
        int update = this.docBalanceOperateService.updateDoctorBalance(updateReq);
        if (update == 0) {
            return BaseResponse.error((IError)EHErrorEnum.OPERATION_FAIL);
        }
        return BaseResponse.success();
    }

    public BaseResponse transferConsultationRemuneration(@RequestBody ConsultationRemunerationReqVO remunerationReqVO) {
        try {
            log.info("\u4f1a\u8bca\u5212\u62e8\u533b\u751f\u5165\u8d26:{}", (Object)JSON.toJSONString((Object)remunerationReqVO));
            this.docBalanceOperateService.transferConsultationRemuneration(remunerationReqVO);
            return BaseResponse.success();
        }
        catch (Exception e) {
            log.error("\u4f1a\u8bca\u5212\u62e8\u916c\u52b3\u5931\u8d25,\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)remunerationReqVO), (Object)e);
            return BaseResponse.error((IError)EHErrorEnum.OPERATION_FAIL);
        }
    }

    public BaseResponse<Map<Long, DoctorBalanceDTO>> getDoctorBalance(List<Long> doctorIds) {
        Map docBalanceMap = this.docBalanceOperateService.getDoctorBalance(doctorIds);
        return BaseResponse.success((Object)docBalanceMap);
    }
}

