/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.controller;

import com.doctor.basedata.api.UserEvaluationApi;
import com.doctor.basedata.api.dto.UcUserEvaluationDTO;
import com.doctor.basedata.api.dto.UserEvaluationDTO;
import com.doctor.basedata.api.vo.DoctorAverageScoreRespVO;
import com.doctor.basedata.api.vo.UcEvaluationTagVO;
import com.doctor.basedata.api.vo.UcUserEvaluationVO;
import com.doctoruser.doctor.service.IUserEvaluationService;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7528\u6237\u8bc4\u4ef7\u64cd\u4f5c\u7c7b"})
public class UserEvaluationController
implements UserEvaluationApi {
    @Autowired
    private IUserEvaluationService iUserEvaluationService;

    public BaseResponse<List<UcEvaluationTagVO>> getEvaluationTag(String servCode) {
        return this.iUserEvaluationService.getEvaluationTag(servCode);
    }

    public BaseResponse<Map<String, Object>> getEvaluationMsg(@RequestBody UserEvaluationDTO dto) {
        return this.iUserEvaluationService.getEvaluationMsg(dto);
    }

    public BaseResponse<List<UcUserEvaluationVO>> getDoctorEvaluationMsg(String doctorId, String servCode, String admId, String productId) {
        return this.iUserEvaluationService.getDoctorEvaluationMsg(doctorId, servCode, admId, productId);
    }

    public BaseResponse<PageResult<UcUserEvaluationVO>> getDoctorEvaluationMsgPage(String doctorId, String servCode, String admId, String productId, int pageNum, int pageSize) {
        return this.iUserEvaluationService.getDoctorEvaluationMsgPage(doctorId, servCode, admId, productId, pageNum, pageSize);
    }

    public BaseResponse<Object> saveEvaluationMsg(@RequestBody List<UcUserEvaluationDTO> dto) {
        return this.iUserEvaluationService.saveEvaluationMsg(dto);
    }

    public BaseResponse<Object> updateEvaluationMsg(String display, String admId) {
        return this.iUserEvaluationService.updateEvaluationMsg(display, admId);
    }

    public BaseResponse<String> getDoctorAverageScore(String doctorId) {
        return this.iUserEvaluationService.getDoctorAverageScore(doctorId);
    }

    public BaseResponse<Integer> siteEvalDisplay(String organId, String evalDisplay) {
        return this.iUserEvaluationService.siteEvalDisplay(organId, evalDisplay);
    }

    public BaseResponse<Object> deleteEvaluationMsg(String patientId, String admId) {
        return this.iUserEvaluationService.deleteEvaluationMsg(patientId, admId);
    }

    public BaseResponse<List<UcEvaluationTagVO>> getEvaluationTagByScore(String servCode, String score) {
        return this.iUserEvaluationService.getEvaluationTagByScore(servCode, score);
    }

    public BaseResponse<List<UcUserEvaluationVO>> getEvaLuationByDoctorIds(@RequestBody List<String> doctorIds) {
        return this.iUserEvaluationService.getEvaluationByDoctorIds(doctorIds);
    }

    public BaseResponse<List<DoctorAverageScoreRespVO>> getDoctorAverageScoreByDoctorIds(@RequestBody List<String> doctorIds) {
        if (null == doctorIds || doctorIds.size() < 1) {
            return BaseResponse.success(new ArrayList());
        }
        return this.iUserEvaluationService.getDoctorAverageScoreByDoctorIds(doctorIds);
    }

    @ApiOperation(value="\u83b7\u53d6\u8bc4\u8bba\u6743\u9650\u72b6\u6001", notes="\u83b7\u53d6\u8bc4\u8bba\u6743\u9650\u72b6\u6001")
    @GetMapping(value={"getDisplayStatus"})
    public BaseResponse<Integer> getDisplayStatus(@RequestParam(value="organId") String organId) {
        Integer displayStatus = this.iUserEvaluationService.getDisplayStatus(organId);
        return BaseResponse.success((Object)displayStatus);
    }
}

