/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.exception;

import com.doctoruser.doctor.exception.BusinessException;
import com.doctoruser.doctor.exception.UniformException;
import com.doctoruser.doctor.pojo.vo.ResultData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class ExceptionHandle {
    private Logger logger = LoggerFactory.getLogger(ExceptionHandle.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ResultData<Object> handle(Exception e) {
        this.logger.error(e.getMessage(), (Throwable)e);
        if (e instanceof UniformException) {
            UniformException uniformException = (UniformException)e;
            return new ResultData().error(uniformException.getMessage(), "-10002");
        }
        if (e instanceof BusinessException) {
            BusinessException busineeException = (BusinessException)((Object)e);
            return new ResultData().error(busineeException.getMessage(), "-1");
        }
        return new ResultData().error("\u672a\u77e5\u9519\u8bef");
    }
}

