/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.doctor.basedata.api.bo.doc_service.JKGLServiceBo;
import com.doctor.basedata.api.utils.ValidateResult;
import com.doctoruser.api.pojo.vo.basedata.doctor.InDoServiceStatus;
import com.doctoruser.doctor.enums.ServiceCodeEnum;
import com.doctoruser.doctor.handler.DocServiceHandler;
import com.doctoruser.doctor.pojo.vo.DocServiceSetParam;
import com.doctoruser.doctor.service.IDoctorService;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="jkgl")
public class JKGLServiceHandler
implements DocServiceHandler {
    private static final Logger log = LoggerFactory.getLogger(JKGLServiceHandler.class);
    @Autowired
    private IDoctorService doctorService;

    public void executeSynchronise(DocServiceSetParam serviceSetParam, List<Long> doctorIds) {
        for (Long doctorId : doctorIds) {
            InDoServiceStatus inDoServiceStatus = new InDoServiceStatus();
            inDoServiceStatus.setStatus(Integer.valueOf(serviceSetParam.getStatus() == 0 ? -1 : 1));
            inDoServiceStatus.setGroupCode(serviceSetParam.getServiceCode());
            inDoServiceStatus.setDoctorId(doctorId);
            this.doctorService.doctorServiceSynchro(inDoServiceStatus);
        }
    }

    public void synchroniseInsert(DocServiceSetParam serviceSetParam, List<Long> doctorIds) {
        this.executeSynchronise(serviceSetParam, doctorIds);
    }

    public void synchroniseUpdate(DocServiceSetParam serviceSetParam, List<Long> doctorIds) {
        this.executeSynchronise(serviceSetParam, doctorIds);
    }

    public String parseAndCheckServiceConfig(String serviceConfig) {
        JKGLServiceBo jkglServiceBO = (JKGLServiceBo)JSON.parseObject((String)serviceConfig, JKGLServiceBo.class);
        if (Objects.isNull(jkglServiceBO)) {
            return ServiceCodeEnum.HLZD.getServiceConfig();
        }
        return JSON.toJSONString((Object)jkglServiceBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
    }

    public ValidateResult parseAndCheckServiceConfigRetValiadte(String serviceConfig) {
        return new ValidateResult().initSuccess();
    }
}

