/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.doctor.basedata.api.bo.doc_service.ZXFZServiceBo;
import com.doctor.basedata.api.bo.doc_service.ZXWZServiceBo;
import com.doctor.basedata.api.utils.ValidPropertyUtil;
import com.doctor.basedata.api.utils.ValidateResult;
import com.doctoruser.doctor.enums.ServiceCodeEnum;
import com.doctoruser.doctor.handler.DocServiceHandler;
import com.doctoruser.doctor.mapper.DocDoctorWorkplacesInfoMapper;
import com.doctoruser.doctor.pojo.dto.OutPatientServiceSyncParamDTO;
import com.doctoruser.doctor.pojo.vo.DocServiceSetParam;
import com.doctoruser.doctor.pojo.vo.InquiryServiceConfigReq;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.HttpClientUtil;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="53110")
public class ZXFZServiceHandler
implements DocServiceHandler {
    private static final Logger log = LoggerFactory.getLogger(ZXFZServiceHandler.class);
    @Value(value="${domainName}")
    private String NodeDomainName;
    @Autowired
    private DocDoctorWorkplacesInfoMapper docDoctorWorkplacesInfoMapper;

    public void executeSynchronise(DocServiceSetParam serviceSetParam, List<Long> doctorWorkInfoIds) {
        List doctorInfoList = this.docDoctorWorkplacesInfoMapper.getDoctorIdAndDeptIdByIds(doctorWorkInfoIds, Integer.valueOf(1));
        ZXFZServiceBo zxfzServiceBo = (ZXFZServiceBo)JSON.parseObject((String)serviceSetParam.getServiceInfo(), ZXFZServiceBo.class);
        OutPatientServiceSyncParamDTO outPatientServiceSyncParamDTO = new OutPatientServiceSyncParamDTO();
        outPatientServiceSyncParamDTO.setDoctorInfo(doctorInfoList);
        outPatientServiceSyncParamDTO.setAppCode(serviceSetParam.getAppCode());
        outPatientServiceSyncParamDTO.setDailyLimit(zxfzServiceBo.getNumLimit());
        outPatientServiceSyncParamDTO.setHospitalId(String.valueOf(serviceSetParam.getOrganId()));
        Integer isSchedule = this.computeScheduleStatus(zxfzServiceBo.getIsSchedule(), zxfzServiceBo.getAnyTimeOrder());
        outPatientServiceSyncParamDTO.setIsSchedule(isSchedule);
        outPatientServiceSyncParamDTO.setNumLimit(zxfzServiceBo.getReplyLimit());
        outPatientServiceSyncParamDTO.setOrderTime(zxfzServiceBo.getWaitTimeLimit());
        outPatientServiceSyncParamDTO.setOrderTimeUnit(Integer.valueOf(zxfzServiceBo.getWaitTimeUnit()));
        outPatientServiceSyncParamDTO.setPrice(zxfzServiceBo.getServicePrice());
        outPatientServiceSyncParamDTO.setServiceCode(serviceSetParam.getServiceCode());
        outPatientServiceSyncParamDTO.setServTime(zxfzServiceBo.getEffectiveTime());
        outPatientServiceSyncParamDTO.setStatus(serviceSetParam.getStatus());
        outPatientServiceSyncParamDTO.setTimeUnit(Integer.valueOf(zxfzServiceBo.getServiceTimeUnit()));
        outPatientServiceSyncParamDTO.setOperationType(serviceSetParam.getOperationType());
        outPatientServiceSyncParamDTO.setOuterCourtyard(zxfzServiceBo.getOuterCourtyard());
        log.info("\u8c03\u7528\u5728\u7ebf\u590d\u8bca\u670d\u52a1\u8bbe\u7f6e\u670d\u52a1\u914d\u7f6e\u5165\u53c2:[{}]", (Object)JSON.toJSONString((Object)outPatientServiceSyncParamDTO));
        BaseResponse baseResponse = HttpClientUtil.doJsonPost((Object)outPatientServiceSyncParamDTO, (String)(this.NodeDomainName + serviceSetParam.getAppCode() + "/netinquiry/serviceconfig/saveConfigInfoListNew"));
        log.info("\u8c03\u7528\u5728\u7ebf\u590d\u8bca\u670d\u52a1\u8bbe\u7f6e\u670d\u52a1\u914d\u7f6e\u8fd4\u56de:[{}]", (Object)JSON.toJSONString((Object)baseResponse));
        if (!baseResponse.isSuccess()) {
            throw new RuntimeException("\u540c\u6b65\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private void executeSynchroniseOld(DocServiceSetParam serviceSetParam, List<Long> doctorIds) {
        log.info("\u8fdb\u5165\u540c\u6b65\u533b\u751f\u670d\u52a1\u8bbe\u7f6e\u5230\u5728\u7ebf\u590d\u8bca,\u670d\u52a1\u53c2\u6570:{},\u533b\u751fid\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)serviceSetParam), doctorIds);
        ZXWZServiceBo serviceInfo = (ZXWZServiceBo)JSON.parseObject((String)serviceSetParam.getServiceInfo(), ZXWZServiceBo.class);
        if (Objects.nonNull(serviceInfo)) {
            for (Long doctorId : doctorIds) {
                InquiryServiceConfigReq inquiryServiceConfig = new InquiryServiceConfigReq();
                inquiryServiceConfig.setDoctorId(String.valueOf(doctorId));
                inquiryServiceConfig.setNumLimit(serviceInfo.getReplyLimit());
                inquiryServiceConfig.setDailyLimit(serviceInfo.getNumLimit());
                inquiryServiceConfig.setPrice(serviceInfo.getServicePrice());
                inquiryServiceConfig.setAppCode(serviceSetParam.getAppCode());
                inquiryServiceConfig.setServTime(serviceInfo.getEffectiveTime());
                inquiryServiceConfig.setServCode(serviceSetParam.getServiceCode());
                log.info("\u8c03\u7528\u5728\u7ebf\u590d\u8bca\u670d\u52a1\u8bbe\u7f6e\u670d\u52a1\u5165\u53c2:{}", (Object)inquiryServiceConfig.toString());
                BaseResponse baseResponse = HttpClientUtil.doJsonPost((Object)inquiryServiceConfig, (String)(this.NodeDomainName + serviceSetParam.getAppCode() + "/netinquiry/advisory/saveServiceInfo"));
                if (baseResponse.isSuccess()) continue;
                throw new RuntimeException("\u540c\u6b65\u5728\u7ebf\u590d\u8bca\u670d\u52a1\u5931\u8d25");
            }
        }
    }

    public void synchroniseInsert(DocServiceSetParam serviceSetParam, List<Long> doctorIds) {
        serviceSetParam.setOperationType(Integer.valueOf(1));
        this.executeSynchronise(serviceSetParam, doctorIds);
    }

    public void synchroniseUpdate(DocServiceSetParam serviceSetParam, List<Long> doctorIds) {
        serviceSetParam.setOperationType(Integer.valueOf(2));
        this.executeSynchronise(serviceSetParam, doctorIds);
    }

    public String parseAndCheckServiceConfig(String serviceConfig) {
        ZXFZServiceBo zxfzServiceBo = (ZXFZServiceBo)JSON.parseObject((String)serviceConfig, ZXFZServiceBo.class);
        if (Objects.isNull(zxfzServiceBo)) {
            return ServiceCodeEnum.ZXFZ.getServiceConfig();
        }
        int anyTimeOrder = Objects.isNull(zxfzServiceBo.getAnyTimeOrder()) ? 1 : zxfzServiceBo.getAnyTimeOrder();
        zxfzServiceBo.setAnyTimeOrder(Integer.valueOf(anyTimeOrder));
        return JSON.toJSONString((Object)zxfzServiceBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
    }

    public ValidateResult parseAndCheckServiceConfigRetValiadte(String serviceConfig) {
        ZXFZServiceBo zxfzServiceBo = (ZXFZServiceBo)JSON.parseObject((String)serviceConfig, ZXFZServiceBo.class);
        if (Objects.isNull(zxfzServiceBo)) {
            return new ValidateResult("\u670d\u52a1\u914d\u7f6e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", false);
        }
        int anyTimeOrder = Objects.isNull(zxfzServiceBo.getAnyTimeOrder()) ? 1 : zxfzServiceBo.getAnyTimeOrder();
        zxfzServiceBo.setAnyTimeOrder(Integer.valueOf(anyTimeOrder));
        return ValidPropertyUtil.validate((Object)zxfzServiceBo);
    }
}

