/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.service.impl;

import com.doctor.basedata.api.vo.BatchAssociatedDeptReqVO;
import com.doctor.basedata.api.vo.DeptCustomClassifyVO;
import com.doctor.basedata.api.vo.RemoveAssociatedDeptReqVO;
import com.doctor.basedata.api.vo.SaveDeptCustomClassifyReqVO;
import com.doctor.basedata.api.vo.UpdateDeptCustomClassifyReqVO;
import com.doctoruser.doctor.enums.EHErrorEnum;
import com.doctoruser.doctor.enums.WhetherModifiedEnum;
import com.doctoruser.doctor.mapper.ClassifyDeptRelativeMapper;
import com.doctoruser.doctor.mapper.DeptCustomClassifyMapper;
import com.doctoruser.doctor.mapper.DictionaryMapper;
import com.doctoruser.doctor.pojo.entity.ClassifyDeptRelative;
import com.doctoruser.doctor.pojo.entity.DeptCustomClassify;
import com.doctoruser.doctor.service.DeptCustomClassifyService;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.framework.utils.UUIDUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeptCustomClassifyServiceImpl
implements DeptCustomClassifyService {
    private static final Logger log = LoggerFactory.getLogger(DeptCustomClassifyServiceImpl.class);
    @Autowired
    private DeptCustomClassifyMapper deptCustomClassifyMapper;
    @Autowired
    private ClassifyDeptRelativeMapper classifyDeptRelativeMapper;
    @Autowired
    private DictionaryMapper dictionaryMapper;

    public BaseResponse save(SaveDeptCustomClassifyReqVO saveDeptCustomClassifyReqVO) {
        String classifyName;
        Long organId = saveDeptCustomClassifyReqVO.getOrganId();
        int count = this.deptCustomClassifyMapper.getCountByOrganIdAndClassifyName(organId, classifyName = saveDeptCustomClassifyReqVO.getClassifyName());
        if (count > 0) {
            return BaseResponse.error((IError)EHErrorEnum.NAME_CANNOT_BE_DUPLICATE);
        }
        DeptCustomClassify deptCustomClassify = new DeptCustomClassify();
        BeanUtils.copyProperties((Object)saveDeptCustomClassifyReqVO, (Object)deptCustomClassify);
        deptCustomClassify.setStatus(Integer.valueOf(1));
        deptCustomClassify.setViewId(UUIDUtils.getUUID());
        deptCustomClassify.setWhetherModified(WhetherModifiedEnum.CAN_MODIFIED.getValue());
        this.deptCustomClassifyMapper.insertSelective(deptCustomClassify);
        return BaseResponse.success();
    }

    public BaseResponse update(UpdateDeptCustomClassifyReqVO updateDeptCustomClassifyReqVO) {
        DeptCustomClassify tbClassify = this.deptCustomClassifyMapper.selectByPrimaryKey(updateDeptCustomClassifyReqVO.getId());
        if (tbClassify == null) {
            return BaseResponse.error((IError)EHErrorEnum.DATA_NOT_EXIST);
        }
        String classifyName = updateDeptCustomClassifyReqVO.getClassifyName();
        int count = this.deptCustomClassifyMapper.getCountByOrganIdAndClassifyName(tbClassify.getOrganId(), classifyName);
        if (count > 0 && !classifyName.equals(tbClassify.getClassifyName())) {
            return BaseResponse.error((IError)EHErrorEnum.NAME_CANNOT_BE_DUPLICATE);
        }
        DeptCustomClassify deptCustomClassify = new DeptCustomClassify();
        BeanUtils.copyProperties((Object)updateDeptCustomClassifyReqVO, (Object)deptCustomClassify);
        deptCustomClassify.setWhetherModified(WhetherModifiedEnum.CAN_MODIFIED.getValue());
        this.deptCustomClassifyMapper.updateByPrimaryKeySelective(deptCustomClassify);
        return BaseResponse.success();
    }

    @Transactional
    public void deleteById(String id) {
        this.classifyDeptRelativeMapper.deleteByClassifyId(id);
        this.deptCustomClassifyMapper.deleteByPrimaryKey(Long.valueOf(id));
    }

    @Transactional
    public void batchAssociatedDept(BatchAssociatedDeptReqVO batchAssociatedDeptReqVO) {
        String classifyId = batchAssociatedDeptReqVO.getClassifyId();
        List deptIdList = batchAssociatedDeptReqVO.getDeptIdList();
        if (deptIdList != null && deptIdList.size() > 0) {
            for (String deptId : deptIdList) {
                ClassifyDeptRelative dbClassifyDeptRelative = this.classifyDeptRelativeMapper.getByClassifyIdAndDeptId(classifyId, deptId);
                if (dbClassifyDeptRelative != null) continue;
                ClassifyDeptRelative classifyDeptRelative = new ClassifyDeptRelative();
                classifyDeptRelative.setClassifyId(Long.valueOf(classifyId));
                classifyDeptRelative.setDeptId(Long.valueOf(deptId));
                this.classifyDeptRelativeMapper.insert(classifyDeptRelative);
            }
        }
    }

    public void removeAssociatedDept(RemoveAssociatedDeptReqVO removeAssociatedDeptReqVO) {
        String classifyId = removeAssociatedDeptReqVO.getClassifyId();
        String deptId = removeAssociatedDeptReqVO.getDeptId();
        this.classifyDeptRelativeMapper.deleteByClassifyIdAndDeptId(classifyId, deptId);
    }

    public List<DeptCustomClassifyVO> findByOrganId(String organId) {
        List list = this.deptCustomClassifyMapper.findByOrganId(organId);
        if (list.isEmpty()) {
            List defaultClassify = this.dictionaryMapper.findByTypeCode("12600");
            log.info("\u67e5\u8be2\u5230\u7684\u9ed8\u8ba4\u79d1\u5ba4\u5206\u7c7b\u6570\u636e:{}", (Object)defaultClassify);
            List defaultClassifyList = defaultClassify.stream().map(item -> {
                DeptCustomClassify deptCustomClassify = new DeptCustomClassify();
                deptCustomClassify.initDefaultClassify();
                deptCustomClassify.setClassifyName(item.getDicName());
                deptCustomClassify.setOrganId(Long.valueOf(organId));
                deptCustomClassify.setClassifyCode(item.getDicCode());
                return deptCustomClassify;
            }).collect(Collectors.toList());
            for (DeptCustomClassify deptCustomClassify : defaultClassifyList) {
                this.deptCustomClassifyMapper.insertSelective(deptCustomClassify);
            }
            list = defaultClassifyList.stream().map(item -> {
                DeptCustomClassifyVO deptCustomClassifyVO = new DeptCustomClassifyVO();
                BeanUtils.copyProperties((Object)item, (Object)deptCustomClassifyVO);
                return deptCustomClassifyVO;
            }).collect(Collectors.toList());
        }
        return list;
    }

    public List<DeptCustomClassifyVO> findByDeptIdAndOrganId(Long deptId, Long organId) {
        return this.deptCustomClassifyMapper.findByDeptIdAndOrganId(deptId, organId);
    }
}

