/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.controller;

import com.doctoruser.doctor.pojo.vo.DeleteRelationGroupReq;
import com.doctoruser.doctor.pojo.vo.DocRelationGroupReqVo;
import com.doctoruser.doctor.pojo.vo.DocRelationGroupRespVo;
import com.doctoruser.doctor.pojo.vo.EditRelationGroupReq;
import com.doctoruser.doctor.pojo.vo.SortRelationGroupReqVo;
import com.doctoruser.doctor.service.DocRelationGroupService;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/relation_group"})
@Api(tags={"\u533b\u751f\u5173\u6ce8\u5206\u7ec4"})
public class DocRelationGroupController {
    private static final Logger log = LoggerFactory.getLogger(DocRelationGroupController.class);
    @Autowired
    private DocRelationGroupService docRelationGroupService;

    @ApiOperation(value="\u6dfb\u52a0\u533b\u751f\u5173\u6ce8\u5206\u7ec4")
    @PostMapping(value={"/add_doc_relation_group"})
    public BaseResponse<DocRelationGroupRespVo> addDocRelationGroup(@RequestBody DocRelationGroupReqVo docRelationGroupReqVo) {
        return this.docRelationGroupService.addDocRelationGroup(docRelationGroupReqVo);
    }

    @ApiOperation(value="\u67e5\u8be2\u533b\u751f\u5173\u6ce8\u5206\u7ec4\u96c6\u5408")
    @GetMapping(value={"/get_doc_relation_group_list"})
    public BaseResponse<List<DocRelationGroupRespVo>> getDocRelationGroupList(@RequestParam(value="doctorId") Long doctorId, @RequestParam(value="appCode") String appCode) {
        return this.docRelationGroupService.getDocRelationGroupList(doctorId, appCode);
    }

    @ApiOperation(value="\u5220\u9664\u533b\u751f\u5173\u6ce8\u5206\u7ec4")
    @PostMapping(value={"/delete_doc_relation_group"})
    public BaseResponse deleteDocRelationGroup(@RequestParam(value="groupId") Long groupId) {
        return this.docRelationGroupService.deleteDocRelationGroup(groupId);
    }

    @ApiOperation(value="\u4fee\u6539\u5206\u7ec4\u540d\u79f0")
    @PostMapping(value={"/update_relation_group_name_"})
    public BaseResponse updateRelationGroupName(@RequestBody EditRelationGroupReq editRelationGroupReq) {
        return this.docRelationGroupService.updateRelationGroupName(editRelationGroupReq.getGroupId(), editRelationGroupReq.getGroupName());
    }

    @ApiOperation(value="\u60a3\u8005\u62a5\u5230-\u6dfb\u52a0\u533b\u751f\u5173\u6ce8\u5206\u7ec4")
    @PostMapping(value={"/add_doc_relation_group_new"})
    public BaseResponse<DocRelationGroupRespVo> addDocRelationGroupNew(@Validated @RequestBody DocRelationGroupReqVo docRelationGroupReqVo) {
        return this.docRelationGroupService.addDocRelationGroupNew(docRelationGroupReqVo);
    }

    @ApiOperation(value="\u60a3\u8005\u62a5\u5230-\u67e5\u8be2\u533b\u751f\u5173\u6ce8\u5206\u7ec4\u96c6\u5408")
    @GetMapping(value={"/get_doc_relation_group_list_new"})
    public BaseResponse<List<DocRelationGroupRespVo>> getDocRelationGroupListNew(@RequestParam(value="doctorId") Long doctorId, @RequestParam(value="appCode") String appCode) {
        if (Objects.isNull(doctorId)) {
            return BaseResponse.error((String)"\u533b\u751fID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.isNull(appCode)) {
            return BaseResponse.error((String)"appCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.docRelationGroupService.getDocRelationGroupListNew(doctorId, appCode);
    }

    @ApiOperation(value="\u60a3\u8005\u62a5\u5230-\u5220\u9664\u533b\u751f\u5173\u6ce8\u5206\u7ec4")
    @PostMapping(value={"/delete_doc_relation_group_new"})
    public BaseResponse deleteDocRelationGroupNew(@RequestParam(value="groupId") Long groupId) {
        return this.docRelationGroupService.deleteDocRelationGroupNew(groupId);
    }

    @ApiOperation(value="\u60a3\u8005\u62a5\u5230-\u5220\u9664\u533b\u751f\u5173\u6ce8\u5206\u7ec4")
    @PostMapping(value={"/v2/delete_doc_relation_group_new"})
    public BaseResponse deleteDocRelationGroupv2(@RequestBody DeleteRelationGroupReq deleteRelationGroupReq) {
        if (Objects.isNull(deleteRelationGroupReq.getGroupId())) {
            return BaseResponse.error((String)"\u5206\u7ec4ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.docRelationGroupService.deleteDocRelationGroupNew(deleteRelationGroupReq.getGroupId());
    }

    @ApiOperation(value="\u60a3\u8005\u62a5\u5230-\u4fee\u6539\u5206\u7ec4\u540d\u79f0")
    @PostMapping(value={"/update_relation_group_name_new"})
    public BaseResponse updateRelationGroupNameNew(@Validated @RequestBody EditRelationGroupReq editRelationGroupReq) {
        return this.docRelationGroupService.updateRelationGroupNameNew(editRelationGroupReq.getGroupId(), editRelationGroupReq.getGroupName());
    }

    @ApiOperation(value="\u60a3\u8005\u62a5\u5230-\u4fee\u6539\u5206\u7ec4\u6392\u5e8f")
    @PostMapping(value={"/sort_relation_group"})
    public BaseResponse sortRelationGroup(@Validated @RequestBody SortRelationGroupReqVo sortRelationGroupReqVo) {
        return this.docRelationGroupService.sortRelationGroup(sortRelationGroupReqVo.getGroupIdList());
    }

    @ApiOperation(value="\u60a3\u8005\u62a5\u5230-\u83b7\u53d6\u533b\u751f\u9ed8\u8ba4\u5206\u7ec4")
    @GetMapping(value={"/get_doctor_default_group"})
    public BaseResponse getDoctorDefaultGroup(@RequestParam(value="doctorId") Long doctorId, @RequestParam(value="appCode") String appCode) {
        if (Objects.isNull(doctorId)) {
            return BaseResponse.error((String)"\u533b\u751fID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.isNull(appCode)) {
            return BaseResponse.error((String)"appCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.docRelationGroupService.getDoctorDefaultGroup(doctorId, appCode);
    }

    @ApiOperation(value="\u60a3\u8005\u62a5\u5230-\u67e5\u8be2\u6162\u75c5\u7ba1\u7406\u5206\u7ec4\u4fe1\u606f")
    @GetMapping(value={"/getChronicGroup"})
    public BaseResponse<DocRelationGroupRespVo> getChronicGroup(@RequestParam(value="doctorId") Long doctorId, @RequestParam(value="appCode") String appCode) {
        if (Objects.isNull(doctorId)) {
            return BaseResponse.error((String)"\u533b\u751fID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.isNull(appCode)) {
            return BaseResponse.error((String)"appCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.docRelationGroupService.getChronicGroup(doctorId, appCode);
    }
}

