/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.controller;

import com.doctoruser.api.DoctorInfoApi;
import com.doctoruser.api.pojo.base.dto.DoctorBaseInfoDTO;
import com.doctoruser.api.pojo.base.dto.FeignQueryDocAndTeamInfoDTO;
import com.doctoruser.api.pojo.base.dto.basedata.ListDoctorReq;
import com.doctoruser.api.pojo.base.dto.doctor.DoctorIdBatch;
import com.doctoruser.api.pojo.base.dto.doctor.DoctorNameAndBaseInfo;
import com.doctoruser.api.pojo.base.dto.doctor.ImInfosReq;
import com.doctoruser.api.pojo.base.dto.doctor.QueryCodeInfoReq;
import com.doctoruser.api.pojo.base.dto.doctor.QueryDocBaseInfoDTO;
import com.doctoruser.api.pojo.base.dto.doctor.QueryDocDeviceIdReq;
import com.doctoruser.api.pojo.base.dto.doctor.QueryDoctorAndTeamInfoDTO;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.dto.verify.DocAllInfoDto;
import com.doctoruser.api.pojo.base.entity.DoctorEntity;
import com.doctoruser.api.pojo.base.query.BusinessDoctorPageQuery;
import com.doctoruser.api.pojo.base.query.DoctorInfoQuery;
import com.doctoruser.api.pojo.base.query.ExecutorInformationQuery;
import com.doctoruser.api.pojo.base.query.QueryDoctorImInformInfoReq;
import com.doctoruser.api.pojo.base.query.ZxmzDoctorPageQuery;
import com.doctoruser.api.pojo.base.vo.BaseDoctorInfoVo;
import com.doctoruser.api.pojo.base.vo.DocBaseInfoVo;
import com.doctoruser.api.pojo.base.vo.DoctorAccountReq;
import com.doctoruser.api.pojo.base.vo.DoctorAllInfoVo;
import com.doctoruser.api.pojo.base.vo.DoctorIdVo;
import com.doctoruser.api.pojo.base.vo.DoctorImInformInfo;
import com.doctoruser.api.pojo.base.vo.DoctorInfoForBaseVo;
import com.doctoruser.api.pojo.base.vo.DoctorNameAndOrganNameRes;
import com.doctoruser.api.pojo.base.vo.DoctorNameInfoVo;
import com.doctoruser.api.pojo.base.vo.DoctorNameVo;
import com.doctoruser.api.pojo.base.vo.ExecutorInformationVO;
import com.doctoruser.api.pojo.base.vo.FeignQueryDocAndTeamInfoVo;
import com.doctoruser.api.pojo.base.vo.ImInfosRes;
import com.doctoruser.api.pojo.base.vo.QueryCodeInfoRes;
import com.doctoruser.api.pojo.base.vo.QueryDocDeviceIdRes;
import com.doctoruser.api.pojo.base.vo.basedata.DocInfoVO;
import com.doctoruser.api.pojo.base.vo.basedata.GuideBaseResponse;
import com.doctoruser.api.pojo.base.vo.doctor.DoctorBasicInfoVo;
import com.doctoruser.api.pojo.base.vo.doctor.DoctorDetailsVO;
import com.doctoruser.api.pojo.base.vo.doctor.DoctorQueryParam;
import com.doctoruser.api.pojo.base.vo.doctor.DoctorQueryReq;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.doctoruser.api.pojo.base.vo.doctor.ShareCodeQueryReqVO;
import com.doctoruser.api.pojo.base.vo.doctor.ShareCodeQueryRespVO;
import com.doctoruser.api.pojo.vo.GuideDoctorInfoVo;
import com.doctoruser.doctor.pojo.dto.DoctorInfoDTO;
import com.doctoruser.doctor.pojo.vo.OrganProfessionDoctorReqVo;
import com.doctoruser.doctor.service.DoctorInfoService;
import com.doctoruser.doctor.service.IDoctorService;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8282\u70b9\u8fc1\u79fb\u533b\u751f\u63a5\u53e3"})
public class DoctorInfoController
implements DoctorInfoApi {
    @Autowired
    private DoctorInfoService doctorInfoService;
    @Autowired
    private IDoctorService doctorService;

    public BaseResponse<DocBaseInfoVo> queryBaseInfoById(@RequestBody QueryDocBaseInfoDTO param) {
        return this.doctorInfoService.queryBaseInfoById(param);
    }

    public BaseResponse<QueryDocDeviceIdRes> queryDocDeviceId(@RequestBody QueryDocDeviceIdReq param) {
        return this.doctorInfoService.queryDocDeviceId(param);
    }

    public BaseResponse<List<ImInfosRes>> queryDoctorImInfos(@RequestBody ImInfosReq param) {
        return this.doctorInfoService.queryDoctorImInfos(param);
    }

    public BaseResponse<FeignQueryDocAndTeamInfoVo> feignQueryDocAndTeamInfo(@RequestBody FeignQueryDocAndTeamInfoDTO dto) {
        return this.doctorInfoService.feignQueryDocAndTeamInfo(dto);
    }

    public BaseResponse<List<DoctorNameAndBaseInfo>> queryDoctorNameBatch(@RequestBody DoctorIdBatch req) {
        return this.doctorInfoService.queryDoctorNameBatch(req);
    }

    public BaseResponse<List<DoctorInfoForBaseVo>> findDoctorOrTeamInfo(@RequestBody List<QueryDoctorAndTeamInfoDTO> param) {
        return this.doctorInfoService.findDoctorOrTeamInfo(param);
    }

    public BaseResponse<DoctorAllInfoVo> findDoctorAllInfo(@RequestBody DocAllInfoDto param) {
        return this.doctorInfoService.findDoctorAllInfo(param);
    }

    public BaseResponse<QueryCodeInfoRes> queryCodeInfo(@RequestBody QueryCodeInfoReq param) {
        return this.doctorInfoService.queryCodeInfo(param);
    }

    public BaseResponse<List<DoctorImInformInfo>> queryPersonImInformInfos(@RequestBody QueryDoctorImInformInfoReq reqVo) {
        List doctorIds = reqVo.getDoctorIds();
        if (doctorIds.isEmpty()) {
            return BaseResponse.error((IError)IError.PARAM_CHECK_FAILD);
        }
        return this.doctorInfoService.queryDoctorImInfo(reqVo);
    }

    public BaseResponse<DoctorNameInfoVo> selectDoctorNameByPhone(@RequestBody DoctorAccountReq req) {
        return this.doctorInfoService.selectDoctorNameByPhone(req.getDoctorAccount());
    }

    public BaseResponse<DoctorNameAndOrganNameRes> queryDoctorInfoForBank(@RequestBody DoctorIdVo param) {
        return this.doctorInfoService.queryDoctorInfoForBank(param);
    }

    public BaseResponse<PageResult<DocInfoVO>> listBaseData(@RequestBody ListDoctorReq param) {
        return this.doctorInfoService.listBaseData(param);
    }

    public BaseResponse<DoctorDetailsVO> queryDocBaseData(@RequestBody DoctorQueryParam param) {
        return BaseResponse.success();
    }

    public BaseResponse<DoctorDetailsVO> queryDocBaseDataInOrgan(@RequestBody DoctorQueryParam param) {
        return this.doctorInfoService.queryDocBaseDataInOrgan(param.getDoctorId(), param.getOrganId());
    }

    public BaseResponse<ShareCodeQueryRespVO> queryShareCode(@RequestBody ShareCodeQueryReqVO reqVO) {
        return this.doctorInfoService.queryShareCode(reqVO);
    }

    public BaseResponse<PersonnelInfo> queryPersonnelInfo(@RequestBody QueryPersonnelInfoReq param) {
        return this.doctorInfoService.queryPersonnelInfo(param);
    }

    public BaseResponse<PageResult<DoctorDetailsVO>> queryDocBaseDataList(@RequestBody DoctorQueryParam param) {
        return this.doctorInfoService.queryDocBaseDataList(param);
    }

    public BaseResponse<DoctorBaseInfoDTO> getDoctorInfo(@RequestParam(value="doctorId") Long doctorId, @RequestParam(value="organId") String organId) {
        return this.doctorInfoService.getDoctorInfo(doctorId, organId);
    }

    public BaseResponse<List<DoctorBaseInfoDTO>> getDoctorInfoList(@RequestParam(value="doctorIdList") List<Long> doctorIdList, @RequestParam(value="organId") String organId) {
        return this.doctorInfoService.getDoctorInfoList(doctorIdList, organId);
    }

    public BaseResponse<PageResult<DoctorDetailsVO>> getDoctorBaseInfoPage(@RequestBody DoctorQueryReq doctorQueryReq) {
        return this.doctorInfoService.getDoctorBaseInfoPage(doctorQueryReq);
    }

    public BaseResponse<String> queryDoctorIds(@RequestParam(value="organId") Long organId, @RequestParam(value="doctorName") String doctorName) {
        return this.doctorInfoService.queryDoctorIds(organId, doctorName);
    }

    public BaseResponse<List<DoctorEntity>> getDepartmentDoctor(@RequestParam(value="organId") Long organId, @RequestParam(name="deptId", required=false) Long deptId, @RequestParam(name="serviceCode", required=false) String serviceCode) {
        return this.doctorInfoService.getDepartmentDoctor(organId, deptId, serviceCode);
    }

    public BaseResponse<DoctorAllInfoVo> getSingleDoctorInfo(@RequestParam(value="doctorId") Long doctorId, @RequestParam(value="organId") Long organId) {
        return this.doctorInfoService.getSingleDoctorInfo(doctorId, organId);
    }

    public BaseResponse<List<DoctorNameVo>> getOpenServiceDoctor(@RequestParam(value="hospitalIds") List<Long> hospitalIds, @RequestParam(value="serviceCode") String serviceCode) {
        return this.doctorInfoService.getOpenServiceDoctor(hospitalIds, serviceCode);
    }

    public BaseResponse<List<BaseDoctorInfoVo>> getStdDeptAndServiceOpenDoctor(@RequestParam(value="appCode") String appCode, @RequestParam(value="stdDeptId") Long stdDeptId, @RequestParam(value="serviceCode") String serviceCode) {
        return this.doctorInfoService.getStdDeptAndServiceOpenDoctor(appCode, stdDeptId, serviceCode);
    }

    public BaseResponse<PageResult<ExecutorInformationVO>> getDoctorAndDepartmentByDoctorName(@RequestBody ExecutorInformationQuery executorInformationQuery) {
        return this.doctorInfoService.getDoctorAndDepartmentByDoctorName(executorInformationQuery);
    }

    public BaseResponse<PageResult<DoctorBasicInfoVo>> getOrganDoctorPage(@RequestBody DoctorInfoQuery doctorInfoQuery) {
        return this.doctorInfoService.getOrganDoctorPage(doctorInfoQuery);
    }

    @Deprecated
    public BaseResponse<PageResult<DoctorBasicInfoVo>> getBusinessDoctorPage(@RequestBody BusinessDoctorPageQuery businessDoctorPageQuery) {
        if (StringUtils.isNotBlank((String)businessDoctorPageQuery.getServiceCodes())) {
            String[] split = businessDoctorPageQuery.getServiceCodes().split(",");
            List<String> serviceCodeList = Arrays.asList(split);
            businessDoctorPageQuery.setServiceCodes("");
            if (!serviceCodeList.isEmpty()) {
                String serviceCodes = serviceCodeList.stream().collect(Collectors.joining("','", "'", "'"));
                businessDoctorPageQuery.setServiceCodes(serviceCodes);
            }
        }
        return this.doctorInfoService.getBusinessDoctorPage(businessDoctorPageQuery);
    }

    public BaseResponse<PageResult<BaseDoctorInfoVo>> getOrganDoctorList(@RequestBody DoctorInfoQuery doctorInfoQuery) {
        return this.doctorService.getOrganDoctorList(doctorInfoQuery);
    }

    public BaseResponse<List<BaseDoctorInfoVo>> getDoctorListByParams(DoctorInfoQuery doctorInfoQuery) {
        return this.doctorService.getDoctorListByParams(doctorInfoQuery);
    }

    public BaseResponse<PageResult<DoctorBasicInfoVo>> queryDoctorZxmz(@RequestBody ZxmzDoctorPageQuery zxmzDoctorPageQuery) {
        return this.doctorInfoService.queryDoctorZxmz(zxmzDoctorPageQuery);
    }

    public GuideBaseResponse<List<GuideDoctorInfoVo>> getDoctorList(String deptId, String hosId, String branchId) {
        return this.doctorInfoService.getDoctorList(deptId, hosId, branchId);
    }

    @PostMapping(value={"/getOrganProfessionDoctor"})
    @Deprecated
    @ApiOperation(value="\u67e5\u8be2\u7279\u5b9a\u804c\u79f0\u533b\u751f")
    public BaseResponse<List<BaseDoctorInfoVo>> getOrganProfessionDoctor(@RequestBody OrganProfessionDoctorReqVo reqVo) {
        return this.doctorInfoService.getOrganProfessionDoctor(reqVo);
    }

    @GetMapping(value={"/getDoctorUserId"})
    @ApiOperation(value="\u67e5\u8be2\u533b\u751fUserId")
    public BaseResponse<List<DoctorInfoDTO>> getDoctorUserId(@RequestParam(value="doctorIds") List<String> doctorIds) {
        return this.doctorInfoService.getDoctorUserId(doctorIds);
    }
}

