/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.doctor.basedata.api.bo.doc_service.JSKFServiceBo;
import com.doctor.basedata.api.utils.ValidPropertyUtil;
import com.doctor.basedata.api.utils.ValidateResult;
import com.doctoruser.doctor.enums.ServiceCodeEnum;
import com.doctoruser.doctor.handler.DocServiceHandler;
import com.doctoruser.doctor.mapper.DocDoctorWorkplacesInfoMapper;
import com.doctoruser.doctor.pojo.dto.DoctorIdsAndOrganIdDTO;
import com.doctoruser.doctor.pojo.dto.OutPatientServiceSyncParamDTO;
import com.doctoruser.doctor.pojo.vo.DocServiceSetParam;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.HttpClientUtil;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="jskfzy")
public class JSKFZYServiceHandler
implements DocServiceHandler {
    private static final Logger log = LoggerFactory.getLogger(JSKFZYServiceHandler.class);
    @Value(value="${domainName}")
    private String NodeDomainName;
    @Autowired
    private DocDoctorWorkplacesInfoMapper docDoctorWorkplacesInfoMapper;

    public void executeSynchronise(DocServiceSetParam serviceSetParam, List<Long> doctorIds) {
        DoctorIdsAndOrganIdDTO doctorIdsAndOrganId = new DoctorIdsAndOrganIdDTO();
        doctorIdsAndOrganId.setDoctorIds(doctorIds);
        doctorIdsAndOrganId.setOrganId(serviceSetParam.getOrganId());
        doctorIdsAndOrganId.setIsDefault(Integer.valueOf(1));
        doctorIdsAndOrganId.setStatus(Integer.valueOf(1));
        List doctorInfoList = this.docDoctorWorkplacesInfoMapper.getDoctorIdAndDeptIdByDoctorIdsAndOrganId(doctorIdsAndOrganId);
        JSKFServiceBo jskfServiceBo = (JSKFServiceBo)JSON.parseObject((String)serviceSetParam.getServiceInfo(), JSKFServiceBo.class);
        OutPatientServiceSyncParamDTO outPatientServiceSyncParamDTO = new OutPatientServiceSyncParamDTO();
        outPatientServiceSyncParamDTO.setDoctorInfo(doctorInfoList);
        outPatientServiceSyncParamDTO.setAppCode(serviceSetParam.getAppCode());
        outPatientServiceSyncParamDTO.setHospitalId(String.valueOf(serviceSetParam.getOrganId()));
        outPatientServiceSyncParamDTO.setServiceCode(serviceSetParam.getServiceCode());
        outPatientServiceSyncParamDTO.setServTime(jskfServiceBo.getEffectiveTime());
        outPatientServiceSyncParamDTO.setDailyLimit(Integer.valueOf(0));
        outPatientServiceSyncParamDTO.setNumLimit(Integer.valueOf(0));
        outPatientServiceSyncParamDTO.setOrderTime(Integer.valueOf(0));
        outPatientServiceSyncParamDTO.setStatus(serviceSetParam.getStatus());
        outPatientServiceSyncParamDTO.setTimeUnit(Integer.valueOf(Objects.isNull(jskfServiceBo.getServiceTimeUnit()) ? 2 : Integer.valueOf(jskfServiceBo.getServiceTimeUnit())));
        outPatientServiceSyncParamDTO.setOperationType(serviceSetParam.getOperationType());
        outPatientServiceSyncParamDTO.setPharmaceuticalIds(jskfServiceBo.getPharmaceuticalIds());
        log.info("\u8c03\u7528\u6025\u901f\u5f00\u65b9\u670d\u52a1\u8bbe\u7f6e\u670d\u52a1\u914d\u7f6e\u5165\u53c2:[{}]", (Object)JSON.toJSONString((Object)outPatientServiceSyncParamDTO));
        BaseResponse baseResponse = HttpClientUtil.doJsonPost((Object)outPatientServiceSyncParamDTO, (String)(this.NodeDomainName + serviceSetParam.getAppCode() + "/netinquiry/serviceconfig/saveConfigInfoListNew"));
        log.info("\u8c03\u7528\u6025\u901f\u5f00\u65b9\u670d\u52a1\u8bbe\u7f6e\u670d\u52a1\u914d\u7f6e\u8fd4\u56de:[{}]", (Object)JSON.toJSONString((Object)baseResponse));
        if (!baseResponse.isSuccess()) {
            throw new RuntimeException("\u540c\u6b65\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    public void synchroniseInsert(DocServiceSetParam serviceSetParam, List<Long> doctorWorkInfoIds) {
        serviceSetParam.setOperationType(Integer.valueOf(1));
        this.executeSynchronise(serviceSetParam, doctorWorkInfoIds);
    }

    public void synchroniseUpdate(DocServiceSetParam serviceSetParam, List<Long> doctorWorkInfoIds) {
        serviceSetParam.setOperationType(Integer.valueOf(2));
        this.executeSynchronise(serviceSetParam, doctorWorkInfoIds);
    }

    public String parseAndCheckServiceConfig(String serviceConfig) {
        JSKFServiceBo jskfServiceBo = (JSKFServiceBo)JSON.parseObject((String)serviceConfig, JSKFServiceBo.class);
        if (Objects.isNull(jskfServiceBo)) {
            return ServiceCodeEnum.JSKF.getServiceConfig();
        }
        return JSON.toJSONString((Object)jskfServiceBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
    }

    public ValidateResult parseAndCheckServiceConfigRetValiadte(String serviceConfig) {
        JSKFServiceBo jskfServiceBo = (JSKFServiceBo)JSON.parseObject((String)serviceConfig, JSKFServiceBo.class);
        if (Objects.isNull(jskfServiceBo)) {
            return new ValidateResult("\u670d\u52a1\u914d\u7f6e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", false);
        }
        return ValidPropertyUtil.validate((Object)jskfServiceBo);
    }
}

