/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.doctor.basedata.api.bo.doc_service.JKGLServiceBo;
import com.doctor.basedata.api.utils.ValidateResult;
import com.doctor.basedata.api.vo.BusinessDoctorListReqVo;
import com.doctor.basedata.api.vo.BusinessDoctorPageReqVo;
import com.doctor.basedata.api.vo.DepartmentStandardVo;
import com.doctor.basedata.api.vo.DoctorBasicRespVO;
import com.doctor.basedata.api.vo.DoctorBusinessListReqVo;
import com.doctor.basedata.api.vo.ServiceCheckReqVo;
import com.doctoruser.api.pojo.base.entity.BaseEntity;
import com.doctoruser.api.pojo.base.entity.DepartmentEntity;
import com.doctoruser.api.pojo.base.entity.OrganWorkingServiceEntity;
import com.doctoruser.api.pojo.base.vo.doctor.DoctorBasicInfoVo;
import com.doctoruser.api.pojo.base.vo.doctor.WorkServiceInfoVo;
import com.doctoruser.doctor.enums.DoctorTypeEnum;
import com.doctoruser.doctor.enums.EHErrorEnum;
import com.doctoruser.doctor.enums.ServiceCodeEnum;
import com.doctoruser.doctor.factory.DocServiceFactory;
import com.doctoruser.doctor.handler.DocServiceHandler;
import com.doctoruser.doctor.mapper.DepartmentMapper;
import com.doctoruser.doctor.mapper.DepartmentStandardMapper;
import com.doctoruser.doctor.mapper.DictionaryMapper;
import com.doctoruser.doctor.mapper.DocDoctorServiceAccessMapper;
import com.doctoruser.doctor.mapper.DocDoctorWorkingServiceMapper;
import com.doctoruser.doctor.mapper.DocDoctorWorkplacesInfoMapper;
import com.doctoruser.doctor.mapper.DocDoctorWorkplacesMapper;
import com.doctoruser.doctor.mapper.DoctorMapper;
import com.doctoruser.doctor.mapper.DoctorWorkInfoMapper;
import com.doctoruser.doctor.mapper.DoctorWorkplacesMapper;
import com.doctoruser.doctor.mapper.OrganWorkingServiceMapper;
import com.doctoruser.doctor.mapper.OrganizationMapper;
import com.doctoruser.doctor.pojo.dto.ServiceAuthStatusDTO;
import com.doctoruser.doctor.pojo.entity.DictionaryEntity;
import com.doctoruser.doctor.pojo.entity.DocDoctorServiceAccessEntity;
import com.doctoruser.doctor.pojo.entity.DocDoctorWorkingServiceEntity;
import com.doctoruser.doctor.pojo.entity.DocDoctorWorkplacesEntity;
import com.doctoruser.doctor.pojo.entity.DocDoctorWorkplacesInfo;
import com.doctoruser.doctor.pojo.entity.DocServiceStatusParam;
import com.doctoruser.doctor.pojo.entity.DoctorInfoEntity;
import com.doctoruser.doctor.pojo.entity.DoctorWorkEntity;
import com.doctoruser.doctor.pojo.entity.DoctorWorkInfoEntity;
import com.doctoruser.doctor.pojo.entity.OrganizationEntity;
import com.doctoruser.doctor.pojo.vo.BatchSetDocServiceReqVO;
import com.doctoruser.doctor.pojo.vo.BatchSetDoctorServiceInfoReq;
import com.doctoruser.doctor.pojo.vo.DocServiceSetParam;
import com.doctoruser.doctor.pojo.vo.DocWorkServiceVo;
import com.doctoruser.doctor.pojo.vo.DoctorServiceReq;
import com.doctoruser.doctor.pojo.vo.DoctorWorkInfoVo;
import com.doctoruser.doctor.pojo.vo.EnterGroupVO;
import com.doctoruser.doctor.pojo.vo.ServiceConfigRes;
import com.doctoruser.doctor.pojo.vo.ServiceSwitchReq;
import com.doctoruser.doctor.service.DoctorWorkInfoService;
import com.doctoruser.doctor.service.DoctorWorkService;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class DoctorWorkInfoServiceImpl
implements DoctorWorkInfoService {
    private static final Logger log = LoggerFactory.getLogger(DoctorWorkInfoServiceImpl.class);
    @Autowired
    private DoctorWorkInfoMapper doctorWorkInfoMapper;
    @Autowired
    private DoctorWorkplacesMapper doctorWorkplacesMapper;
    @Autowired
    private DoctorMapper doctorMapper;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private DocDoctorWorkplacesInfoMapper docDoctorWorkplacesInfoMapper;
    @Autowired
    private DoctorWorkService doctorWorkService;
    @Autowired
    private OrganWorkingServiceMapper organWorkingServiceMapper;
    @Autowired
    private DocDoctorServiceAccessMapper docDoctorServiceAccessMapper;
    @Autowired
    private DocDoctorWorkingServiceMapper docDoctorWorkServiceMapper;
    @Autowired
    private DepartmentMapper departmentMapper;
    @Autowired
    private DocServiceFactory docServiceFactory;
    @Autowired
    private DictionaryMapper dictionaryMapper;
    @Autowired
    private DepartmentStandardMapper departmentStandardMapper;
    @Autowired
    private DocDoctorWorkplacesMapper docDoctorWorkplacesMapper;
    private static final String DOCTOR_MESSAGE = "\u533b\u751f\u7684\u6267\u4e1a\u4fe1\u606f\uff1a{}";

    public DoctorWorkInfoVo getDoctorWorkInfo(Long doctorWorkId, Long deptId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"doctor_workplaces", (Object)doctorWorkId);
        queryWrapper.eq((Object)"dept_id", (Object)deptId);
        queryWrapper.eq((Object)"status", (Object)1);
        DoctorWorkInfoEntity doctorWorkInfoEntity = (DoctorWorkInfoEntity)this.doctorWorkInfoMapper.selectOne((Wrapper)queryWrapper);
        log.info("\u67e5\u8be2\u533b\u751f\u804c\u4e1a\u70b9\u4fe1\u606f\u6570\u636e:{}", (Object)JSON.toJSONString((Object)doctorWorkInfoEntity));
        DoctorWorkInfoVo doctorWorkInfoVo = null;
        if (Objects.nonNull(doctorWorkInfoEntity)) {
            doctorWorkInfoVo = new DoctorWorkInfoVo();
            BeanUtils.copyProperties((Object)doctorWorkInfoEntity, (Object)doctorWorkInfoVo);
            DoctorWorkEntity doctorWorkEntity = (DoctorWorkEntity)this.doctorWorkplacesMapper.selectById((Serializable)doctorWorkInfoEntity.getDoctorWorkId());
            log.info("\u67e5\u8be2\u533b\u751f\u804c\u4e1a\u70b9\u6570\u636e:{}", (Object)JSON.toJSONString((Object)doctorWorkEntity));
            if (Objects.nonNull(doctorWorkEntity)) {
                DoctorInfoEntity doctorInfoEntity = (DoctorInfoEntity)this.doctorMapper.selectById((Serializable)doctorWorkEntity.getDoctorId());
                log.info("\u67e5\u8be2\u533b\u751f\u57fa\u672c\u4fe1\u606f\u6570\u636e:{}", (Object)JSON.toJSONString((Object)doctorInfoEntity));
                OrganizationEntity organization = (OrganizationEntity)this.organizationMapper.selectById((Serializable)doctorWorkEntity.getOrganId());
                log.info("\u67e5\u8be2\u533b\u9662\u57fa\u672c\u4fe1\u606f\u6570\u636e:{}", (Object)JSON.toJSONString((Object)organization));
                doctorWorkInfoVo.setOrganId(doctorWorkEntity.getOrganId());
                doctorWorkInfoVo.setDoctorId(doctorWorkEntity.getDoctorId());
                if (Objects.nonNull(doctorInfoEntity)) {
                    doctorWorkInfoVo.setDoctorName(doctorInfoEntity.getName());
                    doctorWorkInfoVo.setProfession(doctorInfoEntity.getProfession());
                    doctorWorkInfoVo.setProfessionCode(doctorInfoEntity.getProfessionCode());
                }
                doctorWorkInfoVo.setOrganName(Objects.nonNull(organization) ? organization.getOrganName() : "");
            }
        }
        return doctorWorkInfoVo;
    }

    public DoctorWorkInfoVo getDoctorWorkInfo(Long organId, Long doctorId, Long deptId) {
        DoctorWorkEntity doctorWorkEntity = this.doctorWorkService.getDoctorWork(organId, doctorId);
        DoctorWorkInfoVo doctorWorkInfoVo = null;
        if (Objects.nonNull(doctorWorkEntity)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"doctor_workplaces", (Object)doctorWorkEntity.getDoctorWorkId());
            queryWrapper.eq((Object)"dept_id", (Object)deptId);
            queryWrapper.eq((Object)"status", (Object)1);
            DoctorWorkInfoEntity doctorWorkInfoEntity = (DoctorWorkInfoEntity)this.doctorWorkInfoMapper.selectOne((Wrapper)queryWrapper);
            log.info("\u67e5\u8be2\u533b\u751f\u804c\u4e1a\u70b9\u4fe1\u606f\u6570\u636e:{}", (Object)JSON.toJSONString((Object)doctorWorkInfoEntity));
            if (Objects.nonNull(doctorWorkInfoEntity)) {
                doctorWorkInfoVo = new DoctorWorkInfoVo();
                BeanUtils.copyProperties((Object)doctorWorkInfoEntity, (Object)doctorWorkInfoVo);
                DoctorInfoEntity doctorInfoEntity = (DoctorInfoEntity)this.doctorMapper.selectById((Serializable)doctorWorkEntity.getDoctorId());
                log.info("\u67e5\u8be2\u533b\u751f\u57fa\u672c\u4fe1\u606f\u6570\u636e:{}", (Object)JSON.toJSONString((Object)doctorInfoEntity));
                OrganizationEntity organization = (OrganizationEntity)this.organizationMapper.selectById((Serializable)doctorWorkEntity.getOrganId());
                log.info("\u67e5\u8be2\u533b\u9662\u57fa\u672c\u4fe1\u606f\u6570\u636e:{}", (Object)JSON.toJSONString((Object)organization));
                doctorWorkInfoVo.setOrganId(doctorWorkEntity.getOrganId());
                doctorWorkInfoVo.setDoctorId(doctorWorkEntity.getDoctorId());
                if (Objects.nonNull(doctorInfoEntity)) {
                    doctorWorkInfoVo.setDoctorName(doctorInfoEntity.getName());
                    doctorWorkInfoVo.setProfession(doctorInfoEntity.getProfession());
                    doctorWorkInfoVo.setProfessionCode(doctorInfoEntity.getProfessionCode());
                }
                doctorWorkInfoVo.setOrganName(Objects.nonNull(organization) ? organization.getOrganName() : "");
                return doctorWorkInfoVo;
            }
            return doctorWorkInfoVo;
        }
        return doctorWorkInfoVo;
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public BaseResponse<Object> openManageDoctorService(ServiceSwitchReq serviceSwitchReq) {
        log.info("\u7ba1\u7406\u7aef\u5f00\u901a\u670d\u52a1\u7684\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)serviceSwitchReq));
        OrganWorkingServiceEntity organWorkingServiceEntity = this.organWorkingServiceMapper.getServiceByOrganId(serviceSwitchReq.getOrganId(), serviceSwitchReq.getServiceCode(), String.valueOf(1));
        if (Objects.isNull(organWorkingServiceEntity)) {
            return BaseResponse.error((String)"\u65e0\u8be5\u533b\u9662\u7684\u670d\u52a1\u4fe1\u606f\uff0c\u8bf7\u5148\u5f00\u901a\u533b\u9662\u670d\u52a1");
        }
        log.info("\u8be5\u533b\u9662\u7684\u670d\u52a1\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)organWorkingServiceEntity));
        DoctorWorkEntity doctorWorkEntity = this.doctorWorkService.getDoctorWork(serviceSwitchReq.getOrganId(), serviceSwitchReq.getDoctorId());
        log.info("\u8be5\u533b\u751f\u6267\u4e1a\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)doctorWorkEntity));
        if (Objects.isNull(doctorWorkEntity)) {
            return BaseResponse.error((String)"\u533b\u751f\u6267\u4e1a\u4fe1\u606f\u4e0d\u5b58\u5728,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406");
        }
        if (!this.checkServiceWithExpert(serviceSwitchReq)) {
            return BaseResponse.error((IError)EHErrorEnum.SERVICE_WITH_WRONG_LEVEL);
        }
        List docWorkInfoIds = this.filterOperateDocDept(serviceSwitchReq, doctorWorkEntity);
        if (docWorkInfoIds.size() != serviceSwitchReq.getDeptId().size()) {
            return BaseResponse.error((String)"\u5f00\u901a\u670d\u52a1\u7684\u79d1\u5ba4\u4fe1\u606f\u6709\u8bef,\u8bf7\u6838\u5bf9\u540e\u518d\u6b21\u64cd\u4f5c");
        }
        this.updateDoctorManageAuth(serviceSwitchReq.getStatus(), organWorkingServiceEntity.getxId(), doctorWorkEntity.getDoctorWorkId());
        this.updateDoctorWorkService(serviceSwitchReq, organWorkingServiceEntity.getxId(), doctorWorkEntity.getDoctorWorkId(), docWorkInfoIds);
        return BaseResponse.success();
    }

    private boolean checkServiceWithExpert(ServiceSwitchReq serviceSwitchReq) {
        String serviceCode = serviceSwitchReq.getServiceCode();
        if (1 == serviceSwitchReq.getStatus() && (ServiceCodeEnum.YCSPHZ.getServiceCode().equals(serviceCode) || ServiceCodeEnum.YCTWHZ.getServiceCode().equals(serviceCode))) {
            DoctorInfoEntity doctorInfoEntity = (DoctorInfoEntity)this.doctorMapper.selectById((Serializable)serviceSwitchReq.getDoctorId());
            return doctorInfoEntity.getDoctorType().intValue() == DoctorTypeEnum.EXPERT_DOCTOR.getTypeCode();
        }
        return Boolean.TRUE;
    }

    private void updateDoctorManageAuth(int status, String workingServiceId, Long doctorWorkId) {
        DocDoctorServiceAccessEntity serviceAccess = this.docDoctorServiceAccessMapper.getByWorkIdAndServiceId(String.valueOf(doctorWorkId), String.valueOf(workingServiceId));
        log.info("\u67e5\u8be2\u533b\u751f\u670d\u52a1\u64cd\u4f5c\u6743\u9650\u7ed3\u679c{}", (Object)JSON.toJSONString((Object)serviceAccess));
        if (null == serviceAccess) {
            DocDoctorServiceAccessEntity docDoctorServiceAccessEntity = new DocDoctorServiceAccessEntity();
            docDoctorServiceAccessEntity.setWorkingService(Long.valueOf(workingServiceId));
            docDoctorServiceAccessEntity.setxCreateTime(new Date());
            docDoctorServiceAccessEntity.setxUpdateTime(new Date());
            docDoctorServiceAccessEntity.setDoctorWorkId(doctorWorkId);
            docDoctorServiceAccessEntity.setStatus(Integer.valueOf(status));
            this.docDoctorServiceAccessMapper.insertSelective(docDoctorServiceAccessEntity);
            log.info("\u65b0\u63d2\u5165\u7684\u6743\u9650\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)docDoctorServiceAccessEntity));
        } else {
            serviceAccess.setStatus(Integer.valueOf(status));
            serviceAccess.setxUpdateTime(new Date());
            log.info("\u66f4\u65b0\u6570\u636e\u6743\u9650\u6570\u636e\u4e3a:{}", (Object)JSON.toJSONString((Object)serviceAccess));
            this.docDoctorServiceAccessMapper.updateByPrimaryKeySelective(serviceAccess);
        }
    }

    private void updateDoctorWorkService(ServiceSwitchReq serviceSwitchReq, String workingServiceId, Long doctorWorkId, List<Long> docWorkInfoIds) {
        log.info("\u8bbe\u7f6e\u533b\u751f\u670d\u52a1\u4fe1\u606f\u5165\u53c2\uff1a{},\u533b\u9662\u670d\u52a1\u4fe1\u606fid\uff1a{},\u533b\u751f\u5750\u8bca\u70b9\u4fe1\u606fid\uff1a{}", new Object[]{JSON.toJSONString((Object)serviceSwitchReq), workingServiceId, docWorkInfoIds});
        List docSingletonServiceList = this.docDoctorWorkServiceMapper.getByDoctorWorkIdAndServiceCode(Collections.singletonList(doctorWorkId), serviceSwitchReq.getServiceCode(), "1,-1");
        log.info("\u67e5\u8be2\u533b\u751f\u5355\u4e2a\u670d\u52a1\u7684\u914d\u7f6e\u96c6\u5408\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)docSingletonServiceList));
        List invalidDataIds = docSingletonServiceList.stream().filter(item -> !docWorkInfoIds.contains(item.getDoctorWorkInfoId())).map(DocDoctorWorkingServiceEntity::getxId).collect(Collectors.toList());
        log.info("\u8fc7\u6ee4\u51fa\u5931\u6548\u7684\u670d\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3b\u952e\u96c6\u5408:{}", (Object)JSON.toJSONString(invalidDataIds));
        List updateSingletonServiceList = docSingletonServiceList.stream().filter(item -> docWorkInfoIds.contains(item.getDoctorWorkInfoId())).collect(Collectors.toList());
        log.info("\u8fc7\u6ee4\u51fa\u66f4\u65b0\u64cd\u4f5c\u670d\u52a1\u914d\u7f6e\u4fe1\u606f\u96c6\u5408:{}", (Object)JSON.toJSONString(updateSingletonServiceList));
        List updatedDataIds = updateSingletonServiceList.stream().map(DocDoctorWorkingServiceEntity::getxId).collect(Collectors.toList());
        log.info("\u53d6\u51fa\u66f4\u65b0\u670d\u52a1\u914d\u7f6e\u4fe1\u606f\u7684\u4e3b\u952e\u96c6\u5408:{}", (Object)JSON.toJSONString(updatedDataIds));
        List updateDocWorkIds = updateSingletonServiceList.stream().map(DocDoctorWorkingServiceEntity::getDoctorWorkInfoId).collect(Collectors.toList());
        log.info("\u53d6\u51fa\u66f4\u65b0\u64cd\u4f5c\u7684[\u804c\u4e1a\u4fe1\u606f]\u4e3b\u952e:{}", (Object)JSON.toJSONString(updateDocWorkIds));
        docWorkInfoIds.removeAll(updateDocWorkIds);
        log.info("\u5f97\u5230\u65b0\u589e\u64cd\u4f5c\u7684[\u804c\u4e1a\u4fe1\u606f]\u4e3b\u952e:{}", (Object)JSON.toJSONString(docWorkInfoIds));
        for (Long invalidDataId : invalidDataIds) {
            this.docDoctorWorkServiceMapper.deleteByPrimaryKey(invalidDataId);
        }
        for (Long updatedDataId : updatedDataIds) {
            DocDoctorWorkingServiceEntity docWorkingService = new DocDoctorWorkingServiceEntity();
            docWorkingService.setxRemark(serviceSwitchReq.getRemark());
            docWorkingService.setStatus(Integer.valueOf(serviceSwitchReq.getStatus()));
            docWorkingService.setConfig(serviceSwitchReq.getServiceConfig());
            docWorkingService.setxUpdateTime(new Date());
            docWorkingService.setxId(updatedDataId);
            log.info("\u66f4\u65b0\u533b\u751f\u670d\u52a1\u4fe1\u606f:{},", (Object)JSON.toJSONString((Object)docWorkingService));
            this.docDoctorWorkServiceMapper.updateByPrimaryKey(docWorkingService);
        }
        for (Long docWorkInfoId : docWorkInfoIds) {
            DocDoctorWorkingServiceEntity docWorkService = new DocDoctorWorkingServiceEntity();
            docWorkService.setWorkingService(Long.valueOf(workingServiceId));
            docWorkService.setxRemark(serviceSwitchReq.getRemark());
            docWorkService.setStatus(Integer.valueOf(serviceSwitchReq.getStatus()));
            docWorkService.setConfig(serviceSwitchReq.getServiceConfig());
            docWorkService.setServiceCode(serviceSwitchReq.getServiceCode());
            docWorkService.setDoctorWorkInfoId(docWorkInfoId);
            docWorkService.setDoctorWorkId(doctorWorkId);
            docWorkService.setxCreateTime(new Date());
            docWorkService.setxUpdateTime(new Date());
            log.info("\u6dfb\u52a0\u533b\u751f\u670d\u52a1\u4fe1\u606f:{},", (Object)JSON.toJSONString((Object)docWorkService));
            this.docDoctorWorkServiceMapper.insertSelect(docWorkService);
        }
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public BaseResponse openDoctorAppService(ServiceSwitchReq serviceSwitchReq) {
        DocDoctorServiceAccessEntity serviceAccess;
        log.info("\u7ba1\u7406\u7aef\u5f00\u901a\u670d\u52a1\u7684\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)serviceSwitchReq));
        OrganWorkingServiceEntity organWorkingServiceEntity = this.organWorkingServiceMapper.getServiceByOrganId(serviceSwitchReq.getOrganId(), serviceSwitchReq.getServiceCode(), String.valueOf(1));
        if (Objects.isNull(organWorkingServiceEntity)) {
            return BaseResponse.error((String)"\u65e0\u8be5\u533b\u9662\u7684\u670d\u52a1\u4fe1\u606f\uff0c\u8bf7\u5148\u5f00\u901a\u533b\u9662\u670d\u52a1");
        }
        log.info("\u8be5\u533b\u9662\u7684\u670d\u52a1\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)organWorkingServiceEntity));
        DoctorWorkEntity doctorWorkEntity = this.doctorWorkService.getDoctorWork(serviceSwitchReq.getOrganId(), serviceSwitchReq.getDoctorId());
        log.info("\u8be5\u533b\u751f\u7684\u6267\u4e1a\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)doctorWorkEntity));
        if (Objects.isNull(doctorWorkEntity)) {
            return BaseResponse.error((String)"\u533b\u751f\u6267\u4e1a\u4fe1\u606f\u4e0d\u5b58\u5728,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406");
        }
        if (serviceSwitchReq.getStatus() == 1 && (Objects.isNull(serviceAccess = this.docDoctorServiceAccessMapper.getByWorkIdAndServiceId(String.valueOf(doctorWorkEntity.getDoctorWorkId()), String.valueOf(organWorkingServiceEntity.getxId()))) || serviceAccess.getStatus() != 1)) {
            log.info("\u533b\u751f\u5f00\u901a\u670d\u52a1\u6570\u636e\u6743\u9650\u5173\u95ed\uff0c\u7ba1\u7406\u7aef\u5f00\u901a\u533b\u751f\u670d\u52a1\u6743\u9650");
            return BaseResponse.error((String)EHErrorEnum.OPEN_POWER_CLOSED.getMsg());
        }
        List docWorkInfoIds = this.filterOperateDocDept(serviceSwitchReq, doctorWorkEntity);
        if (docWorkInfoIds.size() != serviceSwitchReq.getDeptId().size()) {
            return BaseResponse.error((String)"\u5f00\u901a\u670d\u52a1\u7684\u79d1\u5ba4\u4fe1\u606f\u6709\u8bef,\u8bf7\u6838\u5bf9\u540e\u518d\u6b21\u64cd\u4f5c");
        }
        this.updateDoctorWorkService(serviceSwitchReq, organWorkingServiceEntity.getxId(), doctorWorkEntity.getDoctorWorkId(), docWorkInfoIds);
        return BaseResponse.success();
    }

    private List<Long> filterOperateDocDept(ServiceSwitchReq serviceSwitchReq, DoctorWorkEntity doctorWorkEntity) {
        List doctorWorkplacesInfoList = this.docDoctorWorkplacesInfoMapper.findByWorkInfoId(doctorWorkEntity.getDoctorWorkId());
        List deptParam = serviceSwitchReq.getDeptId().stream().distinct().collect(Collectors.toList());
        List filterDept = doctorWorkplacesInfoList.stream().filter(item -> deptParam.contains(item.getDeptId())).distinct().collect(Collectors.toList());
        return filterDept.stream().map(DocDoctorWorkplacesInfo::getXId).collect(Collectors.toList());
    }

    public BaseResponse<List<ServiceConfigRes>> getDocWorkInfoService(Long organId, Long doctorId) {
        log.info("\u83b7\u53d6\u533b\u9662\u670d\u52a1\u5217\u8868\u5165\u53c2\uff1aorganId={} doctorId={}", (Object)organId, (Object)doctorId);
        DoctorWorkEntity doctorWorkEntity = this.doctorWorkService.getDoctorWork(organId, doctorId);
        if (doctorWorkEntity == null) {
            return BaseResponse.error((String)"\u6ca1\u6709\u8be5\u533b\u751f\u7684\u6267\u4e1a\u4fe1\u606f");
        }
        log.info(DOCTOR_MESSAGE, (Object)JSON.toJSONString((Object)doctorWorkEntity));
        List workPlaceServiceList = this.organWorkingServiceMapper.getWorkPlaceService(organId, 1);
        if (workPlaceServiceList.isEmpty()) {
            return BaseResponse.error((String)"\u8be5\u533b\u9662\u4e3a\u5f00\u901a\u4efb\u4f55\u670d\u52a1,\u8bf7\u5148\u53bb\u7ba1\u7406\u7aef\u5f00\u901a\u533b\u9662\u670d\u52a1");
        }
        log.info("\u533b\u9662\u7684\u670d\u52a1\u4fe1\u606f \uff1a{}", (Object)JSON.toJSONString((Object)workPlaceServiceList));
        List authStatusList = this.docDoctorServiceAccessMapper.getServiceAccessByWorkId(doctorWorkEntity.getDoctorWorkId(), 1);
        Map authStatusMap = authStatusList.stream().collect(Collectors.toMap(ServiceAuthStatusDTO::getServiceCode, Function.identity()));
        List serviceInfoList = this.docDoctorWorkServiceMapper.getServiceByWorkId(doctorWorkEntity.getDoctorWorkId());
        serviceInfoList.sort(Comparator.comparingInt(DocDoctorWorkingServiceEntity::getStatus).reversed());
        Map serviceInfoMap = serviceInfoList.stream().collect(Collectors.toMap(DocDoctorWorkingServiceEntity::getServiceCode, Function.identity(), (v1, v2) -> v1));
        log.info("\u533b\u751f\u5f00\u901a\u7684\u670d\u52a1\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(serviceInfoMap));
        ArrayList<ServiceConfigRes> serviceConfigResList = new ArrayList<ServiceConfigRes>();
        for (WorkServiceInfoVo workServiceInfoVo : workPlaceServiceList) {
            ServiceCodeEnum serviceCodeEnum = ServiceCodeEnum.getByServiceCode((String)workServiceInfoVo.getServiceCode());
            if (serviceCodeEnum == null) continue;
            DocServiceHandler docServiceHandler = this.docServiceFactory.getDocServiceHandler(workServiceInfoVo.getServiceCode());
            ServiceAuthStatusDTO serviceAuthStatusDTO = (ServiceAuthStatusDTO)authStatusMap.get(workServiceInfoVo.getServiceCode());
            DocDoctorWorkingServiceEntity docDoctorWorkingService = (DocDoctorWorkingServiceEntity)serviceInfoMap.get(workServiceInfoVo.getServiceCode());
            if (docDoctorWorkingService != null) {
                ServiceConfigRes serviceConfigRes = new ServiceConfigRes();
                BeanUtils.copyProperties((Object)serviceAuthStatusDTO, (Object)serviceConfigRes);
                String serviceConfig = docServiceHandler.parseAndCheckServiceConfig(docDoctorWorkingService.getConfig());
                serviceConfigRes.setServiceConfig(serviceConfig);
                serviceConfigRes.setStatus(docDoctorWorkingService.getStatus());
                serviceConfigResList.add(serviceConfigRes);
                log.info("\u6dfb\u52a0\u5df2\u5f00\u901a\u670d\u52a1\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)serviceConfigRes));
                continue;
            }
            ServiceConfigRes configRes = new ServiceConfigRes();
            configRes.setServiceCode(workServiceInfoVo.getServiceCode());
            configRes.setServiceName(workServiceInfoVo.getServiceName());
            configRes.setServiceConfig(serviceCodeEnum.getServiceConfig());
            configRes.setStatus(Integer.valueOf(-1));
            configRes.setAuthStatus(Integer.valueOf(-1));
            serviceConfigResList.add(configRes);
            log.info("\u6dfb\u52a0\u672a\u5f00\u901a\u670d\u52a1\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)configRes));
        }
        log.info("\u533b\u9662\u670d\u52a1\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(serviceConfigResList));
        return BaseResponse.success(serviceConfigResList);
    }

    public BaseResponse<List<DocDoctorWorkplacesInfo>> getDoctorWorkInfoList(DoctorServiceReq req) {
        log.info("\u67e5\u8be2\u533b\u751f\u6267\u4e1a\u4fe1\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)req));
        LambdaQueryWrapper doctorWorkQuery = new LambdaQueryWrapper();
        doctorWorkQuery.eq(DoctorWorkEntity::getDoctorId, (Object)req.getDoctorId());
        doctorWorkQuery.eq(DoctorWorkEntity::getOrganId, (Object)req.getOrganId());
        doctorWorkQuery.eq(DoctorWorkEntity::getStatus, (Object)1);
        DoctorWorkEntity doctorWork = (DoctorWorkEntity)this.doctorWorkplacesMapper.selectOne((Wrapper)doctorWorkQuery);
        log.info(DOCTOR_MESSAGE, (Object)JSON.toJSONString((Object)doctorWork));
        if (null == doctorWork) {
            return BaseResponse.error((String)"\u65e0\u8be5\u533b\u751f\u7684\u6267\u4e1a\u4fe1\u606f");
        }
        Long workPlaceId = doctorWork.getDoctorWorkId();
        boolean serviceIsOpen = this.docServiceIsOpen(req.getServiceCode(), workPlaceId);
        List serviceRecord = serviceIsOpen ? this.docDoctorWorkServiceMapper.getByDoctorWorkIdAndServiceCode(Collections.singletonList(workPlaceId), req.getServiceCode(), String.valueOf(1)) : this.docDoctorWorkServiceMapper.getByDoctorWorkIdAndServiceCode(Collections.singletonList(workPlaceId), req.getServiceCode(), "1,-1");
        Set openServiceWorkInfoIds = serviceRecord.stream().distinct().map(DocDoctorWorkingServiceEntity::getDoctorWorkInfoId).collect(Collectors.toSet());
        List docDoctorWorkplacesInfoList = this.docDoctorWorkplacesInfoMapper.findByWorkInfoId(workPlaceId);
        docDoctorWorkplacesInfoList = docDoctorWorkplacesInfoList.stream().distinct().collect(Collectors.toList());
        for (DocDoctorWorkplacesInfo docDoctorWorkplacesInfo : docDoctorWorkplacesInfoList) {
            if (!openServiceWorkInfoIds.contains(docDoctorWorkplacesInfo.getXId())) continue;
            docDoctorWorkplacesInfo.setServiceStatus(Integer.valueOf(1));
        }
        log.info("\u533b\u751f\u7684\u5750\u8bca\u79d1\u5ba4\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(docDoctorWorkplacesInfoList));
        return BaseResponse.success(docDoctorWorkplacesInfoList);
    }

    private boolean docServiceIsOpen(String serviceCode, Long workPlaceId) {
        List serviceOpenRecord = this.docDoctorWorkServiceMapper.getByDoctorWorkIdAndServiceCode(Collections.singletonList(workPlaceId), serviceCode, String.valueOf(1));
        return !serviceOpenRecord.isEmpty();
    }

    public BaseResponse<List<DocDoctorWorkplacesInfo>> getDocOpenServiceDeptList(DoctorServiceReq req) {
        log.info("\u67e5\u8be2\u533b\u751f\u6267\u4e1a\u4fe1\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)req));
        LambdaQueryWrapper doctorWorkQuery = new LambdaQueryWrapper();
        doctorWorkQuery.eq(DoctorWorkEntity::getDoctorId, (Object)req.getDoctorId());
        doctorWorkQuery.eq(DoctorWorkEntity::getStatus, (Object)1);
        doctorWorkQuery.eq(DoctorWorkEntity::getOrganId, (Object)req.getOrganId());
        DoctorWorkEntity doctorWork = (DoctorWorkEntity)this.doctorWorkplacesMapper.selectOne((Wrapper)doctorWorkQuery);
        log.info(DOCTOR_MESSAGE, (Object)JSON.toJSONString((Object)doctorWork));
        if (null == doctorWork) {
            return BaseResponse.error((String)"\u65e0\u8be5\u533b\u751f\u7684\u6267\u4e1a\u4fe1\u606f");
        }
        Long workPlaceId = doctorWork.getDoctorWorkId();
        List docDoctorWorkplacesInfoList = this.docDoctorWorkplacesInfoMapper.findByWorkInfoId(workPlaceId);
        List openServiceRecord = this.docDoctorWorkServiceMapper.getByDoctorWorkIdAndServiceCode(Collections.singletonList(workPlaceId), req.getServiceCode(), String.valueOf(1));
        Set openServiceWorkInfoIds = openServiceRecord.stream().distinct().map(DocDoctorWorkingServiceEntity::getDoctorWorkInfoId).collect(Collectors.toSet());
        docDoctorWorkplacesInfoList = docDoctorWorkplacesInfoList.stream().distinct().filter(info -> openServiceWorkInfoIds.contains(info.getXId())).peek(item -> item.setServiceStatus(Integer.valueOf(1))).collect(Collectors.toList());
        log.info("\u533b\u751f\u7684\u5750\u8bca\u79d1\u5ba4\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(docDoctorWorkplacesInfoList));
        return BaseResponse.success(docDoctorWorkplacesInfoList);
    }

    public BaseResponse<Boolean> checkDoctorServiceByCode(ServiceCheckReqVo serviceCheckReqVo) {
        DoctorWorkEntity doctorWork = this.doctorWorkService.getDoctorWork(serviceCheckReqVo.getOrganId(), serviceCheckReqVo.getDoctorId());
        if (Objects.isNull(doctorWork)) {
            return BaseResponse.success((Object)false);
        }
        DocDoctorWorkplacesInfo doctorWorkInfo = this.docDoctorWorkplacesInfoMapper.getByWorkPlacesIdAndDeptId(doctorWork.getDoctorWorkId(), serviceCheckReqVo.getDeptId());
        if (Objects.isNull(doctorWorkInfo)) {
            return BaseResponse.success((Object)false);
        }
        DocDoctorWorkingServiceEntity serviceInfo = this.docDoctorWorkServiceMapper.getByWorkInfoAndServiceCode(doctorWorkInfo.getXId(), serviceCheckReqVo.getServiceCode());
        if (Objects.nonNull(serviceInfo) && serviceInfo.getStatus().equals(1)) {
            return BaseResponse.success((Object)true);
        }
        return BaseResponse.success((Object)false);
    }

    public BaseResponse<PageResult<DoctorBasicRespVO>> getBusinessDoctorPage(BusinessDoctorPageReqVo reqVo) {
        reqVo.setStatus(1);
        BusinessDoctorListReqVo listReqVo = new BusinessDoctorListReqVo();
        BeanUtils.copyProperties((Object)reqVo, (Object)listReqVo);
        PageHelper.startPage((int)reqVo.getPageNum(), (int)reqVo.getPageSize());
        Page page = (Page)this.docDoctorWorkplacesInfoMapper.getBusinessDoctorList(listReqVo);
        this.paddingDeptAndOrganInfo(page.getResult());
        PageResult pageResult = new PageResult(reqVo.getPageNum(), reqVo.getPageSize());
        pageResult.setContent(page.getResult());
        pageResult.setTotal((int)page.getTotal());
        return BaseResponse.success((Object)pageResult);
    }

    public BaseResponse<List<DoctorBasicRespVO>> getBusinessDoctorList(BusinessDoctorListReqVo reqVo) {
        reqVo.setStatus(1);
        List businessDoctorList = this.docDoctorWorkplacesInfoMapper.getBusinessDoctorList(reqVo);
        this.paddingDeptAndOrganInfo(businessDoctorList);
        return BaseResponse.success((Object)businessDoctorList);
    }

    public BaseResponse<PageResult<DoctorBasicRespVO>> getBusinessDoctorBaseInfoPage(BusinessDoctorPageReqVo reqVo) {
        PageHelper.startPage((int)reqVo.getPageNum(), (int)reqVo.getPageSize());
        reqVo.setStatus(1);
        Page page = (Page)this.docDoctorWorkplacesInfoMapper.getBusinessDoctorBaseInfoList(reqVo);
        this.paddingDeptAndOrganInfo(page.getResult());
        PageResult pageResult = new PageResult(reqVo.getPageNum(), reqVo.getPageSize());
        pageResult.setContent(page.getResult());
        pageResult.setTotal((int)page.getTotal());
        return BaseResponse.success((Object)pageResult);
    }

    private void paddingDeptAndOrganInfo(List<DoctorBasicRespVO> list) {
        String deptIdStr = list.stream().map(item -> String.valueOf(item.getDeptId())).collect(Collectors.joining(","));
        List organIds = list.stream().map(DoctorBasicInfoVo::getOrganId).distinct().collect(Collectors.toList());
        Map organizationMap = new HashMap();
        if (!organIds.isEmpty()) {
            organizationMap = this.organizationMapper.getOrgansByIds(organIds);
        }
        Map doctorTitleMap = this.dictionaryMapper.findByTypeCode("100").stream().collect(Collectors.toMap(DictionaryEntity::getDicCode, Function.identity()));
        ArrayList stdFirstDept = this.departmentStandardMapper.queryAllStandardDept();
        Map stdFirstDeptMap = stdFirstDept.stream().distinct().collect(Collectors.toMap(DepartmentStandardVo::getStandard, Function.identity()));
        Map<Object, Object> deptMap = new HashMap();
        if (StringUtils.isNotBlank((String)deptIdStr)) {
            List departmentEntities = this.departmentMapper.selectByDeptIds(deptIdStr);
            deptMap = departmentEntities.stream().collect(Collectors.toMap(BaseEntity::getxId, Function.identity()));
        }
        for (DoctorBasicRespVO doctorBasicInfo : list) {
            String stdTitleCode;
            DictionaryEntity dictionaryEntity;
            OrganizationEntity organizationEntity;
            DepartmentEntity departmentEntity = (DepartmentEntity)deptMap.get(String.valueOf(doctorBasicInfo.getDeptId()));
            if (Objects.nonNull(departmentEntity)) {
                doctorBasicInfo.setDeptEnglishName(departmentEntity.getEnglishName());
                doctorBasicInfo.setStdFirstDeptId(Long.valueOf(departmentEntity.getStdFirstDeptId().intValue()));
                DepartmentStandardVo stdDeptInfo = (DepartmentStandardVo)stdFirstDeptMap.get(departmentEntity.getStdFirstDeptId());
                doctorBasicInfo.setStdFirstDeptName(stdDeptInfo.getDeptName());
            }
            if (Objects.nonNull(organizationEntity = (OrganizationEntity)organizationMap.get(doctorBasicInfo.getOrganId().intValue()))) {
                doctorBasicInfo.setOrganName(organizationEntity.getOrganName());
            }
            if (!Objects.nonNull(dictionaryEntity = (DictionaryEntity)doctorTitleMap.get(stdTitleCode = doctorBasicInfo.getStdTitleCode()))) continue;
            doctorBasicInfo.setTitleEnglishName(dictionaryEntity.getRemark());
            doctorBasicInfo.setStandardTitle(dictionaryEntity.getDicName());
        }
    }

    public BaseResponse<List<DoctorBasicRespVO>> getBusinessByDocIdsAndServiceCode(DoctorBusinessListReqVo reqVo) {
        reqVo.setStatus(1);
        List businessDoctorList = new ArrayList();
        if (!reqVo.getDoctorIds().isEmpty()) {
            businessDoctorList = this.docDoctorWorkplacesInfoMapper.getBusinessByDocIdsAndServiceCode(reqVo);
        }
        this.paddingDeptAndOrganInfo(businessDoctorList);
        return BaseResponse.success(businessDoctorList);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse batchSetDocService(BatchSetDoctorServiceInfoReq batchSetDoctorServiceInfoReq) {
        if (-1 == batchSetDoctorServiceInfoReq.getStatus()) {
            return this.batchCloseDocService(batchSetDoctorServiceInfoReq.getDoctorWorkIds(), batchSetDoctorServiceInfoReq);
        }
        DocServiceHandler docServiceHandler = this.docServiceFactory.getDocServiceHandler(batchSetDoctorServiceInfoReq.getServiceCode());
        ValidateResult validateResult = docServiceHandler.parseAndCheckServiceConfigRetValiadte(batchSetDoctorServiceInfoReq.getServiceConfig());
        if (!validateResult.isSuccess()) {
            return BaseResponse.error((String)validateResult.getMessage());
        }
        DocServiceSetParam docServiceSetParam = this.convertDoctorServiceSetParam(batchSetDoctorServiceInfoReq);
        log.info("\u6279\u91cf\u8bbe\u7f6e\u7684\u670d\u52a1\u9879:{}", (Object)JSON.toJSONString((Object)docServiceSetParam));
        List doctorWorkServiceList = this.docDoctorWorkServiceMapper.getByDoctorWorkIdAndServiceCode(batchSetDoctorServiceInfoReq.getDoctorWorkIds(), docServiceSetParam.getServiceCode(), "1,-1");
        List doctorWorkIds = doctorWorkServiceList.stream().map(DocDoctorWorkingServiceEntity::getDoctorWorkId).collect(Collectors.toList());
        log.info("\u9700\u8981\u66f4\u65b0\u8bb0\u5f55\u7684\u533b\u751f\u804c\u4e1aid\u96c6\u5408:{}", (Object)JSON.toJSONString(doctorWorkIds));
        List insertServiceWorkIds = batchSetDoctorServiceInfoReq.getDoctorWorkIds().stream().filter(workId -> !doctorWorkIds.contains(workId)).collect(Collectors.toList());
        log.info("\u9700\u8981\u65b0\u589e\u8bb0\u5f55\u7684\u533b\u751f\u804c\u4e1aid\u96c6\u5408:{}", (Object)JSON.toJSONString(insertServiceWorkIds));
        if (!insertServiceWorkIds.isEmpty()) {
            this.docDoctorServiceAccessMapper.batchInsertSelective(insertServiceWorkIds, docServiceSetParam);
            List insertDoctorWork = this.docDoctorWorkplacesMapper.selectByIds(insertServiceWorkIds);
            List insertDataDoctorId = insertDoctorWork.stream().map(DocDoctorWorkplacesEntity::getDoctorId).collect(Collectors.toList());
            log.info("\u9700\u8981\u65b0\u589e\u8bb0\u5f55\u7684\u533b\u751fid\u96c6\u5408:{}", (Object)JSON.toJSONString(insertDataDoctorId));
            docServiceHandler.synchroniseInsert(docServiceSetParam, insertDataDoctorId);
        }
        for (Long doctorWorkId : insertServiceWorkIds) {
            DocDoctorWorkplacesInfo byWorkInfoIdAndDefault = this.docDoctorWorkplacesInfoMapper.getByWorkInfoIdAndDefault(doctorWorkId, 1);
            if (Objects.isNull(byWorkInfoIdAndDefault)) continue;
            DocDoctorWorkingServiceEntity docDoctorWorkingServiceEntity = new DocDoctorWorkingServiceEntity();
            docDoctorWorkingServiceEntity.setConfig(docServiceSetParam.getServiceInfo());
            docDoctorWorkingServiceEntity.setDoctorWorkId(doctorWorkId);
            docDoctorWorkingServiceEntity.setServiceCode(docServiceSetParam.getServiceCode());
            docDoctorWorkingServiceEntity.setStatus(docServiceSetParam.getStatus());
            docDoctorWorkingServiceEntity.setWorkingService(docServiceSetParam.getOrganServiceId());
            docDoctorWorkingServiceEntity.setxCreateTime(new Date());
            docDoctorWorkingServiceEntity.setxRemark(docServiceSetParam.getRemark());
            docDoctorWorkingServiceEntity.setxUpdateTime(new Date());
            docDoctorWorkingServiceEntity.setDoctorWorkInfoId(byWorkInfoIdAndDefault.getXId());
            int insertService = this.docDoctorWorkServiceMapper.insertSelect(docDoctorWorkingServiceEntity);
            if (insertService != 0) continue;
            log.error("======\u533b\u751f\u6267\u4e1aid:{},\u6dfb\u52a0\u670d\u52a1:{},\u5931\u8d25======", (Object)doctorWorkId, (Object)docServiceSetParam.getServiceCode());
            throw new RuntimeException("\u6dfb\u52a0\u533b\u751f\u670d\u52a1\u4fe1\u606f\u5931\u8d25");
        }
        if (!doctorWorkIds.isEmpty()) {
            List existDoctorWork = this.docDoctorWorkplacesMapper.selectByIds(doctorWorkIds);
            List existDataDoctorId = existDoctorWork.stream().map(DocDoctorWorkplacesEntity::getDoctorId).collect(Collectors.toList());
            log.info("\u9700\u8981\u66f4\u65b0\u8bb0\u5f55\u7684\u533b\u751fid\u96c6\u5408:{}", (Object)JSON.toJSONString(existDataDoctorId));
            docServiceHandler.synchroniseUpdate(docServiceSetParam, existDataDoctorId);
            this.docDoctorWorkServiceMapper.batchUpdateConfigByDocWorkIds(doctorWorkIds, docServiceSetParam);
            this.docDoctorServiceAccessMapper.batchUpdateSelective(doctorWorkIds, docServiceSetParam);
        }
        return BaseResponse.success();
    }

    public BaseResponse<Boolean> checkDoctorService(Long doctorId, String serviceCode) {
        WorkServiceInfoVo workServiceInfoVo = this.docDoctorWorkServiceMapper.checkDoctorServiceByCode(doctorId, serviceCode, Integer.valueOf(1));
        if (Objects.nonNull(workServiceInfoVo)) {
            return BaseResponse.success((Object)true);
        }
        return BaseResponse.success((Object)false);
    }

    public BaseResponse<JKGLServiceBo> getEnterGroup(EnterGroupVO enterGroupVO) {
        DoctorWorkEntity doctorWorkEntity = this.doctorWorkService.getDoctorWork(enterGroupVO.getOrganId(), enterGroupVO.getDoctorId());
        if (Objects.isNull(doctorWorkEntity)) {
            return BaseResponse.success((Object)new JKGLServiceBo(new BigDecimal(0)));
        }
        List docSingletonServiceList = this.docDoctorWorkServiceMapper.getByDoctorWorkIdAndServiceCode(Collections.singletonList(doctorWorkEntity.getDoctorWorkId()), ServiceCodeEnum.JKGL.getServiceCode(), String.valueOf(1));
        if (CollectionUtils.isEmpty((Collection)docSingletonServiceList)) {
            return BaseResponse.success((Object)new JKGLServiceBo(new BigDecimal(0)));
        }
        String config = ((DocDoctorWorkingServiceEntity)docSingletonServiceList.get(0)).getConfig();
        JKGLServiceBo jkglServiceBo = (JKGLServiceBo)JSON.parseObject((String)config, JKGLServiceBo.class);
        return BaseResponse.success((Object)jkglServiceBo);
    }

    public BaseResponse batchCloseDocService(List<Long> doctorWorkIds, BatchSetDoctorServiceInfoReq batchSetDoctorServiceInfoReq) {
        DocServiceSetParam docServiceSetParam = this.convertDoctorServiceSetParam(batchSetDoctorServiceInfoReq);
        this.docDoctorWorkServiceMapper.updateStatusByDocWorkIds(doctorWorkIds, docServiceSetParam.getStatus(), docServiceSetParam.getOrganServiceId());
        this.docDoctorServiceAccessMapper.batchUpdateStatusByDocWorkIdsAndWorkService(doctorWorkIds, docServiceSetParam.getOrganServiceId(), docServiceSetParam.getStatus());
        return BaseResponse.success();
    }

    private DocServiceSetParam convertDoctorServiceSetParam(BatchSetDoctorServiceInfoReq batchSetDoctorServiceInfoReq) {
        DocServiceSetParam docServiceSetParam = new DocServiceSetParam();
        docServiceSetParam.setStatus(Integer.valueOf(batchSetDoctorServiceInfoReq.getStatus()));
        docServiceSetParam.setRemark(batchSetDoctorServiceInfoReq.getProperty());
        docServiceSetParam.setServiceCode(batchSetDoctorServiceInfoReq.getServiceCode());
        docServiceSetParam.setServiceInfo(batchSetDoctorServiceInfoReq.getServiceConfig());
        docServiceSetParam.setAppCode(batchSetDoctorServiceInfoReq.getAppCode());
        docServiceSetParam.setOrganId(batchSetDoctorServiceInfoReq.getOrganId());
        OrganWorkingServiceEntity organWorkingServiceEntity = this.organWorkingServiceMapper.getServiceByOrganId(batchSetDoctorServiceInfoReq.getOrganId(), batchSetDoctorServiceInfoReq.getServiceCode(), "1,-1");
        if (Objects.isNull(organWorkingServiceEntity)) {
            throw new RuntimeException("\u533b\u9662\u670d\u52a1\u6709\u8bef,\u8bf7\u6838\u5bf9\u540e\u64cd\u4f5c");
        }
        docServiceSetParam.setOrganServiceId(Long.valueOf(organWorkingServiceEntity.getxId()));
        log.info("\u8f6c\u6362\u670d\u52a1\u8bbe\u7f6e\u96c6\u5408,\u8f6c\u6362\u540e\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)docServiceSetParam));
        return docServiceSetParam;
    }

    public BaseResponse<List<DocWorkServiceVo>> getDocReExaminationServiceStatus(List<Long> doctorIds, Long organId) {
        if (doctorIds.isEmpty()) {
            return BaseResponse.success(new ArrayList());
        }
        DocServiceStatusParam param = new DocServiceStatusParam();
        param.setDoctorIds(doctorIds);
        param.setOrganId(organId);
        param.setServiceCode(ServiceCodeEnum.ZXFZ.getServiceCode());
        param.setStatus(Integer.valueOf(1));
        List list = this.docDoctorWorkplacesInfoMapper.getDocReExaminationServiceStatus(param);
        return BaseResponse.success((Object)list);
    }

    @Transactional(rollbackFor={Exception.class})
    public synchronized BaseResponse setDocReExaminationServiceInfo(BatchSetDocServiceReqVO reqVO) {
        OrganWorkingServiceEntity organService = this.organWorkingServiceMapper.getServiceByOrganId(reqVO.getOrganId(), reqVO.getServiceCode(), String.valueOf(1));
        log.info("\u533b\u9662\u670d\u52a1\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)organService));
        if (Objects.isNull(organService)) {
            return BaseResponse.error((IError)EHErrorEnum.DOC_SERVICE_NOT_OPEN);
        }
        DocServiceSetParam docServiceSetParam = this.prepareSetServiceParam(reqVO, organService);
        log.info("\u8bbe\u7f6e\u670d\u52a1\u53c2\u6570\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)docServiceSetParam));
        if (reqVO.isOpenServiceOperate()) {
            DocServiceHandler docServiceHandler = this.docServiceFactory.getDocServiceHandler(organService.getServCode());
            ValidateResult validateResult = docServiceHandler.parseAndCheckServiceConfigRetValiadte(reqVO.getServiceConfig());
            log.info("\u5f00\u901a\u670d\u52a1\u53c2\u6570\u6821\u9a8c\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)validateResult));
            if (!validateResult.isSuccess()) {
                return BaseResponse.error((String)validateResult.getMessage());
            }
            List workplacesInfoList = this.docDoctorWorkplacesInfoMapper.selectByIds(reqVO.getDoctorWorkIds());
            log.info("\u67e5\u8be2\u5230\u7684\u804c\u4e1a\u4fe1\u606f\u6570\u636e:{}", (Object)JSON.toJSONString((Object)workplacesInfoList));
            List workingServiceList = this.docDoctorWorkServiceMapper.getByWorkInfoIdsAndWorkService(reqVO.getDoctorWorkIds(), Long.valueOf(organService.getxId()));
            log.info("\u67e5\u8be2\u5230\u7684\u670d\u52a1\u4fe1\u606f\u8bb0\u5f55:{}", (Object)JSON.toJSONString((Object)workingServiceList));
            List doctorWorkInfoIds = workingServiceList.stream().map(DocDoctorWorkingServiceEntity::getDoctorWorkInfoId).collect(Collectors.toList());
            log.info("\u8f6c\u6362\u804c\u4e1a\u4fe1\u606fid\u7ed3\u679c:{}", (Object)JSON.toJSONString(doctorWorkInfoIds));
            log.info("\u5f00\u59cb\u66f4\u65b0\u5b58\u5728\u670d\u52a1\u8bb0\u5f55,\u5e76\u540c\u6b65\u5230\u4e1a\u52a1\u7aef...");
            this.updateDoctorWorkServiceAndSync(docServiceSetParam, docServiceHandler, doctorWorkInfoIds);
            log.info("\u5f00\u59cb\u66f4\u65b0\u5b58\u5728\u8bb0\u5f55\u6743\u9650...");
            this.updateServiceAccess(docServiceSetParam, workingServiceList);
            log.info("\u5f00\u59cb\u65b0\u589e\u4e0d\u5b58\u5728\u7684\u670d\u52a1\u53ca\u6743\u9650\u4fe1\u606f...");
            this.insertDoctorWorkServiceAndAccess(docServiceSetParam, docServiceHandler, workplacesInfoList, doctorWorkInfoIds);
            log.info("\u5f00\u59cb\u540c\u6b65\u533b\u751f\u5176\u4ed6\u5750\u8bca\u670d\u52a1\u914d\u7f6e...");
            this.syncNotSelectWorkInfoService(docServiceSetParam, docServiceHandler, workplacesInfoList, doctorWorkInfoIds);
        } else {
            log.info("\u5f00\u59cb\u5173\u95ed\u533b\u751f\u670d\u52a1,\u533b\u751f\u804c\u4e1a\u4fe1\u606fid:{}", (Object)reqVO.getDoctorWorkIds());
            this.closeDoctorServiceByIds(docServiceSetParam, reqVO.getDoctorWorkIds());
        }
        return BaseResponse.success();
    }

    private void closeDoctorServiceByIds(DocServiceSetParam docServiceSetParam, List<Long> doctorWorkIds) {
        docServiceSetParam.setStatus(Integer.valueOf(-1));
        if (!doctorWorkIds.isEmpty()) {
            log.info("\u5173\u95ed\u533b\u751f\u670d\u52a1\u4fe1\u606f,\u533b\u751f\u6267\u4e1a\u4fe1\u606fid:{},\u670d\u52a1\u53c2\u6570:{}", (Object)JSON.toJSONString(doctorWorkIds), (Object)JSON.toJSONString((Object)docServiceSetParam));
            this.docDoctorWorkServiceMapper.updateServiceByDocWorkInfoIds(doctorWorkIds, docServiceSetParam);
            log.info("\u5f00\u59cb\u5173\u95ed\u79d1\u5ba4\u5168\u90e8\u5173\u95ed\u7684\u670d\u52a1\u6743\u9650...");
            List workplacesInfoList = this.docDoctorWorkplacesInfoMapper.selectByIds(doctorWorkIds);
            log.info("\u67e5\u8be2\u5230\u7684\u6267\u4e1a\u4fe1\u606f\u6570\u636e:{}", (Object)JSON.toJSONString((Object)workplacesInfoList));
            List workplacesIds = workplacesInfoList.stream().map(DocDoctorWorkplacesInfo::getDoctorWorkplaces).distinct().collect(Collectors.toList());
            if (!workplacesIds.isEmpty()) {
                List docWorkServiceList = this.docDoctorWorkServiceMapper.getByDoctorWorkIdAndServiceCode(workplacesIds, docServiceSetParam.getServiceCode(), String.valueOf(1));
                if (docWorkServiceList.isEmpty()) {
                    log.info("\u5173\u95ed\u533b\u751f\u670d\u52a1\u6743\u9650=>\u533b\u751f\u804c\u4e1aid:{},\u533b\u9662\u670d\u52a1\u4fe1\u606fid:[{}]", (Object)JSON.toJSONString(workplacesIds), (Object)JSON.toJSONString((Object)docServiceSetParam.getOrganServiceId()));
                    this.docDoctorServiceAccessMapper.batchUpdateStatusByDocWorkIdsAndWorkService(workplacesIds, docServiceSetParam.getOrganServiceId(), Integer.valueOf(-1));
                } else {
                    List openServiceDocWorkIds = docWorkServiceList.stream().map(DocDoctorWorkingServiceEntity::getDoctorWorkId).distinct().collect(Collectors.toList());
                    List closeServiceDocWorkIds = workplacesIds.stream().filter(id -> !openServiceDocWorkIds.contains(id)).collect(Collectors.toList());
                    if (!closeServiceDocWorkIds.isEmpty()) {
                        log.info("\u8fc7\u6ee4\u540e,\u5173\u95ed\u533b\u751f\u670d\u52a1\u6743\u9650=>\u533b\u751f\u804c\u4e1aid:{},\u533b\u9662\u670d\u52a1\u4fe1\u606fid:[{}]", (Object)JSON.toJSONString(closeServiceDocWorkIds), (Object)JSON.toJSONString((Object)docServiceSetParam.getOrganServiceId()));
                        this.docDoctorServiceAccessMapper.batchUpdateStatusByDocWorkIdsAndWorkService(closeServiceDocWorkIds, docServiceSetParam.getOrganServiceId(), Integer.valueOf(-1));
                    }
                }
            }
        }
    }

    private void updateDoctorWorkServiceAndSync(DocServiceSetParam docServiceSetParam, DocServiceHandler docServiceHandler, List<Long> doctorWorkInfoIds) {
        if (!doctorWorkInfoIds.isEmpty()) {
            log.info("\u66f4\u65b0\u670d\u52a1\u4fe1\u606f\u7684\u5165\u53c2=> \u6267\u4e1a\u4fe1\u606fid:{},\u670d\u52a1\u53c2\u6570:{}", (Object)JSON.toJSONString(doctorWorkInfoIds), (Object)JSON.toJSONString((Object)docServiceSetParam));
            this.docDoctorWorkServiceMapper.updateServiceByDocWorkInfoIds(doctorWorkInfoIds, docServiceSetParam);
            docServiceHandler.synchroniseUpdate(docServiceSetParam, doctorWorkInfoIds);
        }
    }

    private void updateServiceAccess(DocServiceSetParam docServiceSetParam, List<DocDoctorWorkingServiceEntity> workingServiceList) {
        List existAuthDoctorWorkplaceIds = workingServiceList.stream().map(DocDoctorWorkingServiceEntity::getDoctorWorkId).distinct().collect(Collectors.toList());
        log.info("\u9700\u8981\u66f4\u65b0\u7684\u6743\u9650\u804c\u4e1aid\u96c6\u5408:{},\u53ca\u533b\u9662\u670d\u52a1id:[{}]", (Object)JSON.toJSONString(existAuthDoctorWorkplaceIds), (Object)docServiceSetParam.getOrganServiceId());
        if (!existAuthDoctorWorkplaceIds.isEmpty()) {
            this.docDoctorServiceAccessMapper.batchUpdateStatusByDocWorkIdsAndWorkService(existAuthDoctorWorkplaceIds, docServiceSetParam.getOrganServiceId(), Integer.valueOf(1));
        }
    }

    private void insertDoctorWorkServiceAndAccess(DocServiceSetParam docServiceSetParam, DocServiceHandler docServiceHandler, List<DocDoctorWorkplacesInfo> workplacesInfoList, List<Long> doctorWorkInfoIds) {
        List noRecordWorkInfoList = workplacesInfoList.stream().filter(info -> !doctorWorkInfoIds.contains(info.getXId())).collect(Collectors.toList());
        if (!noRecordWorkInfoList.isEmpty()) {
            log.info("\u65b0\u589e\u670d\u52a1\u4fe1\u606f\u64cd\u4f5c\u5165\u53c2=>\u6267\u4e1a\u4fe1\u606f:{},\u670d\u52a1\u914d\u7f6e:{}", noRecordWorkInfoList, (Object)docServiceSetParam);
            this.docDoctorWorkServiceMapper.batchInsertDoctorWorkService(noRecordWorkInfoList, docServiceSetParam);
            List noRecordWorkInfoIds = noRecordWorkInfoList.stream().map(DocDoctorWorkplacesInfo::getXId).collect(Collectors.toList());
            log.info("\u540c\u6b65\u65b0\u589e\u533b\u751f\u914d\u7f6e\u4fe1\u606f\u5165\u53c2=>\u6267\u4e1a\u4fe1\u606fid\u96c6\u5408:{},\u670d\u52a1\u914d\u7f6e:{}", (Object)JSON.toJSONString(noRecordWorkInfoIds), (Object)JSON.toJSONString((Object)docServiceSetParam));
            docServiceHandler.synchroniseInsert(docServiceSetParam, noRecordWorkInfoIds);
            List noRecordWorkIdList = noRecordWorkInfoList.stream().map(DocDoctorWorkplacesInfo::getDoctorWorkplaces).distinct().collect(Collectors.toList());
            List existWorkServiceAccessList = this.docDoctorServiceAccessMapper.getByDocWorkIdsAndWorkServiceAccess(noRecordWorkIdList, docServiceSetParam.getOrganServiceId());
            log.info("\u67e5\u8be2\u65b0\u589e\u670d\u52a1\u7684\u5b58\u5728\u6743\u9650:{}", (Object)JSON.toJSONString((Object)existWorkServiceAccessList));
            List existWorkServiceAccessIds = existWorkServiceAccessList.stream().map(DocDoctorServiceAccessEntity::getDoctorWorkId).collect(Collectors.toList());
            log.info("\u8fc7\u6ee4\u51fa\u5df2\u7ecf\u5b58\u5728\u6743\u9650\u7684\u6267\u4e1aid:{}", (Object)JSON.toJSONString(existWorkServiceAccessIds));
            if (!existWorkServiceAccessIds.isEmpty()) {
                this.docDoctorServiceAccessMapper.batchUpdateStatusByDocWorkIdsAndWorkService(existWorkServiceAccessIds, docServiceSetParam.getOrganServiceId(), Integer.valueOf(1));
            }
            List noAccessDocWorkIds = noRecordWorkIdList.stream().filter(item -> !existWorkServiceAccessIds.contains(item)).collect(Collectors.toList());
            log.info("\u8fc7\u6ee4\u51fa\u4e0d\u5b58\u5728\u6743\u9650\u7684\u6267\u4e1aid:{}", (Object)JSON.toJSONString(noAccessDocWorkIds));
            if (!noAccessDocWorkIds.isEmpty()) {
                this.docDoctorServiceAccessMapper.batchInsertSelective(noAccessDocWorkIds, docServiceSetParam);
            }
        }
    }

    private void syncNotSelectWorkInfoService(DocServiceSetParam docServiceSetParam, DocServiceHandler docServiceHandler, List<DocDoctorWorkplacesInfo> workplacesInfoList, List<Long> doctorWorkInfoIds) {
        List doctorWorkplaceIds = workplacesInfoList.stream().map(DocDoctorWorkplacesInfo::getDoctorWorkplaces).distinct().collect(Collectors.toList());
        List docDoctorWorkingService = this.docDoctorWorkServiceMapper.getByDoctorWorkIdAndServiceCode(doctorWorkplaceIds, docServiceSetParam.getServiceCode(), "1,-1");
        log.info("\u67e5\u8be2\u533b\u751f\u5176\u4ed6\u6267\u4e1a\u79d1\u5ba4\u670d\u52a1\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)docDoctorWorkingService));
        Map doctorWorkInfoIdGroupByServiceStatus = docDoctorWorkingService.stream().filter(item -> !doctorWorkInfoIds.contains(item.getDoctorWorkInfoId())).collect(Collectors.groupingBy(DocDoctorWorkingServiceEntity::getStatus, Collectors.mapping(DocDoctorWorkingServiceEntity::getDoctorWorkInfoId, Collectors.toList())));
        log.info("\u6839\u636e\u72b6\u6001\u5206\u7ec4\u5176\u4ed6\u79d1\u5ba4\u670d\u52a1\u4fe1\u606f:{}", (Object)JSON.toJSONString(doctorWorkInfoIdGroupByServiceStatus));
        List serviceOpenDoctorWorkInfoIds = doctorWorkInfoIdGroupByServiceStatus.get(1);
        List serviceCloseDoctorWorkInfoIds = doctorWorkInfoIdGroupByServiceStatus.get(-1);
        if (Objects.nonNull(serviceOpenDoctorWorkInfoIds) && !serviceOpenDoctorWorkInfoIds.isEmpty()) {
            docServiceSetParam.setStatus(Integer.valueOf(1));
            log.info("\u540c\u6b65\u72b6\u6001\u4e3a\u5f00\u901a\u7684\u670d\u52a1\u4fe1\u606f=>\u6267\u4e1a\u4fe1\u606fid{},\u670d\u52a1\u53c2\u6570:{}", (Object)JSON.toJSONString(serviceOpenDoctorWorkInfoIds), (Object)JSON.toJSONString((Object)docServiceSetParam));
            this.docDoctorWorkServiceMapper.updateServiceByDocWorkInfoIds(serviceOpenDoctorWorkInfoIds, docServiceSetParam);
            docServiceHandler.synchroniseUpdate(docServiceSetParam, serviceOpenDoctorWorkInfoIds);
        }
        if (Objects.nonNull(serviceCloseDoctorWorkInfoIds) && !serviceCloseDoctorWorkInfoIds.isEmpty()) {
            docServiceSetParam.setStatus(Integer.valueOf(-1));
            log.info("\u540c\u6b65\u72b6\u6001\u4e3a\u5f00\u901a\u7684\u670d\u52a1\u4fe1\u606f=>\u6267\u4e1a\u4fe1\u606fid{},\u670d\u52a1\u53c2\u6570:{}", (Object)JSON.toJSONString(serviceCloseDoctorWorkInfoIds), (Object)JSON.toJSONString((Object)docServiceSetParam));
            this.docDoctorWorkServiceMapper.updateServiceByDocWorkInfoIds(serviceCloseDoctorWorkInfoIds, docServiceSetParam);
        }
    }

    private DocServiceSetParam prepareSetServiceParam(BatchSetDocServiceReqVO reqVO, OrganWorkingServiceEntity organService) {
        DocServiceSetParam docServiceSetParam = new DocServiceSetParam();
        docServiceSetParam.setOrganServiceId(Long.valueOf(organService.getxId()));
        docServiceSetParam.setServiceCode(organService.getServCode());
        docServiceSetParam.setServiceInfo(reqVO.getServiceConfig());
        docServiceSetParam.setAppCode(reqVO.getAppCode());
        docServiceSetParam.setOrganId(reqVO.getOrganId());
        docServiceSetParam.setStatus(Integer.valueOf(reqVO.getStatus()));
        return docServiceSetParam;
    }
}

