/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.layout.form.renderer;

import com.itextpdf.html2pdf.attach.impl.layout.form.element.IFormField;
import com.itextpdf.html2pdf.attach.impl.layout.form.renderer.AbstractTextFieldRenderer;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.renderer.LineRenderer;
import java.util.List;

public abstract class AbstractOneLineTextFieldRenderer
extends AbstractTextFieldRenderer {
    protected float baseline;

    AbstractOneLineTextFieldRenderer(IFormField modelElement) {
        super(modelElement);
    }

    public float getAscent() {
        return this.occupiedArea.getBBox().getTop() - this.baseline;
    }

    public float getDescent() {
        return this.occupiedArea.getBBox().getBottom() - this.baseline;
    }

    void cropContentLines(List<LineRenderer> lines, Rectangle bBox) {
        this.adjustNumberOfContentLines(lines, bBox, 1);
        this.updateParagraphHeight();
        this.baseline = lines.get(0).getYLine();
    }

    private void updateParagraphHeight() {
        Float height = this.retrieveHeight();
        Float minHeight = this.retrieveMinHeight();
        Float maxHeight = this.retrieveMaxHeight();
        Rectangle flatBBox = this.flatRenderer.getOccupiedArea().getBBox();
        if (height != null && height.floatValue() > 0.0f) {
            this.setContentHeight(flatBBox, height.floatValue());
        } else if (minHeight != null && minHeight.floatValue() > flatBBox.getHeight()) {
            this.setContentHeight(flatBBox, minHeight.floatValue());
        } else if (maxHeight != null && maxHeight.floatValue() > 0.0f && maxHeight.floatValue() < flatBBox.getHeight()) {
            this.setContentHeight(flatBBox, maxHeight.floatValue());
        }
    }

    private void setContentHeight(Rectangle bBox, float height) {
        float dy = (height - bBox.getHeight()) / 2.0f;
        bBox.moveDown(dy);
        bBox.setHeight(height);
    }
}

