/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.layout.form.renderer;

import com.itextpdf.forms.PdfAcroForm;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.forms.fields.PdfTextFormField;
import com.itextpdf.html2pdf.attach.impl.layout.form.element.InputField;
import com.itextpdf.html2pdf.attach.impl.layout.form.renderer.AbstractOneLineTextFieldRenderer;
import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.ParagraphRenderer;
import java.util.List;
import org.slf4j.LoggerFactory;

public class InputFieldRenderer
extends AbstractOneLineTextFieldRenderer {
    public InputFieldRenderer(InputField modelElement) {
        super(modelElement);
    }

    public IRenderer getNextRenderer() {
        return new InputFieldRenderer((InputField)this.modelElement);
    }

    public int getSize() {
        Integer size = this.getPropertyAsInteger(0x100004);
        return size != null ? size.intValue() : ((Integer)this.modelElement.getDefaultProperty(0x100004)).intValue();
    }

    public boolean isPassword() {
        Boolean password = this.getPropertyAsBoolean(0x100006);
        return password != null ? password.booleanValue() : ((Boolean)this.modelElement.getDefaultProperty(0x100006)).booleanValue();
    }

    @Override
    protected void adjustFieldLayout() {
        List flatLines = ((ParagraphRenderer)this.flatRenderer).getLines();
        Rectangle flatBBox = this.flatRenderer.getOccupiedArea().getBBox();
        this.updatePdfFont((ParagraphRenderer)this.flatRenderer);
        if (!flatLines.isEmpty() && this.font != null) {
            this.cropContentLines(flatLines, flatBBox);
        } else {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(MessageFormatUtil.format((String)"Error during layout of form filed with type {0}.", (Object[])new Object[]{"text input"}));
            this.setProperty(0x100003, true);
            this.baseline = flatBBox.getTop();
            flatBBox.setY(this.baseline).setHeight(0.0f);
        }
        flatBBox.setWidth(this.getContentWidth().floatValue());
    }

    @Override
    protected IRenderer createFlatRenderer() {
        String defaultValue = this.getDefaultValue();
        boolean flatten = this.isFlatten();
        boolean password = this.isPassword();
        if (flatten && password) {
            defaultValue = this.obfuscatePassword(defaultValue);
        }
        return this.createParagraphRenderer(defaultValue);
    }

    @Override
    protected void applyAcroField(DrawContext drawContext) {
        this.font.setSubset(false);
        String value = this.getDefaultValue();
        String name = this.getModelId();
        float fontSize = this.getPropertyAsFloat(24).floatValue();
        PdfDocument doc = drawContext.getDocument();
        Rectangle area = this.flatRenderer.getOccupiedArea().getBBox().clone();
        PdfPage page = doc.getPage(this.occupiedArea.getPageNumber());
        boolean password = this.isPassword();
        if (password) {
            value = "";
        }
        PdfTextFormField inputField = PdfFormField.createText((PdfDocument)doc, (Rectangle)area, (String)name, (String)value, (PdfFont)this.font, (float)fontSize);
        if (password) {
            inputField.setFieldFlag(PdfFormField.FF_PASSWORD, true);
        } else {
            inputField.setDefaultValue((PdfObject)new PdfString(value));
        }
        this.applyDefaultFieldProperties((PdfFormField)inputField);
        PdfAcroForm.getAcroForm((PdfDocument)doc, (boolean)true).addField((PdfFormField)inputField, page);
    }

    @Override
    protected Float getContentWidth() {
        Float width = super.getContentWidth();
        if (width == null) {
            float fontSize = this.getPropertyAsFloat(24).floatValue();
            int size = this.getSize();
            return Float.valueOf(fontSize * ((float)size * 0.5f + 2.0f) + 2.0f);
        }
        return width;
    }

    private String obfuscatePassword(String text) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            builder.append('*');
        }
        return builder.toString();
    }
}

