/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.wrapelement;

import com.itextpdf.html2pdf.attach.util.RowColHelper;
import com.itextpdf.html2pdf.attach.util.WaitingColgroupsHelper;
import com.itextpdf.html2pdf.attach.wrapelement.IWrapElement;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.property.UnitValue;
import java.util.ArrayList;
import java.util.List;

public class TableWrapper
implements IWrapElement {
    private List<List<CellWrapper>> rows;
    private List<List<CellWrapper>> headerRows;
    private List<List<CellWrapper>> footerRows;
    private RowColHelper rowShift = new RowColHelper();
    private RowColHelper headerRowShift = new RowColHelper();
    private RowColHelper footerRowShift = new RowColHelper();
    private int numberOfColumns = 0;

    public int getRowsSize() {
        return this.rows.size();
    }

    public void newRow() {
        if (this.rows == null) {
            this.rows = new ArrayList<List<CellWrapper>>();
        }
        this.rowShift.newRow();
        this.rows.add(new ArrayList());
    }

    public void newHeaderRow() {
        if (this.headerRows == null) {
            this.headerRows = new ArrayList<List<CellWrapper>>();
        }
        this.headerRowShift.newRow();
        this.headerRows.add(new ArrayList());
    }

    public void newFooterRow() {
        if (this.footerRows == null) {
            this.footerRows = new ArrayList<List<CellWrapper>>();
        }
        this.footerRowShift.newRow();
        this.footerRows.add(new ArrayList());
    }

    public void addHeaderCell(Cell cell) {
        if (this.headerRows == null) {
            this.headerRows = new ArrayList<List<CellWrapper>>();
        }
        if (this.headerRows.size() == 0) {
            this.newHeaderRow();
        }
        this.addCellToTable(cell, this.headerRows, this.headerRowShift);
    }

    public void addFooterCell(Cell cell) {
        if (this.footerRows == null) {
            this.footerRows = new ArrayList<List<CellWrapper>>();
        }
        if (this.footerRows.size() == 0) {
            this.newFooterRow();
        }
        this.addCellToTable(cell, this.footerRows, this.footerRowShift);
    }

    public void addCell(Cell cell) {
        if (this.rows == null) {
            this.rows = new ArrayList<List<CellWrapper>>();
        }
        if (this.rows.size() == 0) {
            this.newRow();
        }
        this.addCellToTable(cell, this.rows, this.rowShift);
    }

    private void addCellToTable(Cell cell, List<List<CellWrapper>> table, RowColHelper tableRowShift) {
        int col = tableRowShift.moveToNextEmptyCol();
        tableRowShift.updateCurrentPosition(cell.getColspan(), cell.getRowspan());
        List<CellWrapper> currentRow = table.get(table.size() - 1);
        currentRow.add(new CellWrapper(col, cell));
        this.numberOfColumns = Math.max(this.numberOfColumns, col + cell.getColspan());
    }

    public Table toTable(WaitingColgroupsHelper colgroupsHelper) {
        int j;
        int i;
        Table table = this.numberOfColumns > 0 ? new Table(this.getColWidths(colgroupsHelper)) : new Table(1);
        table.deleteOwnProperty(77);
        if (this.headerRows != null) {
            for (i = 0; i < this.headerRows.size(); ++i) {
                for (j = 0; j < this.headerRows.get(i).size(); ++j) {
                    table.addHeaderCell(this.headerRows.get((int)i).get((int)j).cell);
                }
                if (i == this.headerRows.size() - 1) continue;
                table.getHeader().startNewRow();
            }
        }
        if (this.footerRows != null) {
            for (i = 0; i < this.footerRows.size(); ++i) {
                for (j = 0; j < this.footerRows.get(i).size(); ++j) {
                    table.addFooterCell(this.footerRows.get((int)i).get((int)j).cell);
                }
                if (i == this.footerRows.size() - 1) continue;
                table.getFooter().startNewRow();
            }
        }
        if (this.rows != null) {
            for (i = 0; i < this.rows.size(); ++i) {
                for (j = 0; j < this.rows.get(i).size(); ++j) {
                    table.addCell(this.rows.get((int)i).get((int)j).cell);
                }
                if (i == this.rows.size() - 1) continue;
                table.startNewRow();
            }
        }
        return table;
    }

    private UnitValue[] getColWidths(WaitingColgroupsHelper colgroups) {
        UnitValue[] colWidths = new UnitValue[this.numberOfColumns];
        if (colgroups == null) {
            for (int i = 0; i < this.numberOfColumns; ++i) {
                colWidths[i] = null;
            }
        } else {
            for (int i = 0; i < this.numberOfColumns; ++i) {
                colWidths[i] = colgroups.getColWrapper(i) != null ? colgroups.getColWrapper(i).getWidth() : null;
            }
        }
        return colWidths;
    }

    private static class CellWrapper {
        int col;
        Cell cell;

        CellWrapper(int col, Cell cell) {
            this.col = col;
            this.cell = cell;
        }
    }
}

