/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.validate;

import com.itextpdf.html2pdf.css.CssDeclaration;
import com.itextpdf.html2pdf.css.validate.ICssDeclarationValidator;
import com.itextpdf.html2pdf.css.validate.impl.datatype.CssColorValidator;
import com.itextpdf.html2pdf.css.validate.impl.datatype.CssEnumValidator;
import com.itextpdf.html2pdf.css.validate.impl.datatype.CssQuotesValidator;
import com.itextpdf.html2pdf.css.validate.impl.datatype.CssTransformValidator;
import com.itextpdf.html2pdf.css.validate.impl.declaration.MultiTypeDeclarationValidator;
import com.itextpdf.html2pdf.css.validate.impl.declaration.SingleTypeDeclarationValidator;
import java.util.HashMap;
import java.util.Map;

public class CssDeclarationValidationMaster {
    private static final Map<String, ICssDeclarationValidator> DEFAULT_VALIDATORS;

    private CssDeclarationValidationMaster() {
    }

    public static boolean checkDeclaration(CssDeclaration declaration) {
        ICssDeclarationValidator validator = DEFAULT_VALIDATORS.get(declaration.getProperty());
        return validator == null || validator.isValid(declaration);
    }

    static {
        MultiTypeDeclarationValidator colorCommonValidator = new MultiTypeDeclarationValidator(new CssEnumValidator("transparent", "initial", "inherit"), new CssColorValidator());
        DEFAULT_VALIDATORS = new HashMap<String, ICssDeclarationValidator>();
        DEFAULT_VALIDATORS.put("background-color", colorCommonValidator);
        DEFAULT_VALIDATORS.put("color", colorCommonValidator);
        DEFAULT_VALIDATORS.put("border-color", colorCommonValidator);
        DEFAULT_VALIDATORS.put("border-bottom-color", colorCommonValidator);
        DEFAULT_VALIDATORS.put("border-top-color", colorCommonValidator);
        DEFAULT_VALIDATORS.put("border-left-color", colorCommonValidator);
        DEFAULT_VALIDATORS.put("border-right-color", colorCommonValidator);
        DEFAULT_VALIDATORS.put("float", new SingleTypeDeclarationValidator(new CssEnumValidator("left", "right", "none", "inherit", "center")));
        DEFAULT_VALIDATORS.put("page-break-before", new SingleTypeDeclarationValidator(new CssEnumValidator("auto", "always", "avoid", "left", "right")));
        DEFAULT_VALIDATORS.put("page-break-after", new SingleTypeDeclarationValidator(new CssEnumValidator("auto", "always", "avoid", "left", "right")));
        DEFAULT_VALIDATORS.put("quotes", new MultiTypeDeclarationValidator(new CssEnumValidator("initial", "inherit", "none"), new CssQuotesValidator()));
        DEFAULT_VALIDATORS.put("transform", new SingleTypeDeclarationValidator(new CssTransformValidator()));
    }
}

