/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.jmx;

import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.RequiredModelMBean;
import oracle.dms.instrument.Sensor;
import oracle.dms.jmx.MetricMBeanInfo;
import oracle.dms.spy.Metric;

public class MetricMBean
extends RequiredModelMBean {
    private MetricMBeanInfo m_mbi;
    private static final long serialVersionUID = -1227727089617L;

    MetricMBean(MetricMBeanInfo mbi) throws MBeanException {
        super(mbi);
        this.m_mbi = mbi;
    }

    @Override
    public Object getAttribute(String attrName) throws AttributeNotFoundException, MBeanException {
        if (attrName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributeName must not be null"), "Exception occurred trying to get attribute of a RequiredModelMBean");
        }
        ModelMBeanInfo mbeanInfo = (ModelMBeanInfo)((Object)this.getMBeanInfo());
        if (mbeanInfo == null) {
            throw new AttributeNotFoundException("getAttribute failed: ModelMBeanInfo not found for " + attrName);
        }
        try {
            ModelMBeanAttributeInfo attrInfo = mbeanInfo.getAttribute(attrName);
            if (attrInfo == null) {
                throw new AttributeNotFoundException("getAttribute failed: ModelMBeanAttributeInfo not found for " + attrName);
            }
            Descriptor attrDescr = attrInfo.getDescriptor();
            if (attrDescr == null) {
                throw new AttributeNotFoundException("getAttribute failed due to no descriptor: " + attrName);
            }
            String metricType = (String)attrDescr.getFieldValue("oracle.dms.metrictype");
            if ("metric".equals(metricType)) {
                String sensorPath = (String)attrDescr.getFieldValue("oracle.dms.sensor");
                String metricName = (String)attrDescr.getFieldValue("oracle.dms.metric");
                Sensor sensor = Sensor.get(sensorPath);
                Metric metric = null;
                if (sensor != null) {
                    metric = sensor.getMetric(metricName);
                }
                if (metric != null) {
                    return metric.getValue();
                }
                return null;
            }
            if ("fixvalue".equals(metricType)) {
                return attrDescr.getFieldValue("value");
            }
            throw new AttributeNotFoundException("Attribute not found: " + attrName);
        }
        catch (MBeanException e) {
            throw e;
        }
        catch (AttributeNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MBeanException(e, "An exception occurred while trying to get value for attribute" + attrName + ": " + e.getMessage());
        }
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.m_mbi;
    }
}

