/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.reporter;

import java.util.ArrayList;
import java.util.List;
import oracle.dms.http.Request;
import oracle.dms.reporter.Agency;
import oracle.dms.reporter.HtmlReporter;
import oracle.dms.reporter.MetricHelpReporter;
import oracle.dms.reporter.MetricListReporter;
import oracle.dms.reporter.MetricTableReporter;
import oracle.dms.reporter.PdmlReporter;
import oracle.dms.reporter.RawReporter;
import oracle.dms.reporter.Reporter;
import oracle.dms.reporter.TbmlTableReporter;
import oracle.dms.reporter.TreeletGenerator;
import oracle.dms.reporter.TreeletGeneratorFactory;
import oracle.dms.table.TableSource;

public class SpyAgency
extends Agency {
    private TableSource m_source = null;
    private List<TreeletGeneratorFactory> m_treeletGeneratorsFactory = new ArrayList<TreeletGeneratorFactory>();

    public SpyAgency(TableSource source) {
        if (source == null) {
            throw new IllegalArgumentException("storage=" + source);
        }
        this.m_source = source;
    }

    @Override
    public void close() {
        this.m_treeletGeneratorsFactory.clear();
    }

    public void registerTreeletGeneratorFactory(TreeletGeneratorFactory treeletGeneratorFactory) {
        if (treeletGeneratorFactory != null) {
            this.m_treeletGeneratorsFactory.add(treeletGeneratorFactory);
        }
    }

    public void unregisterTreeletGeneratorFactory(TreeletGeneratorFactory treeletGeneratorFactory) {
        if (treeletGeneratorFactory != null) {
            this.m_treeletGeneratorsFactory.remove(treeletGeneratorFactory);
        }
    }

    @Override
    public Reporter getReporter(Request request) {
        if (request.isFormat("tbml") || request.isFormat("xml")) {
            return new TbmlTableReporter(this.m_source, request);
        }
        if (request.isFormat("metrictable")) {
            return new MetricTableReporter(this.m_source, request);
        }
        if (request.isFormat("metriclist")) {
            return new MetricListReporter(this.m_source, request, false);
        }
        if (request.isFormat("metrichelp")) {
            return new MetricHelpReporter(this.m_source, request);
        }
        if (request.isFormat("raw") || request.isOperation("reset") || request.isOperation("set")) {
            RawReporter reporter = new RawReporter(request);
            for (TreeletGeneratorFactory treeletGeneratorFactory : this.m_treeletGeneratorsFactory) {
                TreeletGenerator treeletGenerator = treeletGeneratorFactory.createTreeletGenerator();
                reporter.registerTreeletGenerator(treeletGenerator);
            }
            return reporter;
        }
        if (request.isFormat("pdml")) {
            PdmlReporter reporter = new PdmlReporter(request);
            for (TreeletGeneratorFactory treeletGeneratorFactory : this.m_treeletGeneratorsFactory) {
                TreeletGenerator treeletGenerator = treeletGeneratorFactory.createTreeletGenerator();
                reporter.registerTreeletGenerator(treeletGenerator);
            }
            return reporter;
        }
        return new HtmlReporter(request);
    }
}

