/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.was;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import oracle.dms.context.DMSContextManager;
import oracle.dms.context.ExecutionContext;
import oracle.dms.context.ExecutionContextStub;
import oracle.dms.context.RID;
import oracle.dms.context.internal.DomainContextManager;
import oracle.dms.context.internal.WrapUtils;
import oracle.dms.context.internal.was.WASContextManager;
import oracle.dms.context.internal.was.WASExecutionContext;
import oracle.dms.servlet.DMSServletRequestInspector;
import oracle.dms.util.ServletUtils;

public class DMSServletRequestListener
implements ServletRequestListener {
    private static String CLASS_NAME = DMSServletRequestListener.class.getName();
    private Logger mLogger = Logger.getLogger("oracle.dms.context", "oracle.dms.context.ContextResourceBundle");
    private DMSServletRequestInspector mServletRequestInspector = new DMSServletRequestInspector();
    private static final String START_CONTEXT_ATTRIBUTE_NAME = CLASS_NAME + "-startContext";

    public void requestInitialized(ServletRequestEvent servletRequestEvent) {
        String METHOD_NAME = "requestInitialized";
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequestEvent.getServletRequest();
        ExecutionContext startContext = null;
        boolean skipProcessing = DomainContextManager.WEB_REQUEST_CONTEXT_ATTRIBUTE_VALUE_TRUE.equals(httpServletRequest.getAttribute("oracle.dms.context.http.WebRequestContextProcessed"));
        if (skipProcessing) {
            if (this.mLogger.isLoggable(Level.FINE)) {
                this.mLogger.logp(Level.FINE, CLASS_NAME, "requestInitialized", "The request attribute used to signify that DMS has already processed the starting of this http request has been detected. This instance of " + CLASS_NAME + " will not perform any further " + "processing.");
            }
        } else {
            httpServletRequest.setAttribute("oracle.dms.context.http.WebRequestContextProcessed", DomainContextManager.WEB_REQUEST_CONTEXT_ATTRIBUTE_VALUE_TRUE);
            if (DMSContextManager.isEnabled() && (startContext = this.mServletRequestInspector.getStartContext(httpServletRequest)) instanceof ExecutionContextStub) {
                WASContextManager wcm = (WASContextManager)DMSContextManager.getDomainContextManager();
                WASExecutionContext wctx = wcm.newFamily(WrapUtils.createECID(), new RID());
                startContext = wctx.getAsMutableExecutionContext();
                startContext.activate();
            }
            if (startContext != null) {
                this.mServletRequestInspector.registerRequestStarted(httpServletRequest, null, startContext);
                httpServletRequest.setAttribute(START_CONTEXT_ATTRIBUTE_NAME, (Object)startContext);
            }
        }
    }

    public void requestDestroyed(ServletRequestEvent servletRequestEvent) {
        block3: {
            String METHOD_NAME = "requestDestroyed";
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequestEvent.getServletRequest();
            ExecutionContext endContext = DMSContextManager.getActiveContext();
            this.mServletRequestInspector.registerRequestEnded(httpServletRequest, null, endContext);
            this.compareStartAndEndContexts(endContext, httpServletRequest);
            if (endContext != null) {
                try {
                    endContext.deactivate();
                }
                catch (Exception e) {
                    if (!this.mLogger.isLoggable(Level.WARNING)) break block3;
                    LogRecord lr = new LogRecord(Level.WARNING, "DMS-57006");
                    lr.setResourceBundle(this.mLogger.getResourceBundle());
                    lr.setSourceClassName(CLASS_NAME);
                    lr.setSourceMethodName("requestDestroyed");
                    lr.setParameters(new Object[]{endContext.getIDasString(), httpServletRequest.getRequestURL().toString()});
                    lr.setThrown(e);
                    this.mLogger.log(lr);
                }
            }
        }
    }

    private void compareStartAndEndContexts(ExecutionContext endContext, HttpServletRequest httpServletRequest) {
        String METHOD_NAME = "compareStartAndEndContexts";
        ExecutionContext startContext = (ExecutionContext)httpServletRequest.getAttribute(START_CONTEXT_ATTRIBUTE_NAME);
        if (startContext != null && startContext != endContext && this.mLogger.isLoggable(Level.WARNING)) {
            this.mLogger.logp(Level.WARNING, CLASS_NAME, "compareStartAndEndContexts", "DMS-57008", new Object[]{startContext != null ? startContext.getIDasString() : "null", endContext != null ? endContext.getIDasString() : "null", ServletUtils.getRequestAsPrettyString(httpServletRequest)});
        }
    }
}

