/*
 * Decompiled with CFR 0.152.
 */
package com.xingyuv.jushauth.request;

import com.alibaba.fastjson.JSONObject;
import com.xingyuv.jushauth.cache.AuthStateCache;
import com.xingyuv.jushauth.config.AuthConfig;
import com.xingyuv.jushauth.config.AuthDefaultSource;
import com.xingyuv.jushauth.enums.AuthUserGender;
import com.xingyuv.jushauth.enums.scope.AuthCodingScope;
import com.xingyuv.jushauth.exception.AuthException;
import com.xingyuv.jushauth.model.AuthCallback;
import com.xingyuv.jushauth.model.AuthToken;
import com.xingyuv.jushauth.model.AuthUser;
import com.xingyuv.jushauth.request.AuthDefaultRequest;
import com.xingyuv.jushauth.utils.AuthScopeUtils;
import com.xingyuv.jushauth.utils.UrlBuilder;

public class AuthCodingRequest
extends AuthDefaultRequest {
    public AuthCodingRequest(AuthConfig config) {
        super(config, AuthDefaultSource.CODING);
    }

    public AuthCodingRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.CODING, authStateCache);
    }

    @Override
    protected AuthToken getAccessToken(AuthCallback authCallback) {
        String response = this.doGetAuthorizationCode(authCallback.getCode());
        JSONObject accessTokenObject = JSONObject.parseObject((String)response);
        this.checkResponse(accessTokenObject);
        return AuthToken.builder().accessToken(accessTokenObject.getString("access_token")).expireIn(accessTokenObject.getIntValue("expires_in")).refreshToken(accessTokenObject.getString("refresh_token")).build();
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        String response = this.doGetUserInfo(authToken);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        object = object.getJSONObject("data");
        return AuthUser.builder().rawUserInfo(object).uuid(object.getString("id")).username(object.getString("name")).avatar("https://coding.net" + object.getString("avatar")).blog("https://coding.net" + object.getString("path")).nickname(object.getString("name")).company(object.getString("company")).location(object.getString("location")).gender(AuthUserGender.getRealGender(object.getString("sex"))).email(object.getString("email")).remark(object.getString("slogan")).token(authToken).source(this.source.toString()).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.getIntValue("code") != 0) {
            throw new AuthException(object.getString("msg"));
        }
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl(String.format(this.source.authorize(), this.config.getDomainPrefix())).queryParam("response_type", "code").queryParam("client_id", this.config.getClientId()).queryParam("redirect_uri", this.config.getRedirectUri()).queryParam("scope", this.getScopes(" ", true, AuthScopeUtils.getDefaultScopes(AuthCodingScope.values()))).queryParam("state", this.getRealState(state)).build();
    }

    @Override
    public String accessTokenUrl(String code) {
        return UrlBuilder.fromBaseUrl(String.format(this.source.accessToken(), this.config.getDomainPrefix())).queryParam("code", code).queryParam("client_id", this.config.getClientId()).queryParam("client_secret", this.config.getClientSecret()).queryParam("grant_type", "authorization_code").queryParam("redirect_uri", this.config.getRedirectUri()).build();
    }

    @Override
    public String userInfoUrl(AuthToken authToken) {
        return UrlBuilder.fromBaseUrl(String.format(this.source.userInfo(), this.config.getDomainPrefix())).queryParam("access_token", authToken.getAccessToken()).build();
    }
}

