/*
 * Decompiled with CFR 0.152.
 */
package com.xingyuv.jushauth.request;

import com.alibaba.fastjson.JSONObject;
import com.xingyuv.http.support.HttpHeader;
import com.xingyuv.jushauth.cache.AuthStateCache;
import com.xingyuv.jushauth.config.AuthConfig;
import com.xingyuv.jushauth.config.AuthDefaultSource;
import com.xingyuv.jushauth.enums.AuthUserGender;
import com.xingyuv.jushauth.enums.scope.AuthGoogleScope;
import com.xingyuv.jushauth.exception.AuthException;
import com.xingyuv.jushauth.model.AuthCallback;
import com.xingyuv.jushauth.model.AuthToken;
import com.xingyuv.jushauth.model.AuthUser;
import com.xingyuv.jushauth.request.AuthDefaultRequest;
import com.xingyuv.jushauth.utils.AuthScopeUtils;
import com.xingyuv.jushauth.utils.HttpUtils;
import com.xingyuv.jushauth.utils.UrlBuilder;

public class AuthGoogleRequest
extends AuthDefaultRequest {
    public AuthGoogleRequest(AuthConfig config) {
        super(config, AuthDefaultSource.GOOGLE);
    }

    public AuthGoogleRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.GOOGLE, authStateCache);
    }

    @Override
    protected AuthToken getAccessToken(AuthCallback authCallback) {
        String response = this.doPostAuthorizationCode(authCallback.getCode());
        JSONObject accessTokenObject = JSONObject.parseObject((String)response);
        this.checkResponse(accessTokenObject);
        return AuthToken.builder().accessToken(accessTokenObject.getString("access_token")).expireIn(accessTokenObject.getIntValue("expires_in")).scope(accessTokenObject.getString("scope")).tokenType(accessTokenObject.getString("token_type")).idToken(accessTokenObject.getString("id_token")).build();
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        HttpHeader httpHeader = new HttpHeader();
        httpHeader.add("Authorization", "Bearer " + authToken.getAccessToken());
        String userInfo = new HttpUtils(this.config.getHttpConfig()).post(this.userInfoUrl(authToken), null, httpHeader).getBody();
        JSONObject object = JSONObject.parseObject((String)userInfo);
        this.checkResponse(object);
        return AuthUser.builder().rawUserInfo(object).uuid(object.getString("sub")).username(object.getString("email")).avatar(object.getString("picture")).nickname(object.getString("name")).location(object.getString("locale")).email(object.getString("email")).gender(AuthUserGender.UNKNOWN).token(authToken).source(this.source.toString()).build();
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl(super.authorize(state)).queryParam("access_type", "offline").queryParam("scope", this.getScopes(" ", false, AuthScopeUtils.getDefaultScopes(AuthGoogleScope.values()))).queryParam("prompt", "select_account").build();
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return UrlBuilder.fromBaseUrl(this.source.userInfo()).queryParam("access_token", authToken.getAccessToken()).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"error") || object.containsKey((Object)"error_description")) {
            throw new AuthException(object.containsKey((Object)"error") + ":" + object.getString("error_description"));
        }
    }
}

