/*
 * Decompiled with CFR 0.152.
 */
package com.xingyuv.jushauth.request;

import com.alibaba.fastjson.JSONObject;
import com.xingyuv.http.support.HttpHeader;
import com.xingyuv.jushauth.cache.AuthStateCache;
import com.xingyuv.jushauth.config.AuthConfig;
import com.xingyuv.jushauth.config.AuthDefaultSource;
import com.xingyuv.jushauth.enums.AuthResponseStatus;
import com.xingyuv.jushauth.enums.AuthUserGender;
import com.xingyuv.jushauth.enums.scope.AuthLineScope;
import com.xingyuv.jushauth.model.AuthCallback;
import com.xingyuv.jushauth.model.AuthResponse;
import com.xingyuv.jushauth.model.AuthToken;
import com.xingyuv.jushauth.model.AuthUser;
import com.xingyuv.jushauth.request.AuthDefaultRequest;
import com.xingyuv.jushauth.utils.AuthScopeUtils;
import com.xingyuv.jushauth.utils.HttpUtils;
import com.xingyuv.jushauth.utils.UrlBuilder;
import java.util.HashMap;

public class AuthLineRequest
extends AuthDefaultRequest {
    public AuthLineRequest(AuthConfig config) {
        super(config, AuthDefaultSource.LINE);
    }

    public AuthLineRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.LINE, authStateCache);
    }

    @Override
    protected AuthToken getAccessToken(AuthCallback authCallback) {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("grant_type", "authorization_code");
        params.put("code", authCallback.getCode());
        params.put("redirect_uri", this.config.getRedirectUri());
        params.put("client_id", this.config.getClientId());
        params.put("client_secret", this.config.getClientSecret());
        String response = new HttpUtils(this.config.getHttpConfig()).post(this.source.accessToken(), params, false).getBody();
        JSONObject accessTokenObject = JSONObject.parseObject((String)response);
        return AuthToken.builder().accessToken(accessTokenObject.getString("access_token")).refreshToken(accessTokenObject.getString("refresh_token")).expireIn(accessTokenObject.getIntValue("expires_in")).idToken(accessTokenObject.getString("id_token")).scope(accessTokenObject.getString("scope")).tokenType(accessTokenObject.getString("token_type")).build();
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        String userInfo = new HttpUtils(this.config.getHttpConfig()).get(this.source.userInfo(), null, new HttpHeader().add("Content-Type", "application/x-www-form-urlencoded").add("Authorization", "Bearer ".concat(authToken.getAccessToken())), false).getBody();
        JSONObject object = JSONObject.parseObject((String)userInfo);
        return AuthUser.builder().rawUserInfo(object).uuid(object.getString("userId")).username(object.getString("displayName")).nickname(object.getString("displayName")).avatar(object.getString("pictureUrl")).remark(object.getString("statusMessage")).gender(AuthUserGender.UNKNOWN).token(authToken).source(this.source.toString()).build();
    }

    @Override
    public AuthResponse revoke(AuthToken authToken) {
        HashMap<String, String> params = new HashMap<String, String>(5);
        params.put("access_token", authToken.getAccessToken());
        params.put("client_id", this.config.getClientId());
        params.put("client_secret", this.config.getClientSecret());
        String userInfo = new HttpUtils(this.config.getHttpConfig()).post(this.source.revoke(), params, false).getBody();
        JSONObject object = JSONObject.parseObject((String)userInfo);
        AuthResponseStatus status = object.getBooleanValue("revoked") ? AuthResponseStatus.SUCCESS : AuthResponseStatus.FAILURE;
        return AuthResponse.builder().code(status.getCode()).msg(status.getMsg()).build();
    }

    @Override
    public AuthResponse refresh(AuthToken oldToken) {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("grant_type", "refresh_token");
        params.put("refresh_token", oldToken.getRefreshToken());
        params.put("client_id", this.config.getClientId());
        params.put("client_secret", this.config.getClientSecret());
        String response = new HttpUtils(this.config.getHttpConfig()).post(this.source.accessToken(), params, false).getBody();
        JSONObject accessTokenObject = JSONObject.parseObject((String)response);
        return AuthResponse.builder().code(AuthResponseStatus.SUCCESS.getCode()).data(AuthToken.builder().accessToken(accessTokenObject.getString("access_token")).refreshToken(accessTokenObject.getString("refresh_token")).expireIn(accessTokenObject.getIntValue("expires_in")).idToken(accessTokenObject.getString("id_token")).scope(accessTokenObject.getString("scope")).tokenType(accessTokenObject.getString("token_type")).build()).build();
    }

    @Override
    public String userInfoUrl(AuthToken authToken) {
        return UrlBuilder.fromBaseUrl(this.source.userInfo()).queryParam("user", authToken.getUid()).build();
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl(super.authorize(state)).queryParam("nonce", state).queryParam("scope", this.getScopes(" ", true, AuthScopeUtils.getDefaultScopes(AuthLineScope.values()))).build();
    }
}

