/*
 * Decompiled with CFR 0.152.
 */
package com.xingyuv.jushauth.request;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xingyuv.http.util.UrlUtil;
import com.xingyuv.jushauth.cache.AuthStateCache;
import com.xingyuv.jushauth.config.AuthConfig;
import com.xingyuv.jushauth.config.AuthDefaultSource;
import com.xingyuv.jushauth.enums.AuthResponseStatus;
import com.xingyuv.jushauth.enums.AuthUserGender;
import com.xingyuv.jushauth.enums.scope.AuthRenrenScope;
import com.xingyuv.jushauth.exception.AuthException;
import com.xingyuv.jushauth.model.AuthCallback;
import com.xingyuv.jushauth.model.AuthResponse;
import com.xingyuv.jushauth.model.AuthToken;
import com.xingyuv.jushauth.model.AuthUser;
import com.xingyuv.jushauth.request.AuthDefaultRequest;
import com.xingyuv.jushauth.utils.AuthScopeUtils;
import com.xingyuv.jushauth.utils.HttpUtils;
import com.xingyuv.jushauth.utils.UrlBuilder;
import java.util.Objects;

public class AuthRenrenRequest
extends AuthDefaultRequest {
    public AuthRenrenRequest(AuthConfig config) {
        super(config, AuthDefaultSource.RENREN);
    }

    public AuthRenrenRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.RENREN, authStateCache);
    }

    @Override
    protected AuthToken getAccessToken(AuthCallback authCallback) {
        return this.getToken(this.accessTokenUrl(authCallback.getCode()));
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        String response = this.doGetUserInfo(authToken);
        JSONObject userObj = JSONObject.parseObject((String)response).getJSONObject("response");
        return AuthUser.builder().rawUserInfo(userObj).uuid(userObj.getString("id")).avatar(this.getAvatarUrl(userObj)).nickname(userObj.getString("name")).company(this.getCompany(userObj)).gender(this.getGender(userObj)).token(authToken).source(this.source.toString()).build();
    }

    @Override
    public AuthResponse refresh(AuthToken authToken) {
        return AuthResponse.builder().code(AuthResponseStatus.SUCCESS.getCode()).data(this.getToken(this.refreshTokenUrl(authToken.getRefreshToken()))).build();
    }

    private AuthToken getToken(String url) {
        String response = new HttpUtils(this.config.getHttpConfig()).post(url).getBody();
        JSONObject jsonObject = JSONObject.parseObject((String)response);
        if (jsonObject.containsKey((Object)"error")) {
            throw new AuthException("Failed to get token from Renren: " + jsonObject);
        }
        return AuthToken.builder().tokenType(jsonObject.getString("token_type")).expireIn(jsonObject.getIntValue("expires_in")).accessToken(UrlUtil.urlEncode((String)jsonObject.getString("access_token"))).refreshToken(UrlUtil.urlEncode((String)jsonObject.getString("refresh_token"))).openId(jsonObject.getJSONObject("user").getString("id")).build();
    }

    private String getAvatarUrl(JSONObject userObj) {
        JSONArray jsonArray = userObj.getJSONArray("avatar");
        if (Objects.isNull(jsonArray) || jsonArray.isEmpty()) {
            return null;
        }
        return jsonArray.getJSONObject(0).getString("url");
    }

    private AuthUserGender getGender(JSONObject userObj) {
        JSONObject basicInformation = userObj.getJSONObject("basicInformation");
        if (Objects.isNull(basicInformation)) {
            return AuthUserGender.UNKNOWN;
        }
        return AuthUserGender.getRealGender(basicInformation.getString("sex"));
    }

    private String getCompany(JSONObject userObj) {
        JSONArray jsonArray = userObj.getJSONArray("work");
        if (Objects.isNull(jsonArray) || jsonArray.isEmpty()) {
            return null;
        }
        return jsonArray.getJSONObject(0).getString("name");
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return UrlBuilder.fromBaseUrl(this.source.userInfo()).queryParam("access_token", authToken.getAccessToken()).queryParam("userId", authToken.getOpenId()).build();
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl(super.authorize(state)).queryParam("scope", this.getScopes(",", false, AuthScopeUtils.getDefaultScopes(AuthRenrenScope.values()))).build();
    }
}

