/*
 * Decompiled with CFR 0.152.
 */
package com.xingyuv.jushauth.request;

import com.alibaba.fastjson.JSONObject;
import com.xingyuv.jushauth.cache.AuthStateCache;
import com.xingyuv.jushauth.config.AuthConfig;
import com.xingyuv.jushauth.config.AuthDefaultSource;
import com.xingyuv.jushauth.enums.AuthResponseStatus;
import com.xingyuv.jushauth.exception.AuthException;
import com.xingyuv.jushauth.log.Log;
import com.xingyuv.jushauth.model.AuthCallback;
import com.xingyuv.jushauth.model.AuthResponse;
import com.xingyuv.jushauth.model.AuthToken;
import com.xingyuv.jushauth.model.AuthUser;
import com.xingyuv.jushauth.request.AbstractAuthWeChatEnterpriseRequest;
import com.xingyuv.jushauth.utils.AuthChecker;
import com.xingyuv.jushauth.utils.HttpUtils;
import com.xingyuv.jushauth.utils.UrlBuilder;

public class AuthWeChatEnterpriseThirdQrcodeRequest
extends AbstractAuthWeChatEnterpriseRequest {
    public AuthWeChatEnterpriseThirdQrcodeRequest(AuthConfig config) {
        super(config, AuthDefaultSource.WECHAT_ENTERPRISE_QRCODE_THIRD);
    }

    public AuthWeChatEnterpriseThirdQrcodeRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.WECHAT_ENTERPRISE_QRCODE_THIRD, authStateCache);
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl(this.source.authorize()).queryParam("appid", this.config.getClientId()).queryParam("redirect_uri", this.config.getRedirectUri()).queryParam("state", this.getRealState(state)).queryParam("usertype", this.config.getUsertype()).build();
    }

    @Override
    public AuthResponse login(AuthCallback authCallback) {
        try {
            if (!this.config.isIgnoreCheckState()) {
                AuthChecker.checkState(authCallback.getState(), this.source, this.authStateCache);
            }
            AuthToken authToken = this.getAccessToken(authCallback);
            AuthUser user = this.getUserInfo(authToken);
            return AuthResponse.builder().code(AuthResponseStatus.SUCCESS.getCode()).data(user).build();
        }
        catch (Exception e) {
            Log.error("Failed to login with oauth authorization.", e);
            return this.responseError(e);
        }
    }

    @Override
    protected AuthToken getAccessToken(AuthCallback authCallback) {
        try {
            String response = this.doGetAuthorizationCode(this.accessTokenUrl());
            JSONObject object = this.checkResponse(response);
            AuthToken authToken = AuthToken.builder().accessToken(object.getString("provider_access_token")).expireIn(object.getIntValue("expires_in")).build();
            return authToken;
        }
        catch (Exception e) {
            throw new AuthException("\u4f01\u4e1a\u5fae\u4fe1\u83b7\u53d6token\u5931\u8d25", e);
        }
    }

    @Override
    protected String doGetAuthorizationCode(String code) {
        JSONObject data = new JSONObject();
        data.put("corpid", (Object)this.config.getClientId());
        data.put("provider_secret", (Object)this.config.getClientSecret());
        return new HttpUtils(this.config.getHttpConfig()).post(this.accessTokenUrl(code), data.toJSONString()).getBody();
    }

    protected String accessTokenUrl() {
        return UrlBuilder.fromBaseUrl(this.source.accessToken()).build();
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        JSONObject response = this.checkResponse(this.doGetUserInfo(authToken));
        return AuthUser.builder().rawUserInfo(response).build();
    }

    @Override
    protected String doGetUserInfo(AuthToken authToken) {
        JSONObject data = new JSONObject();
        data.put("auth_code", (Object)authToken.getCode());
        return new HttpUtils(this.config.getHttpConfig()).post(this.userInfoUrl(authToken), data.toJSONString()).getBody();
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return UrlBuilder.fromBaseUrl(this.source.userInfo()).queryParam("access_token", authToken.getAccessToken()).build();
    }

    private JSONObject checkResponse(String response) {
        JSONObject object = JSONObject.parseObject((String)response);
        if (object.containsKey((Object)"errcode") && object.getIntValue("errcode") != 0) {
            throw new AuthException(object.getString("errmsg"), this.source);
        }
        return object;
    }
}

