/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.remoting.invoker.reference;

import com.xxl.rpc.remoting.invoker.XxlRpcInvokerFactory;
import com.xxl.rpc.remoting.invoker.call.CallType;
import com.xxl.rpc.remoting.invoker.call.XxlRpcInvokeCallback;
import com.xxl.rpc.remoting.invoker.call.XxlRpcInvokeFuture;
import com.xxl.rpc.remoting.invoker.generic.XxlRpcGenericService;
import com.xxl.rpc.remoting.invoker.route.LoadBalance;
import com.xxl.rpc.remoting.net.Client;
import com.xxl.rpc.remoting.net.NetEnum;
import com.xxl.rpc.remoting.net.params.XxlRpcFutureResponse;
import com.xxl.rpc.remoting.net.params.XxlRpcRequest;
import com.xxl.rpc.remoting.net.params.XxlRpcResponse;
import com.xxl.rpc.remoting.provider.XxlRpcProviderFactory;
import com.xxl.rpc.serialize.Serializer;
import com.xxl.rpc.util.ClassUtil;
import com.xxl.rpc.util.XxlRpcException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XxlRpcReferenceBean {
    private static final Logger logger = LoggerFactory.getLogger(XxlRpcReferenceBean.class);
    private NetEnum netType;
    private Serializer serializer;
    private CallType callType;
    private LoadBalance loadBalance;
    private Class<?> iface;
    private String version;
    private long timeout = 1000L;
    private String address;
    private String accessToken;
    private XxlRpcInvokeCallback invokeCallback;
    private XxlRpcInvokerFactory invokerFactory;
    Client client = null;

    public XxlRpcReferenceBean(NetEnum netType, Serializer serializer, CallType callType, LoadBalance loadBalance, Class<?> iface, String version, long timeout, String address, String accessToken, XxlRpcInvokeCallback invokeCallback, XxlRpcInvokerFactory invokerFactory) {
        this.netType = netType;
        this.serializer = serializer;
        this.callType = callType;
        this.loadBalance = loadBalance;
        this.iface = iface;
        this.version = version;
        this.timeout = timeout;
        this.address = address;
        this.accessToken = accessToken;
        this.invokeCallback = invokeCallback;
        this.invokerFactory = invokerFactory;
        if (this.netType == null) {
            throw new XxlRpcException("xxl-rpc reference netType missing.");
        }
        if (this.serializer == null) {
            throw new XxlRpcException("xxl-rpc reference serializer missing.");
        }
        if (this.callType == null) {
            throw new XxlRpcException("xxl-rpc reference callType missing.");
        }
        if (this.loadBalance == null) {
            throw new XxlRpcException("xxl-rpc reference loadBalance missing.");
        }
        if (this.iface == null) {
            throw new XxlRpcException("xxl-rpc reference iface missing.");
        }
        if (this.timeout < 0L) {
            this.timeout = 0L;
        }
        if (this.invokerFactory == null) {
            this.invokerFactory = XxlRpcInvokerFactory.getInstance();
        }
        this.initClient();
    }

    public Serializer getSerializer() {
        return this.serializer;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public XxlRpcInvokerFactory getInvokerFactory() {
        return this.invokerFactory;
    }

    private void initClient() {
        try {
            this.client = this.netType.clientClass.newInstance();
            this.client.init(this);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new XxlRpcException(e);
        }
    }

    public Object getObject() {
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{this.iface}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String className = method.getDeclaringClass().getName();
                String varsion_ = XxlRpcReferenceBean.this.version;
                String methodName = method.getName();
                Class<?>[] parameterTypes = method.getParameterTypes();
                Object[] parameters = args;
                if (className.equals(XxlRpcGenericService.class.getName()) && methodName.equals("invoke")) {
                    String[] paramTypes_str;
                    Class[] paramTypes = null;
                    if (args[3] != null && (paramTypes_str = (String[])args[3]).length > 0) {
                        paramTypes = new Class[paramTypes_str.length];
                        for (int i = 0; i < paramTypes_str.length; ++i) {
                            paramTypes[i] = ClassUtil.resolveClass(paramTypes_str[i]);
                        }
                    }
                    className = (String)args[0];
                    varsion_ = (String)args[1];
                    methodName = (String)args[2];
                    parameterTypes = paramTypes;
                    parameters = (Object[])args[4];
                }
                if (className.equals(Object.class.getName())) {
                    logger.info(">>>>>>>>>>> xxl-rpc proxy class-method not support [{}#{}]", (Object)className, (Object)methodName);
                    throw new XxlRpcException("xxl-rpc proxy class-method not support");
                }
                String finalAddress = XxlRpcReferenceBean.this.address;
                if ((finalAddress == null || finalAddress.trim().length() == 0) && XxlRpcReferenceBean.this.invokerFactory != null && XxlRpcReferenceBean.this.invokerFactory.getServiceRegistry() != null) {
                    String serviceKey = XxlRpcProviderFactory.makeServiceKey(className, varsion_);
                    TreeSet<String> addressSet = XxlRpcReferenceBean.this.invokerFactory.getServiceRegistry().discovery(serviceKey);
                    if (addressSet != null && addressSet.size() != 0) {
                        finalAddress = addressSet.size() == 1 ? addressSet.first() : ((XxlRpcReferenceBean)XxlRpcReferenceBean.this).loadBalance.xxlRpcInvokerRouter.route(serviceKey, addressSet);
                    }
                }
                if (finalAddress == null || finalAddress.trim().length() == 0) {
                    throw new XxlRpcException("xxl-rpc reference bean[" + className + "] address empty");
                }
                XxlRpcRequest xxlRpcRequest = new XxlRpcRequest();
                xxlRpcRequest.setRequestId(UUID.randomUUID().toString());
                xxlRpcRequest.setCreateMillisTime(System.currentTimeMillis());
                xxlRpcRequest.setAccessToken(XxlRpcReferenceBean.this.accessToken);
                xxlRpcRequest.setClassName(className);
                xxlRpcRequest.setMethodName(methodName);
                xxlRpcRequest.setParameterTypes(parameterTypes);
                xxlRpcRequest.setParameters(parameters);
                if (CallType.SYNC == XxlRpcReferenceBean.this.callType) {
                    XxlRpcFutureResponse futureResponse = new XxlRpcFutureResponse(XxlRpcReferenceBean.this.invokerFactory, xxlRpcRequest, null);
                    try {
                        XxlRpcReferenceBean.this.client.asyncSend(finalAddress, xxlRpcRequest);
                        XxlRpcResponse xxlRpcResponse = futureResponse.get(XxlRpcReferenceBean.this.timeout, TimeUnit.MILLISECONDS);
                        if (xxlRpcResponse.getErrorMsg() != null) {
                            throw new XxlRpcException(xxlRpcResponse.getErrorMsg());
                        }
                        Object object = xxlRpcResponse.getResult();
                        return object;
                    }
                    catch (Exception e) {
                        logger.info(">>>>>>>>>>> xxl-rpc, invoke error, address:{}, XxlRpcRequest{}", (Object)finalAddress, (Object)xxlRpcRequest);
                        throw e instanceof XxlRpcException ? e : new XxlRpcException(e);
                    }
                    finally {
                        futureResponse.removeInvokerFuture();
                    }
                }
                if (CallType.FUTURE == XxlRpcReferenceBean.this.callType) {
                    XxlRpcFutureResponse futureResponse = new XxlRpcFutureResponse(XxlRpcReferenceBean.this.invokerFactory, xxlRpcRequest, null);
                    try {
                        XxlRpcInvokeFuture invokeFuture = new XxlRpcInvokeFuture(futureResponse);
                        XxlRpcInvokeFuture.setFuture(invokeFuture);
                        XxlRpcReferenceBean.this.client.asyncSend(finalAddress, xxlRpcRequest);
                        return null;
                    }
                    catch (Exception e) {
                        logger.info(">>>>>>>>>>> xxl-rpc, invoke error, address:{}, XxlRpcRequest{}", (Object)finalAddress, (Object)xxlRpcRequest);
                        futureResponse.removeInvokerFuture();
                        throw e instanceof XxlRpcException ? e : new XxlRpcException(e);
                    }
                }
                if (CallType.CALLBACK == XxlRpcReferenceBean.this.callType) {
                    XxlRpcInvokeCallback finalInvokeCallback = XxlRpcReferenceBean.this.invokeCallback;
                    XxlRpcInvokeCallback threadInvokeCallback = XxlRpcInvokeCallback.getCallback();
                    if (threadInvokeCallback != null) {
                        finalInvokeCallback = threadInvokeCallback;
                    }
                    if (finalInvokeCallback == null) {
                        throw new XxlRpcException("xxl-rpc XxlRpcInvokeCallback\uff08CallType=" + CallType.CALLBACK.name() + "\uff09 cannot be null.");
                    }
                    XxlRpcFutureResponse futureResponse = new XxlRpcFutureResponse(XxlRpcReferenceBean.this.invokerFactory, xxlRpcRequest, finalInvokeCallback);
                    try {
                        XxlRpcReferenceBean.this.client.asyncSend(finalAddress, xxlRpcRequest);
                    }
                    catch (Exception e) {
                        logger.info(">>>>>>>>>>> xxl-rpc, invoke error, address:{}, XxlRpcRequest{}", (Object)finalAddress, (Object)xxlRpcRequest);
                        futureResponse.removeInvokerFuture();
                        throw e instanceof XxlRpcException ? e : new XxlRpcException(e);
                    }
                    return null;
                }
                if (CallType.ONEWAY == XxlRpcReferenceBean.this.callType) {
                    XxlRpcReferenceBean.this.client.asyncSend(finalAddress, xxlRpcRequest);
                    return null;
                }
                throw new XxlRpcException("xxl-rpc callType[" + (Object)((Object)XxlRpcReferenceBean.this.callType) + "] invalid");
            }
        });
    }

    public Class<?> getObjectType() {
        return this.iface;
    }
}

