/*
 * Decompiled with CFR 0.152.
 */
package oms.com.base.server.common.constants;

import java.io.Serializable;
import jodd.util.StringUtil;
import oms.com.base.server.common.enums.ReturnCodeEnum;

public class Result<T>
implements Serializable {
    private int code;
    private String msg;
    private T data;

    public Result() {
    }

    public Result(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Result(int code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public Result(ReturnCodeEnum returnCodeEnum) {
        this.code = returnCodeEnum.getValue();
        this.msg = returnCodeEnum.getDisplay();
    }

    public Result(ReturnCodeEnum returnCodeEnum, String msg, T data) {
        this.code = returnCodeEnum.getValue();
        this.msg = StringUtil.isNotBlank((String)msg) ? msg : returnCodeEnum.getDisplay();
    }

    public Result(ReturnCodeEnum returnCodeEnum, T data) {
        this.code = returnCodeEnum.getValue();
        this.msg = returnCodeEnum.getDisplay();
        this.data = data;
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "Result(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ")";
    }
}

