/*
 * Decompiled with CFR 0.152.
 */
package oms.com.base.server.common.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import oms.com.base.server.common.enums.OrderConditionsEnum;
import oms.com.base.server.common.utils.StringUtil;

@ApiModel(value="pillDto")
public class BillDto
implements Serializable {
    @ApiModelProperty(hidden=true)
    private OrderConditionsEnum.OrderStatusCollectionEnum orderStatus = OrderConditionsEnum.OrderStatusCollectionEnum.ALL;
    @ApiModelProperty(hidden=true)
    private OrderConditionsEnum.OrderTimeEnum orderTime = OrderConditionsEnum.OrderTimeEnum.ARRIVE_TIME;
    @ApiModelProperty(hidden=true)
    private OrderConditionsEnum.OrderSortEnum sort = OrderConditionsEnum.OrderSortEnum.SORT_ARRIVETIME_ASC;
    @ApiModelProperty(hidden=true)
    private String shopIds = "";
    @ApiModelProperty(name="startTime", value="\u5f00\u59cb\u65f6\u95f4", required=true, dataType="String")
    private String startTime = "";
    @ApiModelProperty(name="endTime", value="\u7ed3\u675f\u65f6\u95f4", required=true, dataType="String")
    private String endTime = "";
    @ApiModelProperty(name="poiId", value="\u5e97\u94fapoiId", required=false, dataType="string")
    private String poiId = "";
    @ApiModelProperty(name="channelId", value="\u6e20\u9053id", required=false, dataType="Integer")
    private Integer channelId = 0;
    @ApiModelProperty(name="selectText", value="\u8ba2\u5355\u5e8f\u53f7\uff0c\u8ba2\u5355\u53f7\uff0c\u624b\u673a\uff0c\u59d3\u540d", required=false, dataType="String")
    private String selectText = "";
    @ApiModelProperty(name="pageIndex", value="\u9875\u7801", required=false, dataType="Integer")
    private Integer pageIndex = 1;
    @ApiModelProperty(name="pageSize", value="\u6bcf\u9875\u6570\u91cf", required=false, dataType="Integer")
    private Integer pageSize = 20;
    @ApiModelProperty(name="tenantId", value="\u79df\u6237", required=false, dataType="Long")
    private Long tenantId = 0L;
    @ApiModelProperty(name="type", value="\u8ba2\u5355\u7c7b\u578b", required=false, dataType="String")
    private String type = "";
    @ApiModelProperty(name="channelIds", value="\u6e20\u9053", required=false, dataType="string")
    private String channelIds = "";

    public String getStartTime() {
        if (StringUtil.isNotBlank(this.startTime)) {
            return this.startTime + " 00:00:00";
        }
        return this.startTime;
    }

    public String getEndTime() {
        if (StringUtil.isNotBlank(this.endTime)) {
            Calendar c = Calendar.getInstance();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            Date endTime = null;
            try {
                endTime = df.parse(this.endTime);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            c.setTime(endTime);
            c.add(5, 1);
            endTime = c.getTime();
            return df.format(endTime);
        }
        return this.endTime;
    }

    public OrderConditionsEnum.OrderStatusCollectionEnum getOrderStatus() {
        return this.orderStatus;
    }

    public OrderConditionsEnum.OrderTimeEnum getOrderTime() {
        return this.orderTime;
    }

    public OrderConditionsEnum.OrderSortEnum getSort() {
        return this.sort;
    }

    public String getShopIds() {
        return this.shopIds;
    }

    public String getPoiId() {
        return this.poiId;
    }

    public Integer getChannelId() {
        return this.channelId;
    }

    public String getSelectText() {
        return this.selectText;
    }

    public Integer getPageIndex() {
        return this.pageIndex;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Long getTenantId() {
        return this.tenantId;
    }

    public String getType() {
        return this.type;
    }

    public String getChannelIds() {
        return this.channelIds;
    }

    public void setOrderStatus(OrderConditionsEnum.OrderStatusCollectionEnum orderStatus) {
        this.orderStatus = orderStatus;
    }

    public void setOrderTime(OrderConditionsEnum.OrderTimeEnum orderTime) {
        this.orderTime = orderTime;
    }

    public void setSort(OrderConditionsEnum.OrderSortEnum sort) {
        this.sort = sort;
    }

    public void setShopIds(String shopIds) {
        this.shopIds = shopIds;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public void setPoiId(String poiId) {
        this.poiId = poiId;
    }

    public void setChannelId(Integer channelId) {
        this.channelId = channelId;
    }

    public void setSelectText(String selectText) {
        this.selectText = selectText;
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setChannelIds(String channelIds) {
        this.channelIds = channelIds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BillDto)) {
            return false;
        }
        BillDto other = (BillDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OrderConditionsEnum.OrderStatusCollectionEnum this$orderStatus = this.getOrderStatus();
        OrderConditionsEnum.OrderStatusCollectionEnum other$orderStatus = other.getOrderStatus();
        if (this$orderStatus == null ? other$orderStatus != null : !this$orderStatus.equals(other$orderStatus)) {
            return false;
        }
        OrderConditionsEnum.OrderTimeEnum this$orderTime = this.getOrderTime();
        OrderConditionsEnum.OrderTimeEnum other$orderTime = other.getOrderTime();
        if (this$orderTime == null ? other$orderTime != null : !this$orderTime.equals(other$orderTime)) {
            return false;
        }
        OrderConditionsEnum.OrderSortEnum this$sort = this.getSort();
        OrderConditionsEnum.OrderSortEnum other$sort = other.getSort();
        if (this$sort == null ? other$sort != null : !this$sort.equals(other$sort)) {
            return false;
        }
        String this$shopIds = this.getShopIds();
        String other$shopIds = other.getShopIds();
        if (this$shopIds == null ? other$shopIds != null : !this$shopIds.equals(other$shopIds)) {
            return false;
        }
        String this$startTime = this.getStartTime();
        String other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !this$startTime.equals(other$startTime)) {
            return false;
        }
        String this$endTime = this.getEndTime();
        String other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !this$endTime.equals(other$endTime)) {
            return false;
        }
        String this$poiId = this.getPoiId();
        String other$poiId = other.getPoiId();
        if (this$poiId == null ? other$poiId != null : !this$poiId.equals(other$poiId)) {
            return false;
        }
        Integer this$channelId = this.getChannelId();
        Integer other$channelId = other.getChannelId();
        if (this$channelId == null ? other$channelId != null : !((Object)this$channelId).equals(other$channelId)) {
            return false;
        }
        String this$selectText = this.getSelectText();
        String other$selectText = other.getSelectText();
        if (this$selectText == null ? other$selectText != null : !this$selectText.equals(other$selectText)) {
            return false;
        }
        Integer this$pageIndex = this.getPageIndex();
        Integer other$pageIndex = other.getPageIndex();
        if (this$pageIndex == null ? other$pageIndex != null : !((Object)this$pageIndex).equals(other$pageIndex)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        Long this$tenantId = this.getTenantId();
        Long other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$channelIds = this.getChannelIds();
        String other$channelIds = other.getChannelIds();
        return !(this$channelIds == null ? other$channelIds != null : !this$channelIds.equals(other$channelIds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BillDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OrderConditionsEnum.OrderStatusCollectionEnum $orderStatus = this.getOrderStatus();
        result = result * 59 + ($orderStatus == null ? 43 : $orderStatus.hashCode());
        OrderConditionsEnum.OrderTimeEnum $orderTime = this.getOrderTime();
        result = result * 59 + ($orderTime == null ? 43 : $orderTime.hashCode());
        OrderConditionsEnum.OrderSortEnum $sort = this.getSort();
        result = result * 59 + ($sort == null ? 43 : $sort.hashCode());
        String $shopIds = this.getShopIds();
        result = result * 59 + ($shopIds == null ? 43 : $shopIds.hashCode());
        String $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : $startTime.hashCode());
        String $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : $endTime.hashCode());
        String $poiId = this.getPoiId();
        result = result * 59 + ($poiId == null ? 43 : $poiId.hashCode());
        Integer $channelId = this.getChannelId();
        result = result * 59 + ($channelId == null ? 43 : ((Object)$channelId).hashCode());
        String $selectText = this.getSelectText();
        result = result * 59 + ($selectText == null ? 43 : $selectText.hashCode());
        Integer $pageIndex = this.getPageIndex();
        result = result * 59 + ($pageIndex == null ? 43 : ((Object)$pageIndex).hashCode());
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        Long $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $channelIds = this.getChannelIds();
        result = result * 59 + ($channelIds == null ? 43 : $channelIds.hashCode());
        return result;
    }

    public String toString() {
        return "BillDto(orderStatus=" + this.getOrderStatus() + ", orderTime=" + this.getOrderTime() + ", sort=" + this.getSort() + ", shopIds=" + this.getShopIds() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", poiId=" + this.getPoiId() + ", channelId=" + this.getChannelId() + ", selectText=" + this.getSelectText() + ", pageIndex=" + this.getPageIndex() + ", pageSize=" + this.getPageSize() + ", tenantId=" + this.getTenantId() + ", type=" + this.getType() + ", channelIds=" + this.getChannelIds() + ")";
    }
}

