/*
 * Decompiled with CFR 0.152.
 */
package oms.com.base.server.common.enums;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public enum OrderStatus implements Serializable
{
    DELETE(-1, "", 0, 0, "\u5220\u9664", "#ED4C4C", "\u5220\u9664", 0, 0),
    IDLE(0, "", 0, 0, "\u95f2\u7f6e", "#ED4C4C", "\u95f2\u7f6e", 0, 0),
    NO_PAY(1, "pending", 0, 0, "\u672a\u652f\u4ed8", "#FFC321", "\u5f85\u652f\u4ed8", 0, 0),
    NO_RECEIVING(2, "unprocessed", 1, 2, "\u672a\u63a5\u5355", "#FFC321", "\u5f85\u63a5\u5355", 0, 0),
    ADMIN_RECEIVE(2, "", 0, 3, "\u672a\u63a5\u5355", "#FFC321", "\u5f85\u63a5\u5355", 0, 0),
    WAIT_EXCHANGE(101, "", 0, 0, "\u7b49\u5f85\u7528\u6237\u5151\u6362", "#FFC321", "\u5f85\u5151\u6362", 0, 0),
    ALREADY_PAY_DEPOSIT_PRICE(111, "unprocessed", 1, 2, "\u5df2\u652f\u4ed8\u5b9a\u91d1", "#FFC321", "\u5df2\u652f\u4ed8\u5b9a\u91d1", 0, 0),
    ADMIN_RECEIVING(300, "valid", 5, 4, "\u5546\u5bb6\u63a5\u5355", "#1296DB", "\u5546\u5bb6\u63a5\u5355", 0, 0),
    ADMIN_REJECTED(310, "", 0, 0, "\u5546\u5bb6\u62d2\u5355", "#ED4C4C", "\u5df2\u62d2\u5355", 0, 0),
    REPOSITORY_RECEIVE(340, "", 0, 0, "\u4f9b\u5e94\u94fe\u672a\u63a5\u5355", "#1296DB", "\u4f9b\u5e94\u94fe\u672a\u63a5\u5355", 0, 0),
    SUPPLY_RECEIVING(350, "", 0, 0, "\u4f9b\u5e94\u94fe\u63a5\u5355", "#1296DB", "\u4f9b\u5e94\u94fe\u63a5\u5355", 0, 0),
    FACTORY_RECEIVING(400, "", 0, 0, "\u5de5\u5382\u63a5\u5355", "#1296DB", "\u5de5\u5382\u63a5\u5355", 0, 0),
    DELIVERY_TOBEASSIGNEDCOURIER(500, "tobeAssignedCourier", 0, 0, "\u5f85\u5206\u914d\uff08\u914d\u9001\u7cfb\u7edf\u5df2\u63a5\u5355\uff0c\u5f85\u5206\u914d\u914d\u9001\u5458\uff09", "#FFC321", "\u5f85\u914d\u9001", 20, 1),
    DELIVERY_TOBEFETCHED(501, "tobeFetched", 7, 0, "\u5f85\u53d6\u9910\uff08\u5df2\u5206\u914d\u7ed9\u914d\u9001\u5458\uff0c\u914d\u9001\u5458\u672a\u53d6\u9910\uff09", "#1296DB", "\u5f85\u53d6\u9910", 30, 3),
    DELIVERY_TOBEASSIGNEDMERCHANT(502, "tobeAssignedMerchant", 0, 0, "\u5df2\u5230\u5e97", "#FFC321", "\u5df2\u5230\u5e97", 42, 4),
    DELIVERY_DELIVERING(503, "delivering", 8, 6, "\u914d\u9001\u4e2d\uff08\u914d\u9001\u5458\u5df2\u53d6\u9910\uff0c\u6b63\u5728\u914d\u9001\uff09", "#1296DB", "\u914d\u9001\u4e2d", 44, 5),
    DELIVERY_COMPLETED(504, "completed", 0, 0, "\u914d\u9001\u6210\u529f\uff08\u914d\u9001\u5458\u914d\u9001\u5b8c\u6210\uff09", "#1296DB", "\u914d\u9001\u6210\u529f", 60, 10),
    DELIVERY_CANCELLED(505, "cancelled", 0, 0, "\u914d\u9001\u53d6\u6d88\uff08\u5546\u5bb6\u53ef\u4ee5\u91cd\u65b0\u53d1\u8d77\u914d\u9001\uff09", "#FFC321", "\u914d\u9001\u53d6\u6d88", 64, -1),
    CANCEL_APPLIED(600, "", 0, 1, "\u7528\u6237\u7533\u8bf7\u53d6\u6d88\u5355", "#ED4C4C", "\u7533\u8bf7\u53d6\u6d88", 0, 0),
    CANCEL_CANCEL(601, "", 0, 0, "\u7528\u6237\u53d6\u6d88\u53d6\u6d88\u5355\u7533\u8bf7", "#ED4C4C", "\u64a4\u9500\u53d6\u6d88\u7533\u8bf7", 0, 0),
    CANCEL_REJECTED(602, "", 0, 0, "\u5546\u6237\u62d2\u7edd\u53d6\u6d88\u5355", "#ED4C4C", "\u62d2\u7edd\u53d6\u6d88", 0, 0),
    CANCEL_AGREE(603, "", 0, 0, "\u5546\u6237\u540c\u610f\u53d6\u6d88\u5355", "#ED4C4C", "\u5df2\u53d6\u6d88", 0, 0),
    CANCEL_ARBITRATING(604, "", 0, 0, "\u7528\u6237\u7533\u8bf7\u4ef2\u88c1\u53d6\u6d88\u5355", "#ED4C4C", "\u7533\u8bf7\u53d6\u6d88", 0, 0),
    CANCEL_SUCCESSFUL(605, "", 0, 0, "\u7528\u6237\u7533\u8bf7\u53d6\u6d88\u5355\u6210\u529f", "#ED4C4C", "\u5df2\u53d6\u6d88", 0, 0),
    CANCEL_FAILED(606, "", 0, 0, "\u7528\u6237\u7533\u8bf7\u53d6\u6d88\u5355\u5931\u8d25", "#ED4C4C", "\u53d6\u6d88\u5931\u8d25", 0, 0),
    SUCCESSFUL(700, "settled", 9, 8, "\u8ba2\u5355\u5b8c\u6210", "#45BF3B", "\u5df2\u5b8c\u6210", 0, 0),
    REFUND_NO_REFUND(710, "noRefund", 0, 0, "\u672a\u7533\u8bf7\u9000\u5355", "#45BF3B", "\u5df2\u5b8c\u6210", 0, 0),
    REFUND_APPLIED(711, "applied", 0, 0, "\u7528\u6237\u7533\u8bf7\u9000\u5355", "#ED4C4C", "\u7533\u8bf7\u9000\u5355", 0, 0),
    REFUND_CANCEL(712, "", 0, 0, "\u7528\u6237\u53d6\u6d88\u9000\u5355", "#ED4C4C", "\u64a4\u9500\u9000\u5355\u7533\u8bf7", 0, 0),
    REFUND_REJECTED(713, "rejected", 0, 0, "\u5546\u5bb6\u62d2\u63a5\u9000\u5355", "#ED4C4C", "\u62d2\u7edd\u9000\u5355", 0, 0),
    REFUND_AGREE(714, "", 0, 0, "\u5546\u5bb6\u540c\u610f\u9000\u5355", "#ED4C4C", "\u5df2\u9000\u5355", 0, 0),
    REFUND_ARBITRATING(715, "arbitrating", 0, 0, "\u5ba2\u670d\u4ef2\u88c1\u4e2d", "#ED4C4C", "\u7533\u8bf7\u9000\u5355", 0, 0),
    REFUND_FAILED(716, "failed", 0, 0, "\u9000\u5355\u5931\u8d25", "#ED4C4C", "\u9000\u5355\u5931\u8d25", 0, 0),
    REFUND_SUCCESSFUL(717, "successful", 0, 0, "\u9000\u5355\u6210\u529f", "#ED4C4C", "\u5df2\u9000\u5355", 0, 0),
    CANCEL_ORDER(750, "invalid", 10, 9, "\u8ba2\u5355\u53d6\u6d88", "#ED4C4C", "\u5df2\u53d6\u6d88", 0, 0),
    NO_PAY_CANCEL_ORDER(755, "invalid", 10, 9, "\u672a\u652f\u4ed8\u8ba2\u5355\u53d6\u6d88", "#ED4C4C", "\u5df2\u53d6\u6d88", 0, 0),
    HAS_REFUND_PAY(760, "invalid", 10, 9, "\u5df2\u9000\u6b3e", "#ED4C4C", "\u5df2\u9000\u6b3e", 0, 0),
    DEPOSIT_HAS_REFUND_PAY(761, "invalid", 10, 9, "\u5b9a\u91d1\u5df2\u9000\u6b3e", "#ED4C4C", "\u5b9a\u91d1\u5df2\u9000\u6b3e", 0, 0),
    FINANCE_RECORDED(800, "", 0, 0, "", "#45BF3B", "\u5df2\u5165\u8d26", 0, 0),
    WITHDRAWING(810, "", 0, 0, "", "#45BF3B", "\u63d0\u73b0\u4e2d", 0, 0),
    WITHDRAWED(820, "", 0, 0, "", "#45BF3B", "\u63d0\u73b0\u5b8c\u6210", 0, 0);

    private int code;
    private String elmCode;
    private int bdCode;
    private int mtwmCode;
    private String msg;
    private String color;
    private String title;
    private int ssCode;
    private int uuCode;

    private OrderStatus(int code, String elmCode, int bdCode, int mtwmCode, String msg, String color, String title, int ssCode, int uuCode) {
        this.code = code;
        this.msg = msg;
        this.elmCode = elmCode;
        this.bdCode = bdCode;
        this.mtwmCode = mtwmCode;
        this.color = color;
        this.title = title;
        this.ssCode = ssCode;
        this.uuCode = uuCode;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getElmCode() {
        return this.elmCode;
    }

    public void setElmCode(String elmCode) {
        this.elmCode = elmCode;
    }

    public int getBdCode() {
        return this.bdCode;
    }

    public void setBdCode(int bdCode) {
        this.bdCode = bdCode;
    }

    public int getMtwmCode() {
        return this.mtwmCode;
    }

    public void setMtwmCode(int mtwmCode) {
        this.mtwmCode = mtwmCode;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getSsCode() {
        return this.ssCode;
    }

    public void setSsCode(int ssCode) {
        this.ssCode = ssCode;
    }

    public int getUuCode() {
        return this.uuCode;
    }

    public void setUuCode(int uuCode) {
        this.uuCode = uuCode;
    }

    public static OrderStatus getByCode(int code) {
        for (OrderStatus c : OrderStatus.values()) {
            if (c.getCode() != code) continue;
            return c;
        }
        return IDLE;
    }

    public static String getUnavailableCodes() {
        return DELETE.getCode() + "," + IDLE.getCode() + "," + NO_PAY.getCode() + "," + NO_PAY_CANCEL_ORDER.getCode() + "," + ALREADY_PAY_DEPOSIT_PRICE.getCode();
    }

    public static String getAvailableCodes() {
        ArrayList<String> availableCodes = new ArrayList<String>();
        ArrayList unavailableCodes = Lists.newArrayList((Object[])OrderStatus.getUnavailableCodes().split(","));
        for (OrderStatus c : OrderStatus.values()) {
            if (unavailableCodes.contains(String.valueOf(c.getCode()))) continue;
            availableCodes.add(String.valueOf(c.getCode()));
        }
        return StringUtils.join(availableCodes, (String)",");
    }

    public static OrderStatus getByElemeCode(String elmecode) {
        for (OrderStatus c : OrderStatus.values()) {
            if (!c.getElmCode().equals(elmecode)) continue;
            return c;
        }
        return IDLE;
    }

    public static OrderStatus getByBDWMCode(int bdcode) {
        for (OrderStatus c : OrderStatus.values()) {
            if (c.getBdCode() != bdcode) continue;
            return c;
        }
        return IDLE;
    }

    public static OrderStatus getByWTWMCode(int mtwmcode) {
        for (OrderStatus c : OrderStatus.values()) {
            if (c.getMtwmCode() != mtwmcode) continue;
            return c;
        }
        return IDLE;
    }

    public static OrderStatus getBySsCode(int ssCode) {
        for (OrderStatus c : OrderStatus.values()) {
            if (c.getSsCode() != ssCode) continue;
            return c;
        }
        return IDLE;
    }

    public static OrderStatus getByUuCode(int uuCode) {
        for (OrderStatus c : OrderStatus.values()) {
            if (c.getUuCode() != uuCode) continue;
            return c;
        }
        return IDLE;
    }
}

