/*
 * Decompiled with CFR 0.152.
 */
package oms.com.base.server.common.enums;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import oms.com.base.server.common.enums.IBaseEnum;

public enum PoiTypeEnum implements IBaseEnum,
Serializable
{
    POI_TYPE_DIRECT(1, "1"),
    POI_TYPE_FRANCHISE(2, "2"),
    POI_TYPE_FACTORY(3, "3"),
    POI_TYPE_SHOP(5, POI_TYPE_DIRECT.getValue() + "," + POI_TYPE_FRANCHISE.getValue()),
    POI_TYPE_ALL(0, POI_TYPE_DIRECT.getValue() + "," + POI_TYPE_FRANCHISE.getValue() + "," + POI_TYPE_FACTORY.getValue());

    private Integer value;
    private String display;
    private static Map<Integer, PoiTypeEnum> valueMap;

    private PoiTypeEnum(Integer value, String display) {
        this.value = value;
        this.display = display;
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    @Override
    public String getDisplay() {
        return this.display;
    }

    public static PoiTypeEnum getByValue(Integer value) {
        PoiTypeEnum result = valueMap.get(value);
        if (result == null) {
            throw new IllegalArgumentException("No element matches " + value);
        }
        return result;
    }

    static {
        valueMap = new HashMap<Integer, PoiTypeEnum>();
        for (PoiTypeEnum e : PoiTypeEnum.values()) {
            valueMap.put(e.value, e);
        }
    }
}

