/*
 * Decompiled with CFR 0.152.
 */
package oms.com.base.server.common.enums.goeasy;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import oms.com.base.server.common.enums.BusinessTypeEnum;
import oms.com.base.server.common.enums.IBaseEnum;

public enum MessagePushTypeEnum implements IBaseEnum,
Serializable
{
    TYPE_ORDER(1, "\u8ba2\u5355", BusinessTypeEnum.SHOP_ORDER_BUSINESS),
    TYPE_REPLENISHMENT(2, "\u8865\u8d27\u5355", BusinessTypeEnum.SHOP_ORDER_BUSINESS),
    TYPE_ORDER_CANNEL(3, "\u53d6\u6d88\u5355", BusinessTypeEnum.SHOP_ORDER_BUSINESS),
    TYPE_ORDER_MODIFY(4, "\u8ba2\u5355\u4fee\u6539", BusinessTypeEnum.SHOP_ORDER_BUSINESS),
    TYPE_CHANGE_ORDER(5, "\u8f6c\u5de5\u5382\u8ba2\u5355", BusinessTypeEnum.SHOP_ORDER_BUSINESS),
    TYPE_AUTORECEIVED_ORDER(6, "\u81ea\u52a8\u63a5\u5355", BusinessTypeEnum.SHOP_ORDER_BUSINESS),
    TYPE_ORDER_CANNEL_BY_CUSTOM(7, "\u987e\u5ba2\u53d6\u6d88\u8ba2\u5355", BusinessTypeEnum.SHOP_ORDER_BUSINESS),
    TYPE_APPLY_ORDER_CANNEL_BY_CUSTOM(8, "\u987e\u5ba2\u7533\u8bf7\u53d6\u6d88\u8ba2\u5355", BusinessTypeEnum.SHOP_ORDER_BUSINESS),
    TYPE_REPL_CANCEL(9, "\u53d6\u6d88\u8865\u8d27\u5355", BusinessTypeEnum.SHOP_ORDER_BUSINESS),
    TYPE_ORDER_TIMEOUT_NOTIFY(11, "\u8ba2\u5355\u8d85\u65f6\u63d0\u9192", BusinessTypeEnum.SHOP_ORDER_BUSINESS),
    TYPE_COMMODITYSYNC_SPU(10, "\u5546\u54c1\u540c\u6b65", BusinessTypeEnum.GOODS_BUSINESS),
    TYPE_LOGISTICS_TTYCFH(20, "\u7269\u6d41\u59a5\u6295\u5f02\u5e38", BusinessTypeEnum.DELIVERY_BUSINESS),
    TYPE_LOGISTICS_QSQX(30, "\u9a91\u58eb\u53d6\u6d88\u8ba2\u5355", BusinessTypeEnum.DELIVERY_BUSINESS),
    TYPE_STOCK_CKDSC(101, "\u51fa\u5e93\u5355\u751f\u6210", BusinessTypeEnum.REPOSITORY_GOODS_BUSINESS),
    TYPE_STOCK_CKDQX(102, "\u51fa\u5e93\u5355\u53d6\u6d88", BusinessTypeEnum.REPOSITORY_GOODS_BUSINESS),
    TYPE_STOCK_CKDXQ(103, "\u9500\u552e\u5355\u4fee\u6539", BusinessTypeEnum.REPOSITORY_GOODS_BUSINESS),
    TYPE_AUDIT_DSH(201, "\u5f85\u5ba1\u6838", BusinessTypeEnum.AUDIT_BUSINESS),
    TYPE_AUDIT_TG(202, "\u5ba1\u6838\u901a\u8fc7", BusinessTypeEnum.AUDIT_BUSINESS),
    TYPE_AUDIT_BH(203, "\u5ba1\u6838\u9a73\u56de", BusinessTypeEnum.AUDIT_BUSINESS),
    PROCESS_TASK_TX(204, "\u751f\u4ea7\u4efb\u52a1\u63d0\u9192", BusinessTypeEnum.SHOP_ORDER_BUSINESS),
    PROCESS_TASK_TX_OLD(205, "\u751f\u4ea7\u4efb\u52a1\u63d0\u9192", BusinessTypeEnum.SHOP_ORDER_BUSINESS),
    OUT_VOUCHER(206, "\u51fa\u5e93\u5355\u63d0\u9192", BusinessTypeEnum.SHOP_ORDER_BUSINESS),
    TYPE_LOGISTICS_CREATE(301, "\u9a91\u624b\u5df2\u63a5\u5355", BusinessTypeEnum.DELIVERY_BUSINESS),
    TYPE_LOGISTICS_CANCEL(302, "\u914d\u9001\u53d6\u6d88", BusinessTypeEnum.DELIVERY_BUSINESS),
    TYPE_LOGISTICS_FINISHED(303, "\u914d\u9001\u5b8c\u6210", BusinessTypeEnum.DELIVERY_BUSINESS),
    TYPE_LOGISTICS_CREATE_TIME_OUT(304, "\u914d\u9001\u63a5\u5355\u8d85\u65f6", BusinessTypeEnum.DELIVERY_BUSINESS),
    TYPE_ORDER_REMOVE(305, "\u8ba2\u5355\u5220\u9664", BusinessTypeEnum.SHOP_ORDER_BUSINESS),
    TYPE_LOGISTICS_NEW(306, "\u8ba2\u5355\u4e0b\u5355", BusinessTypeEnum.DELIVERY_BUSINESS),
    TYPE_ORDER_IGNORE_DELIVERY(307, "\u8ba2\u5355\u5ffd\u7565", BusinessTypeEnum.SHOP_ORDER_BUSINESS),
    TYPE_ORDER_STATUS_UPDATE(308, "\u8ba2\u5355\u72b6\u6001\u9759\u9ed8\u63a8\u9001", BusinessTypeEnum.BE_SILENT_BUSINESS),
    TYPE_LOGISTICS_REASSIGN(309, "\u914d\u9001\u5355\u91cd\u65b0\u5206\u914d", BusinessTypeEnum.DELIVERY_BUSINESS),
    TYPE_LOGISTICS_TRANSFER(310, "\u914d\u9001\u5355\u8f6c\u5355", BusinessTypeEnum.DELIVERY_BUSINESS);

    private static Map<Integer, MessagePushTypeEnum> valueMap;
    public static List<Integer> ORDER_TYPE_SET;
    public static List<Integer> REPOSITORY_TYPE_SET;
    public static List<Integer> GOODS_TYPE_SET;
    private Integer value;
    private String display;
    private BusinessTypeEnum businessTypeEnum;

    private MessagePushTypeEnum(Integer value, String display, BusinessTypeEnum businessTypeEnum) {
        this.value = value;
        this.display = display;
        this.businessTypeEnum = businessTypeEnum;
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    @Override
    public String getDisplay() {
        return this.display;
    }

    public BusinessTypeEnum getBusinessTypeEnum() {
        return this.businessTypeEnum;
    }

    public static MessagePushTypeEnum getByValue(Integer value) {
        MessagePushTypeEnum result = valueMap.get(value);
        if (result == null) {
            throw new IllegalArgumentException("No element matches " + value);
        }
        return result;
    }

    static {
        valueMap = new HashMap<Integer, MessagePushTypeEnum>();
        for (MessagePushTypeEnum e : MessagePushTypeEnum.values()) {
            valueMap.put(e.value, e);
        }
        ORDER_TYPE_SET = valueMap.values().stream().filter(l -> l.getBusinessTypeEnum().equals(BusinessTypeEnum.SHOP_ORDER_BUSINESS)).map(MessagePushTypeEnum::getValue).collect(Collectors.toList());
        GOODS_TYPE_SET = valueMap.values().stream().filter(l -> l.getBusinessTypeEnum().equals(BusinessTypeEnum.REPOSITORY_GOODS_BUSINESS)).map(MessagePushTypeEnum::getValue).collect(Collectors.toList());
        REPOSITORY_TYPE_SET = GOODS_TYPE_SET;
        GOODS_TYPE_SET = valueMap.values().stream().filter(l -> l.getBusinessTypeEnum().equals(BusinessTypeEnum.GOODS_BUSINESS)).map(MessagePushTypeEnum::getValue).collect(Collectors.toList());
    }
}

